/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dao;

import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import pl.decerto.hyperon.runtime.dao.BaseDao;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSession;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSessionElement;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSessionOperation;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSessionStatus;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeUserView;
import pl.decerto.hyperon.runtime.model.ElementType;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;

public class DevModeJdbcDao
extends BaseDao {
    private final DialectTemplate dialect = DialectRegistry.getDialectTemplate();

    public DevModeJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        super(dataSource, connectionInterceptor);
        this.setDefaultFetchSize(50);
    }

    public Date getSessionMaxLastUpdate() {
        return this.jdbcTemplate(1).queryForObject(this.dialect.parse("select max(lastupdate) from @worksession"), Date.class);
    }

    public RuntimeSession getOpenSession(String username) {
        RuntimeSession session = this.singleOpenSession(username);
        if (session != null) {
            this.jdbcTemplate(100).query(this.dialect.parse(" select wse.id, wse.elementId, wse.code, wse.type, wse.operation, wse.regionversionid_id, r.code, r.profile_code, rv.versionnumber from @worksessionelement wse  left outer join @regionversion rv on wse.regionversionid_id = rv.id  left outer join @region r on rv.region_id = r.id where wse.worksession_id = ?"), rs -> {
                String et = rs.getString(4);
                if (this.isParameter(et) || this.isFunction(et)) {
                    RuntimeSessionElement e = new RuntimeSessionElement();
                    e.setId(rs.getInt(1));
                    e.setElementId(rs.getInt(2));
                    e.setElementCode(rs.getString(3));
                    e.setElementType(ElementType.valueOf(et));
                    e.setOperation(RuntimeSessionOperation.valueOf(rs.getString(5)));
                    e.setRegionVersionId(rs.getInt(6));
                    e.setRegion(rs.getString(7));
                    e.setProfileCode(rs.getString(8));
                    e.setVersion(rs.getString(9));
                    e.setSid(session.getId());
                    session.addElement(e);
                }
            }, session.getId());
        }
        return session;
    }

    private boolean isParameter(String et) {
        return ElementType.PARAMETER.name().equals(et);
    }

    private boolean isFunction(String et) {
        return ElementType.FUNCTION.name().equals(et);
    }

    public RuntimeUserView getUserView(String username) {
        RuntimeUserView userView = new RuntimeUserView(username);
        this.jdbcTemplate(50).query(this.dialect.parse(" select r.code, rv.versionnumber from @userregionversion urv   inner join @regionversion rv on urv.regionversion_id = rv.id   inner join @region r on rv.region_id = r.id where username = ?"), rs -> {
            String region = rs.getString(1);
            String version = rs.getString(2);
            userView.setVersion(region, version);
        }, username);
        return userView;
    }

    private RuntimeSession singleOpenSession(String username) {
        List<RuntimeSession> result = this.jdbcTemplate(1).query(this.dialect.parse(" select id, status, username, lastupdate  from @worksession where status = 'OPEN'   and username = ?"), (rs, rowNum) -> {
            int id = rs.getInt("id");
            RuntimeSessionStatus status = RuntimeSessionStatus.valueOf(rs.getString("status"));
            java.sql.Date lastupdate = this.dialect.getTimestamp(rs, "lastupdate");
            return new RuntimeSession(id, username, lastupdate, status);
        }, username);
        return result.isEmpty() ? null : result.get(0);
    }
}

