/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.invoker;

import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.decerto.hyperon.runtime.invoker.RhinoPreparedScript;

public class RhinoPreprocessor {
    private int uniqueId;
    private final String body;
    private final RhinoPreparedScript script;
    private static final Pattern forPattern;

    public RhinoPreprocessor(String body) {
        this.body = body == null ? "" : body.trim();
        this.script = new RhinoPreparedScript(this.body);
    }

    public RhinoPreparedScript preprocess() {
        Scanner scanner = new Scanner(this.body);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.contains("for")) {
                line = this.checkFor(line);
            }
            this.script.appendLine(line);
        }
        scanner.close();
        return this.script;
    }

    String checkFor(String line) {
        int cnt;
        Matcher m = forPattern.matcher(line);
        if (m.matches() && (cnt = m.groupCount()) == 2) {
            String it = "$" + this.uniqueId++;
            String variable = m.group(1);
            String iterable = m.group(2);
            return String.format("for ( var %s=%s.iterator(); %s.hasNext(); ) { var %s=%s.next();", it, iterable, it, variable, it);
        }
        return line;
    }

    static {
        String identifierRegex = "[\\p{L}_$][\\p{L}\\p{N}_$]*";
        String forRegexTemplate = "^\\s*for\\s*\\(\\s*(?:var)?\\s*(%s)\\s+in\\s+(%s)\\s*\\)\\s*\\{\\s*$";
        String forRegex = String.format(forRegexTemplate, identifierRegex, identifierRegex);
        forPattern = Pattern.compile(forRegex);
    }
}

