/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.invoker.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.ClassShutter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.invoker.context.RhinoSecurityException;

public class RhinoClassShutter
implements ClassShutter {
    private static final Logger log = LoggerFactory.getLogger(RhinoClassShutter.class);
    private static final Set<String> REJECTED = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.lang.System", "java.lang.Runtime", "java.lang.ProcessImpl", "java.lang.reflect.Method")));

    @Override
    public boolean visibleToScripts(String fullClassName) {
        if (REJECTED.contains(fullClassName)) {
            log.warn("rhino security alert: trying to use java class [{}]", (Object)fullClassName);
            throw new RhinoSecurityException();
        }
        return true;
    }
}

