/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.reload;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.dao.VersionJdbcDao;
import pl.decerto.hyperon.runtime.dao.parameter.ParameterJdbcDao;
import pl.decerto.hyperon.runtime.model.Parameter;
import pl.decerto.hyperon.runtime.model.RegionVersion;
import pl.decerto.hyperon.runtime.reload.AsyncReloader;
import pl.decerto.hyperon.runtime.reload.ReloadPolicy;
import pl.decerto.hyperon.runtime.reload.Reloader;

public class DefaultReloader
implements Reloader {
    private static final Logger log = LoggerFactory.getLogger(DefaultReloader.class);
    private final VersionJdbcDao versionDao;
    private final ParameterJdbcDao paramDao;
    private final ReloadPolicy policy;
    private final AsyncReloader asyncReloader;

    @Override
    public void reloadParameter(int pid) {
        Param p = this.findParameter(pid);
        if (this.policy.eligibleForReload(p.code, p.region, p.version)) {
            log.debug("reloading parameter: {}", (Object)p);
            this.asyncReloader.submitToReload(p.uid());
        }
    }

    private Param findParameter(int pid) {
        RegionVersion rv;
        Parameter p = this.paramDao.getHeader(pid);
        if (p.getRegionVersionId() > 0 && (rv = this.versionDao.getRegionVersion(p.getRegionVersionId())) != null) {
            return new Param(p.getName(), rv.getRegion(), rv.getNumber());
        }
        return new Param(p.getName());
    }

    public String toString() {
        return "DefaultReloader[async=" + this.asyncReloader + "]";
    }

    public DefaultReloader(VersionJdbcDao versionDao, ParameterJdbcDao paramDao, ReloadPolicy policy, AsyncReloader asyncReloader) {
        this.versionDao = versionDao;
        this.paramDao = paramDao;
        this.policy = policy;
        this.asyncReloader = asyncReloader;
    }

    private record Param(String code, String region, String version) {
        Param(String code) {
            this(code, null, null);
        }

        String uid() {
            return this.version != null ? this.code + "@" + this.version : this.code;
        }

        @Override
        public String toString() {
            return this.code + "/" + this.region + "/" + this.version;
        }
    }
}

