/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.rhino;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.annotated.annotations.FetchSuggestion;
import org.smartparam.engine.types.date.SimpleDateFormatPool;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.helper.TypeConverter;
import pl.decerto.hyperon.runtime.utils.HprDate;

public class RhinoDate {
    private static Logger log = LoggerFactory.getLogger(RhinoDate.class);
    public static final RhinoDate INSTANCE = new RhinoDate();
    public static final String YMD = "yyyy-MM-dd";
    public static final String YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMDHMSMS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DMY = "dd-MM-yyyy";
    public static final String DMYHMS = "dd-MM-yyyy HH:mm:ss";
    public static final String DMYHMSMS = "dd-MM-yyyy HH:mm:ss.SSS";
    public static final int CAL_MONTHS_IN_YEAR = 12;
    public static final int CAL_MILLIS_IN_DAY = 86400000;
    public static final int CAL_MILLIS_IN_HOUR = 3600000;
    public static final int CAL_MILLIS_IN_MINUTE = 60000;
    public static final int CAL_LEAP_YEAR_DAYS = 366;
    private static final int N3 = 3;
    private static final int N4 = 4;
    private static final int N5 = 5;
    private static final int N6 = 6;
    private static final int N7 = 7;
    private static final int N8 = 8;
    private static final int N11 = 11;
    private static final int N12 = 12;
    private static final int N15 = 15;
    private static final int N19 = 19;
    private static final int N22 = 22;
    private static final int N25 = 25;
    private static final int N26 = 26;
    private static final int N30 = 30;
    private static final int N31 = 31;
    private static final int N32 = 32;
    private static final int N59 = 59;
    private static final int N100 = 100;
    private static final int N114 = 114;
    private static final int N451 = 451;
    private static final TypeConverter type = TypeConverter.getInstance();

    private RhinoDate() {
    }

    @FetchSuggestion(value="suggester.date.parse_str")
    public static Date parse(String dateStr) {
        return HprDate.guess(dateStr);
    }

    @FetchSuggestion(value="suggester.date.parse_dateStr_pattern")
    public static Date parse(String dateStr, String pattern) {
        try {
            return SimpleDateFormatPool.get(pattern).parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse date String [" + dateStr + "]", e);
        }
    }

    @Deprecated
    @FetchSuggestion(value="suggester.date.current")
    public static Date current() {
        return new Date();
    }

    @FetchSuggestion(value="suggester.date.currentDate")
    public static Date currentDate() {
        return RhinoDate.trim(System.currentTimeMillis());
    }

    @FetchSuggestion(value="suggester.date.currentDatetime")
    public static Date currentDatetime() {
        return new Date();
    }

    @FetchSuggestion(value="suggester.date.getSimpleDateFormat")
    public static SimpleDateFormat getSimpleDateFormat(String pattern) {
        return HprDate.getSimpleDateFormat(pattern);
    }

    @FetchSuggestion(value="suggester.date.parseDMY")
    public static Date parseDMY(String dateString) {
        return RhinoDate.parse(dateString, DMY);
    }

    @FetchSuggestion(value="suggester.date.parseYMD")
    public static Date parseYMD(String dateString) {
        return RhinoDate.parse(dateString, YMD);
    }

    @FetchSuggestion(value="suggester.date.parseLong")
    public static Date parseLong(Object date) {
        if (date != null) {
            Date result = RhinoDate.parse(date, (Object)YMDHMS);
            if (result == null) {
                return RhinoDate.parse(date, (Object)YMD);
            }
            return result;
        }
        return null;
    }

    @FetchSuggestion(value="suggester.date.parse_obj")
    public static Date parse(Object date) {
        if (date != null) {
            return RhinoDate.parse(date, (Object)YMD);
        }
        return null;
    }

    @FetchSuggestion(value="suggester.date.parse_obj_pattern")
    public static Date parse(Object date, Object pattern) {
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date != null) {
            try {
                DateFormat df = RhinoDate.getDateFormat(pattern);
                df.setLenient(false);
                return df.parse(date.toString());
            }
            catch (IllegalArgumentException e) {
                log.warn("IllegalArgumentException occurred, format {} probably not valid.", pattern);
                throw e;
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    @FetchSuggestion(value="suggester.date.parseNoEx")
    public static Date parseNoEx(String date) {
        return RhinoDate.parse((Object)date);
    }

    @FetchSuggestion(value="suggester.date.parseNoEx_str_pattern")
    public static Date parseNoEx(String date, String pattern) {
        return RhinoDate.parse((Object)date, (Object)pattern);
    }

    @FetchSuggestion(value="suggester.date.format_date")
    public static String format(Date date) {
        return HprDate.format(date);
    }

    @FetchSuggestion(value="suggester.date.formatTimestamp_date")
    public static String formatTimestamp(Date date) {
        return HprDate.formatTimestamp(date);
    }

    @FetchSuggestion(value="suggester.date.formatTimestamp_long")
    public static String formatTimestamp(long timestamp) {
        return HprDate.formatTimestamp(timestamp);
    }

    @FetchSuggestion(value="suggester.date.format_date_str")
    public static String format(Date date, String pattern) {
        return HprDate.format(date, pattern);
    }

    @FetchSuggestion(value="suggester.date.formatDMY")
    public static String formatDMY(Date date) {
        return RhinoDate.format(date, DMY);
    }

    @FetchSuggestion(value="suggester.date.getYear")
    public static int getYear(Object date) {
        return RhinoDate.getDateField(date, 1);
    }

    @FetchSuggestion(value="suggester.date.getMonth")
    public static int getMonth(Object date) {
        return RhinoDate.getDateField(date, 2);
    }

    @FetchSuggestion(value="suggester.date.getDay")
    public static int getDay(Object date) {
        return RhinoDate.getDateField(date, 5);
    }

    @FetchSuggestion(value="suggester.date.getHour")
    public static int getHour(Object date) {
        return RhinoDate.getDateField(date, 11);
    }

    @FetchSuggestion(value="suggester.date.getMinute")
    public static int getMinute(Object date) {
        return RhinoDate.getDateField(date, 12);
    }

    @FetchSuggestion(value="suggester.date.getSecond")
    public static int getSecond(Object date) {
        return RhinoDate.getDateField(date, 13);
    }

    @FetchSuggestion(value="suggester.date.addYear_obj_obj")
    public static Date addYear(Object date, Object amount) {
        return RhinoDate.addField(date, amount, 1);
    }

    @FetchSuggestion(value="suggester.date.addYear_obj_int")
    public static Date addYear(Object date, int amount) {
        return RhinoDate.addField(date, amount, 1);
    }

    @FetchSuggestion(value="suggester.date.addYear_date_int")
    public static Date addYear(Date date, int amount) {
        return RhinoDate.addField(date, amount, 1);
    }

    @FetchSuggestion(value="suggester.date.addMonth_obj_obj")
    public static Date addMonth(Object date, Object amount) {
        return RhinoDate.addField(date, amount, 2);
    }

    @FetchSuggestion(value="suggester.date.addMonth_obj_int")
    public static Date addMonth(Object date, int amount) {
        return RhinoDate.addField(date, amount, 2);
    }

    @FetchSuggestion(value="suggester.date.addMonth_date_int")
    public static Date addMonth(Date date, int amount) {
        return RhinoDate.addField(date, amount, 2);
    }

    @FetchSuggestion(value="suggester.date.addDay_obj_obj")
    public static Date addDay(Object date, Object amount) {
        return RhinoDate.addField(date, amount, 5);
    }

    @FetchSuggestion(value="suggester.date.addDay_obj_int")
    public static Date addDay(Object date, int amount) {
        return RhinoDate.addField(date, amount, 5);
    }

    @FetchSuggestion(value="suggester.date.addDay_date_int")
    public static Date addDay(Date date, int amount) {
        return RhinoDate.addField(date, amount, 5);
    }

    @FetchSuggestion(value="suggester.date.addHour_obj_obj")
    public static Date addHour(Object date, Object amount) {
        return RhinoDate.addField(date, amount, 11);
    }

    @FetchSuggestion(value="suggester.date.addHour_obj_int")
    public static Date addHour(Object date, int amount) {
        return RhinoDate.addField(date, amount, 11);
    }

    @FetchSuggestion(value="suggester.date.addHour_date_int")
    public static Date addHour(Date date, int amount) {
        return RhinoDate.addField(date, amount, 11);
    }

    @FetchSuggestion(value="suggester.date.addMinute_obj_obj")
    public static Date addMinute(Object date, Object amount) {
        return RhinoDate.addField(date, amount, 12);
    }

    @FetchSuggestion(value="suggester.date.addMinute_obj_int")
    public static Date addMinute(Object date, int amount) {
        return RhinoDate.addField(date, amount, 12);
    }

    @FetchSuggestion(value="suggester.date.addMinute_date_int")
    public static Date addMinute(Date date, int amount) {
        return RhinoDate.addField(date, amount, 12);
    }

    @FetchSuggestion(value="suggester.date.addSecond_obj_obj")
    public static Date addSecond(Object date, Object amount) {
        return RhinoDate.addField(date, amount, 13);
    }

    @FetchSuggestion(value="suggester.date.addSecond_obj_int")
    public static Date addSecond(Object date, int amount) {
        return RhinoDate.addField(date, amount, 13);
    }

    @FetchSuggestion(value="suggester.date.addSecond_date_int")
    public static Date addSecond(Date date, int amount) {
        return RhinoDate.addField(date, amount, 13);
    }

    @FetchSuggestion(value="suggester.date.setYear")
    public static Date setYear(Object date, Object amount) {
        return RhinoDate.setField(date, amount, 1);
    }

    @FetchSuggestion(value="suggester.date.setMonth")
    public static Date setMonth(Object date, Object amount) {
        return RhinoDate.setField(date, amount, 2);
    }

    @FetchSuggestion(value="suggester.date.setDay")
    public static Date setDay(Object date, Object amount) {
        return RhinoDate.setField(date, amount, 5);
    }

    @FetchSuggestion(value="suggester.date.setHour")
    public static Date setHour(Object date, Object amount) {
        return RhinoDate.setField(date, amount, 11);
    }

    @FetchSuggestion(value="suggester.date.setMinute")
    public static Date setMinute(Object date, Object amount) {
        return RhinoDate.setField(date, amount, 12);
    }

    @FetchSuggestion(value="suggester.date.setSecond")
    public static Date setSecond(Object date, Object amount) {
        return RhinoDate.setField(date, amount, 13);
    }

    @FetchSuggestion(value="suggester.date.rollYear")
    public static Date rollYear(Object date, Object amount) {
        return RhinoDate.rollField(date, amount, 1);
    }

    @FetchSuggestion(value="suggester.date.rollMonth")
    public static Date rollMonth(Object date, Object amount) {
        return RhinoDate.rollField(date, amount, 2);
    }

    @FetchSuggestion(value="suggester.date.rollDay")
    public static Date rollDay(Object date, Object amount) {
        return RhinoDate.rollField(date, amount, 5);
    }

    @FetchSuggestion(value="suggester.date.rollHour")
    public static Date rollHour(Object date, Object amount) {
        return RhinoDate.rollField(date, amount, 11);
    }

    @FetchSuggestion(value="suggester.date.rollMinute")
    public static Date rollMinute(Object date, Object amount) {
        return RhinoDate.rollField(date, amount, 12);
    }

    @FetchSuggestion(value="suggester.date.rollSecond")
    public static Date rollSecond(Object date, Object amount) {
        return RhinoDate.rollField(date, amount, 13);
    }

    @FetchSuggestion(value="suggester.date.getYearDiff")
    public static int getYearDiff(Object date1, Object date2) {
        if (date1 != null && date2 != null) {
            return RhinoDate.getYearDiffInner(type.getDate(date1), type.getDate(date2));
        }
        return 0;
    }

    @FetchSuggestion(value="suggester.date.getFullYearDiff")
    public static int getFullYearDiff(Date date1, Date date2) {
        return RhinoDate.getYearsBetween(date1, date2);
    }

    @FetchSuggestion(value="suggester.date.getMonthDiff")
    public static int getMonthDiff(Object date1, Object date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        Date d1 = type.getDate(date1);
        Date d2 = type.getDate(date2);
        return RhinoDate.getMonthDiffInner(d1, d2);
    }

    @Deprecated
    @FetchSuggestion(value="suggester.date.getMonthDiffDeprecated")
    public static int getMonthDiffDeprecated(Object date1, Object date2) {
        Date d1 = RhinoDate.parseLong(date1);
        Date d2 = RhinoDate.parseLong(date2);
        if (d1 != null && d2 != null) {
            int yearDiff = RhinoDate.getDateField(d2, 1) - RhinoDate.getDateField(d1, 1);
            return RhinoDate.getDateField(d2, 2) - RhinoDate.getDateField(d1, 2) + yearDiff * 12;
        }
        return 0;
    }

    @Deprecated
    @FetchSuggestion(value="suggester.date.getDayDiffDeprecated")
    public static int getDayDiffDeprecated(Object date1, Object date2) {
        return RhinoDate.getDiff(date1, date2, 86400000);
    }

    @FetchSuggestion(value="suggester.date.getDayDiff_obj_obj")
    public static int getDayDiff(Object date1, Object date2) {
        return RhinoDate.getDayDiffInner(type.getDatetime(date1), type.getDatetime(date2));
    }

    @FetchSuggestion(value="suggester.date.getDayDiff_obj_obj_str")
    public static int getDayDiff(Object date1, Object date2, String pattern) {
        Date d1 = RhinoDate.parse(date1, (Object)pattern);
        Date d2 = RhinoDate.parse(date2, (Object)pattern);
        return RhinoDate.getDaysBetween(d1, d2);
    }

    @Deprecated
    @FetchSuggestion(value="suggester.date.getHourDiff")
    public static int getHourDiff(Object date1, Object date2) {
        return RhinoDate.getDiff(date1, date2, 3600000);
    }

    @Deprecated
    @FetchSuggestion(value="suggester.date.getMinuteDiff")
    public static int getMinuteDiff(Object date1, Object date2) {
        return RhinoDate.getDiff(date1, date2, 60000);
    }

    @Deprecated
    @FetchSuggestion(value="suggester.date.getTime")
    public static Date getTime(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.getTime();
    }

    @Deprecated
    private static int getDiff(Object date1, Object date2, int div) {
        Date d1 = RhinoDate.parseLong(date1);
        Date d2 = RhinoDate.parseLong(date2);
        if (d1 != null && d2 != null) {
            return (int)(d2.getTime() / (long)div - d1.getTime() / (long)div);
        }
        return 0;
    }

    private static int getDateField(Object date, int field) {
        Date d = RhinoDate.parseLong(date);
        if (d != null) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d);
            int f = gc.get(field);
            return field != 2 ? f : f + 1;
        }
        return 0;
    }

    private static Date addField(Object date, Object amount, int field) {
        int f;
        if (amount == null) {
            return null;
        }
        try {
            f = RhinoDate.getIntValue(amount);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return RhinoDate.addField(date, f, field);
    }

    private static Date addField(Object date, int amount, int field) {
        Date d = type.getDate(date);
        return RhinoDate.addField(d, amount, field);
    }

    private static Date addField(Date date, int amount, int field) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(field, amount);
        return gc.getTime();
    }

    @FetchSuggestion(value="suggester.date.addMonthOracle_obj_obj")
    public static Date addMonthOracle(Object date, Object amount) {
        int f;
        if (amount == null) {
            return null;
        }
        try {
            f = RhinoDate.getIntValue(amount);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return RhinoDate.addMonthOracle(date, f);
    }

    @FetchSuggestion(value="suggester.date.addMonthOracle_obj_number")
    public static Date addMonthOracle(Object date, int amount) {
        Date d = type.getDate(date);
        return RhinoDate.addMonthOracle(d, amount);
    }

    @FetchSuggestion(value="suggester.date.addMonthOracle_date_number")
    public static Date addMonthOracle(Date date, int amount) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        int actualMaximum = gc.getActualMaximum(5);
        int actualDayOfMonth = gc.get(5);
        gc.add(2, amount);
        if (actualDayOfMonth == actualMaximum) {
            gc.set(5, gc.getActualMaximum(5));
        }
        return gc.getTime();
    }

    private static Date setField(Object date, Object amount, int field) {
        Date d = RhinoDate.parseLong(date);
        if (d != null && amount != null) {
            int f;
            try {
                f = RhinoDate.getIntValue(amount);
            }
            catch (NumberFormatException e) {
                return null;
            }
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d);
            gc.set(field, field != 2 ? f : f - 1);
            return gc.getTime();
        }
        return null;
    }

    private static Date rollField(Object date, Object amount, int field) {
        Date d = RhinoDate.parseLong(date);
        if (d != null && amount != null) {
            int f;
            try {
                f = RhinoDate.getIntValue(amount);
            }
            catch (NumberFormatException e) {
                return null;
            }
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d);
            gc.roll(field, f);
            return gc.getTime();
        }
        return null;
    }

    private static int getIntValue(Object amount) {
        if (amount instanceof Number) {
            return ((Number)amount).intValue();
        }
        return Integer.parseInt(amount.toString());
    }

    private static DateFormat getDateFormat(Object pattern) {
        if (pattern instanceof DateFormat) {
            return (DateFormat)pattern;
        }
        return RhinoDate.getSimpleDateFormat(pattern.toString());
    }

    @FetchSuggestion(value="suggester.date.trim")
    public static Date trim(Date date) {
        return date != null ? RhinoDate.trim(date.getTime()) : null;
    }

    private static Date trim(long time) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(time);
        gc.set(9, 0);
        gc.set(10, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc.getTime();
    }

    @FetchSuggestion(value="suggester.date.getDate_fullTime")
    public static Date getDate(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        return cal.getTime();
    }

    @FetchSuggestion(value="suggester.date.getDate_smallerTime")
    public static Date getDate(int year, int month, int day, int hour, int minute) {
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hour, minute);
        return cal.getTime();
    }

    @FetchSuggestion(value="suggester.date.getDate_date")
    public static Date getDate(int year, int month, int day) {
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day);
        return cal.getTime();
    }

    @FetchSuggestion(value="suggester.date.getFirstDayOfMonth")
    public static Date getFirstDayOfMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    @FetchSuggestion(value="suggester.date.getFirstDayOfYear")
    public static Date getFirstDayOfYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(2, 0);
        return cal.getTime();
    }

    @FetchSuggestion(value="suggester.date.getLastDayOfMonth")
    public static Date getLastDayOfMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, ((Calendar)cal).getActualMaximum(5));
        return cal.getTime();
    }

    @FetchSuggestion(value="suggester.date.getLastDayOfYear")
    public static Date getLastDayOfYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, ((Calendar)cal).getActualMaximum(2));
        cal.set(5, ((Calendar)cal).getActualMaximum(5));
        return cal.getTime();
    }

    @FetchSuggestion(value="suggester.date.getNextWorkDay")
    public static Date getNextWorkDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(7);
        if (day == 6) {
            return RhinoDate.addDay(date, 3);
        }
        if (day == 7) {
            return RhinoDate.addDay(date, 2);
        }
        return RhinoDate.addDay(date, 1);
    }

    @FetchSuggestion(value="suggester.date.getNearestWorkDay")
    public static Date getNearestWorkDay(Date date) {
        if (RhinoDate.isWorkDay(date)) {
            return date;
        }
        return RhinoDate.getNextWorkDay(date);
    }

    @FetchSuggestion(value="suggester.date.isWorkDay")
    public static boolean isWorkDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        return dayOfWeek != 7 && dayOfWeek != 1;
    }

    @FetchSuggestion(value="suggester.date.isLastDayOfMonth")
    public static boolean isLastDayOfMonth(Date date) {
        return date != null && date.equals(RhinoDate.getLastDayOfMonth(date));
    }

    @FetchSuggestion(value="suggester.date.isFirstWorkDayOfMonth")
    public static boolean isFirstWorkDayOfMonth(Date date) {
        Date firstDayOfMonth = RhinoDate.getFirstDayOfMonth(date);
        Date firstWorkDayOfMonth = RhinoDate.getNearestWorkDayExcludingPolishHolidays(firstDayOfMonth);
        return date.equals(firstWorkDayOfMonth);
    }

    @Deprecated
    @FetchSuggestion(value="suggester.date.subtractYear")
    public static Date subtractYear(Date date) {
        GregorianCalendar dateCal = new GregorianCalendar();
        dateCal.setTime(date);
        boolean lastDay = dateCal.get(5) == dateCal.getActualMaximum(5);
        dateCal.add(1, -1);
        if (lastDay) {
            dateCal.set(5, dateCal.getActualMaximum(5));
        }
        return dateCal.getTime();
    }

    @FetchSuggestion(value="suggester.date.copy")
    public static Date copy(Date date) {
        return date != null ? new Date(date.getTime()) : null;
    }

    @FetchSuggestion(value="suggester.date.getFirstDayOfYear_int")
    public static Date getFirstDayOfYear(int year) {
        return RhinoDate.getDate(year, 1, 1);
    }

    @FetchSuggestion(value="suggester.date.getFirstWorkingDayOfYear")
    public static Date getFirstWorkingDayOfYear(int year) {
        return RhinoDate.getNextWorkDay(RhinoDate.getFirstDayOfYear(year));
    }

    @FetchSuggestion(value="suggester.date.isInPeriod")
    public static boolean isInPeriod(Date dateToCheck, Date minDateInclusive, Date maxDateExclusive) {
        return RhinoDate.isInPeriod(dateToCheck.getTime(), minDateInclusive != null ? minDateInclusive.getTime() : 0L, maxDateExclusive != null ? maxDateExclusive.getTime() : 0L);
    }

    @FetchSuggestion(value="suggester.date.isInPeriod_longs")
    public static boolean isInPeriod(long d, long d1, long d2) {
        long lower = d1 > 0L ? d1 : Long.MIN_VALUE;
        long upper = d2 > 0L ? d2 : Long.MAX_VALUE;
        return lower <= d && d < upper;
    }

    @FetchSuggestion(value="suggester.date.isInPeriodInclusive")
    public static boolean isInPeriodInclusive(Date dateToCheck, Date minDateInclusive, Date maxDateInclusive) {
        return RhinoDate.isInPeriodInclusive(dateToCheck.getTime(), minDateInclusive != null ? minDateInclusive.getTime() : 0L, maxDateInclusive != null ? maxDateInclusive.getTime() : 0L);
    }

    @FetchSuggestion(value="suggester.date.isInPeriodInclusive_longs")
    public static boolean isInPeriodInclusive(long d, long d1, long d2) {
        long lower = d1 > 0L ? d1 : Long.MIN_VALUE;
        long upper = d2 > 0L ? d2 : Long.MAX_VALUE;
        return lower <= d && d <= upper;
    }

    @FetchSuggestion(value="suggester.date.max")
    public static Date max(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1.getTime() > d2.getTime() ? d1 : d2;
    }

    @FetchSuggestion(value="suggester.date.max_three_dates")
    public static Date max(Date d1, Date d2, Date d3) {
        return RhinoDate.max(d1, RhinoDate.max(d2, d3));
    }

    @FetchSuggestion(value="suggester.date.min")
    public static Date min(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        return d1.getTime() < d2.getTime() ? d1 : d2;
    }

    @FetchSuggestion(value="suggester.date.min_three_dates")
    public static Date min(Date d1, Date d2, Date d3) {
        return RhinoDate.min(d1, RhinoDate.min(d2, d3));
    }

    @FetchSuggestion(value="suggester.date.getPolishHolidays")
    public static Set<Date> getPolishHolidays(int year) {
        HashSet<Date> result = new HashSet<Date>();
        result.add(RhinoDate.getDate(year, 1, 1));
        result.add(RhinoDate.getDate(year, 1, 6));
        result.add(RhinoDate.getDate(year, 5, 1));
        result.add(RhinoDate.getDate(year, 5, 3));
        result.add(RhinoDate.getDate(year, 8, 15));
        result.add(RhinoDate.getDate(year, 11, 1));
        result.add(RhinoDate.getDate(year, 11, 11));
        result.add(RhinoDate.getDate(year, 12, 25));
        result.add(RhinoDate.getDate(year, 12, 26));
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int p = (h + l - 7 * m + 114) % 31;
        GregorianCalendar cal = new GregorianCalendar(year, (h + l - 7 * m + 114) / 31 - 1, p + 1);
        ((Calendar)cal).add(5, 1);
        result.add(cal.getTime());
        ((Calendar)cal).add(5, 59);
        result.add(cal.getTime());
        return result;
    }

    @FetchSuggestion(value="suggester.date.getNearestWorkDayExcludingPolishHolidays")
    public static Date getNearestWorkDayExcludingPolishHolidays(Date date) {
        if (RhinoDate.getPolishHolidays(RhinoDate.getYear(date)).contains(date) || !RhinoDate.isWorkDay(date)) {
            return RhinoDate.getNearestWorkDayExcludingPolishHolidays(RhinoDate.getNextWorkDay(date));
        }
        return date;
    }

    @FetchSuggestion(value="suggester.date.compareYMD")
    public static int compareYMD(Date date1, Date date2) {
        GregorianCalendar gc1 = new GregorianCalendar();
        gc1.setTime(date1);
        GregorianCalendar gc2 = new GregorianCalendar();
        gc2.setTime(date2);
        int yearCompare = Integer.compare(gc1.get(1), gc2.get(1));
        if (yearCompare == 0) {
            int monthCompare = Integer.compare(gc1.get(2), gc2.get(2));
            if (monthCompare == 0) {
                return Integer.compare(gc1.get(5), gc2.get(5));
            }
            return monthCompare;
        }
        return yearCompare;
    }

    @FetchSuggestion(value="suggester.date.isLeapYear")
    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    @FetchSuggestion(value="suggester.date.getDaysInYear")
    public static int getDaysInYear(int year) {
        return RhinoDate.isLeapYear(year) ? 366 : 365;
    }

    @FetchSuggestion(value="suggester.date.toInt")
    public static int toInt(Date date) {
        return Integer.parseInt(RhinoDate.format(date, "yyyyMMdd"));
    }

    @FetchSuggestion(value="suggester.date.fromInt")
    public static Date fromInt(int date) {
        return RhinoDate.parseNoEx("" + date, "yyyyMMdd");
    }

    @FetchSuggestion(value="suggester.date.getMonthsBetween")
    public static int getMonthsBetween(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new HyperonRuntimeException("getMonthsBetween: argument is null");
        }
        Date d1 = date1.getTime() < date2.getTime() ? date1 : date2;
        Date d2 = date1.getTime() < date2.getTime() ? date2 : date1;
        int y1 = RhinoDate.getYear(d1);
        int y2 = RhinoDate.getYear(d2);
        int m1 = RhinoDate.getMonth(d1);
        int m2 = RhinoDate.getMonth(d2);
        int day1 = RhinoDate.getDay(d1);
        int day2 = RhinoDate.isLastDayOfMonth(d2) ? 32 : RhinoDate.getDay(d2);
        int dd = day1 > day2 ? -1 : 0;
        return y2 * 12 + m2 - (y1 * 12 + m1) + dd;
    }

    @FetchSuggestion(value="suggester.date.getDaysBetween")
    public static int getDaysBetween(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new HyperonRuntimeException("getDaysBetween: argument is null");
        }
        Date d1 = date1.getTime() < date2.getTime() ? date1 : date2;
        Date d2 = date1.getTime() < date2.getTime() ? date2 : date1;
        int diff = RhinoDate.getDayDiffInner(d1, d2);
        if (RhinoDate.getTimeComponent(d1) > RhinoDate.getTimeComponent(d2)) {
            --diff;
        }
        return diff;
    }

    @FetchSuggestion(value="suggester.date.getAbsoluteYearDiff")
    public static int getAbsoluteYearDiff(Object date1, Object date2) {
        if (date1 != null && date2 != null) {
            return RhinoDate.getYearsBetween(type.getDate(date1), type.getDate(date2));
        }
        return 0;
    }

    @FetchSuggestion(value="suggester.date.getYearsBetween")
    public static int getYearsBetween(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new HyperonRuntimeException("getYearsBetween: argument is null");
        }
        return RhinoDate.getMonthsBetween(date1, date2) / 12;
    }

    @FetchSuggestion(value="suggester.date.julianDay")
    public static int julianDay(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }

    @FetchSuggestion(value="suggester.date.julianDay_date")
    public static int julianDay(Date date) {
        int y = RhinoDate.getYear(date);
        int m = RhinoDate.getMonth(date);
        int d = RhinoDate.getDay(date);
        return RhinoDate.julianDay(y, m, d);
    }

    @FetchSuggestion(value="suggester.date.julianDayDiff")
    public static int julianDayDiff(Date date1, Date date2) {
        return RhinoDate.julianDay(date2) - RhinoDate.julianDay(date1);
    }

    private static int getDayDiffInner(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        return Days.daysBetween(new LocalDate(date1.getTime()), new LocalDate(date2.getTime())).getDays();
    }

    private static int getYearDiffInner(Date d1, Date d2) {
        if (d1 != null && d2 != null) {
            return RhinoDate.getYear(d2) - RhinoDate.getYear(d1);
        }
        return 0;
    }

    private static int getMonthDiffInner(Date d1, Date d2) {
        int y1 = RhinoDate.getYear(d1);
        int y2 = RhinoDate.getYear(d2);
        int m1 = RhinoDate.getMonth(d1);
        int m2 = RhinoDate.getMonth(d2);
        return y2 * 12 + m2 - (y1 * 12 + m1);
    }

    private static long getTimeComponent(Date d) {
        Objects.requireNonNull(d);
        long h = RhinoDate.getHour(d);
        long m = RhinoDate.getMinute(d);
        long s = RhinoDate.getSecond(d);
        long ms = d.getTime() % 1000L;
        return TimeUnit.HOURS.toMillis(h) + TimeUnit.MINUTES.toMillis(m) + TimeUnit.SECONDS.toMillis(s) + ms;
    }
}

