package com.hippoagent;

import java.util.ArrayList;

/**
 * Created by gurmail on 22/01/21.
 *
 * @author gurmail
 */

public class AgentSupportChannel {

    private String transactionId;
    private String otherUserEmail;
    private ArrayList<String> groupingTags;
    private boolean initiatedByAgent;
    private boolean isCreateChannelByTransactionId;

    public String getTransactionId() {
        return transactionId;
    }

    public String getOtherUserEmail() {
        return otherUserEmail;
    }

    public ArrayList<String> getGroupingTags() {
        return groupingTags;
    }

    public boolean isInitiatedByAgent() {
        return initiatedByAgent;
    }

    public boolean isCreateChannelByTransactionId() {
        return isCreateChannelByTransactionId;
    }

    public static class Builder {
        private AgentSupportChannel supportChannel = new AgentSupportChannel();

        public Builder transactionId(String transactionId) {
            supportChannel.transactionId = transactionId;
            return this;
        }
        public Builder otherUserEmail(String otherUserEmail) {
            supportChannel.otherUserEmail = otherUserEmail;
            return this;
        }
        public Builder groupingTags(ArrayList<String> groupingTags) {
            supportChannel.groupingTags = groupingTags;
            return this;
        }
        public Builder initiatedByAgent(boolean initiatedByAgent) {
            supportChannel.initiatedByAgent = initiatedByAgent;
            return this;
        }
        public Builder isCreateChannelByTransactionId(boolean isCreateChannelByTransactionId) {
            supportChannel.isCreateChannelByTransactionId = isCreateChannelByTransactionId;
            return this;
        }

        public AgentSupportChannel build() {
            return supportChannel;
        }
    }
}
