package com.hippoagent;

/**
 * Class for handling activity lifecycle events
 * Created by gurmail on 2020-05-02.
 *
 * @author gurmail
 */
import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.os.Bundle;

import androidx.lifecycle.ProcessLifecycleOwner;

import com.hippoagent.encription.JsEncryptor;
import com.hippoagent.services.AppLifecycleListener;
import com.hippoagent.utils.Log;

import java.util.HashSet;

import timber.log.Timber;


@SuppressWarnings({"unused", "WeakerAccess"})
public final class HippoActivityLifecycleCallback {
    static boolean registered = false;
    private static final String TAG = HippoActivityLifecycleCallback.class.getSimpleName();
    public static HashSet<String> hippoClasses;
    public static JsEncryptor mJsEncryptor;


    /**
     * Enables lifecycle callbacks for Android devices
     * @param application App's Application object
     */
    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    public static synchronized void registerApplication(android.app.Application application) {
        if (application == null) {
            Log.i("register", "Application instance is null/system API is too old");
            return;
        }

        if (registered) {
            Log.v("register", "Lifecycle callbacks have already been registered");
            return;
        }
        ProcessLifecycleOwner.get().getLifecycle().addObserver(new AppLifecycleListener(application.getApplicationContext()));
//        final FetchConfiguration fetchConfiguration = new FetchConfiguration.Builder(application)
//                .enableRetryOnNetworkGain(true)
//                .setDownloadConcurrentLimit(3)
//                .setHttpDownloader(new HttpUrlConnectionDownloader(Downloader.FileDownloaderType.PARALLEL))
//                // OR
//                //.setHttpDownloader(getOkHttpDownloader())
//                .build();
//        Fetch.Impl.setDefaultInstanceConfiguration(fetchConfiguration);

        hippoClasses = new HashSet<>();
        registered = true;
        application.registerActivityLifecycleCallbacks(
                new android.app.Application.ActivityLifecycleCallbacks() {

                    @Override
                    public void onActivityCreated(Activity activity, Bundle bundle) {
                        hippoClasses.add(activity.getClass().getName());
                        Log.v(TAG, "onActivityCreated "+activity.getClass().getName());
                    }

                    @Override
                    public void onActivityStarted(Activity activity) {
                        Log.v(TAG, "onActivityStarted "+activity.getClass().getSimpleName());
                    }

                    @Override
                    public void onActivityResumed(Activity activity) {
                        Log.v(TAG, "onActivityResumed "+activity.getClass().getSimpleName());
                    }

                    @Override
                    public void onActivityPaused(Activity activity) {
                        Log.v(TAG, "onActivityPaused "+activity.getClass().getSimpleName());
                    }

                    @Override
                    public void onActivityStopped(Activity activity) {
                        Log.v(TAG, "onActivityStopped "+activity.getClass().getSimpleName());
                    }

                    @Override
                    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                        Log.v(TAG, "onActivitySaveInstanceState "+activity.getClass().getSimpleName());
                    }

                    @Override

                    public void onActivityDestroyed(Activity activity) {
                        Log.v(TAG, "onActivityDestroyed "+activity.getClass().getSimpleName());
                        hippoClasses.remove(activity.getClass().getSimpleName());
                    }
                }

        );
        Log.i("In callback", "Activity Lifecycle Callback successfully registered");
    }

    /**
     * Enables lifecycle callbacks for Android devices
     * @param application App's Application object
     */
    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    public static synchronized void register(android.app.Application application) {
        registerApplication(application);
        mJsEncryptor = JsEncryptor.evaluateAllScripts(application.getApplicationContext());

    }
}