package com.hippoagent;

/**
 * Created by gurmail on 2020-03-09.
 *
 * @author gurmail
 */
public class HippoAdditionalInfo {

    private boolean canSavePlan;
    private boolean showBusinessPlan;
    private boolean showPaymentButton;
    private boolean announcementCount;
    private boolean hideAudioRecording = false;


    public boolean canSavePlan() {
        return canSavePlan;
    }

    public boolean showBusinessPlan() {
        return showBusinessPlan;
    }

    public boolean showPaymentButton() {
        return showPaymentButton;
    }

    public boolean isAnnouncementCount() {
        return announcementCount;
    }

    public boolean hideAudioRecordingButton(){
        return hideAudioRecording;
    }

    public static class Builder {

        private HippoAdditionalInfo additionalInfo = new HippoAdditionalInfo();

        public Builder canSavePlan(boolean canSavePlan) {
            additionalInfo.canSavePlan = canSavePlan;
            return this;
        }

        public Builder showPaymentButton(boolean showPaymentButton) {
            additionalInfo.showPaymentButton = showPaymentButton;
            return this;
        }

        public Builder showBusinessPlan(boolean showBusinessPlan) {
            additionalInfo.showBusinessPlan = showBusinessPlan;
            return this;
        }

        public Builder setAnnouncementCount(boolean announcementCount) {
            additionalInfo.announcementCount = announcementCount;
            return this;
        }

        public Builder hideAudioRecordingButton(boolean hideAudioRecording){
            additionalInfo.hideAudioRecording = hideAudioRecording;
            return this;
        }

        public HippoAdditionalInfo build() {
            return additionalInfo;
        }
    }
}
