package com.hippoagent;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;

import androidx.lifecycle.LifecycleObserver;
import androidx.multidex.MultiDexApplication;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import android.widget.Toast;

import com.hippoagent.callback.BaseManagerInterface;
import com.hippoagent.callback.BaseUIListener;
import com.hippoagent.callback.OnCloseListener;
import com.hippoagent.callback.OnInitializedListener;
import com.hippoagent.database.CommonData;
import com.hippoagent.database.DeleteDatabase;
import com.hippoagent.database.UserCommonData;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.model.TagData;
import com.hippoagent.model.agent_profile_response.AgentProfileDetails;
import com.hippoagent.receiver.NetworkManager;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.ConfigMode;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.filePicker.Prefs;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.filelogger.LoggerObj;
import com.hippoagent.utils.typekit.Typekit;

import net.danlew.android.joda.JodaTimeAndroid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

import io.github.inflationx.calligraphy3.CalligraphyConfig;
import io.github.inflationx.calligraphy3.CalligraphyInterceptor;
import io.github.inflationx.viewpump.ViewPump;
import io.paperdb.Paper;

/**
 * Created by ankit on 06/06/17.
 */

public class HippoApplication extends MultiDexApplication implements Application.ActivityLifecycleCallbacks, LifecycleObserver { //implements FuguAgentFayeClientListener {

    private static final String TAG = HippoApplication.class.getSimpleName();
    private static HippoApplication mInstance;
    private UserData userData;
    private GetAgentsResponse getAgentsResponse;
    private int latestVersion = 0;
    private static Bundle fuguBundle;
    private Integer isAppOpen;
    private AgentProfileDetails agentProfileDetails;
    public ArrayList<TagData> tagData = new ArrayList<>();

    public String deviceTokan = "";

    @Override
    public void onCreate() {
        HippoActivityLifecycleCallback.register(this);
        HippoCallConfig.getInstance().setCallBackListener(this);
        super.onCreate();
        addManagers();
        JodaTimeAndroid.init(this);


        Typekit.getInstance()
                .add(getString(R.string.proxima_r), Typekit.createFromAsset(this, "fonts/ProximaNova-Reg.ttf"))
                .add(getString(R.string.proxima_b), Typekit.createFromAsset(this, "fonts/ProximaNova-Sbold.ttf"))
                .add(getString(R.string.proxima_sb), Typekit.createFromAsset(this, "fonts/ProximaNova-Sbold.ttf"))
                .add(getString(R.string.montserrat_m), Typekit.createFromAsset(this, "fonts/ProximaNova-Reg.ttf"))
                .add(getString(R.string.montserrat_sb), Typekit.createFromAsset(this, "fonts/ProximaNova-Sbold.ttf"))
                .add(getString(R.string.montserrat_r), Typekit.createFromAsset(this, "fonts/ProximaNova-Reg.ttf"));

        ViewPump.init(ViewPump.builder()
                .addInterceptor(new CalligraphyInterceptor(
                        new CalligraphyConfig.Builder()
                                .setDefaultFontPath("fonts/ProximaNova-Reg.ttf")
                                .setFontAttrId(R.attr.fontPath)
                                .build()))
                .build());

        Paper.init(this);
        mInstance = this;

        String currentDBPath = getDatabasePath("hippo_agent").getAbsolutePath();
        Log.e(TAG, "currentDBPath = "+currentDBPath);

    }

    public static Bundle getFuguBundle() {
        return fuguBundle;
    }

    public static void setFuguBundle(Bundle fuguBundle) {
        HippoApplication.fuguBundle = fuguBundle;
    }

    public static synchronized HippoApplication getInstance() {
        return mInstance;
    }

    public void clearUserData() {
        userData = null;
    }

    public UserData getUserDataa() {
        if (userData == null) {
            userData = Paper.book(CommonData.name).read(SPLabels.USER_DATA);
            if(userData == null) {
                userData = Paper.book().read(SPLabels.USER_DATA);
            }
        }
        return userData;
    }

    public UserData getUserData() {
        if (userData == null) {
            userData = Paper.book(CommonData.name).read(SPLabels.USER_DATA);
        }
        return userData;
    }

    public void saveUserData(UserData uData) {
        Paper.book(CommonData.name).write(SPLabels.USER_DATA, uData);
        userData = null;
    }

    public AgentProfileDetails getAgentProfileDetails() {
        if (agentProfileDetails == null) {
            agentProfileDetails = Paper.book(CommonData.name).read(SPLabels.AGENT_PROFILE_DATA);
        }
        return agentProfileDetails;
    }

    public void setAgentProfileDetails(AgentProfileDetails agentProfileDetails) {
        this.agentProfileDetails = agentProfileDetails;
    }

    public int getLatestVersion() {
//        if (Paper.book(name).read(SPLabels.LATEST_VERSION) != null) {
//            latestVersion = Paper.book(name).read(SPLabels.LATEST_VERSION);
//        }
        return latestVersion;
    }

    public void setAgentsResponse(GetAgentsResponse agentsResponse) {
        if (getAgentsResponse != null)
            getAgentsResponse = agentsResponse;
    }

    public GetAgentsResponse getAgentsResponse() {
        if (getAgentsResponse == null) {
            getAgentsResponse = Paper.book(CommonData.name).read(SPLabels.AGENTS);
        }
        return getAgentsResponse;
    }

    public void logout(Activity activity) {
        ConnectionManager.INSTANCE.onClose();
        agentProfileDetails = null;
        userData = null;
        clearData();
//        activity.finish();
//        Intent intent = new Intent(this, LoginActivity.class);
//        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
//        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
//        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//        startActivity(intent);

    }

    public void clearData() {
        deviceTokan = Paper.book(CommonData.name).read(SPLabels.DEVICE_TOKEN);
        CommonData.clearData();
        userData = null;
        Prefs.with(HippoApplication.this).removeAll();
        try {
            UserCommonData.clearData();
            new DeleteDatabase().execute();
        } catch (Exception e) {
            e.printStackTrace();
        }

        /*try {
            new ClearData().execute();
        } catch (Exception e) {
            e.printStackTrace();
        }*/
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {

    }

    @Override
    public void onActivityStarted(Activity activity) {

    }

    @Override
    public void onActivityResumed(Activity activity) {

    }

    @Override
    public void onActivityPaused(Activity activity) {

    }

    @Override
    public void onActivityStopped(Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {

    }

    class ClearData extends AsyncTask<Void, Void, Void> {

        @Override
        protected Void doInBackground(Void... voids) {
            CopyOnWriteArrayList<LoggerObj> loggerObjs = Logger.INSTANCE.getData();
            CommonData.clearData();
            Paper.init(HippoApplication.this);
            Logger.INSTANCE.saveAllData(loggerObjs);
            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
        }
    }



    /**
     * Method to check whether the Permission is Granted by the User
     * <p/>
     * permission type: DANGEROUS
     *
     * @param activity
     * @param permission
     * @return
     */
    public boolean isPermissionGranted(Context activity, String permission) {
        return ContextCompat.checkSelfPermission(activity, permission) == PackageManager.PERMISSION_GRANTED;
    }

    /**
     * Method to check whether the Permission is Granted by the User
     * <p/>
     * permission type: DANGEROUS
     *
     * @param activity
     * @param permission
     * @return
     */
    public boolean askUserToGrantPermission(Activity activity, String permission, String explanation, int code) {

        Log.e("permission", "permissions" + permission);

        return askUserToGrantPermission(activity, new String[]{permission}, explanation, code);
    }

    /**
     * Method to check whether the Permission is Granted by the User
     * <p/>
     * permission type: DANGEROUS
     *
     * @param activity
     * @param permissions
     * @param explanation
     * @param requestCode
     * @return
     */
    public boolean askUserToGrantPermission(Activity activity, String[] permissions, String explanation, int requestCode) {

        String permissionRequired = null;

        for (String permission : permissions)
            if (!isPermissionGranted(activity, permission)) {
                permissionRequired = permission;
                break;
            }

        // Check if the Permission is ALREADY GRANTED
        if (permissionRequired == null) return true;

        // Check if there is a need to show the PERMISSION DIALOG
        boolean explanationRequired = ActivityCompat.shouldShowRequestPermissionRationale(activity, permissionRequired);
        Log.e("ask user", "askUserToGrantPermission: explanationRequired(" + explanationRequired + "): " + permissionRequired);

        // Convey the EXPLANATION if required
        if (explanationRequired) {

            if (explanation == null) explanation = "Please grant permission";
            Toast.makeText(activity, explanation, Toast.LENGTH_SHORT).show();
        } else {

            // We can request the permission, if no EXPLANATIONS required
            ActivityCompat.requestPermissions(activity, permissions, requestCode);
        }

        return false;
    }

    public Integer getIsAppOpen() {
        return isAppOpen;
    }

    public void setIsAppOpen(Integer isAppOpen) {
        this.isAppOpen = isAppOpen;
    }

    public void initializeServerURL(ConfigMode configModeToSet) {
        /*String link = Paper.book(CommonData.name).read(SPLabels.SERVER_SELECTED, Config.getDefaultServerUrl());
        ConfigMode configModeToSet = ConfigMode.LIVE;

        if (link.equalsIgnoreCase(Config.getLiveServerUrl())) {
            configModeToSet = ConfigMode.LIVE;
        } else if (link.equalsIgnoreCase(Config.getBetaServerUrl())) {
            configModeToSet = ConfigMode.BETA;
        } else if (link.equalsIgnoreCase(Config.getLiveBetaServerUrl())) {
            configModeToSet = ConfigMode.LIVE_BETA;
        } else if(link.equalsIgnoreCase(Config.getAlphaUrl())) {
            configModeToSet = ConfigMode.ALPHA;
        } else if(link.equalsIgnoreCase(Config.getDevServerUrl())) {
            configModeToSet = ConfigMode.DEV;
        } else {
            configModeToSet = ConfigMode.LIVE;
        }*/

        if (configModeToSet != Config.getConfigMode()) {
            RestClient.clearRestClients();
        }

        Config.setConfigMode(configModeToSet);
        // Paper.book(name).write(SPLabels.SERVER_SELECTED, "Beta");
        Paper.book(CommonData.name).write(SPLabels.SERVER_SELECTED, Config.getServerUrl());
        RestClient.setupAllClients();
    }

    /*public void initializeServerURL(Context context) {
        String link = Paper.book(CommonData.name).read(SPLabels.SERVER_SELECTED, Config.getDefaultServerUrl());
        ConfigMode configModeToSet = ConfigMode.LIVE;

        if (link.equalsIgnoreCase(Config.getLiveServerUrl())) {
            configModeToSet = ConfigMode.LIVE;
        } else if (link.equalsIgnoreCase(Config.getBetaServerUrl())) {
            configModeToSet = ConfigMode.BETA;
        } else if (link.equalsIgnoreCase(Config.getLiveBetaServerUrl())) {
            configModeToSet = ConfigMode.LIVE_BETA;
        } else if(link.equalsIgnoreCase(Config.getAlphaUrl())) {
            configModeToSet = ConfigMode.ALPHA;
        } else if(link.equalsIgnoreCase(Config.getDevServerUrl())) {
            configModeToSet = ConfigMode.DEV;
        } else {
            configModeToSet = ConfigMode.LIVE;
        }

        if (configModeToSet != Config.getConfigMode()) {
            RestClient.clearRestClients();
        }

        Config.setConfigMode(configModeToSet);
        // Paper.book(name).write(SPLabels.SERVER_SELECTED, "Beta");
        Paper.book(CommonData.name).write(SPLabels.SERVER_SELECTED, Config.getServerUrl());
        RestClient.setupAllClients();
    }*/

    private Map<Class<? extends BaseUIListener>, Collection<? extends BaseUIListener>> uiListeners;
    private Map<Class<? extends BaseManagerInterface>, Collection<? extends BaseManagerInterface>> managerInterfaces;
    private Map<Class<? extends BaseUIListener>, Collection<? extends BaseUIListener>> messageListener;
    private final ArrayList<Object> registeredManagers;

    public HippoApplication() {
        serviceStarted = false;
        closed = false;
        uiListeners = new HashMap<>();
        messageListener = new HashMap<>();
        managerInterfaces = new HashMap<>();
        registeredManagers = new ArrayList<>();
    }

    @SuppressWarnings("unchecked")
    private <T extends BaseUIListener> Collection<T> getOrCreateUIListeners(Class<T> cls) {
        Collection<T> collection = (Collection<T>) uiListeners.get(cls);
        if (collection == null) {
            collection = new ArrayList<T>();
            uiListeners.put(cls, collection);
        }
        return collection;
    }

    /**
     * @param cls Requested class of listeners.
     * @return List of registered UI listeners.
     */
    public <T extends BaseUIListener> Collection<T> getUIListeners(Class<T> cls) {
//        if (closed) {
//            return Collections.emptyList();
//        }
        return Collections.unmodifiableCollection(getOrCreateUIListeners(cls));
    }

    /**
     * Register new listener.
     * <p/>
     * Should be called from {@link Activity onResume()}. In channel activity we use this method in
     * {@link Activity onCreate(Bundle)} and  {@link Activity onDestroy()}
     */
    public <T extends BaseUIListener> void addUIListener(Class<T> cls, T listener) {
        if (!getOrCreateUIListeners(cls).contains(listener))
            getOrCreateUIListeners(cls).add(listener);
    }

    public <T extends BaseUIListener> void addOrUpdateUIListener(Class<T> cls, T listener) {
        try {
            if(getUIListeners(cls).size() == 0) {
                getOrCreateUIListeners(cls).add(listener);
            }
        } catch (Exception e) {

        }
    }

    /**
     * Unregister listener.
     * <p/>
     * Should be called from {@link Activity onPause()}.
     */
    public <T extends BaseUIListener> void removeUIListener(Class<T> cls, T listener) {
        getOrCreateUIListeners(cls).remove(listener);
    }

    /**
     * @param cls Requested class of managers.
     * @return List of registered manager.
     */
    @SuppressWarnings("unchecked")
    public <T extends BaseManagerInterface> Collection<T> getManagers(Class<T> cls) {
        if (closed) {
            return Collections.emptyList();
        }
        Collection<T> collection = (Collection<T>) managerInterfaces.get(cls);
        if (collection == null) {
            collection = new ArrayList<>();
            for (Object manager : registeredManagers) {
                if (cls.isInstance(manager)) {
                    collection.add((T) manager);
                }
            }
            collection = Collections.unmodifiableCollection(collection);
            managerInterfaces.put(cls, collection);
        }
        return collection;
    }


    private void addManagers() {
        addManager(NetworkManager.getInstance(this));
        //addManager(ConnectionManager.INSTANCE);
    }

    /**
     * Register new manager.
     */
    private void addManager(Object manager) {
        registeredManagers.add(manager);
    }


    private void onInitialized() {
        for (OnInitializedListener listener : getManagers(OnInitializedListener.class)) {
            Log.i(TAG, "OnInitializedListener onInitialized " + listener);
            listener.onInitialized();
        }
    }

    @Override
    public void onTerminate() {
        super.onTerminate();
    }

    /**
     * Where data load was requested.
     */
    private boolean serviceStarted;

    /**
     * Starts data loading in background if not started yet.
     */
    public void onServiceStarted() {
        if (serviceStarted) {
            return;
        }
        //serviceStarted = true;
        closed = false;
        Log.i(TAG, "onServiceStarted in HippoConfig");

        onInitialized();
    }

    /**
     * Service have been destroyed.
     */
    public void onServiceDestroy() {
        Log.i(TAG, "onServiceDestroy");

        if (closed) {
            Log.i(TAG, "onServiceDestroy closed");
            return;
        }
        onClose();
    }

    /**
     * Whether {@link #onServiceDestroy()} has been called.
     */
    private boolean closed;

    private void onClose() {
        Log.i(TAG, "onClose1");
        for (Object manager : registeredManagers) {
            if (manager instanceof OnCloseListener) {
                ((OnCloseListener) manager).onClose();
            }
        }
        closed = true;
        serviceStarted = false;
        Log.i(TAG, "onClose2");
    }

    public int getAppVersion() {
        try {
            return getPackageManager().getPackageInfo(getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getDeviceId() {
        try {
            return UniqueIMEIID.getUniqueIMEIId(getApplicationContext());
        } catch (Exception e) {
            return "EMPTY";
        }
    }

    public void showToast() throws Exception {
        Toast.makeText(getApplicationContext(), getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
    }
}
