package com.hippoagent;

import android.text.TextUtils;

import java.util.HashMap;

/**
 * Created by gurmail on 2020-04-30.
 *
 * @author gurmail
 */
public class HippoConfigAttributes {

    private String appType;
    private String appKey; // as app secret key
    private String environment;
    private String provider;
    private boolean showLog;
    private String deviceToken;
    private String authToken;
    private int versionCode;
    private boolean debugType;
    private boolean isWhitelabel;
    private String appName;
    private boolean hasAccessToken;
    private boolean isForked;
    private HashMap<String, Object> customAttributes;
    private String lang;
    private HippoAdditionalInfo additionalInfo;
    private boolean shareAllFiles;

    public HippoAdditionalInfo getAdditionalInfo() {
        return additionalInfo;
    }
    public HashMap<String, Object> getCustomAttributes() {
        return customAttributes;
    }

    public String getAppType() {
        return appType;
    }

    public String getAppKey() {
        return appKey;
    }

    public int getVersionCode() {
        return versionCode;
    }

    public String getEnvironment() {
        return environment;
    }

    public boolean getIsWhitelabel() {
        return isWhitelabel;
    }

    public boolean getIsForked() {
        return isForked;
    }

    public boolean hasAccessToken() {
        return hasAccessToken;
    }

    public String getProvider() {
        return provider;
    }

    public String getDeviceToken() {
        return deviceToken;
    }

    public String getAuthToken() {
        return authToken;
    }

    public boolean isShowLog() {
        return showLog;
    }
    public boolean isShareAllFiles() {
        return shareAllFiles;
    }

    public boolean isdebugType() {
        return debugType;
    }

    public String getAppName() {
        return appName;
    }

    public String getLang() {
        return lang;
    }

    public static class Builder {

        private String appName;
        private String appType;
        private String appKey;
        private String environment;
        private String provider;
        private boolean showLog;
        private boolean shareAllFiles;
        private boolean debugType;
        private String authToken;
        private String deviceToken;
        private int versionCode;
        private boolean isWhitelabel;
        private boolean isForked;
        private boolean hasAccessToken;
        private HashMap<String, Object> customAttributes;
        private String lang;
        private HippoAdditionalInfo additionalInfo;

        private HippoConfigAttributes attributes = new HippoConfigAttributes(this);

        public Builder setAuthToken(String authToken) {
            attributes.authToken = authToken;
            return this;
        }

        public Builder setLanguage(String lang) {
            attributes.lang = lang;
            return this;
        }

        public Builder hasAccessToken(boolean hasAccessToken) {
            attributes.hasAccessToken = hasAccessToken;
            return this;
        }

        public Builder setAppType(String appType) {
            attributes.appType = appType;
            return this;
        }

        public Builder setAppName(String appName) {
            attributes.appName = appName;
            return this;
        }

        public Builder setAppSecretKey(String appKey) {
            attributes.appKey = appKey;
            return this;
        }

        public Builder setEnvironment(String environment) {
            attributes.environment = environment;
            return this;
        }

        public Builder setIsWhitelabel(boolean isWhitelabel) {
            attributes.isWhitelabel = isWhitelabel;
            return this;
        }

        public Builder setIsForked(boolean isForked) {
            attributes.isForked = isForked;
            return this;
        }

        public Builder setProvider(String provider) {
            attributes.provider = provider;
            return this;
        }


        public Builder setShowLog(boolean showLog) {
            attributes.showLog = showLog;
            return this;
        }

        //set true if you want to share all types of files in chat
        public Builder setShareAllFiles(boolean shareAllFiles) {
            attributes.shareAllFiles = shareAllFiles;
            return this;
        }

        public Builder setdebugType(boolean debugType) {
            attributes.debugType = debugType;
            return this;
        }


        public Builder setDeviceToken(String deviceToken) {
            attributes.deviceToken = deviceToken;
            return this;
        }

        public Builder setVersionCode(int versionCode) {
            attributes.versionCode = versionCode;
            return this;
        }

        public Builder setCustomAttributes(HashMap<String, Object> customAttributes) {
            attributes.customAttributes = customAttributes;
            return this;
        }

        public Builder setAdditionalInfo(HippoAdditionalInfo additionalInfo) {
            attributes.additionalInfo = additionalInfo;
            return this;
        }


        public HippoConfigAttributes build() {
//            if (TextUtils.isEmpty(attributes.appType)) {
//                throw new IllegalStateException("AppType can not be empty!");
//            } else
            if (TextUtils.isEmpty(attributes.provider)) {
                throw new IllegalStateException("Provider can not be empty!");
            } else if (TextUtils.isEmpty(attributes.authToken))
                throw new IllegalArgumentException("AuthToken can not be empty!");

            return attributes;
        }
    }

    private HippoConfigAttributes(Builder builder) {
        this.appType = builder.appType;
        this.appKey = builder.appKey;
        this.environment = builder.environment;
        this.provider = builder.provider;
        this.showLog = builder.showLog;
        this.shareAllFiles = builder.shareAllFiles;
        this.authToken = builder.authToken;
        this.deviceToken = builder.deviceToken;
        this.versionCode = builder.versionCode;
        this.isWhitelabel = builder.isWhitelabel;
        this.isForked = builder.isForked;
        this.appName = builder.appName;
        this.hasAccessToken = builder.hasAccessToken;
        this.customAttributes = builder.customAttributes;
        this.lang = builder.lang;
        this.additionalInfo = builder.additionalInfo;
    }
}