package com.hippoagent;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;

import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.google.gson.Gson;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.HippoChatActivity;
import com.hippoagent.activities.HomeActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.fcm.NotificationUtils;
import com.hippoagent.fcm.PushHandler;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.helper.ConnectionUtils;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.model.FuguConversation;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.model.promotional.CustomAttributes;
import com.hippoagent.model.promotional.Data;
import com.hippoagent.model.promotional.PromotionResponse;
import com.hippoagent.services.AdvanceSpecService;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.ToastUtil;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

import io.paperdb.Paper;
import kotlin.jvm.Synchronized;

import static com.hippoagent.datastructure.FuguAppConstant.NOTIFICATION_INTENT;
import static com.hippoagent.fcm.NotificationUtils.NOTIFICATION_CHANNEL_ID;

/**
 * Created by gurmail on 2020-05-01.
 *
 * @author gurmail
 */
public class HippoNotificationConfig {
    private static String TAG = HippoNotificationConfig.class.getSimpleName();
    UserData userData;
    private int smallIcon = -1;
    private int priority;

    private long[] vibrate;
    private Uri soundUri;

    public static Long pushChannelId = -1L;
    public static Long pushLabelId = -1L;

    private NotificationUtils notificationUtils;
    Context mcontext;

    public boolean isHippoNotification(@NotNull Context applicationContext, @NotNull Map<String, String> data) {
        mcontext = applicationContext;
        if (data.containsKey("push_source") && data.get("push_source").equalsIgnoreCase("FUGU")) {
            return true;
        } else
            return false;
    }

    public void showNotification(@Nullable Context applicationContext, @NotNull Map<String, String> data) {
        JSONObject object = null;
        try {
            object = new JSONObject(data.get("message"));
            handleDataMessage(applicationContext, object, data);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void handleHippoPushNotification(final Context context, final Bundle bundle) {
        if (bundle != null) {
            new Handler().postDelayed(() -> {
                FuguConversation conversation = new Gson().fromJson(bundle.getString(FuguAppConstant.CONVERSATION), FuguConversation.class);
                if (conversation != null && HippoConfig.getInstance() != null) {
                    Log.e(TAG, "conversation: " + new Gson().toJson(conversation));
                    Intent conversationIntent = new Intent(context, FuguChatActivity.class);
                    if (conversation.getChannelId() < 0 && conversation.getLabelId() < 0) {
                        conversationIntent = new Intent(context, HomeActivity.class);
                    }
                    conversationIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));
                    context.startActivity(conversationIntent);
                }
            }, 400);
        }
    }

    private UserData getUserData() {
        if (userData == null) {
            userData = Paper.book(CommonData.name).read(SPLabels.USER_DATA);
        }
        return userData;
    }


    private void handleDataMessage(@Nullable Context context, JSONObject data, @NotNull Map<String, String> stringStringMap) {
        try {
            //JSONObject data = json.getJSONObject("message");

            try {
                if (getUserData() != null && getUserData().isVideoCallEnabled() && data.optInt("notification_type") == 14
                        && (data.optString("video_call_type").equalsIgnoreCase("START_CALL")
                        || (data.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP")))) {
                    videoCallPush(context, data);
                    return;
                } else if (data.optInt("notification_type") == 14) {
                    return;
                } else if (getUserData() != null && getUserData().isVideoCallEnabled()
                        && data.optInt("notification_type") == 20) {
                    HippoConfCallPush(context, data);
                } else if (data.optInt("notification_type") == 21) {
                    int channedId = data.optInt("channel_id", -1);
                    if (channedId > 0)
                        NotificationUtils.clearNotifications(context, channedId);
                    checkConnection(context);
                } else if (data.optInt("notification_type") == 23) {
                    new PushHandler().notificationMissedCall(context, data);
                    checkConnection(context);
                } else if (!TextUtils.isEmpty(data.optString("chat_transaction_id", ""))) {
                    int channedId = data.optInt("channel_id", -1);
                    if (HippoNotificationConfig.pushChannelId != channedId && channedId > 0) {
                        new PushHandler().notificationCustomerHelper(context, data, notificationSoundEnabled);
                    }
                } else {

                    Intent mIntent = new Intent(NOTIFICATION_INTENT);
                    Bundle dataBundle = new Bundle();
                    for (String key : stringStringMap.keySet()) {
                        dataBundle.putString(key, stringStringMap.get(key));
                    }
                    mIntent.putExtras(dataBundle);
                    LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent);
                    Paper.init(context);

                    if (data.has("is_announcement_push") && data.optInt("is_announcement_push", 0) == 1) {
                        Integer channelId = 0;
                        try {
                            advanceStatsApi(context, data);
                            if (data.has("channel_id")) {
                                channelId = data.optInt("channel_id", -1);
                                updateCount("" + channelId);
                            }
                        } catch (Exception e) {

                        }

                        if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isAnnouncements()) {
                            JSONObject json = data;
                            PromotionResponse response = CommonData.getPromotionResponse();
                            if (response == null)
                                response = new PromotionResponse();


                            Data broadcast = new Data(Integer.parseInt(HippoConfig.getInstance().getUserData().getUserId().toString()));
                            broadcast.setChannelId(json.getInt("channel_id"));
                            broadcast.setCreatedAt(json.getString("date_time"));
                            broadcast.setDisableReply(json.getInt("disable_reply"));
                            broadcast.setDescription(json.getString("message"));
                            if(json.has("custom_attributes")) {
                                CustomAttributes attr = new Gson().fromJson(json.getString("custom_attributes"), CustomAttributes.class);
                                broadcast.setCustomAttributes(attr);
                            }
                            broadcast.setTitle(json.getString("title"));
                            broadcast.setAddedFromBroadcast(true);
                            if (response == null || response.getData() == null)
                                response.setData(new ArrayList<>());

                            response.getData().add(0, broadcast);
                            CommonData.savePromotionResponse(response);

                            new PushHandler().notificationAnnouncementHelper(context, data, notificationSoundEnabled);
                        }
                    } else {
                        advanceStatsApi(context, data);
                        int channedId = data.optInt("channel_id", -1);
                        if (FuguChatActivity.pushChannelId != channedId && channedId > 0) {
                            new PushHandler().notificationHelper(context, data, notificationSoundEnabled);
                            updateUnreadCount(channedId);
                        }
                        checkConnection(context);
                    }
                    return;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        } catch (Exception e) {
            Log.e(TAG, "Json Exception: " + e.getMessage());
        }
    }
    private void advanceStatsApi(Context context, JSONObject messageJson) {

        try {
            if (CommonData.getAdvanceSpecData() != null && CommonData.getAdvanceSpecData().getStart_time_milis() > 0L) {
                Intent intent = new Intent(context, AdvanceSpecService.class);
                intent.putExtra("messageJson", CommonData.getAdvanceSpecData().getMessage());
                intent.putExtra("isCtrSessionTime", true);
//                intent.putExtra("messageJson", messageJson.toString());
//                intent.putExtra("isDelivered", true);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O)

                    context.startForegroundService(intent);
                else
                    context.startService(intent);
            }


        } catch (Exception e) {
            e.printStackTrace();
        }


        Intent intent = new Intent(context, AdvanceSpecService.class);
        intent.putExtra("messageJson", messageJson.toString());
        intent.putExtra("isDelivered", true);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O)
            context.startForegroundService(intent);
        else
            context.startService(intent);

    }
    private void updateUnreadCount(int channedId) {
        /*try {
            if (HippoConfig.getInstance() != null && HippoApplication.getInstance().isAppOpen == null
                    || HippoApplication.getInstance().isAppOpen == 0) {
                UnreadCountHelper.getInstance().addTotalPushUnread(messageJson.getInt("channel_id"));
            }
        } catch (Exception e) {
            //e.printStackTrace();
        }*/
    }

    @Synchronized
    private void checkConnection(Context context) {
        if (ConnectionUtils.INSTANCE.isAppRunning(context)) {
            ConnectionManager.INSTANCE.onInitialized();
        }
    }

    /**
     * Showing notification with text only
     */
    private void showNotificationMessage(Context context, String title, String message,
                                         String timeStamp, Intent intent, int channedId, int userId, int disableReply) {
        notificationUtils = new NotificationUtils(context);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        if (channedId != -1)
            intent.putExtra("channed_id", channedId);
        if (userId != -1)
            intent.putExtra("user_id", userId);
        intent.putExtra("disable_reply", disableReply);
        notificationUtils.showNotificationMessage(title, message, timeStamp, intent, channedId);
    }

    /**
     * Showing notification with text and image
     */
    private void showNotificationMessageWithBigImage(Context context, String title, String message,
                                                     String timeStamp, Intent intent, String imageUrl,
                                                     int channedId, int userId, int disableReply) {
        notificationUtils = new NotificationUtils(context);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        if (channedId != -1)
            intent.putExtra("channed_id", channedId);
        if (userId != -1)
            intent.putExtra("user_id", userId);
        intent.putExtra("disable_reply", disableReply);
        notificationUtils.showNotificationMessage(title, message, timeStamp, intent, imageUrl, channedId);
    }


    private void playSound() {
        /*if (CommonData.isBkUser()) {
            Intent intent = new Intent(this, AudioPlay.class);
            intent.putExtra("type", AppManager.AudioType.START);
            intent.putExtra("time", BK_SOUND_TIME);
            startService(intent);
        }*/
    }

    private void videoCallPush(Context context, JSONObject jsonObject) throws Exception {
        HippoCallConfig.getInstance().onNotificationReceived(context, jsonObject);
    }

    private void HippoConfCallPush(Context context, JSONObject jsonObject) throws Exception {
        HippoCallConfig.getInstance().onConfNotificationReceived(context, jsonObject);
    }

    /*public void setNotificationSoundEnabled(boolean isSoundEnbled) {
        if (isSoundEnbled) {
            notificationUtils = new NotificationUtils(mcontext);
            notificationUtils.playNotificationSound();
        }
    }*/

    private boolean notificationSoundEnabled = true;

    public void setNotificationSoundEnabled(boolean notificationSoundEnabled) {
        this.notificationSoundEnabled = notificationSoundEnabled;
    }

    public void setPriority(int priority) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(mcontext, NOTIFICATION_CHANNEL_ID);
        builder.setPriority(priority);
    }

    public void setSmallIcon(int smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setVibrate(long[] vibrate) {
        this.vibrate = vibrate;
    }

    public void setSoundUri(Uri soundUri) {
        this.soundUri = soundUri;
    }

    private void updateCount(String channelId) {
        if (HippoConfig.getInstance().getCallbackListener() == null) {
            return;
        }
        if (!HippoConfig.getInstance().isAnnouncements()) {
            HashSet<String> count = CommonData.getAnnouncementCount();
            count.add(channelId);
            CommonData.setAnnouncementCount(count);
            if (HippoConfig.getInstance().getAnnouncementCountListener() != null) {
                HippoConfig.getInstance().getAnnouncementCountListener().unreadAnnouncementsCount(count.size());
            }
        }
    }

    // Clears notification tray messages
    public static void clearNotifications(Context context, ArrayList<Integer> ids) {
        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        if (ids != null && ids.size() > 0) {
            for (Integer integer : ids) {
                notificationManager.cancel(integer);
            }
        }
    }
}

