package com.hippoagent.PrescriptionModule

import android.content.Intent
import android.os.Bundle
import android.view.View
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import com.google.gson.Gson
import com.hippoagent.HippoApplication
import com.hippoagent.PrescriptionModule.layouts.CustomFieldTextPrescription
import com.hippoagent.PrescriptionModule.layouts.CustomFieldTextViewPrescription
import com.hippoagent.PrescriptionModule.model.BodyKeys
import com.hippoagent.PrescriptionModule.model.BusinessTemplate
import com.hippoagent.PrescriptionModule.model.PrescriptionUrlData.PrescriptionUrlData
import com.hippoagent.R
import com.hippoagent.langs.Restring
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParamsObj
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Constants
import com.hippoagent.utils.Utils
import com.hippoagent.utils.filelogger.Logger.apiFailed
import com.hippoagent.utils.filelogger.Logger.apiRequest
import com.hippoagent.utils.filelogger.Logger.apiResponse
import kotlinx.android.synthetic.main.activity_custom_fields_prescription.*
import org.json.JSONObject
import java.util.*

class CustomFieldsPrescriptionActivity : AppCompatActivity() {

    private var channelID: String = ""
    var businessTemplate: BusinessTemplate = BusinessTemplate()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_custom_fields_prescription)

        btnSubmit.text = Restring.getString(this, R.string.send)
        noDataTV.text = Restring.getString(this, R.string.no_custom_field_found)

        // Get extra data included in the Intent
        if (intent.hasExtra("template")) {
            businessTemplate = Gson().fromJson(intent.getStringExtra("template"), BusinessTemplate::class.java)
            channelID = intent.getStringExtra("channelID").toString()
            if (businessTemplate.bodyKeys != null && businessTemplate.bodyKeys.size > 0) {
                ll_placeHolder.visibility = View.GONE
                llCustomFields.visibility = View.VISIBLE
                btnSubmit.visibility = View.VISIBLE
                renderCustomFieldsUi(businessTemplate.getBodyKeys())
            } else {
                ll_placeHolder.visibility = View.VISIBLE
                llCustomFields.visibility = View.GONE
                btnSubmit.visibility = View.GONE
            }
        }



        setSupportActionBar(my_toolbar);
        my_toolbar.setNavigationIcon(R.drawable.ic_back_icon);

        my_toolbar.setNavigationOnClickListener {
            onBackPressed()
        }

        tv_toolbar_name.text = Restring.getString(this, R.string.send_prescription)

        btnSubmit.setOnClickListener(View.OnClickListener {
            if (!Utils.preventMultipleClicks()) {
                return@OnClickListener
            }

            if (!isValid()) {
                return@OnClickListener
            }
            createPrescription()

        })

    }

    private fun isValid(): Boolean {
        var isvalid = true;
        for (i in businessTemplate.bodyKeys) {
            if (i.value == null || i.value.isEmpty()) {
                isvalid = false
                Toast.makeText(applicationContext, i.key.replace("_", " ") + " " + Restring.getString(this, R.string.cannot_be_empty).trim(), Toast.LENGTH_SHORT).show()

                break
            }
        }

        return isvalid
    }


    private fun createPrescription() {

//        custom_attributes: {"AGENT_EMAIL":"g7@yopmail.com","AGENT_PHONE_NUMBER":"+9718288870152","CUSTOMER_NAME":"sdf","test":"test"}
//        lang: en


        val params = HashMap<String, Any>()
        params[Constants.ACCESS_TOKEN] = HippoApplication.getInstance().userData.accessToken.toString()
        params["template_id"] = businessTemplate.templateId
        params["lang"] = HippoApplication.getInstance().userData.langCode
        params["channel_id"] = channelID

        var temPlateData = JSONObject()

        for (i in businessTemplate.bodyKeys) {
            if (i.type.equals("href", false)) {
                temPlateData.put(i.key, getHyperLink(i))
            } else {
                temPlateData.put(i.key, i.value)
            }
        }

        params["custom_attributes"] = temPlateData

        val commonParams = CommonParamsObj.Builder()
                .addAll(params)
                .build()

        apiRequest("/api/conversation/createAndSendPrescription", Gson().toJson(commonParams.map))
        RestClient.getApiInterface().createAndSendPrescription(commonParams.map)
                .enqueue(object : ResponseResolver<PrescriptionUrlData?>(this, true) {

                    override fun failure(error: APIError) {
                        apiFailed("/api/conversation/createAndSendPrescription", error.message)
                    }

                    override fun success(t: PrescriptionUrlData?) {
                        apiResponse("/api/conversation/createAndSendPrescription", "")

                        returnIntent(t)

                    }
                })

    }

    private fun getHyperLink(i: BodyKeys): String {
        val url: String = i.value
        val utring = "<a target=\"_blank\" href=\"${url}\">${url}</a>"
        return utring
    }

    private fun returnIntent(t: PrescriptionUrlData?) {
        val returnIntent = Intent()
        returnIntent.putExtra("PrescriptionUrlData", t)
        setResult(RESULT_OK, returnIntent)
        finish()
    }

    private fun renderCustomFieldsUi(bodyKeys: List<BodyKeys?>) {
        llCustomFields.removeAllViews()
        for (i in bodyKeys.indices!!) {
            val template: BodyKeys? = bodyKeys[i]
            if (template?.type.equals("text", true)) {
                val customFieldString = CustomFieldTextPrescription(this)
                llCustomFields.addView(customFieldString.render(template))
            } else {
                val customFieldString = CustomFieldTextViewPrescription(this)
                llCustomFields.addView(customFieldString.render(template))
            }
        }

    }


}