package com.hippoagent.PrescriptionModule

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.graphics.Typeface
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.hippoagent.PrescriptionModule.model.PrescriptionTemplateData
import com.hippoagent.R
import com.hippoagent.langs.Restring
import kotlinx.android.synthetic.main.bottom_sheet_prescription_template.*
import org.jetbrains.annotations.NotNull

//class PrescriptionBottomSheetFragment {
//}

class PrescriptionBottomSheetFragment(prescriptionData: @NotNull PrescriptionTemplateData, var activity: @NotNull Activity, var channelID: String) : BottomSheetDialogFragment() {
    private var prescriptionRV: RecyclerView? = null
    private var titleTV: TextView? = null

    private val mView: View? = null
    private var mContext: Context? = null
    private var prescriptionTemplateAdapter: PrescriptionTemplateAdapter? = null
    var prescriptionTemplateData: PrescriptionTemplateData = prescriptionData

    override fun getTheme(): Int {
        return R.style.HippoBottomSheetDialogTheme
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
                              savedInstanceState: Bundle?): View? {
        // Inflate the layout for this fragment
        val view: View = inflater.inflate(R.layout.bottom_sheet_prescription_template, container, false)
        init(view)
        return view
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        mContext = context
    }


    private fun init(rootView: View) {
        prescriptionRV = rootView.findViewById<View>(R.id.prescriptionRV) as RecyclerView
        titleTV = rootView.findViewById<View>(R.id.titleTV) as TextView
        val layoutManager = LinearLayoutManager(mContext)
        layoutManager.orientation = LinearLayoutManager.VERTICAL
        titleTV!!.text = Restring.getString(activity,R.string.select_e_form_template)
        titleTV!!.typeface = Typeface.DEFAULT_BOLD
        prescriptionRV!!.layoutManager = layoutManager
        prescriptionTemplateAdapter = PrescriptionTemplateAdapter(prescriptionTemplateData.data.businessTemplates, activity,channelID)
        prescriptionRV!!.adapter = prescriptionTemplateAdapter
    }


}
