package com.hippoagent.PrescriptionModule

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.google.gson.Gson
import com.hippoagent.PrescriptionModule.model.BusinessTemplate
import com.hippoagent.R
import com.hippoagent.model.Conversation
import com.hippoagent.utils.Constants
import kotlinx.android.synthetic.main.hippo_item_option.view.*

class PrescriptionTemplateAdapter(var templatesList: ArrayList<BusinessTemplate>, var activity: Activity, var channelID: String) : androidx.recyclerview.widget.RecyclerView.Adapter<androidx.recyclerview.widget.RecyclerView.ViewHolder>() {
    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.hippo_item_option, parent, false))
    }

    override fun getItemCount(): Int {
        return templatesList!!.size
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        val holder: PrescriptionTemplateAdapter.ViewHolder = holder as PrescriptionTemplateAdapter.ViewHolder
        holder.bind(position, templatesList!![position])
    }

    inner class ViewHolder(itemView: View) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, businessTemplate: BusinessTemplate) = with(itemView) {
            tvOption.text = businessTemplate.name.toString()
            main_layout.setOnClickListener {
//                if (templatesList?.get(position).getBodyKeys().size > 0) {
                val intent = Intent(activity, CustomFieldsPrescriptionActivity::class.java)
                intent.putExtra("template", Gson().toJson(templatesList?.get(position), BusinessTemplate::class.java))
                intent.putExtra("channelID", channelID)
                activity.startActivityForResult(intent, 22)
//                }
            }
        }

    }
}