package com.hippoagent.PrescriptionModule.layouts

import android.app.Activity
import android.content.Context
import android.text.*
import android.text.style.ForegroundColorSpan
import android.view.LayoutInflater
import android.view.View
import android.view.View.OnFocusChangeListener
import android.widget.EditText
import android.widget.TextView
import androidx.core.content.ContextCompat
import com.hippoagent.PrescriptionModule.model.BodyKeys
import com.hippoagent.R

class CustomFieldTextPrescription(var context: Activity) : TextWatcher, View.OnClickListener, OnFocusChangeListener {
    private val TAG = CustomFieldTextPrescription::class.java.simpleName

    private val view: View
    private val tvLabel: TextView
    private val vwDeliveryDetailsEmail: View
    private val etCustomFieldValue: EditText
    private var item: BodyKeys? = null


    /**
     * Method to render the data of the Custom Field
     *
     * @return
     */
    fun render(item: BodyKeys?): View {
        this.item = item

        if (item?.placeholder != null && !item?.placeholder.isEmpty())
            etCustomFieldValue.hint = item?.placeholder
        else
            etCustomFieldValue.hint = item?.key?.replace("_", " ")


        if (!item?.value?.isEmpty()!!)
            etCustomFieldValue.setText(item?.value)


        tvLabel.text = createSpan(context, item.key.replace("_", " "), "*")


        if (item.type.equals("email", true))
            etCustomFieldValue.inputType = InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS
        else if (item.type.equals("number", true))
            etCustomFieldValue.inputType = InputType.TYPE_CLASS_NUMBER



        return view
    }

    override fun beforeTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {}
    override fun onTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {}
    override fun afterTextChanged(editable: Editable) {

        item?.value = editable.toString()

    }

    override fun onClick(view: View) {
        when (view.id) {
            R.id.etCustomFieldValue -> {
            }

        }
    }

    /**
     * Method to create Listener
     *
     * @return
     */


    fun getView(): Any {
        return this
    }


    override fun onFocusChange(view: View, isFocus: Boolean) {
        if (!isFocus) etCustomFieldValue.isFocusableInTouchMode = false
    }
    //    private DateSelectionListener dateSelectionListener;
    /**
     * Method to initialize the CustomField
     */
    init {
        view = (context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater).inflate(R.layout.layout_custom_field_text_area, null)
        tvLabel = view.findViewById<View>(R.id.tvLabel) as TextView
        vwDeliveryDetailsEmail = view.findViewById(R.id.vwDeliveryDetailsEmail) as View
        etCustomFieldValue = view.findViewById<View>(R.id.etCustomFieldValue) as EditText
        etCustomFieldValue.addTextChangedListener(this)
        vwDeliveryDetailsEmail.visibility = View.GONE

    }

    fun createSpan(activity: Activity?, label: String, label1: String): Spannable? {
        var wordToSpan: Spannable? = null
        return try {
            wordToSpan = SpannableString(label + label1)
            wordToSpan.setSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.red)),
                    label.length, label.length + label1.length,
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
            wordToSpan
        } catch (e: Exception) {
            e.printStackTrace()
            wordToSpan
        }
    }
}
