package com.hippoagent.PrescriptionModule.layouts

import android.app.Activity
import android.app.DatePickerDialog
import android.app.TimePickerDialog.OnTimeSetListener
import android.content.Context
import android.text.*
import android.text.style.ForegroundColorSpan
import android.view.LayoutInflater
import android.view.View
import android.view.View.OnFocusChangeListener
import android.widget.*
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import com.hippoagent.PrescriptionModule.DatePickerFragment_
import com.hippoagent.PrescriptionModule.model.BodyKeys
import com.hippoagent.R
import com.hippoagent.langs.Restring
import com.hippoagent.utils.DateUtils
import java.text.ParseException
import java.util.*

class CustomFieldTextViewPrescription(var activity: Activity) : TextWatcher, View.OnClickListener, OnFocusChangeListener, DatePickerDialog.OnDateSetListener, OnTimeSetListener {
    private val TAG = CustomFieldTextViewPrescription::class.java.simpleName

    private val view: View
    private val tvLabel: TextView
    private val vwDeliveryDetailsEmail: View
    private val etCustomFieldValue: EditText
    private var item: BodyKeys? = null
    private var year = 0
    private var month = 0
    private var day = 0

    val inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"
    val outputFormat = "yyyy-MM-dd"

    /**
     * Method to render the data of the Custom Field
     *
     * @return
     */
    fun render(item: BodyKeys?): View {
        this.item = item

        if (item?.placeholder != null && !item?.placeholder.isEmpty())
            etCustomFieldValue.hint = item?.placeholder
        else
            etCustomFieldValue.hint = item?.key?.replace("_", " ")


        if (!item?.value?.isEmpty()!!)
            etCustomFieldValue.setText(item?.value)

        tvLabel.text = createSpan(activity, item.key.replace("_", " "), "*")

        if (item.type.equals("email", true))
            etCustomFieldValue.inputType = InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS
        else if (item.type.equals("number", true))
            etCustomFieldValue.inputType = InputType.TYPE_CLASS_NUMBER
        else if (item.type.equals("date", true)) {
            etCustomFieldValue.isFocusableInTouchMode = false
            etCustomFieldValue.isLongClickable = false
            etCustomFieldValue.isFocusable = false
            etCustomFieldValue.setOnClickListener(this)
            if (item?.value.isEmpty()) {
                val localDate = DateUtils.getFormattedDate(Date())
                etCustomFieldValue.setText(DateUtils.getInstance().convertToLocal(localDate,
                        inputFormat, outputFormat))
            }
        }



        return view
    }


    override fun beforeTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {}
    override fun onTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {}
    override fun afterTextChanged(editable: Editable) {

        item?.value = editable.toString()

    }

    override fun onClick(view: View) {
        when (view.id) {
            R.id.etCustomFieldValue -> {
                var datePickerFragment: DatePickerFragment_? = null
                datePickerFragment = DatePickerFragment_()
                datePickerFragment.setListener(this@CustomFieldTextViewPrescription)
                val taskTime = System.currentTimeMillis()

                if (item?.type.equals("date", true)) {
                    datePickerFragment.setMinDate(taskTime)

                }
                if (year > 0 && month > 0 && day > 0) {
                    datePickerFragment.day = day
                    datePickerFragment.setMonth(month)
                    datePickerFragment.setYear(year)
                }

                datePickerFragment.show((activity as AppCompatActivity).supportFragmentManager, TAG)


            }

        }
    }

    /**
     * Method to create Listener
     *
     * @return
     */


    fun getView(): Any {
        return this
    }


    override fun onFocusChange(view: View, isFocus: Boolean) {
        if (!isFocus) etCustomFieldValue.isFocusableInTouchMode = false
    }
    //    private DateSelectionListener dateSelectionListener;
    /**
     * Method to initialize the CustomField
     */
    init {
        view = (activity.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater).inflate(R.layout.layout_custom_field_text, null)
        tvLabel = view.findViewById<View>(R.id.tvLabel) as TextView
        vwDeliveryDetailsEmail = view.findViewById(R.id.vwDeliveryDetailsEmail) as View
        etCustomFieldValue = view.findViewById<View>(R.id.etCustomFieldValue) as EditText
        etCustomFieldValue.addTextChangedListener(this)
        vwDeliveryDetailsEmail.visibility = View.GONE

    }

    override fun onDateSet(p0: DatePicker?, year_: Int, monthOfYear: Int, dayOfMonth: Int) {
        year = year_
        month = monthOfYear
        day = dayOfMonth

        var dateSelected: String? = (monthOfYear + 1).toString() + "/" + dayOfMonth + "/" + year
        //Check if date is selected from lollipop devices
        //Check if date is selected from lollipop devices


        etCustomFieldValue.setText(dateSelected)
        val date = Date(year - 1900, month, day)
        date.hours = 0
        date.minutes = 0
        date.seconds = 0

        try {
            item?.value = DateUtils.getInstance().convertToUTC(date, true)
            etCustomFieldValue.setText(DateUtils.getInstance().convertToLocal(item?.value.toString(),
                    inputFormat, outputFormat))
        } catch (e: ParseException) {
            e.printStackTrace()
        }
    }

    override fun onTimeSet(p0: TimePicker?, hour: Int, minute: Int) {
        var isValid = year <= Calendar.getInstance()[Calendar.YEAR] && month <= Calendar.getInstance()[Calendar.MONTH] && day <= Calendar.getInstance()[Calendar.DAY_OF_MONTH] && hour <= Calendar.getInstance()[Calendar.HOUR_OF_DAY]
        if (hour == Calendar.getInstance()[Calendar.HOUR_OF_DAY]) {
            isValid = isValid && minute < Calendar.getInstance()[Calendar.MINUTE]
        }
        if (isValid) {
            Toast.makeText(activity, Restring.getString(activity,R.string.please_select_future_date_time), Toast.LENGTH_LONG).show()
            return
        }

        val timeSelected: String = "hh:mm"
        val dateSelected = (month + 1).toString() + "/" + day + "/" + year

        etCustomFieldValue.setText("$dateSelected $timeSelected")

        val date = Date(year - 1900, month, day)
        date.hours = hour
        date.minutes = minute

        try {
            item?.value = DateUtils.getInstance().convertToUTC(date.toString())
            etCustomFieldValue.setText(DateUtils.getInstance().convertToLocal(item?.value.toString(),
                    "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd HH:mm a"))
        } catch (e: ParseException) {
            e.printStackTrace()
        }
    }

    fun createSpan(activity: Activity?, label: String, label1: String): Spannable? {
        var wordToSpan: Spannable? = null
        return try {
            wordToSpan = SpannableString(label + label1)
            wordToSpan.setSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.red)),
                    label.length, label.length + label1.length,
                    Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
            wordToSpan
        } catch (e: Exception) {
            e.printStackTrace()
            wordToSpan
        }
    }
}
