package com.hippoagent.PrescriptionModule.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.List;

public class BusinessTemplate implements Parcelable {

    @SerializedName("template_id")
    @Expose
    private Long templateId;
    @SerializedName("business_id")
    @Expose
    private Object businessId;
    @SerializedName("template_header")
    @Expose
    private Object templateHeader;
    @SerializedName("template_footer")
    @Expose
    private Object templateFooter;
    @SerializedName("template_body")
    @Expose
    private Object templateBody;
    @SerializedName("header_keys")
    @Expose
    private HeaderKeys headerKeys;
    @SerializedName("footer_keys")
    @Expose
    private FooterKeys footerKeys;
    @SerializedName("body_keys")
    @Expose
    private List<BodyKeys> bodyKeys = null;
    @SerializedName("preview")
    @Expose
    private String preview;
    @SerializedName("status")
    @Expose
    private String status;
    @SerializedName("name")
    @Expose
    private String name;
    @SerializedName("body_data")
    @Expose
    private String bodyData;
    public final static Parcelable.Creator<BusinessTemplate> CREATOR = new Creator<BusinessTemplate>() {


        @SuppressWarnings({
                "unchecked"
        })
        public BusinessTemplate createFromParcel(Parcel in) {
            return new BusinessTemplate(in);
        }

        public BusinessTemplate[] newArray(int size) {
            return (new BusinessTemplate[size]);
        }

    };

    protected BusinessTemplate(Parcel in) {
        this.templateId = ((Long) in.readValue((Long.class.getClassLoader())));
        this.businessId = ((Object) in.readValue((Object.class.getClassLoader())));
        this.templateHeader = ((Object) in.readValue((Object.class.getClassLoader())));
        this.templateFooter = ((Object) in.readValue((Object.class.getClassLoader())));
        this.templateBody = ((Object) in.readValue((Object.class.getClassLoader())));
        this.headerKeys = ((HeaderKeys) in.readValue((HeaderKeys.class.getClassLoader())));
        this.footerKeys = ((FooterKeys) in.readValue((FooterKeys.class.getClassLoader())));
        in.readList(this.bodyKeys, (BodyKeys.class.getClassLoader()));
        this.preview = ((String) in.readValue((String.class.getClassLoader())));
        this.status = ((String) in.readValue((String.class.getClassLoader())));
        this.name = ((String) in.readValue((String.class.getClassLoader())));
        this.bodyData = ((String) in.readValue((String.class.getClassLoader())));
    }

    public BusinessTemplate() {
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Object getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Object businessId) {
        this.businessId = businessId;
    }

    public Object getTemplateHeader() {
        return templateHeader;
    }

    public void setTemplateHeader(Object templateHeader) {
        this.templateHeader = templateHeader;
    }

    public Object getTemplateFooter() {
        return templateFooter;
    }

    public void setTemplateFooter(Object templateFooter) {
        this.templateFooter = templateFooter;
    }

    public Object getTemplateBody() {
        return templateBody;
    }

    public void setTemplateBody(Object templateBody) {
        this.templateBody = templateBody;
    }

    public HeaderKeys getHeaderKeys() {
        return headerKeys;
    }

    public void setHeaderKeys(HeaderKeys headerKeys) {
        this.headerKeys = headerKeys;
    }

    public FooterKeys getFooterKeys() {
        return footerKeys;
    }

    public void setFooterKeys(FooterKeys footerKeys) {
        this.footerKeys = footerKeys;
    }

    public List<BodyKeys> getBodyKeys() {
        return bodyKeys;
    }

    public void setBodyKeys(List<BodyKeys> bodyKeys) {
        this.bodyKeys = bodyKeys;
    }

    public String getPreview() {
        return preview;
    }

    public void setPreview(String preview) {
        this.preview = preview;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBodyData() {
        return bodyData;
    }

    public void setBodyData(String bodyData) {
        this.bodyData = bodyData;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue(templateId);
        dest.writeValue(businessId);
        dest.writeValue(templateHeader);
        dest.writeValue(templateFooter);
        dest.writeValue(templateBody);
        dest.writeValue(headerKeys);
        dest.writeValue(footerKeys);
        dest.writeList(bodyKeys);
        dest.writeValue(preview);
        dest.writeValue(status);
        dest.writeValue(name);
        dest.writeValue(bodyData);
    }

    public int describeContents() {
        return 0;
    }

}