package com.hippoagent;

import android.text.TextUtils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippoagent.callback.AgentUnreadCountListener;
import com.hippoagent.callback.UnreadListener;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.model.UnreadCountData;
import com.hippoagent.model.unreadResponse.AgentUnreadCount;
import com.hippoagent.model.unreadResponse.UnreadCountResponse;
import com.hippoagent.model.unreadResponse.UserUnreadCount;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Log;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by gurmail on 27/06/18.
 *
 * @author gurmail
 */

public class UnreadCountHelper implements UnreadListener {
    private static final String TAG = UnreadCountHelper.class.getSimpleName();
    private static UnreadCountHelper instance;
    private HashMap<Integer, Integer> totalUnreadCount = new HashMap<>();
    private int totalCount = 0;
    private UnreadCountHelper() {

    }

    protected void setListener() {
        HippoConfig.getInstance().setInternalCountListener(this);
    }

    protected static UnreadCountHelper getInstance() {
        if(instance == null) {
            synchronized (UnreadCountHelper.class) {
                if(instance == null) {
                    instance = new UnreadCountHelper();
                    instance.setHelperListener();
                }
            }
        }
        instance.checkHelperListener();
        return instance;
    }

    private void setHelperListener() {
        HippoApplication.getInstance().addUIListener(UnreadListener.class, this);
    }

    private void checkHelperListener() {
        HippoApplication.getInstance().addOrUpdateUIListener(UnreadListener.class, this);
    }

    private static Type listType = new TypeToken<ArrayList<String>>() {
    }.getType();

    @Override
    public void pushUpdateCount(String userUniqueKey, boolean isArrayStr) {
        if(TextUtils.isEmpty(userUniqueKey))
            return;
        if(isArrayStr) {
            ArrayList<String> userUniqueKeyArr = new Gson().fromJson(userUniqueKey, listType);
            for(String string : userUniqueKeyArr) {
                UnreadCountData countData = CommonData.getUnreadCount(string);
                if(countData == null || TextUtils.isEmpty(countData.getUserUniqueKey()))
                    continue;

                int count = countData.getCount();
                count = count + 1;
                countData.setCount(count);
                CommonData.addUnreadCount(string, countData);
            }
        } else {
            UnreadCountData countData = CommonData.getUnreadCount(userUniqueKey);
            if(countData == null || TextUtils.isEmpty(countData.getUserUniqueKey()))
                return;

            int count = countData.getCount();
            count = count + 1;
            countData.setCount(count);
            CommonData.addUnreadCount(userUniqueKey, countData);
        }

        HashMap<String, UnreadCountData> dataHashMap = CommonData.getUnreadCount();

        HashMap<String, Integer> hashMap = new HashMap<>();
        for (Map.Entry map : dataHashMap.entrySet()) {
            UnreadCountData data = (UnreadCountData) map.getValue();
            hashMap.put((String) map.getKey(), data.getCount());
        }

        String jsonData = new Gson().toJson(hashMap);
        if(HippoConfig.getInstance().getAgentCountListener() != null)
            HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
    }

    @Override
    public void updateOpenChannelCount(ArrayList<String> userUniqueKeyArr, int value) {
        for(String userUniqueKey : userUniqueKeyArr) {
            UnreadCountData countData = CommonData.getUnreadCount(userUniqueKey);
            if (countData == null || TextUtils.isEmpty(countData.getUserUniqueKey()))
                continue;
            int count = countData.getCount();
            count = count - value;
            if (count < 0)
                count = 0;
            countData.setCount(count);
            CommonData.addUnreadCount(userUniqueKey, countData);
        }
        HashMap<String, UnreadCountData> dataHashMap = CommonData.getUnreadCount();
        HashMap<String, Integer> hashMap = new HashMap<>();
        for (Map.Entry map : dataHashMap.entrySet()) {
            UnreadCountData data = (UnreadCountData) map.getValue();
            hashMap.put((String) map.getKey(), data.getCount());
        }

        String jsonData = new Gson().toJson(hashMap);
        if(HippoConfig.getInstance().getAgentCountListener() != null)
            HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
    }



    @Override
    public void getUnreadCount() {
        HashMap<String, UnreadCountData> countHashMap = CommonData.getUnreadCount();
        HashMap<String, Integer> hashMap = new HashMap<>();
        for (Map.Entry map : countHashMap.entrySet()) {
            UnreadCountData data = (UnreadCountData) map.getValue();
            hashMap.put((String) map.getKey(), data.getCount());
        }

        String jsonData = new Gson().toJson(hashMap);
        if(HippoConfig.getInstance().getAgentCountListener() != null)
            HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
    }

    @Override
    public void getUpdatedUnreadCount(ArrayList<String> strings) {
        //FuguLog.i(TAG, "getUIListeners = "+HippoConfig.getInstance().getUIListeners(UnreadListener.class).size());
        if(strings == null)
            strings = CommonData.getAgentUniqueKey();
        if(HippoConfig.getInstance().getAgentCountListener() != null)
            getUpdatedUnreadCount(strings, HippoConfig.getInstance().getAgentCountListener());

    }

    @Override
    public void getUpdatedUnreadCount(ArrayList<String> strings, final AgentUnreadCountListener countListener) {
        UserData userData = HippoApplication.getInstance().getUserData();
        if(strings == null)
            strings = CommonData.getAgentUniqueKey();
        if(userData == null || strings == null)
            return;
        CommonParams commonParams = new CommonParams.Builder()
                .add(FuguAppConstant.ACCESS_TOKEN, userData.getAccessToken())
                .add(FuguAppConstant.USER_UNIQUE_KEY, new Gson().toJson(strings))
                .add(FuguAppConstant.RESPONSE_TYPE, 1)
                .build();

        RestClient.getApiInterface().getUnreadCount(commonParams.getMap())
                .enqueue(new ResponseResolver<UnreadCountResponse>() {
                    @Override
                    public void success(UnreadCountResponse unreadCountResponse) {
                        try {
                            CommonData.clearUnreadCount();
                            HashMap<String, UnreadCountData> countHashMap = new HashMap<>();

                            for(UserUnreadCount unreadCount : unreadCountResponse.getData().getUserUnreadCount()) {
                                UnreadCountData data = new UnreadCountData();
                                data.setUserUniqueKey(unreadCount.getUserUniqueKey());
                                data.setHippoUserId(unreadCount.getUserId());
                                data.setCount(unreadCount.getUnreadCount());

                                countHashMap.put(unreadCount.getUserUniqueKey(), data);
                            }
                            CommonData.addAllUnreadCount(countHashMap);
                            HashMap<String, Integer> hashMap = new HashMap<>();
                            for (Map.Entry map : countHashMap.entrySet()) {
                                UnreadCountData data = (UnreadCountData) map.getValue();
                                hashMap.put((String) map.getKey(), data.getCount());
                            }
                            String jsonData = new Gson().toJson(hashMap);
                            if(HippoConfig.getInstance().getAgentCountListener() != null)
                                HippoConfig.getInstance().getAgentCountListener().unreadCount(jsonData);
                        } catch (Exception e) {

                        }
                    }

                    @Override
                    public void failure(APIError error) {

                    }
                });
    }


    @Override
    public void setApiCountResponse(ArrayList<AgentUnreadCount> agentWiseCount) {
        try {
            totalCount = 0;
            if(agentWiseCount != null && agentWiseCount.size() > 0) {
                for(AgentUnreadCount unreadCount : agentWiseCount) {
                    totalCount = totalCount + unreadCount.getUnreadCount();
                    totalUnreadCount.put(unreadCount.getChannelId(), unreadCount.getUnreadCount());
                }
            }

            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(totalCount, totalUnreadCount.values().size());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTotalPushUnread(Integer channelId) {
        try {
            totalCount += 1;
            // containsKey() checks if this map contains a mapping for a key
            try {
                Integer count = totalUnreadCount.containsKey(channelId) ? totalUnreadCount.get(channelId) : 0;
                totalUnreadCount.put(channelId, count + 1);
            } catch (Exception e) {

            }

            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(totalCount, totalUnreadCount.values().size());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeTotalPushUnread(Integer channelId) {
        int count = totalUnreadCount.get(channelId);
        totalUnreadCount.remove(channelId);
        totalCount = totalCount - count;
        if(totalCount == 0 || totalCount < 0) {
            totalUnreadCount.clear();
            totalCount = 0;
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(totalCount, totalUnreadCount.values().size());
        }
    }

    @Override
    public void sendTotalUnreadCount() {
        Log.i(TAG, "totalUnreadCount: "+new Gson().toJson(totalUnreadCount));
        totalCount = 0;
        for(Integer value : totalUnreadCount.values()) {
            totalCount = totalCount + value;
        }
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(totalCount, totalUnreadCount.values().size());
        }
    }


}
