package com.hippoagent.activities

import android.app.Activity
import android.app.ActivityManager
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.graphics.Color
import android.net.ConnectivityManager
import android.os.Bundle
import com.google.android.material.snackbar.Snackbar
import androidx.core.content.ContextCompat
import androidx.appcompat.app.ActionBar
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import android.view.MenuItem
import android.view.View
import android.widget.TextView
import com.hippoagent.R
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.dialogs.DialogPop
import com.hippoagent.model.FileuploadModel
import com.hippoagent.utils.filePicker.Prefs
import com.hippoagent.utils.filePicker.UploadingService

import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.hippoagent.HippoConfig
import io.github.inflationx.viewpump.ViewPumpContextWrapper
import java.util.ArrayList

/**
 * Created by gurmail on 2019-09-26.
 * @author gurmail
 */
abstract class BaseActivity: AppCompatActivity(), FuguAppConstant {

    private var toolbar: Toolbar? = null
    var fileuploadType = object : TypeToken<List<FileuploadModel>>() {

    }.type

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onResume() {
        super.onResume()
    }

    override fun attachBaseContext(newBase: Context) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase))
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        // handle arrow click here
        if (item?.itemId == android.R.id.home) {
            finish() // close this context and return to preview context (if there is any)
        }
        return super.onOptionsItemSelected(item)
    }

    public fun checkAutoUpload() {
        if (!isMyServiceRunning(UploadingService::class.java)) {
            val fileuploadModels = Gson().fromJson<ArrayList<FileuploadModel>>(Prefs.with(this).getString(FuguAppConstant.KEY, ""), fileuploadType)
                    ?: return
            if (fileuploadModels.size > 0) {
                val intent = Intent(baseContext, UploadingService::class.java)
                intent.action = "start"
                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                    startForegroundService(intent)
                } else {
                    //lower then Oreo, just start the service.
                    startService(intent)
                }
            }
        }
    }

    public fun isMyServiceRunning(serviceClass: Class<*>): Boolean {
        val manager = getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
        for (service in manager.getRunningServices(Integer.MAX_VALUE)) {
            if (serviceClass.name == service.service.className) {
                return true
            }
        }
        return false
    }

    public fun setToolbar() {
        toolbar = findViewById<View>(R.id.toolbar) as Toolbar
        setSupportActionBar(toolbar)
        supportActionBar!!.setDisplayShowTitleEnabled(false)
    }

    public fun updateToolbar(toolbar: Toolbar, title: String) {
        (toolbar.findViewById<View>(R.id.tv_toolbar_name) as TextView).text = title
    }

    public fun setToolbar(toolbar: Toolbar, title: String): ActionBar? {
        //this.toolbar = toolbar;
        setSupportActionBar(toolbar)
        val ab = supportActionBar
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true)
            ab.title = ""
        }


        (toolbar.findViewById<View>(R.id.tv_toolbar_name) as TextView).text = title
        return supportActionBar
    }

    fun isNetworkAvailable(): Boolean {
        val cm = getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        val networkInfo = cm.activeNetworkInfo
        return networkInfo != null && networkInfo.isConnected
    }

    fun getToolbar(): Toolbar? {
        return toolbar
    }

    fun getAppVersion(): Int {
        try {
            return packageManager.getPackageInfo(packageName, 0).versionCode
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
            return 0
        }

    }

    fun getAppVersionName(): String {
        try {
            return "v" + packageManager.getPackageInfo(packageName, 0).versionName
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
            return ""
        }

    }

    fun showErrorMessage(errorMessage: String, positiveButtonText: String) {
        showErrorMessage(errorMessage, positiveButtonText, false)
    }

    fun showErrorMessage(errorMessage: String, positiveButtonText: String, isFinish: Boolean) {
        runOnUiThread {
            AlertDialog.Builder(this@BaseActivity)
                    .setMessage(errorMessage)
                    .setPositiveButton(positiveButtonText) { dialog, which ->
                        if (isFinish)
                            finish()
                    }
                    .setCancelable(false)
                    .show()
        }
    }

    private fun isEnabled(): Boolean {
        val update = CommonData.getVersionInfo()
        return if (update == null)
            false
        else if (HippoConfig.getInstance().getAttributes().versionCode >= update.version)
            false
        else if (HippoConfig.getInstance().getAttributes().versionCode  < update.version && update.lastVersion != update.version)
            true
        else if (update.lastVersion == update.version && update.interval > 0) {
            System.currentTimeMillis() - update.lastShown > update.interval * 60 * 1000
        } else
            false
    }

    internal var dialogPop: DialogPop? = null

    abstract fun updateOnActivityResult(requestCode: Int, resultCode: Int, data: Intent?)
    abstract fun getDrawerLayout(): View
    abstract fun showUpdate(flag: Boolean)

    lateinit var drawerView: View
    fun setDrawerLayout(view: View) {
        drawerView = view
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == APP_UPDATE_REQUEST_CODE) {
            if (resultCode != Activity.RESULT_OK) {
                if(CommonData.getInstallType() == 1) {
                    finishAffinity()
                    //checkForAppUpdate(CommonData.getInstallType())
                } else {
                    //Toast.makeText(this,"App Update failed, please try again on the next app launch.", Toast.LENGTH_SHORT).show()
                }
            }
        }
    }

//    private fun popupSnackbarForCompleteUpdate() {
//        showUpdate(true)
//        val snackbar = Snackbar.make(getDrawerLayout(), "An update has just been downloaded.", Snackbar.LENGTH_INDEFINITE)
//        snackbar.setAction("RESTART") {
//            //startUpdating(installType)
//            showUpdate(false)
////            appUpdateManager.completeUpdate()
//        }
//        snackbar.setActionTextColor(ContextCompat.getColor(this, R.color.assign_color))
//
//        //snack.view.setBackgroundColor(Color.parseColor("#FFFFFF"))
//        val textView = snackbar.view.findViewById(com.google.android.material.R.id.snackbar_text) as TextView
//        // change Snackbar text color
//        textView.setTextColor(Color.parseColor("#FFFFFF"))
//
//        snackbar.show()
//    }
//
//    var snackbar: Snackbar? = null
//    public fun softupdate() {
//        try {
//            if (!isEnabled())
//                return
//
//            if(snackbar != null && snackbar?.isShown!!)
//                return
//
//            showUpdate(true)
//            snackbar = Snackbar.make(getDrawerLayout(), "", Snackbar.LENGTH_INDEFINITE)
//            val view = layoutInflater.inflate(R.layout.snackbar_layout, null)
//            val snackBarView: Snackbar.SnackbarLayout = snackbar?.view as Snackbar.SnackbarLayout
//            snackBarView.addView(view, 0)
//
//            val cancelBtn: TextView = view.findViewById(R.id.btnCancel)
//            val updateBtn: TextView = view.findViewById(R.id.btnUpdate)
//
//            cancelBtn.setOnClickListener {
//                try {
//                    val update = CommonData.getVersionInfo()
//                    update.lastVersion = update.version
//                    update.lastShown = System.currentTimeMillis()
//                    CommonData.saveVersionInfo(update)
//                } catch (e: Exception) {
//                }
//                showUpdate(false)
//                snackbar?.dismiss()
//            }
//
//            updateBtn.setOnClickListener {
//                showUpdate(false)
////                showUpdatePopup()
//                snackbar?.dismiss()
//            }
//
//            snackbar?.show()
//        } catch (e: Exception) {
//        }
//    }

    companion object {
        private const val APP_UPDATE_REQUEST_CODE = 1991
    }

}