package com.hippoagent.activities

import android.os.Bundle
import com.hippoagent.R
import com.hippoagent.fragments.ChannelJourneyFragment
import com.hippoagent.langs.Restring
import kotlinx.android.synthetic.main.activity_payment.*

/**
 * Created by gurmail on 2019-09-09.
 * @author gurmail
 */
class ChannelJourney: FuguBaseActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_payment)

        setSupportActionBar(my_toolbar)
        setToolbar(my_toolbar, Restring.getString(this@ChannelJourney, R.string.channel_journey))

        my_toolbar.setNavigationOnClickListener {
            onBackPressed()
        }

        val data = intent.getStringExtra("cJourneyList")
        val channelID = intent.getStringExtra("channelID")
        channelID?.let { data?.let { it1 -> onChannelJourneyFragment(it1, it) } }
    }

    override fun onResume() {
        super.onResume()
    }

    override fun onPause() {
        super.onPause()
    }

    override fun onBackPressed() {
        if(supportFragmentManager.backStackEntryCount < 2) {
            finish()
        } else {
            super.onBackPressed()
        }
    }

    private fun onChannelJourneyFragment(data: String, channelID: String) {
        var fragment = ChannelJourneyFragment()
        val bundle = Bundle()
        bundle.putString("data", data)
        bundle.putString("channelID", channelID)
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
                .add(R.id.main_layout, fragment, ChannelJourneyFragment::class.java.simpleName)
                .addToBackStack(ChannelJourneyFragment::class.java.simpleName)
                .commitAllowingStateLoss()
    }
}