package com.hippoagent.activities;

import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;

import android.text.TextUtils;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.fragments.AgentFragment;
import com.hippoagent.fragments.ChannelFragment;
import com.hippoagent.fragments.DateFragment;
import com.hippoagent.fragments.LablesFragment;
import com.hippoagent.fragments.PeopleFragment;
import com.hippoagent.fragments.StatusFragment;
import com.hippoagent.fragments.TypeFragment;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.AgentListModel;
import com.hippoagent.model.DateModel;
import com.hippoagent.model.Filter;
import com.hippoagent.model.FilterModel;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.model.GetChannelsResponse;
import com.hippoagent.model.LoginResponse.ChannelFilter;
import com.hippoagent.model.LoginResponse.Tag;
import com.hippoagent.model.gettags.GetTagsResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.SPLabels;
import com.google.gson.Gson;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import io.paperdb.Paper;

/**
 * Created by gurmail on 31/05/18.
 *
 * @author gurmail
 */

public class FilterActivity extends FuguBaseActivity implements View.OnClickListener {

    private static final String TAG = FilterActivity.class.getSimpleName();

    private TextView peopleBtn, statusBtn, channelBtn, labelsBtn, typeBtn, tvResetBtn, dateTab, agentTab;
    private View dateView;
    public Button applyBtn;
    private String filterData;
    private FilterModel filterModel;
    private ArrayList<DateModel> dateList = new ArrayList<>();
    private boolean isAllChat;
    private TextView titleView;

    private String fromDate, toDate;

    public ArrayList<DateModel> getDateList() {
        return dateList;
    }

    public boolean isAllChat() {
        return isAllChat;
    }

    public FilterModel getFilterModel() {
        return filterModel;
    }

    public String getFromDate() {
        return fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getToDate() {
        return toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_filter);
        filterData = getIntent().getStringExtra("filterData");
        isAllChat = getIntent().getBooleanExtra("isAllChat", false);
        filterModel = new Gson().fromJson(filterData, FilterModel.class);


        if ((HippoApplication.getInstance().getUserData().getTags() != null && HippoApplication.getInstance().getUserData().getTags().size() > 0) ||
                (HippoApplication.getInstance().getUserData().getChannelFilter() != null && HippoApplication.getInstance().getUserData().getChannelFilter().size() > 0)) {
            setTagsTofilterModel();

            if (HippoApplication.getInstance().getUserData().getChannelFilter() != null && HippoApplication.getInstance().getUserData().getChannelFilter().size() > 0) {
                setChannelsToFilterModel();
                setView();
            } else
                getChannelFilter();

        } else
            getTagsAndFilters();

    }

    private void setChannelsToFilterModel() {
        if (filterModel.getChannelList().size() == 0) {
            ArrayList<ChannelFilter> channelFilters = (ArrayList<ChannelFilter>) HippoApplication.getInstance().getUserData().getChannelFilter();
            filterModel.getChannelList().clear();
            for (int i = 0; i < channelFilters.size(); i++) {
                Filter filter = new Filter();
                filter.setId(channelFilters.get(i).getId());
                filter.setName(channelFilters.get(i).getName());
                filter.setChecked(false);
                filterModel.getChannelList().add(filter);
            }
        }
    }

    private void setTagsTofilterModel() {
        if (filterModel.getLabelsList().size() == 0) {
            ArrayList<Tag> labels = (ArrayList<Tag>) HippoApplication.getInstance().getUserData().getTags();
            filterModel.getLabelsList().clear();
            for (int i = 0; i < labels.size(); i++) {
                Filter filter = new Filter();
                filter.setId(labels.get(i).getTagId());
                filter.setName(labels.get(i).getTagName());
                filter.setChecked(false);
                filterModel.getLabelsList().add(filter);
            }
        }
    }

    private void setView() {
        initView();

        int viewType = 0;
        if (filterModel.getViewType() == 1 || filterModel.getViewType() == 2)
            viewType = 1;
        else if (filterModel.getViewType() == 3)
            viewType = 3;

        openFragment(viewType);

        Toolbar toolbar = findViewById(R.id.my_toolbar);
        titleView = toolbar.findViewById(R.id.tv_toolbar_name);
        titleView.setText(Restring.getString(this, R.string.filter));

        toolbar.setTitle("");
        toolbar.setNavigationIcon(R.drawable.ic_close);
        setSupportActionBar(toolbar);

        setSupportActionBar(toolbar);
        toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }


    private void getTagsAndFilters() {
        CommonParams commonParams = new CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .build();
        RestClient.getApiInterface().getTags(commonParams.getMap()).enqueue
                (new ResponseResolver<GetTagsResponse>(this, true, true) {

                    @Override
                    public void success(GetTagsResponse getTagsResponse) {
                        try {
                            Paper.book(CommonData.name).write(SPLabels.TAGS, getTagsResponse.getData().getTags());
                            HippoApplication.getInstance().getUserData().setTags(getTagsResponse.getData().getTags());
                            setTagsTofilterModel();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        if (HippoApplication.getInstance().getUserData().getChannelFilter() != null
                                && HippoApplication.getInstance().getUserData().getChannelFilter().size() > 0) {
                            setChannelsToFilterModel();
                            setView();
                        } else
                            getChannelFilter();


                    }

                    @Override
                    public void failure(APIError error) {
                        setView();

                    }
                });
    }

    private void getChannelFilter() {
        CommonParams commonParams = new CommonParams.Builder()
                .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .build();
        RestClient.getApiInterface().getChannels(commonParams.getMap()).enqueue
                (new ResponseResolver<GetChannelsResponse>(this, true, true) {

                    @Override
                    public void success(GetChannelsResponse getTagsResponse) {
                        try {

                            ArrayList<ChannelFilter> channelFilters = new ArrayList<>();
                            for (int i = 0; i < getTagsResponse.getData().getChannels().size(); i++) {
                                ChannelFilter channelFilter = new ChannelFilter();
                                channelFilter.setId(getTagsResponse.getData().getChannels().get(i).getChannelId());
                                channelFilter.setName(getTagsResponse.getData().getChannels().get(i).getChannelName());
                                channelFilters.add(channelFilter);
                            }
                            HippoApplication.getInstance().getUserData().setChannelFilter(channelFilters);
                            setChannelsToFilterModel();

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        setView();
                    }

                    @Override
                    public void failure(APIError error) {
                        setView();

                    }
                });
    }


    private void initView() {
        peopleBtn = findViewById(R.id.people_tab);
        statusBtn = findViewById(R.id.status_tab);
        channelBtn = findViewById(R.id.channel_tab);
        labelsBtn = findViewById(R.id.labels_tab);
        typeBtn = findViewById(R.id.type_tab);
        applyBtn = findViewById(R.id.apply_btn);
        tvResetBtn = findViewById(R.id.tvResetBtn);
        dateTab = findViewById(R.id.date_tab);
        agentTab = findViewById(R.id.agent_tab);
        dateView = findViewById(R.id.date_view);


        peopleBtn.setText(Restring.getString(this, R.string.people));
        statusBtn.setText(Restring.getString(this, R.string.status));
        channelBtn.setText(Restring.getString(this, R.string.channels));
        labelsBtn.setText(Restring.getString(this, R.string.labels));
        typeBtn.setText(Restring.getString(this, R.string.type));
        tvResetBtn.setText(Restring.getString(this, R.string.reset));
        dateTab.setText(Restring.getString(this, R.string.date));
        agentTab.setText(Restring.getString(this, R.string.agents));
        applyBtn.setText(Restring.getString(this, R.string.apply));


        if (!isAllChat) {
            agentTab.setVisibility(View.GONE);
        } else {
            setAgentList();
        }

        peopleBtn.setOnClickListener(this);
        statusBtn.setOnClickListener(this);
        channelBtn.setOnClickListener(this);
        labelsBtn.setOnClickListener(this);
        typeBtn.setOnClickListener(this);
        applyBtn.setOnClickListener(this);
        tvResetBtn.setOnClickListener(this);
        dateTab.setOnClickListener(this);
        agentTab.setOnClickListener(this);

        applyBtn.setVisibility(View.GONE);

        setDateFilter();

    }

    private void openFragment(int tag) {
        setTabBackground();
        switch (tag) {
            case 1:
                openPeopleFragment();
                applyBtn.setVisibility(View.GONE);
                peopleBtn.setBackgroundColor(Color.parseColor("#ffffff"));
                break;
            case 2:
                openStatusFragment();
                applyBtn.setVisibility(View.VISIBLE);
                statusBtn.setBackgroundColor(Color.parseColor("#ffffff"));
                break;
            case 3:
                openChannelFragment();
                applyBtn.setVisibility(View.VISIBLE);
                channelBtn.setBackgroundColor(Color.parseColor("#ffffff"));
                break;
            case 4:
                openLabelfragment();
                applyBtn.setVisibility(View.VISIBLE);
                labelsBtn.setBackgroundColor(Color.parseColor("#ffffff"));
                break;
            case 5:
                openTypeFragment();
                applyBtn.setVisibility(View.VISIBLE);
                typeBtn.setBackgroundColor(Color.parseColor("#ffffff"));
                break;
            case 6:
                openDateFragment();
                applyBtn.setVisibility(View.VISIBLE);
                dateTab.setBackgroundColor(Color.parseColor("#ffffff"));
                break;
            case 7:
                openAgentFragment();
                applyBtn.setVisibility(View.VISIBLE);
                agentTab.setBackgroundColor(Color.parseColor("#ffffff"));
                break;
            default:
                peopleBtn.setBackgroundColor(Color.parseColor("#ffffff"));
                getSupportFragmentManager().beginTransaction()
                        .add(R.id.filter_container, new PeopleFragment(), PeopleFragment.class.getName())
                        .commitAllowingStateLoss();
                break;
        }
    }

    @Override
    public void onBackPressed() {
        if (getSupportFragmentManager().getBackStackEntryCount() == 1) {
            finish();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public void onClick(View view) {

        int id = view.getId();
        if (id == R.id.people_tab) {
            openFragment(1);
        } else if (id == R.id.status_tab) {
            openFragment(2);
        } else if (id == R.id.channel_tab) {
            openFragment(3);
        } else if (id == R.id.labels_tab) {
            openFragment(4);
        } else if (id == R.id.type_tab) {
            openFragment(5);
        } else if (id == R.id.apply_btn) {
            filterModel.setViewType(10);
            applyFilterData();
        } else if (id == R.id.tvResetBtn) {
            resetFilter();
        } else if (id == R.id.date_tab) {
            openFragment(6);
        } else if (id == R.id.agent_tab) {
            openFragment(7);
        }
    }

    private void setTabBackground() {
        peopleBtn.setBackgroundColor(getResources().getColor(R.color.transparent));
        statusBtn.setBackgroundColor(getResources().getColor(R.color.transparent));
        channelBtn.setBackgroundColor(getResources().getColor(R.color.transparent));
        labelsBtn.setBackgroundColor(getResources().getColor(R.color.transparent));
        typeBtn.setBackgroundColor(getResources().getColor(R.color.transparent));
        dateTab.setBackgroundColor(getResources().getColor(R.color.transparent));
        agentTab.setBackgroundColor(getResources().getColor(R.color.transparent));
    }

    private void openPeopleFragment() {
        if (getPeopleFragment() == null) {
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.filter_container, new PeopleFragment(), PeopleFragment.class.getName())
                    .commitAllowingStateLoss();
        }
    }

    private void openStatusFragment() {
        if (getStatusFragment() == null) {
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.filter_container, new StatusFragment(), StatusFragment.class.getName())
                    .commitAllowingStateLoss();
        }
    }

    private void openChannelFragment() {
        if (getChannelFragment() == null) {
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.filter_container, new ChannelFragment(), ChannelFragment.class.getName())
                    .commitAllowingStateLoss();
        }
    }

    private void openLabelfragment() {
        if (getLablesFragment() == null) {
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.filter_container, new LablesFragment(), LablesFragment.class.getName())
                    .commitAllowingStateLoss();
        }
    }

    private void openTypeFragment() {
        if (getTypeFragment() == null) {
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.filter_container, new TypeFragment(), TypeFragment.class.getName())
                    .commitAllowingStateLoss();
        }
    }

    private void openDateFragment() {
        if (getDateFragment() == null) {
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.filter_container, new DateFragment(), DateFragment.class.getName())
                    .commitAllowingStateLoss();
        }
    }

    private void openAgentFragment() {
        if (getAgentFragment() == null) {
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.filter_container, new AgentFragment(), AgentFragment.class.getName())
                    .commitNowAllowingStateLoss();
        }
    }

    private AgentFragment getAgentFragment() {
        return (AgentFragment) getSupportFragmentManager().findFragmentByTag(AgentFragment.class.getName());
    }

    private PeopleFragment getPeopleFragment() {
        return (PeopleFragment) getSupportFragmentManager().findFragmentByTag(PeopleFragment.class.getName());
    }

    private StatusFragment getStatusFragment() {
        return (StatusFragment) getSupportFragmentManager().findFragmentByTag(StatusFragment.class.getName());
    }

    private ChannelFragment getChannelFragment() {
        return (ChannelFragment) getSupportFragmentManager().findFragmentByTag(ChannelFragment.class.getName());
    }

    private LablesFragment getLablesFragment() {
        return (LablesFragment) getSupportFragmentManager().findFragmentByTag(LablesFragment.class.getName());
    }

    private TypeFragment getTypeFragment() {
        return (TypeFragment) getSupportFragmentManager().findFragmentByTag(TypeFragment.class.getName());
    }

    private DateFragment getDateFragment() {
        return (DateFragment) getSupportFragmentManager().findFragmentByTag(DateFragment.class.getName());
    }

    public void setButtonVisibility(int buttonVisibility) {
        applyBtn.setVisibility(buttonVisibility);
    }

    public void applyFilterData() {
        if (filterModel.isHasDateFilter() && filterModel.getDatePos() == 5) {
            if (TextUtils.isEmpty(filterModel.getFromDate()) || TextUtils.isEmpty(filterModel.getToDate()) || !filterModel.isValidDate()) {
                Toast.makeText(this, Restring.getString(this, R.string.hippo_please_select_valid_date), Toast.LENGTH_SHORT).show();
                return;
            }
        }
        String filterData = new Gson().toJson(filterModel);
        Intent intent = new Intent();
        intent.putExtra("filterData", filterData);
        setResult(RESULT_OK, intent);

        overridePendingTransition(R.anim.hold, R.anim.slide_out_bottom);
        finish();
    }

    public void resetFilter() {

        filterModel.setViewType(0);

        filterModel.setSelectedPeople("");
        filterModel.setSelectedPeopleUserId("");

        filterModel.setSearchCustomName("");
        filterModel.setSearchCustomLabel(-1);

        for (int i = 0; i < filterModel.getChannelList().size(); i++) {
            filterModel.getChannelList().get(i).setChecked(false);
        }

        for (int i = 0; i < filterModel.getLabelsList().size(); i++) {
            filterModel.getLabelsList().get(i).setChecked(false);
        }

        for (int i = 0; i < filterModel.getTypeArrayList().size(); i++) {
            filterModel.getTypeArrayList().get(i).setChecked(false);
        }

        filterModel.getAgentList().clear();

        filterModel.getStatusArrayList().get(0).setChecked(true);
        filterModel.getStatusArrayList().get(1).setChecked(false);

        filterModel.setHasDateFilter(false);
        filterModel.setDatePos(0);
        filterModel.setFromDate("");
        filterModel.setToDate("");

        applyFilterData();
    }

    public void setDateFilter() {
        dateList.clear();
        dateList.add(new DateModel(1, getStringValue(1), false));
        dateList.add(new DateModel(2, getStringValue(2), false));
        dateList.add(new DateModel(3, getStringValue(3), false));
        dateList.add(new DateModel(4, getStringValue(4), false));
        dateList.add(new DateModel(5, getStringValue(5), false));

        if (filterModel.isHasDateFilter()) {
            dateList.get(filterModel.getDatePos() - 1).setSelected(true);
        }
    }

    public ArrayList<AgentListModel> agentListModels = new ArrayList<>();

    private void setAgentList() {
        GetAgentsResponse getAgentsResponse = Paper.book(CommonData.name).read(SPLabels.AGENTS);
        if (getAgentsResponse != null && getAgentsResponse.getData() != null && getAgentsResponse.getData().getAgents() != null &&
                getAgentsResponse.getData().getAgents().size() > 0) {
            for (GetAgentsResponse.Agents agents : getAgentsResponse.getData().getAgents()) {
                if (agents.getStatus() == 1)
                    agentListModels.add(new AgentListModel(agents.getUserId(), agents.getFullName(), false));
            }
        }

        if (filterModel.getAgentList() != null && filterModel.getAgentList().size() > 0) {
            for (Filter filter : filterModel.getAgentList()) {
                int index = agentListModels.indexOf(new AgentListModel(filter.getId(), "", false));
                if (index > -1) {
                    agentListModels.get(index).setBoolean(true);
                }
            }
        }
    }

    private String getStringValue(int position) {
        String textValue = "";
        switch (position) {
            case 1:
                textValue = Restring.getString(this, R.string.today) + "\n" + getCalculatedDate("dd MMM", 0);
                break;
            case 2:
                textValue = Restring.getString(this, R.string.yesterday) + "\n" + getCalculatedDate("dd MMM", -1);
                break;
            case 3:
                textValue = Restring.getString(this, R.string.last_7_days) + "\n" + getCalculatedDate("dd MMM", -6) + " - " + getCalculatedDate("dd MMM", 0);
                break;
            case 4:
                textValue = Restring.getString(this, R.string.last_30_days) + "\n" + getCalculatedDate("dd MMM", -29) + " - " + getCalculatedDate("dd MMM", 0);
                break;
            case 5:
                textValue = Restring.getString(this, R.string.custom_date);
                break;
        }
        return textValue;
    }


    private String getCalculatedDate(String dateFormat, int days) {
        Calendar cal = Calendar.getInstance();
        DateFormat s = new SimpleDateFormat(dateFormat);
        cal.add(Calendar.DAY_OF_YEAR, days);
        return s.format(new Date(cal.getTimeInMillis()));
    }
}
