package com.hippoagent.activities;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;

import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.dialogs.DialogPop;
import com.hippoagent.helper.VersionUpdate;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.model.LoginResponse.LoginResponse;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.filePicker.Prefs;
import com.hippoagent.utils.filePicker.UploadingService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import io.paperdb.Paper;

/**
 * Created by Bhavya Rattan on 08/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class FuguBaseActivity extends AppCompatActivity implements FuguAppConstant {

    private Toolbar toolbar;
    public Type fileuploadType = new TypeToken<List<FileuploadModel>>() {
    }.getType();

    protected void checkAutoUpload() {
        if(!isMyServiceRunning(UploadingService.class)) {
            ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(FuguAppConstant.KEY, ""), fileuploadType);
            if (fileuploadModels == null)
                return;
            if(fileuploadModels.size() > 0) {
                Intent intent = new Intent(getBaseContext(), UploadingService.class);
                intent.setAction("start");
                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                    startForegroundService(intent);
                } else {
                    //lower then Oreo, just start the service.
                    startService(intent);
                }
            }
        }
    }

    protected boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (serviceClass.getName().equals(service.service.getClassName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onResume() {
        super.onResume();
        //showUpdatePopup(FuguBaseActivity.this);
    }

    public ActionBar setToolbar(Toolbar toolbar, String title) {
       //this.toolbar = toolbar;
        setSupportActionBar(toolbar);
        ActionBar ab = getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);

            try {
                final Drawable upArrow = getResources().getDrawable(R.drawable.hippo_ic_arrow_back);
                upArrow.setColorFilter(getResources().getColor(R.color.hippo_back_button), PorterDuff.Mode.SRC_ATOP);
                ab.setHomeAsUpIndicator(upArrow);
            } catch (Resources.NotFoundException e) {

            }

            ab.setTitle("");
        }

        //<color name="hippo_back_button">#000000</color>

        ((TextView) toolbar.findViewById(R.id.tv_toolbar_name)).setText(title);
        return getSupportActionBar();
    }

    public void updateToolbar(Toolbar toolbar, String title) {
        ((TextView) toolbar.findViewById(R.id.tv_toolbar_name)).setText(title);
    }

    public void setToolBar() {
        toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayShowTitleEnabled(false);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            return true;
        }
        return false;
    }

//    @Override
//    protected void attachBaseContext(Context newBase) {
//        super.attachBaseContext(TypekitContextWrapper.wrap(newBase));
//    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // handle arrow click here
        if (item.getItemId() == android.R.id.home) {
            finish(); // close this context and return to preview context (if there is any)
        }
        return super.onOptionsItemSelected(item);
    }

    public Toolbar getToolbar() {
        return toolbar;
    }

    public int getAppVersion() {
        try {
            return getPackageManager().getPackageInfo(getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

//    public String getAppVersionName() {
//        try {
//            return "v"+getPackageManager().getPackageInfo(getPackageName(), 0).versionName;
//        } catch (PackageManager.NameNotFoundException e) {
//            e.printStackTrace();
//            return "";
//        }
//    }

    public void showErrorMessage(final String errorMessage, final String positiveButtonText) {
        showErrorMessage(errorMessage, positiveButtonText, false);
    }
    public void showErrorMessage(final String errorMessage, final String positiveButtonText, final boolean isFinish) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                new AlertDialog.Builder(FuguBaseActivity.this)
                        .setMessage(errorMessage)
                        .setPositiveButton(positiveButtonText, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(final DialogInterface dialog, final int which) {
                                if(isFinish)
                                    finish();
                            }
                        })
                        .setCancelable(false)
                        .show();
            }
        });
    }

//    private boolean isEnabled() {
//        VersionUpdate update = CommonData.getVersionInfo();
//        if(update == null)
//            return false;
//        else if(HippoConfig.getInstance().getAttributes().getVersionCode() >= update.getVersion())
//            return false;
//        else if(HippoConfig.getInstance().getAttributes().getVersionCode() < update.getVersion() && update.getLastVersion() != update.getVersion())
//            return true;
//        else if(update.getLastVersion() == update.getVersion() && update.getInterval() > 0) {
//            return System.currentTimeMillis() - update.getLastShown() > update.getInterval() * 60 * 1000;
//        }
//        else
//            return false;
//    }

//    DialogPop dialogPop;
//    public void showUpdatePopup(Context context) {
//        if(!isEnabled())
//            return;
//
//        VersionUpdate update = CommonData.getVersionInfo();
//        if(update == null)
//            return;
//        update.setLastVersion(update.getVersion());
//        update.setLastShown(System.currentTimeMillis());
//        CommonData.saveVersionInfo(update);
//
//        String message = update.getText();
//        String link = update.getLink();
//
//        if(dialogPop == null)
//            dialogPop = new DialogPop();
//
//        dialogPop.alertPopupWithTwoButton(context, "", message
//                , getResources().getString(R.string.ok)
//                , getResources().getString(R.string.cancel), new DialogPop.Callback() {
//                    @Override
//                    public void onPositiveClick() {
//                        Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(link));
//                        startActivity(browserIntent);
//                    }
//
//                    @Override
//                    public void onNegativeClick() {
//
//                    }
//                });
//    }

    /**
     * Hide softkeyboard of opened
     * @param activity
     */
    public void hideKeyboard(Activity activity) {
        try {
            View view = activity.getCurrentFocus();
            InputMethodManager imm = (InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//    public void ShowUpdateWindowTwoBtns(final LoginResponse loginResponse) {
//
//        Paper.book(CommonData.name).delete(SPLabels.USER_DATA);
//        Paper.book(CommonData.name).write(SPLabels.USER_DATA, loginResponse.getUserData());
//        Paper.book(CommonData.name).write(SPLabels.TAGS, loginResponse.getUserData().getTags());
//        Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
//        Paper.book(CommonData.name).write(SPLabels.LATEST_VERSION, loginResponse.getUserData().getVersion().getLatestVersion());
//
//        startActivity(new Intent(FuguBaseActivity.this, HomeActivity.class).putExtra(SHOW_UPDATE, true)
//                .putExtra(UPDATE_LINK, loginResponse.getUserData().getVersion().getDownloadLink())
//                .putExtra(UPDATE_TITLE, loginResponse.getUserData().getVersion().getText()));
//    }

//    public void SingleBtnUpdateWindow(final LoginResponse loginResponse) {
////        //HippoApplication.getInstance().trackEvent(GAEvents.LOGIN_SCREEN, GAEvents.FORCE_UPDATE, "force_update_clicked");
//        android.app.AlertDialog alertDialog = new android.app.AlertDialog.Builder(FuguBaseActivity.this).create();
//        alertDialog.setMessage(loginResponse.getUserData().getVersion().getText());
//        alertDialog.setButton(android.app.AlertDialog.BUTTON_NEUTRAL, "OK",
//                new DialogInterface.OnClickListener() {
//                    public void onClick(DialogInterface dialog, int which) {
//                        Intent browserIntent = new Intent(Intent.ACTION_VIEW,
//                                Uri.parse(loginResponse.getUserData().getVersion().getDownloadLink()));
//                        startActivity(browserIntent);
//                        finish();
//                    }
//                });
//        alertDialog.show();
//    }

}
