package com.hippoagent.activities;

import android.Manifest;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.Toolbar;
import androidx.cardview.widget.CardView;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.content.ContextCompat;
import androidx.core.util.Pair;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;

import com.canhub.cropper.CropImage;
import com.canhub.cropper.CropImageContract;
import com.canhub.cropper.CropImageContractOptions;
import com.canhub.cropper.CropImageOptions;
import com.canhub.cropper.CropImageView;
import com.google.android.material.appbar.AppBarLayout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.hippo.record.RecordingListener;
import com.hippo.record.RecordingUtil;
import com.hippoagent.BuildConfig;
import com.hippoagent.Config;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.PrescriptionModule.PrescriptionBottomSheetFragment;
import com.hippoagent.PrescriptionModule.model.PrescriptionTemplateData;
import com.hippoagent.PrescriptionModule.model.PrescriptionUrlData.PrescriptionUrlData;
import com.hippoagent.R;
import com.hippoagent.adapters.FollowerAdapter;
import com.hippoagent.adapters.FuguMessageAdapter;
import com.hippoagent.adapters.FuguMessageAdapter.OnUserConcent;
import com.hippoagent.adapters.FuguTagAdapter;
import com.hippoagent.adapters.GiffyAdapter;
import com.hippoagent.adapters.ListItem;
import com.hippoagent.adapters.OptionAdapter;
import com.hippoagent.adapters.ShowAgentsAdapter;
import com.hippoagent.apis.MessageUpdate;
import com.hippoagent.appData.AppManager;
import com.hippoagent.callback.OnAgentParseCallback;
import com.hippoagent.callback.OnMessageUpdate;
import com.hippoagent.confcall.OngoingCallService;
import com.hippoagent.database.CommonData;
import com.hippoagent.database.repository.ChannelInfoRepo;
import com.hippoagent.datastructure.AgentType;
import com.hippoagent.datastructure.ApiResponseFlags;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.datastructure.MessageMode;
import com.hippoagent.datastructure.Overlay;
import com.hippoagent.datastructure.TypingMode;
import com.hippoagent.datastructure.UserType;
import com.hippoagent.dialogs.CannedDialog;
import com.hippoagent.dialogs.ConfirmationDialog;
import com.hippoagent.dialogs.DealinfoFragment;
import com.hippoagent.dialogs.DialogPop;
import com.hippoagent.eventbus.BusProvider;
import com.hippoagent.eventbus.UpdateEvent;
import com.hippoagent.fcm.AudioPlay;
import com.hippoagent.fcm.NotificationDatabase;
import com.hippoagent.fcm.NotificationUtils;
import com.hippoagent.fragments.AttachmentSheetFragment;
import com.hippoagent.fragments.BottomSheetFragment;
import com.hippoagent.fragments.ChatOptionFragment;
import com.hippoagent.helper.BusEvents;
import com.hippoagent.helper.ConnectionManager;
import com.hippoagent.helper.ConversationApiHelper;
import com.hippoagent.helper.FayeMessage;
import com.hippoagent.helper.ParseAgents;
import com.hippoagent.hippocall.AppContants;
import com.hippoagent.hippocall.HippoCallConfig;
import com.hippoagent.hippocall.VideoCallModel;
import com.hippoagent.hippocall.WebRTCCallConstants;
import com.hippoagent.langs.Restring;
import com.hippoagent.mentions.Mentionable;
import com.hippoagent.mentions.Mentions;
import com.hippoagent.mentions.QueryListener;
import com.hippoagent.mentions.SuggestionsListener;
import com.hippoagent.model.ActionButtonModel;
import com.hippoagent.model.CallModel;
import com.hippoagent.model.CannedMessageResponse;
import com.hippoagent.model.ContentValue;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.CustomAction;
import com.hippoagent.model.DescriptionObject;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.model.FuguGetMessageParams;
import com.hippoagent.model.FuguGetMessageResponse;
import com.hippoagent.model.GetAgentsResponse;
import com.hippoagent.model.GetConversationResponse;
import com.hippoagent.model.Image;
import com.hippoagent.model.MakePayment;
import com.hippoagent.model.Member;
import com.hippoagent.model.Message;
import com.hippoagent.model.OtherUser;
import com.hippoagent.model.PaymentData;
import com.hippoagent.model.TagData;
import com.hippoagent.model.add_deal.AddDeal;
import com.hippoagent.model.createConversation.CreateConversation;
import com.hippoagent.model.get_all_bots.Bot;
import com.hippoagent.model.get_all_bots.GetAllBots;
import com.hippoagent.model.get_deal_info.FollowerDatum;
import com.hippoagent.model.get_deal_info.GetDealInfo;
import com.hippoagent.model.payment.OldPaymentData;
import com.hippoagent.model.response_modals.Datum;
import com.hippoagent.model.response_modals.GiffyResponse;
import com.hippoagent.model.shareurl.ShareUrlModel;
import com.hippoagent.model.update_deal.UpdateDeal;
import com.hippoagent.model.user_detail.EditUserDetails;
import com.hippoagent.model.user_details.DeviceDetails;
import com.hippoagent.record.OnBasketAnimationEnd;
import com.hippoagent.record.OnRecordListener;
import com.hippoagent.record.RecordButton;
import com.hippoagent.record.RecordPermissionHandler;
import com.hippoagent.record.RecordView;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.CommonParamsObj;
import com.hippoagent.retrofit.CommonResponse;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.tickets.CreateTicketActivity;
import com.hippoagent.utils.Constants;
import com.hippoagent.utils.CustomRelative;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.EditTextSelectable;
import com.hippoagent.utils.GAEvents;
import com.hippoagent.utils.GeneralFunctions;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.PhoneFunctions;
import com.hippoagent.utils.SPLabels;
import com.hippoagent.utils.ToastUtil;
import com.hippoagent.utils.UniqueIMEIID;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.beatAnimation.AVLoadingIndicatorView;
import com.hippoagent.utils.compressor.Compressor;
import com.hippoagent.utils.easypermissions.AfterPermissionGranted;
import com.hippoagent.utils.easypermissions.AppSettingsDialog;
import com.hippoagent.utils.easypermissions.EasyPermissions;
import com.hippoagent.utils.filePicker.CompressorListener;
import com.hippoagent.utils.filePicker.Constant;
import com.hippoagent.utils.filePicker.FileManager;
import com.hippoagent.utils.filePicker.ImageUtils;
import com.hippoagent.utils.filePicker.KeyboardUtil;
import com.hippoagent.utils.filePicker.Prefs;
import com.hippoagent.utils.filePicker.UploadingService;
import com.hippoagent.utils.filePicker.activity.AudioPickActivity;
import com.hippoagent.utils.filePicker.activity.ImagePickActivity;
import com.hippoagent.utils.filePicker.activity.NormalFilePickActivity;
import com.hippoagent.utils.filePicker.activity.VideoPickActivity;
import com.hippoagent.utils.filePicker.filter.entity.AudioFile;
import com.hippoagent.utils.filePicker.filter.entity.ImageFile;
import com.hippoagent.utils.filePicker.filter.entity.NormalFile;
import com.hippoagent.utils.filePicker.filter.entity.VideoFile;
import com.hippoagent.utils.filelogger.Logger;
import com.hippoagent.utils.loadingBox.FuguAgentProgressWheel;
import com.hippoagent.utils.loadingBox.LoadingBox;
import com.hippoagent.utils.zoomview.ZoomageView;
import com.squareup.otto.Subscribe;

import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import io.paperdb.Paper;

import static com.hippoagent.utils.Constants.CustomField.DataType.DATE_TIME;
import static com.hippoagent.utils.Constants.USER_TYPE;

public class FuguChatActivity extends FuguBaseActivity implements ListItem,
        GAEvents, View.OnClickListener, QueryListener, SuggestionsListener, FuguAppConstant, OnUserConcent,
        KeyboardUtil.SoftKeyboardToggleListener, EasyPermissions.PermissionCallbacks,
        FuguMessageAdapter.AdapterCallback, RecordingListener {

    public static final String RECIEVER_MSG = "com.fugu.agent.msg";
    public static final String RECIEVER_MSG_AGENT_REFRESH = "com.fugu.agent.refresh.msg";
    public static final String UPDATE_MSG = "com.fugu.update.msg";
    public static final String MIGRATE_USER = "com.hippo.migrate";
    public static final String RECIEVER_BOT_ENDED = "com.hippoagent.bot.ended";
    private static final String TAG = "FuguChatActivity";
    public static int pushChannelId = -1;
    public static int currentChannelId = -1;
    public GetDealInfo getDealInfoForNotes;
    public String dealId, notes, lastMessage, custName, custEmail, custPhone, custCompany;
    EditText etCustName, etCustPhone, etCustEmail, etCustCompanyName, etLeadOwner, etNotes;
    private ImageView copyEmail, copyPhone;
    private LinearLayout llFollowers;
    private TextView followername, followersMore;
    private CheckBox assignCheckbox;
    //View vwCustName, vwCustEmail, vwCustPhone, vwCustCompanyName, vwNotes;
    ShowNotesAdapter showNotesAdapter;
    RecyclerView rvNotes;
    ImageButton ibAddNotes;
    Dialog dialog;
    TextView btnBack;
    GetAgentsResponse getAgentsResponseData;
    ArrayList<com.hippoagent.model.get_deal_info.Datum> notesList = new ArrayList<>();
    private FuguAgentProgressWheel progress_wheel, progressWheelPrescription, paymentProgressWheel;
    private RelativeLayout ivManualBot, ivPaymentBtn;
    private String LOG_TAG = getClass().getSimpleName();
    private CustomRelative llRoot;
    private CardView cvTypeMessage;
    private Button botChatAssign;
    private TextView tvClosed;
    private TextView tvNoInternet, tvAssignNotify;
    private View viewBlack;
    private EditTextSelectable etMsg;
    private OptionAdapter optionAdapter;
    private RecyclerView rvMessages, rvTagged, rvOptions, rvAttachmentsMentionList;
    private LinearLayoutManager layoutManager;
    private FuguMessageAdapter fuguMessageAdapter;
    private int isTyping = 0;
    private Toolbar myToolbar;
    private AVLoadingIndicatorView aviTyping;
    private LinearLayout llTyping, llChatBottom, llUserDetails;
    private RelativeLayout llMsgInput;
    private int onSubscribe = 0;
    private Conversation conversation;
    private ProgressBar pbSendingImage;
    private ImageView ivSend, ivPrivate, ivText;
    private RecordButton record_button;
    private RecordView record_view;
    private LinearLayout itemLayout;
    private View vText, vPrivate;
    private RelativeLayout rlPrivate;
    private ImageUtils imageUtils;
    private DateUtils dateUtils;
    private String sentAtUTC = "", savedPrivateNote = "";
    private int messageType = TEXT_MESSAGE;
    private Dialog cannedDialog;
    private BottomSheetFragment bottomSheetFragment;
    private PrescriptionBottomSheetFragment prescriptionBottomSheetFragment;
    private RelativeLayout rlText, rlCanned, rlImage, rlPrescription;
    private ProgressBar pbLoading;
    private boolean showLoading = true;
    private boolean allMessagesFetched = false;
    private boolean isNetworkStateChanged = false;
    private RelativeLayout rlScrollBottom, rlGiff;
    private TextView tvUnread, tvTitle, tvCustLocation, tvTitleCustName, tvCustNameTitle;
    private ImageView ivMenuInfo, ivCloseConv, ivNextIcon, ivViewInfo, ivVideoView, ivAudioView;
    private boolean isPrivateClicked = false;
    private boolean isVisibleProfile = false;
    private CoordinatorLayout clToolbar;
    private int position;
    private int ownerId;

    private int pageStart = 1;
    private int dateItemCount = 0;
    private int scrollBottomCount = 0;
    private int status;
    private CharSequence tagChar;
    private AppBarLayout appBarLayout;
    private int cursorPositionNow = 0;
    private String msgWithTag, tagName, privateNote = "", chatClicked = "";
    private boolean isTagged = false;
    private String finalPrivateNote = "";
    private boolean isBackPressed = false;
    private String temp = "";
    private FuguTagAdapter fuguTagAdapter;
    private ArrayList<GetAgentsResponse.Agents> showTaggedAgents = new ArrayList<>();
    private GetMsgData getMsgData;
    private GetAgentData getAgentData;
    private UPdateData updateData;
    private MigrateData migrateUser;
    private boolean isBlock = false;
    private RecyclerView rvGiffy;
    private GiffyAdapter giffyAdapter;
    private ArrayList<Datum> giffList = new ArrayList<>();
    private LinearLayoutManager linearLayoutManager1;
    private ImageView ivBack;
    private LinearLayout llCollapsingLayout;
    private RelativeLayout rlBulbulActions, rlDealViewNotes;
    //private View extraView;
    private Button btnViewDetails, btnAddDeal, btnViewNotes, btnPushToBulbul;
    private boolean isTouched = true;
    private ArrayList<TagData> tagData = new ArrayList<>();
    private ArrayList<FollowerDatum> followesList = new ArrayList<>();
    private boolean firstOpen = true;
    private boolean isFromGetConversation;
    private RelativeLayout botLayout, prescriptionRL;
    private RelativeLayout paymentLayout;
    private static int API_DELAY_TIME = 1000;

    private Mentions mentions;
    private ArrayList<Integer> taggedUsers = new ArrayList<>();
    private ArrayList<GetAgentsResponse.Agents> membersList = new ArrayList<>();
    private LinearLayout llBottom, retryLayout;
    private FuguAgentProgressWheel progressWheel;
    private TextView btnRetry;
    private boolean isFirstTimeOpened = true;
    private boolean isFirstTimeApi = true;
    private ZoomageView ivCropImage ;

    // Declaring objects and variables
    @NonNull
    private ArrayList<Message> fuguMessageList = new ArrayList<>();
    private LinkedHashMap<String, Message> hippoMessageList = new LinkedHashMap<>();
    private LinkedHashMap<String, Message> sentMessages = new LinkedHashMap<>();
    private LinkedHashMap<String, Message> unsentMessages = new LinkedHashMap<>();
    @NonNull
    private LinkedHashMap<String, JSONObject> unsentMessageMapNew = new LinkedHashMap<>();

    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";

    private Handler handler = new Handler();
    private final static Integer RECONNECTION_TIME = 2500;
    private int index = -1;
    private int messageIndex = -1;

    private boolean keyboardVisibility;
    private boolean isFromFilePicker = false;
    public String audioMuid = "";
    public int playingItem = -1;
    private String url;
    private Integer userId = -1;
    private boolean isP2PChat;
    private boolean isO2oChat;
    private boolean isCreateO2OChat = false;
    private boolean isMerchantChat;
    private ArrayList<String> gtTags = new ArrayList<>();
    private String email;
    private boolean isVideoView, isAudioView;
    private boolean btnHistory = true;
    private boolean hasBotRunning = false;
    private boolean isBotChatAssign = true;
    private boolean isDirectChannel = false;
    private String transactionId;
    private int fragmentType;
    private String other_user_email = "";
    private boolean initiated_by_agent = false;

    //For edit message
    private LinearLayout ivAttachment;
    private ImageView ivCancelEdit;

    private RelativeLayout mainLayout;
    private boolean isCreateChannelByTransactionId;

    private RecordingUtil recordingUtil;

    private TextView editDeal;

    private BroadcastReceiver mMessageReceiver1 = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, final Intent intent) {
            // Get extra data included in the Intent
            final String msg = intent.getStringExtra("message");
            final String channelId = intent.getStringExtra("channel_id");
            int msgType = intent.getIntExtra("message_type", 0);

            try {
                final JSONObject messageJson = new JSONObject(msg);
                if (!messageJson.optString("channel_id").equals(String.valueOf(conversation.getChannelId())))
                    return;

                if (messageJson.optInt(NOTIFICATION_TYPE, 0) == BOT_ENDED) {
                    int disableReply = messageJson.optInt("disable_reply", 0);
                    int botRunning = messageJson.optInt("is_bot_in_progress", 0);
                    if (conversation != null) {
                        conversation.setDisableReply(disableReply);
                        conversation.setBotEnabled(botRunning);
                    }
                    try {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                if (disableReply == 1) {
                                    cvTypeMessage.setVisibility(View.GONE);
                                } else if (disableReply == 0) {
                                    cvTypeMessage.setVisibility(View.VISIBLE);
                                }
                                hasBotRunning = false;
                                botChatAssign.setVisibility(View.GONE);
                                if (disableReply == 1 && botRunning == 1) {
                                    hasBotRunning = true;
                                    botChatAssign.setVisibility(View.VISIBLE);
                                }
                            }
                        });
                    } catch (Exception e) {

                    }

                    return;
                }

                if (messageJson.optInt("message_type", 0) == BOT_FORM_MESSAGE) {
                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        if (fuguMessageList.get(i).getType() == LEAD_FORM_VIEW) {
                            Message currentMessage = fuguMessageList.get(i);
                            if (currentMessage.getId() != null && currentMessage.getId().equals(messageJson.getString("id"))) {

                                List<ContentValue> contentValue = new ArrayList<>();
                                ArrayList<String> values = new ArrayList<>();


                                JSONArray contentvaluesArray = messageJson.getJSONArray("content_value");
                                JSONArray valuesArray = messageJson.getJSONArray("values");

                                if (contentvaluesArray != null) {

                                    for (int a = 0; a < contentvaluesArray.length(); a++) {
                                        JSONObject object = contentvaluesArray.getJSONObject(a);
                                        ContentValue contentValue1 = new ContentValue();
                                        contentValue1.setBot_id(object.getString("bot_id"));
                                        JSONArray array = object.getJSONArray("questions");
                                        ArrayList<String> questions = new ArrayList<>();
                                        for (int x = 0; x < array.length(); x++) {
                                            questions.add(array.getString(x));
                                        }
                                        contentValue1.setQuestions(questions);
                                        contentValue.add(contentValue1);
                                    }
                                }

                                if (valuesArray != null) {
                                    for (int b = 0; b < valuesArray.length(); b++) {
                                        values.add(valuesArray.getString(b));
                                    }
                                }


                                currentMessage.setValues(values);
                                currentMessage.setContentValue(contentValue);

                                unsentMessageMapNew.remove(messageJson.getString("muid"));
                                unsentMessages.remove(messageJson.getString("muid"));
                                sentMessages.put(messageJson.getString("muid"), currentMessage);

                                if (values != null) {
                                    updateFeedback(i, false);
                                    if (values.size() == contentValue.get(0).getQuestions().size()) {

                                        try {
                                            new Handler().postDelayed(new Runnable() {
                                                @Override
                                                public void run() {
                                                    allMessagesFetched = false;
                                                    pageStart = 1;
                                                    getMessages(true, false);
                                                }
                                            }, API_DELAY_TIME);
                                        } catch (Exception e) {
                                            //e.printStackTrace();
                                        }

                                    }
                                    return;
                                }
                            }
                        }
                    }
                } else if (messageJson.getInt("message_type") == BOT_TEXT_MESSAGE) {
                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        Message currentMessage = fuguMessageList.get(i);
                        if (currentMessage.getId() != null
                                && currentMessage.getId().equals(messageJson.getString("id"))) {

                            unsentMessageMapNew.remove(messageJson.getString("muid"));
                            unsentMessages.remove(messageJson.getString("muid"));
                            sentMessages.put(messageJson.getString("muid"), currentMessage);
                            return;
                        }
                    }
                }

                if (messageJson.getInt("message_type") == BOT_FORM_MESSAGE) {
                    if (!messageJson.has("id"))
                        return;
                    Message message = new Message(messageJson.getString("full_name"),
                            Integer.parseInt(messageJson.getString("user_id")),
                            messageJson.getString("message"),
                            messageJson.getString("date_time"),
                            false,
                            onSubscribe == 1 ? MESSAGE_READ : MESSAGE_SENT,
                            fuguMessageList.size(),
                            messageJson.has("image_url") ? messageJson.getString("image_url") : "",
                            messageJson.has("thumbnail_url") ? messageJson.getString("thumbnail_url") : "",
                            messageJson.getInt("message_type"),
                            messageJson.optInt("user_type"));

                    message.setMuid(messageJson.optString("muid", ""));
                    message.setId(messageJson.optString("id"));
                    List<ContentValue> contentValue = new ArrayList<>();
                    ArrayList<String> values = new ArrayList<>();

                    JSONArray contentvaluesArray = messageJson.getJSONArray("content_value");
                    JSONArray valuesArray = messageJson.getJSONArray("values");

                    if (contentvaluesArray != null) {

                        for (int a = 0; a < contentvaluesArray.length(); a++) {
                            JSONObject object = contentvaluesArray.getJSONObject(a);
                            ContentValue contentValue1 = new ContentValue();
                            contentValue1.setBot_id(object.getString("bot_id"));
                            JSONArray array = object.getJSONArray("questions");
                            ArrayList<String> questions = new ArrayList<>();
                            for (int x = 0; x < array.length(); x++) {
                                questions.add(array.getString(x));
                            }
                            contentValue1.setQuestions(questions);
                            contentValue.add(contentValue1);
                        }
                    }

                    if (valuesArray != null) {
                        for (int b = 0; b < valuesArray.length(); b++) {
                            values.add(valuesArray.getString(b));
                        }
                    }

                    message.setUserImage(messageJson.optString("user_image"));
                    message.setOriginalMessageType(messageJson.getInt("message_type"));
                    boolean isSelf = false;
                    if (isO2oChat) {
                        isSelf = isSelf(ownerId, HippoApplication.getInstance().getUserData().getUserId().intValue(), message.getUserId().intValue());
                    }
                    int listMessageType = getType(messageJson.optInt("message_type"), isSelf, messageJson.optString("document_type"));
                    message.setMessageType(listMessageType);

                    message.setValues(values);
                    message.setContentValue(contentValue);

                    message = addAboveUserId(message);


                    Log.e(TAG, "2222222222222222222222222222");
                    sentMessages.put(messageJson.getString("muid"), message);
                    fuguMessageList.add(message);
                    updateFeedback(0, true);

                    unsentMessageMapNew.remove(messageJson.getString("muid"));
                    unsentMessages.remove(messageJson.getString("muid"));

                    messageSending = false;
                    sendMessages();
                } else if (messageJson.getInt("message_type") == BOT_TEXT_MESSAGE) {
                    String localDate = dateUtils.convertToLocal(messageJson.getString("date_time"), inputFormat, outputFormat);

                    if (!sentAtUTC.equalsIgnoreCase(localDate)) {
                        fuguMessageList.add(new Message(localDate, true));
                        sentAtUTC = localDate;
                        dateItemCount = dateItemCount + 1;
                    }

                    Message message = new Message(messageJson.getString("full_name"),
                            Integer.parseInt(messageJson.getString("user_id")),
                            messageJson.getString("message"),
                            messageJson.getString("date_time"),
                            false,
                            onSubscribe == 1 ? MESSAGE_READ : MESSAGE_SENT,
                            fuguMessageList.size(),
                            messageJson.has("image_url") ? messageJson.getString("image_url") : "",
                            messageJson.has("thumbnail_url") ? messageJson.getString("thumbnail_url") : "",
                            messageJson.getInt("message_type"),
                            messageJson.has("user_type") ? messageJson.getInt("user_type") : UserType.AGENT.getOrdinal());


                    message.setUserImage(messageJson.optString("user_image"));
                    message.setOriginalMessageType(messageJson.getInt("message_type"));
                    boolean isSelf = true;
                    if (isO2oChat) {
                        isSelf = isSelf(ownerId, HippoApplication.getInstance().getUserData().getUserId().intValue(), message.getUserId().intValue());
                    }
                    int listMessageType = getType(messageJson.optInt("message_type"), isSelf, messageJson.optString("document_type"));
                    message.setMessageType(listMessageType);

                    String muid = messageJson.optString("muid");
                    message.setMuid(muid);
                    message.setId(messageJson.optString("id"));

                    message = addAboveUserId(message);

                    Log.v(TAG, "%%%%%%%%%%%%%%%%%%%%%%%%muid : " + muid);
                    if (!sentMessages.containsKey(muid)) {
                        Log.v(TAG, "%%%%%%%%%%%%%%%%%%%%%%%%");
                        sentMessages.put(muid, message);
                        fuguMessageList.add(message);
                        updateFeedback(0, true);
                    }
                    try {
                        if (messageJson.has("consent_action_url"))
                            openUrl(messageJson.optString("consent_action_url", ""), messageJson.optInt("channel_id"));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    };
    private int originalMessageType;
    private boolean isAttachmentDialogOpen = false;


    private boolean isSelf(int owner_id, int userId, int messageID) {
        if (owner_id == userId) {
            if (messageID == userId)
                return true;
            else
                return false;
        } else {
            if ((messageID == owner_id))
                return false;
            else
                return true;
        }


    }

    private Message addAboveUserId(Message message) {
        try {
            ArrayList<Message> items = new ArrayList<>();
            items.addAll(sentMessages.values());
            Message lastMessage = items.get(items.size() - 1);
            lastMessage.setBelowMuid(message.getMuid());
            lastMessage.setBelowUserId(message.getUserId());
            sentMessages.put(lastMessage.getMuid(), lastMessage);

            message.setAboveUserId(lastMessage.getUserId());
            message.setAboveMuid(lastMessage.getMuid());
        } catch (Exception e) {

        }

        return message;
    }

    private void openUrl(String openedUrl, int channelId) throws Exception {
        FuguGetMessageResponse response = CommonData.getMessageResponse(conversation.getChannelId());

        if (response.getData() != null && response.getData().getUserId() != -1)
            userId = response.getData().getUserId();

        if (HippoApplication.getInstance().getUserData().getUserId().intValue() == userId) {
            if (pushChannelId == channelId && (TextUtils.isEmpty(url) || !url.equalsIgnoreCase(openedUrl))) {
                if (!TextUtils.isEmpty(openedUrl)) {
                    url = openedUrl;
                    Intent i = new Intent(Intent.ACTION_VIEW);
                    i.setData(Uri.parse(openedUrl));
                    startActivity(i);
                }
            }
        }
    }

    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case NETWORK_STATE_INTENT:
                    Log.d(TAG, "Network connectivity change " + intent.getBooleanExtra("isConnected", false));

                    if (intent.getBooleanExtra("isConnected", false)) {
                        /*if (HippoApplication.getmClient() != null) {
                            HippoApplication.getInstance().addUIListener(OnActiveChannelListener.class, FuguChatActivity.this);
                            new Handler().postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        connectAgainToServer();
                                    } catch (Exception e) {

                                    }
                                }
                            }, 500);

                        }*/
                        if (unsentMessageMapNew.size() == 0) {
                            pageStart = 1;
                            getMessages();
                        } else {
                            isNetworkStateChanged = true;
                            btnRetry.setText("Connecting...");
                        }
                        setConnectionMessage(2);
                    } else if (!intent.getBooleanExtra("isConnected", false)) {
                        setConnectionMessage(3);
                    } else if (llTyping.getVisibility() == View.VISIBLE) {
                        stopAnim();
                    } else {
                        setConnectionMessage(3);
                    }
                    break;

                case NOTIFICATION_TAPPED:

                    conversation = new Gson().fromJson(getIntent().getStringExtra(Constants.CONVERSATION), Conversation.class);

                    pushChannelId = conversation.getChannelId();
                    clearNotification(conversation.getChannelId());
                    currentChannelId = conversation.getChannelId();
                    userId = conversation.getUserId();


                    pageStart = 1;
                    setUpUI();
                    ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(conversation.getChannelId()));
                    break;
            }

        }
    };
    private BroadcastReceiver mPushMessages = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String payload = intent.getStringExtra("json");
                Log.v(TAG, "payload: " + payload);
                JSONObject messageJson = new JSONObject(payload);

                String muid = messageJson.optString("muid", "");
                if (TextUtils.isEmpty(muid))
                    return;
                boolean isSelf = false;
                try {
                    int userType = messageJson.optInt("user_type");
                    if (isO2oChat) {
//                        if (messageJson.optInt("user_id") == userId.intValue()) {
                        isSelf = isSelf(ownerId, HippoApplication.getInstance().getUserData().getUserId().intValue(), messageJson.optInt("user_id"));
//                        }
                    } else {
                        if (userType == UserType.AGENT.getOrdinal() || userType == UserType.SYSTEM.getOrdinal()) {
                            isSelf = true;
                        }
                    }
                } catch (Exception e) {
                    // e.printStackTrace();
                }

                String localDate = dateUtils.convertToLocal(messageJson.getString("date_time"), inputFormat, outputFormat);

                if (!sentAtUTC.equalsIgnoreCase(localDate)) {
                    sentMessages.put(localDate, new Message(localDate, true));
                    fuguMessageList.add(new Message(localDate, true));
                    sentAtUTC = localDate;
                    dateItemCount = dateItemCount + 1;
                }

                Message message = new Message(messageJson.getString("full_name"),
                        Integer.parseInt(messageJson.getString("user_id")),
                        messageJson.getString("message"),
                        messageJson.getString("date_time"),
                        isSelf,
                        onSubscribe == 1 ? MESSAGE_READ : MESSAGE_SENT,
                        fuguMessageList.size(),
                        messageJson.has("image_url") ? messageJson.getString("image_url") : "",
                        messageJson.has("thumbnail_url") ? messageJson.getString("thumbnail_url") : "",
                        messageJson.getInt("message_type"),
                        messageJson.has("user_type") ? messageJson.getInt("user_type") : UserType.AGENT.getOrdinal());

                message.setMuid(messageJson.optString("muid", muid));
                message.setMessageSubType(messageJson.has("message_sub_type") ? messageJson.getInt("message_sub_type") : 0);
                message.setUserImage(messageJson.optString("user_image"));
                message.setOriginalMessageType(messageJson.getInt("message_type"));
                int listMessageType = getType(messageJson.optInt("message_type"), isSelf, messageJson.optString("document_type"));
                message.setMessageType(listMessageType);

                if (messageJson.has("integration_source"))
                    message.setIntegrationSource(messageJson.optInt("integration_source", 0));

                if (messageJson.getInt("message_type") == FEEDBACK_MESSAGE) {
                    message.setRatingGiven(messageJson.getInt("rating_given"));
                    message.setComment(messageJson.getString("comment"));
                    message.setIsRatingGiven(messageJson.getInt("is_rating_given"));
                    message.setTotalRating(messageJson.getInt("total_rating"));

                    message.setLineBeforeFeedback(messageJson.optString("line_before_feedback"));
                    message.setLineAfterFeedback_1(messageJson.optString("line_after_feedback_1"));
                    message.setLineAfterFeedback_2(messageJson.optString("line_after_feedback_2"));
                }

                message = addAboveUserId(message);

                if (!sentMessages.containsValue(messageJson.optString("muid", ""))) {
                    sentMessages.put(messageJson.optString("muid", ""), message);
                    fuguMessageList.add(message);
                }


            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    };

    // intentFilter to add multiple actions
    private IntentFilter getIntentFilter() {
        IntentFilter intent = new IntentFilter();
        intent.addAction(NETWORK_STATE_INTENT);
        intent.addAction(NOTIFICATION_TAPPED);
        return intent;
    }

    private static String myReverse(String str) {
        String reverse = "";
        int length = str.length();
        for (int i = length - 1; i >= 0; i--) {
            reverse = reverse + str.charAt(i);
        }
        return reverse;
    }

    public void collapse(final View v) {
        //HippoApplication.getInstance().trackEvent(GAEvents.CHAT_SCREEN, GAEvents.CLOSE_SHORT_INFO, "short_info_closed");
        final int initialHeight = v.getMeasuredHeight();

        Animation a = new Animation() {
            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                if (interpolatedTime == 1) {
                    v.setVisibility(View.GONE);
                } else {
                    v.getLayoutParams().height = initialHeight - (int) (initialHeight * interpolatedTime);
                    v.requestLayout();
                }
            }

            @Override
            public boolean willChangeBounds() {
                return true;
            }
        };

        // 1dp/ms
        a.setDuration((int) (initialHeight / v.getContext().getResources().getDisplayMetrics().density));
        v.startAnimation(a);
    }

    @Override
    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);

    }

    private static Type listType = new TypeToken<ArrayList<String>>() {
    }.getType();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_chat);

        isFirstTimeOpened = true;
        isFirstTimeApi = true;
        isFromGetConversation = false;
        if (HippoApplication.getInstance().getUserData() != null) {
            initViews();
            registerBroadcast();
            checkAudioButton();

            if (savedInstanceState == null) {
                conversation = new Gson().fromJson(getIntent().getStringExtra(Constants.CONVERSATION), Conversation.class);
                isCreateO2OChat = getIntent().getBooleanExtra("is_one_two_one", false);
                isMerchantChat = getIntent().getBooleanExtra("is_new_o2o", false);
                other_user_email = getIntent().getStringExtra("other_user_email");
                initiated_by_agent = getIntent().getBooleanExtra("initiated_by_agent", false);
                if (isMerchantChat) {
                    conversation.setChatType(2);
                    gtTags.clear();
                    if (getIntent().hasExtra("gt_tags")) {
                        String tags = getIntent().getStringExtra("gt_tags");
                        gtTags.addAll(new Gson().fromJson(tags, listType));
                    }
                }
                if (isCreateO2OChat) {
                    email = getIntent().getStringExtra("one_two_one_email");
                }
                isO2oChat = conversation.getChatType();//
                isP2PChat = getIntent().getBooleanExtra("is_p2p_chat", false);
                btnHistory = getIntent().getBooleanExtra("btnHistory", true);
                isDirectChannel = getIntent().getBooleanExtra("is_direct_channel", false);
                if (getIntent().hasExtra("transactionId"))
                    transactionId = getIntent().getStringExtra("transactionId");
                if (getIntent().hasExtra("isCreateChannelByTransactionId"))
                    isCreateChannelByTransactionId = getIntent().getBooleanExtra("isCreateChannelByTransactionId", false);
                fragmentType = getIntent().getIntExtra(FuguAppConstant.FRAGMENT_TYPE, 0);

            } else {
                String data = savedInstanceState.getString("conversation");
                conversation = new Gson().fromJson(data, Conversation.class);
                isCreateO2OChat = savedInstanceState.getBoolean("is_one_two_one", false);
                if (isCreateO2OChat) {
                    email = savedInstanceState.getString("one_two_one_email");
                }
                isO2oChat = savedInstanceState.getBoolean("is_o2o_chat", false);
                isMerchantChat = savedInstanceState.getBoolean("is_new_o2o", false);
                if (isMerchantChat) {
                    conversation.setChatType(2);
                    gtTags.clear();
                    if (getIntent().hasExtra("gt_tags")) {
                        String tags = getIntent().getStringExtra("gt_tags");
                        gtTags.addAll(new Gson().fromJson(tags, listType));
                    }
                }
                other_user_email = savedInstanceState.getString("other_user_email");
                initiated_by_agent = savedInstanceState.getBoolean("initiated_by_agent", false);
                isP2PChat = savedInstanceState.getBoolean("is_p2p_chat", false);
                btnHistory = savedInstanceState.getBoolean("btnHistory", true);
                transactionId = savedInstanceState.getString("transactionId", "");
                fragmentType = savedInstanceState.getInt(FuguAppConstant.FRAGMENT_TYPE, 0);
            }

            invalidateOptionsMenu();

            if (!TextUtils.isEmpty(transactionId) && !isMerchantChat) {
                createUserConversation();
            } else {
                fetchIntentData();
                setUpUI();
            }

            if (isO2oChat) {
                try {
                    etMsg.setHint("" + Restring.getString(FuguChatActivity.this, R.string.type_message_only));
                    hideO2OViews();
                    tvTitle.setClickable(false);
                    //tvCustNameTitle.setClickable(false);

                } catch (Exception e) {

                }
            }

            if (userInfoflag || isO2oChat)
                tvCustNameTitle.setVisibility(View.GONE);

            stateChangeListeners();
            setSubscribeChannel();
            setUpMentions(etMsg);

            getAgentsResponseData = (GetAgentsResponse) Paper.book(CommonData.name).read(SPLabels.AGENTS);

            if (getAgentsResponseData == null) {
                new ConversationApiHelper((ConversationApiHelper.HelperListener) () -> {

                }).apiGetAgents();
            }

            checkAutoUpload();

        /*if (HippoApplication.getInstance().getUserData().getUserProperties().getTermsAndConditions() == 0) {
            showTnCPopup();
        }*/
        }else {
            showTrialExpirePopUp();
        }
    }

    private void showTrialExpirePopUp() {
        AlertDialog alertDialog = new AlertDialog.Builder(FuguChatActivity.this, R.style.AppCompatAlertDialogStyle).create();
        alertDialog.setMessage("Your free trial has expired, Please navigate to your dashboard");
        alertDialog.setButton(AlertDialog.BUTTON_NEUTRAL, "OK",
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int which) {
                        onBackPressed();
                    }
                });
        alertDialog.setCanceledOnTouchOutside(false);
        alertDialog.show();

        final Button positiveButton = alertDialog.getButton(AlertDialog.BUTTON_NEUTRAL);
        LinearLayout.LayoutParams positiveButtonLL = (LinearLayout.LayoutParams) positiveButton.getLayoutParams();
        positiveButtonLL.gravity = Gravity.CENTER;
        positiveButton.setLayoutParams(positiveButtonLL);
        LinearLayout parent = (LinearLayout) positiveButton.getParent();
        parent.setGravity(Gravity.CENTER_HORIZONTAL);
        View leftSpacer = parent.getChildAt(1);
        leftSpacer.setVisibility(View.GONE);
    }

    /**
     * Terms and policy popup
     */
    private void showTnCPopup() {
        new ConfirmationDialog.Builder(FuguChatActivity.this)
                .listener(new ConfirmationDialog.Listener() {
                    @Override
                    public void performPositiveAction() {
                        new ConversationApiHelper().updateTnCstatus();
                    }

                    @Override
                    public void performNegativeAction() {
                        finish();
                    }
                }).build().show();
    }

    @Override
    protected void onStart() {
        super.onStart();
        BusProvider.getInstance().register(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister(this);
    }

    @Subscribe
    public void onUpdateEvent(UpdateEvent event) {
        if (event.type == 3) {
            showTnCPopup();
        }
    }

    @Subscribe
    public void onFayeMessage(FayeMessage events) {
        if (events.type.equalsIgnoreCase(BusEvents.CONNECTED_SERVER.toString())) {
            onConnectedServer();
        } else if (events.type.equalsIgnoreCase(BusEvents.RECEIVED_MESSAGE.toString())) {
            onReceivedMessage(events.message, events.channelId);
        } else if (events.type.equalsIgnoreCase(BusEvents.PONG_RECEIVED.toString())) {
            onPongReceived();
        } else if (events.type.equalsIgnoreCase(BusEvents.DISCONNECTED_SERVER.toString())) {

        } else if (events.type.equalsIgnoreCase(BusEvents.ERROR_RECEIVED.toString())) {
            onErrorReceived(events.message, events.channelId);
        } else if (events.type.equalsIgnoreCase(BusEvents.WEBSOCKET_ERROR.toString())) {
            onWebSocketError();
        } else if (events.type.equalsIgnoreCase(BusEvents.NOT_CONNECTED.toString())) {
            // TODO: 2020-04-27 show error in faye connection.
        }
    }


    public void subscribeReceivers() {
        setSubscribeChannel();
        LocalBroadcastManager.getInstance(this).registerReceiver(mMessageReceiver, getIntentFilter());
        LocalBroadcastManager.getInstance(this).registerReceiver(mMessageReceiver1, new IntentFilter("custom-event-name"));
        LocalBroadcastManager.getInstance(this).registerReceiver(fileUploadReceiver, new IntentFilter(FuguAppConstant.HIPPO_FILE_UPLOAD));
        LocalBroadcastManager.getInstance(this).registerReceiver(mProgressReceiver, new IntentFilter(FuguAppConstant.HIPPO_PROGRESS_INTENT));

        getMsgData = new GetMsgData();
        getAgentData = new GetAgentData();
        migrateUser = new MigrateData();
        registerReceiver(getMsgData, new IntentFilter(RECIEVER_MSG));
        registerReceiver(getAgentData, new IntentFilter(RECIEVER_MSG_AGENT_REFRESH));
        registerReceiver(updateData, new IntentFilter(UPDATE_MSG));
        registerReceiver(migrateUser, new IntentFilter(MIGRATE_USER));
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putString("conversation", new Gson().toJson(conversation));
        outState.putBoolean("is_o2o_chat", isO2oChat);
        outState.putBoolean("is_new_o2o", isMerchantChat);
        outState.putBoolean("is_p2p_chat", isP2PChat);
        outState.putBoolean("btnHistory", btnHistory);
        super.onSaveInstanceState(outState);
    }

    private IntentFilter getFormIntentFilter() {
        IntentFilter intent = new IntentFilter();
        intent.addAction(LOCAL_PUSH_NOTIFICATION);
        return intent;
    }

    boolean userInfoflag = false;

    private void initViews() {
        ivMenuInfo = (ImageView) findViewById(R.id.ivMenuInfo);

        myToolbar = (Toolbar) findViewById(R.id.my_toolbar);
        setSupportActionBar(myToolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        try {
            final Drawable upArrow = getResources().getDrawable(R.drawable.hippo_ic_arrow_back);
            upArrow.setColorFilter(getResources().getColor(R.color.hippo_back_button), PorterDuff.Mode.SRC_ATOP);
            getSupportActionBar().setHomeAsUpIndicator(upArrow);
        } catch (Resources.NotFoundException e) {

        }

        tvTitle = (TextView) myToolbar.findViewById(R.id.tv_toolbar_name);
        tvTitle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!userInfoflag)
                    ivViewInfo.performClick();
            }
        });
        tvCustNameTitle = (TextView) myToolbar.findViewById(R.id.tvCustNameTitle);
        tvCustNameTitle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!userInfoflag)
                    ivViewInfo.performClick();
            }
        });


        try {
            if (HippoApplication.getInstance().getUserData().getAgentType() == AgentType.AGENT.getOrdinal()
                    && HippoApplication.getInstance().getUserData().getBusinessProperty().hideCustomerData())
                userInfoflag = true;
        } catch (Exception e) {
        }
        if (userInfoflag || isO2oChat)
            tvCustNameTitle.setVisibility(View.GONE);


        //ivMenuInfo.setVisibility(View.VISIBLE);
        ivMenuInfo.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialogShowAgents((GetAgentsResponse) Paper.book(CommonData.name).read(SPLabels.AGENTS));
            }
        });

        mainLayout = findViewById(R.id.main_layout);
        //mainLayout.setBackground(getResources().getDrawable(R.drawable.hippo_chat_bg);

        llBottom = findViewById(R.id.llBottom);
        btnRetry = findViewById(R.id.btnRetry);
        retryLayout = findViewById(R.id.retry_layout);
        progressWheel = findViewById(R.id.progressWheel);
        llCollapsingLayout = (LinearLayout) findViewById(R.id.llCollapsingLayout);
        ivCloseConv = (ImageView) findViewById(R.id.ivCloseConv);
        ivNextIcon = (ImageView) findViewById(R.id.ivNextIcon);
        ivCloseConv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                performMarkConversation();
            }
        });
        llRoot = (CustomRelative) findViewById(R.id.llRoot);
        cvTypeMessage = (CardView) findViewById(R.id.cvTypeMessage);
        botChatAssign = findViewById(R.id.bot_chat_assign);
        tvClosed = (TextView) findViewById(R.id.tvClosed);

        botChatAssign.setText(Restring.getString(FuguChatActivity.this, R.string.take_over));
        tvClosed.setText(Restring.getString(FuguChatActivity.this, R.string.hippo_conversation_closed));
//        vwCustName = (View) findViewById(R.id.vwCustName);
//        vwCustEmail = (View) findViewById(R.id.vwCustEmail);
//        vwCustPhone = (View) findViewById(R.id.vwCustPhone);
//        vwCustCompanyName = (View) findViewById(R.id.vwCustCompanyName);
//        vwNotes = (View) findViewById(R.id.vwNotes);
        progress_wheel = (FuguAgentProgressWheel) findViewById(R.id.progress_wheel);
        progressWheelPrescription = (FuguAgentProgressWheel) findViewById(R.id.progress_wheel_prescription);
        paymentProgressWheel = findViewById(R.id.payment_progress_wheel);
        ivManualBot = (RelativeLayout) findViewById(R.id.ivManualBot);
        ivPaymentBtn = (RelativeLayout) findViewById(R.id.ivPaymentBtn);

        ivCancelEdit = findViewById(R.id.ivCancelEdit);
        ivAttachment = findViewById(R.id.attachment_layout);

        botChatAssign.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                isBotChatAssign = true;
                performAgentClick(HippoApplication.getInstance().getUserData().getUserId(), true);
                //apiAssignAgent(HippoApplication.getInstance().getUserData().getUserId(), true);

            }
        });

        ivCancelEdit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                cancelEditing();
            }
        });

        assignCheckbox = findViewById(R.id.assign_checkbox);
        etCustCompanyName = (EditText) findViewById(R.id.etCustCompanyName);
        etLeadOwner = (EditText) findViewById(R.id.etLeadOwner);
        etNotes = (EditText) findViewById(R.id.etNotes);
        etCustName = (EditText) findViewById(R.id.etCustName);
        etCustPhone = (EditText) findViewById(R.id.etCustPhone);


        editDeal = findViewById(R.id.editDeal);
        editDeal.setVisibility(View.GONE);
        editDeal.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openDealInfo();
            }
        });

        llFollowers = findViewById(R.id.ll_followers);
        followername = findViewById(R.id.tvfirstFollower);
        followersMore = findViewById(R.id.tvMoreFollowers);

        etCustPhone.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToPhone(etCustPhone.getText().toString());
            }
        });
        etCustEmail = (EditText) findViewById(R.id.etCustEmail);
        copyEmail = findViewById(R.id.copy_email);
        copyPhone = findViewById(R.id.copy_phone);

        copyEmail.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!TextUtils.isEmpty(etCustEmail.getText().toString().trim())) {
                    copyToClipBoard(etCustEmail.getText().toString().trim());
                }
            }
        });

        copyPhone.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!TextUtils.isEmpty(etCustPhone.getText().toString().trim()))
                    copyToClipBoard(etCustPhone.getText().toString().trim());
            }
        });

        etCustEmail.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToGmail(etCustEmail.getText().toString());
            }
        });
        tvCustLocation = (TextView) findViewById(R.id.tvCustLocation);
        tvTitleCustName = (TextView) findViewById(R.id.tvTitleCustName);
        tvAssignNotify = (TextView) findViewById(R.id.tvAssignNotify);
        tvNoInternet = (TextView) findViewById(R.id.tvNoInternet);

        tvNoInternet.setText(Restring.getString(FuguChatActivity.this, R.string.hippo_something_wrong_api));
        btnViewDetails = (Button) findViewById(R.id.btnViewDetails);
        btnViewDetails.setVisibility(View.VISIBLE);
        btnViewDetails.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!Utils.preventMultipleClicks()) {
                    return;
                }
                if (conversation.getAgentId() == null)
                    return;
                Intent i = new Intent(FuguChatActivity.this, ChannelInfoActivity.class);
                i.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                i.putExtra(Constants.TAGS_DATA, tagData);
                i.putExtra("deal_id", dealId);
                i.putExtra("directOpen", isDirectChannel);
                i.putExtra("hasBotRunning", hasBotRunning);
                if (conversation.getChatType())
                    i.putExtra("iso2o", conversation.getChatType());
                if (isMerchantChat) {
                    i.putExtra("isMerchantChat", true);
                }

                if (btnHistory && !isO2oChat) {
                    i.putExtra("btnHistory", true);
                }
                startActivityForResult(i, 100);
            }
        });
        ivViewInfo = (ImageView) findViewById(R.id.ivViewInfo);
        ivViewInfo.setVisibility(View.GONE);
        ivViewInfo.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (botChatAssign.getVisibility() == View.VISIBLE) {
                    return;
                }
                if (isP2PChat) {
                    Intent i = new Intent(FuguChatActivity.this, ChatMembersActivity.class);
                    i.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                    startActivity(i);
                } else {
                    if (conversation.getAgentId() == null)
                        return;

                    boolean flag = false;
                    try {
                        if (HippoApplication.getInstance().getUserData().getAgentType() == AgentType.AGENT.getOrdinal()
                                && HippoApplication.getInstance().getUserData().getBusinessProperty().hideCustomerData())
                            flag = true;
                    } catch (Exception e) {
                    }
                    if (flag)
                        return;
                    if (!isO2oChat) {
                        if (llCollapsingLayout.getVisibility() == View.GONE)
                            expand(llCollapsingLayout);
                        else
                            collapse(llCollapsingLayout);
                    }
                }
            }
        });

        ivAudioView = (ImageView) findViewById(R.id.ivAudioView);
        ivAudioView.setVisibility(View.GONE);
        ivAudioView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                videoCallInit(FuguAppConstant.AUDIO_CALL_VIEW);
            }
        });


        ivVideoView = (ImageView) findViewById(R.id.ivVideoView);
        ivVideoView.setVisibility(View.GONE);
        ivVideoView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                videoCallInit(FuguAppConstant.VIDEO_CALL_VIEW);
            }
        });

        btnAddDeal = (Button) findViewById(R.id.btnAddDeal);
        btnAddDeal.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                custEmail = etCustEmail.getText().toString().trim();
                custName = etCustName.getText().toString().trim();
                custPhone = etCustPhone.getText().toString().trim();
                custCompany = etCustCompanyName.getText().toString().trim();
                if (btnAddDeal.getText().toString().equalsIgnoreCase(Restring.getString(FuguChatActivity.this, R.string.edit_deal))) {
                    etCustName.requestFocus();
                    etCustEmail.setVisibility(View.VISIBLE);
                    copyEmail.setVisibility(View.VISIBLE);
                    //vwCustEmail.setVisibility(View.VISIBLE);
                    etCustEmail.setEnabled(true);
                    etCustEmail.setFocusableInTouchMode(true);
                    etCustEmail.setOnClickListener(null);

                    etCustPhone.setVisibility(View.VISIBLE);
                    copyPhone.setVisibility(View.VISIBLE);
                    //vwCustPhone.setVisibility(View.VISIBLE);
                    etCustPhone.setEnabled(true);
                    etCustPhone.setFocusableInTouchMode(true);
                    etCustPhone.setOnClickListener(null);

                    etCustName.setEnabled(false);
                    etCustName.setFocusableInTouchMode(false);
                    //vwCustName.setVisibility(View.GONE);
                    etCustCompanyName.setVisibility(View.GONE);
//                    vwCustCompanyName.setVisibility(View.GONE);
                    assignCheckbox.setVisibility(View.GONE);
//                    vwNotes.setVisibility(View.GONE);

                    llFollowers.setVisibility(View.GONE);

                    btnPushToBulbul.setText(Restring.getString(FuguChatActivity.this, R.string.update));

                    //openDealInfo(true);
                } else {
                    etCustName.setVisibility(View.VISIBLE);
                    //vwCustName.setVisibility(View.VISIBLE);
                    etCustName.setEnabled(true);
                    etCustName.setFocusableInTouchMode(true);

                    etCustEmail.setVisibility(View.VISIBLE);
                    copyEmail.setVisibility(View.GONE);
                    //vwCustEmail.setVisibility(View.VISIBLE);
                    etCustEmail.setEnabled(true);
                    etCustEmail.setFocusableInTouchMode(true);
                    etCustEmail.setOnClickListener(null);

                    etCustPhone.setVisibility(View.VISIBLE);
                    copyPhone.setVisibility(View.VISIBLE);
                    //vwCustPhone.setVisibility(View.VISIBLE);
                    etCustPhone.setEnabled(true);
                    etCustPhone.setFocusableInTouchMode(true);
                    etCustPhone.setOnClickListener(null);

                    etCustCompanyName.setVisibility(View.VISIBLE);
                    //vwCustCompanyName.setVisibility(View.VISIBLE);
                    etCustCompanyName.setEnabled(true);
                    etCustCompanyName.setFocusableInTouchMode(true);

                    assignCheckbox.setVisibility(View.GONE);
                    //vwNotes.setVisibility(View.GONE);
                    llFollowers.setVisibility(View.GONE);

                    if (HippoApplication.getInstance().getUserData().getBusinessProperty().getCrmIntegrationType().intValue() == 1) {
                        btnPushToBulbul.setText(Restring.getString(FuguChatActivity.this, R.string.push_deal_to_bulbul));
                    } else {
                        btnPushToBulbul.setText(Restring.getString(FuguChatActivity.this, R.string.push_deal));
                        //btnPushToBulbul.setText("Push to Leadsquared");
                    }
                    //openDealInfo(false);
                }
                etLeadOwner.setVisibility(View.GONE);
                etNotes.setVisibility(View.GONE);
                rlBulbulActions.setVisibility(View.VISIBLE);
                rlDealViewNotes.setVisibility(View.GONE);
            }
        });
        btnViewNotes = (Button) findViewById(R.id.btnViewNotes);
        btnViewNotes.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialogShowNotes();
            }
        });

        followersMore.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialogShowFollowers();
            }
        });

        btnBack = (TextView) findViewById(R.id.btnBack);
        btnBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                showKeyboard();

                if (!custPhone.equalsIgnoreCase(etCustPhone.getText().toString().trim())) {
                    etCustPhone.setText(custPhone);
                }
                if (!custEmail.equalsIgnoreCase(etCustEmail.getText().toString().trim())) {
                    etCustEmail.setText(custEmail);
                }
                if (!custCompany.equalsIgnoreCase(etCustCompanyName.getText().toString().trim())) {
                    etCustCompanyName.setText(custCompany);
                }

                etCustName.setVisibility(View.GONE);
                //vwCustName.setVisibility(View.GONE);
                etCustName.setEnabled(false);
                etCustName.setFocusableInTouchMode(false);


                if (etCustEmail.getText().toString().isEmpty()) {
                    etCustEmail.setVisibility(View.GONE);
                    copyEmail.setVisibility(View.GONE);
                } else {
                    etCustEmail.setVisibility(View.VISIBLE);
                    copyEmail.setVisibility(View.VISIBLE);
                }
                //vwCustEmail.setVisibility(View.GONE);
                etCustEmail.setEnabled(false);
                etCustEmail.setFocusableInTouchMode(false);
                etCustEmail.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        goToGmail(etCustEmail.getText().toString());
                    }
                });


                if (etCustPhone.getText().toString().isEmpty()) {
                    etCustPhone.setVisibility(View.GONE);
                    copyPhone.setVisibility(View.GONE);
                } else {
                    etCustPhone.setVisibility(View.VISIBLE);
                    copyPhone.setVisibility(View.VISIBLE);
                }
                //vwCustPhone.setVisibility(View.GONE);
                etCustPhone.setEnabled(false);
                etCustPhone.setFocusableInTouchMode(false);
                etCustPhone.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        goToPhone(etCustPhone.getText().toString());
                    }
                });


                if (etCustCompanyName.getText().toString().isEmpty()) {
                    etCustCompanyName.setVisibility(View.GONE);
                } else {
                    etCustCompanyName.setVisibility(View.VISIBLE);
                }
                //vwCustCompanyName.setVisibility(View.GONE);
                etCustCompanyName.setEnabled(false);
                etCustCompanyName.setFocusableInTouchMode(false);

                assignCheckbox.setVisibility(View.GONE);
                //vwNotes.setVisibility(View.GONE);

                if (etLeadOwner.getText().toString().isEmpty()) {
                    etLeadOwner.setVisibility(View.GONE);
                } else {
                    etLeadOwner.setVisibility(View.VISIBLE);
                }
                if (etNotes.getText().toString().isEmpty()) {
                    etNotes.setVisibility(View.GONE);
                } else {
                    etNotes.setVisibility(View.VISIBLE);
                }

                // vwLe.setVisibility(View.GONE);
                etLeadOwner.setEnabled(false);
                etLeadOwner.setFocusableInTouchMode(false);

                etNotes.setEnabled(false);
                etNotes.setFocusableInTouchMode(false);


                rlBulbulActions.setVisibility(View.GONE);

                followersUI();
            }
        });
        btnPushToBulbul = (Button) findViewById(R.id.btnPushToBulbul);
        btnPushToBulbul.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                hideKeyboard();
                if (btnPushToBulbul.getText().toString().equalsIgnoreCase(Restring.getString(FuguChatActivity.this, R.string.update))) {
                    editUserDetails(true);
                } else {
                    if (etCustName.getText().toString().isEmpty()) {
                        Toast.makeText(getApplicationContext(), Restring.getString(FuguChatActivity.this, R.string.hippo_field_cant_empty), Toast.LENGTH_SHORT).show();
                        return;
                    }
                    if (etCustEmail.getText().toString().isEmpty()) {
                        Toast.makeText(getApplicationContext(), Restring.getString(FuguChatActivity.this, R.string.hippo_field_cant_empty), Toast.LENGTH_SHORT).show();
                        return;
                    }
                    if (!Utils.isValidEmail(etCustEmail.getText().toString())) {
                        Toast.makeText(getApplicationContext(), Restring.getString(FuguChatActivity.this, R.string.enter_valid_email), Toast.LENGTH_SHORT).show();
                        return;
                    }
                    if (TextUtils.isEmpty(etCustPhone.getText().toString().trim())) {
                        Toast.makeText(getApplicationContext(), Restring.getString(FuguChatActivity.this, R.string.enter_valid_phn_no), Toast.LENGTH_SHORT).show();
                        return;
                    }


                    editUserDetails(false);
                    addDealToBulbul();
                }
                //

            }
        });
        //extraView = findViewById(R.id.extra_view);
        rlBulbulActions = (RelativeLayout) findViewById(R.id.rlBulbulActions);
        rlDealViewNotes = (RelativeLayout) findViewById(R.id.rlDealViewNotes);
        rlDealViewNotes.setVisibility(View.GONE);
        aviTyping = (AVLoadingIndicatorView) findViewById(R.id.aviTyping);
        llTyping = (LinearLayout) findViewById(R.id.llTyping);
        llTyping.setFocusable(false);
        llChatBottom = (LinearLayout) findViewById(R.id.llChatBottom);
        llMsgInput = findViewById(R.id.llMsgInput);
        etMsg = (EditTextSelectable) findViewById(R.id.etMsg);
        rvMessages = (RecyclerView) findViewById(R.id.rvMessages);
        layoutManager = new LinearLayoutManager(FuguChatActivity.this);
        layoutManager.setStackFromEnd(true);
        rvMessages.setLayoutManager(layoutManager);

        viewBlack = (View) findViewById(R.id.viewBlack);


        etMsg.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (llCollapsingLayout.getVisibility() == View.VISIBLE) {
                    if (etCustName.getVisibility() == View.VISIBLE) {
                        tvTitle.setTextSize(TypedValue.COMPLEX_UNIT_PX,
                                getResources().getDimension(R.dimen.fugu_text_size_intermediate));
                    }

                    Log.v("scroll up on layout", "scroll up");
                    collapse(llCollapsingLayout);


                    ivNextIcon.setVisibility(View.GONE);
                    ivNextIcon.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {

                        }
                    });
                }
                return false;
            }
        });

        etMsg.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                //You can identify which key pressed buy checking keyCode value with KeyEvent.KEYCODE_
                if (keyCode == KeyEvent.KEYCODE_DEL) {
                    //this is for backspace
                }
                return false;
            }
        });

        pbSendingImage = (ProgressBar) findViewById(R.id.pbSendingImage);
        ivSend = (ImageView) findViewById(R.id.ivSend1);
        record_button = findViewById(R.id.record_button);
        record_view = findViewById(R.id.record_view);
        itemLayout = findViewById(R.id.itemLayout);

        ivSend.setClickable(false);
        //ivSend.setColorFilter(ContextCompat.getColor(this, R.color.colorPrimary), PorterDuff.Mode.DST_IN);
        ivSend.setAlpha(0.5f);

        ivPrivate = (ImageView) findViewById(R.id.ivPrivate);
        ivText = (ImageView) findViewById(R.id.ivText);
        vPrivate = findViewById(R.id.vPrivate);
        vText = findViewById(R.id.vText);
        rlPrivate = findViewById(R.id.rlPrivate);
        rlGiff = (RelativeLayout) findViewById(R.id.rlGiff);
        rlText = (RelativeLayout) findViewById(R.id.rlText);
        rlCanned = (RelativeLayout) findViewById(R.id.rlCanned);
        rlPrescription = (RelativeLayout) findViewById(R.id.rlPrescription);
        rlPrescription.setOnClickListener(this);
        rlImage = (RelativeLayout) findViewById(R.id.rlImage);
        pbLoading = (ProgressBar) findViewById(R.id.pbLoading);
        rlScrollBottom = (RelativeLayout) findViewById(R.id.rlScrollBottom);
        tvUnread = (TextView) findViewById(R.id.tvUnread);
        imageUtils = new ImageUtils(FuguChatActivity.this);
        dateUtils = DateUtils.getInstance();
        rvTagged = (RecyclerView) findViewById(R.id.rvTagged);
        rvOptions = (RecyclerView) findViewById(R.id.rvOptions);

        ivPrivate.setColorFilter(ContextCompat.getColor(this, R.color.black), PorterDuff.Mode.SRC_IN);
        ivText.setColorFilter(ContextCompat.getColor(this, R.color.colorPrimary), PorterDuff.Mode.SRC_IN);

        cvTypeMessage.post(new Runnable() {
            @Override
            public void run() {
                cvTypeMessage.getMeasuredHeight();
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) rlScrollBottom.getLayoutParams();
                params.setMargins(0, 0, (int) getResources().getDimension(R.dimen.fugu_margin_minus_10), cvTypeMessage.getMeasuredHeight() + (int) getResources().getDimension(R.dimen.fugu_margin_20));
                rlScrollBottom.setLayoutParams(params);
            }
        });


        fuguTagAdapter = new FuguTagAdapter(FuguChatActivity.this, showTaggedAgents
                , "", new FuguTagAdapter.Callback() {
            @Override
            public void onClick(GetAgentsResponse.Agents agent) {
                getTaggedText(agent, true);
                //HippoApplication.getInstance().trackEvent(GAEvents.CHAT_SCREEN, "Tagged selected", "tag_agent_selected");
            }
        });

        paymentLayout = findViewById(R.id.payment_layout);
        paymentLayout.setVisibility(View.GONE);
        try {
            if (HippoApplication.getInstance().getUserData().getBusinessProperty().isAskPaymentAllowed())
                paymentLayout.setVisibility(View.VISIBLE);
        } catch (Exception e) {
            e.printStackTrace();
        }

        paymentLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                openSavedPlan();
            }
        });

        botLayout = (RelativeLayout) findViewById(R.id.bot_layout);
        prescriptionRL = (RelativeLayout) findViewById(R.id.prescriptionRL);

        if (HippoApplication.getInstance().getUserData()!= null && HippoApplication.getInstance().getUserData().getBusinessProperty().getIsEformEnabled() == 0) {
            prescriptionRL.setVisibility(View.GONE);
        } else {
            prescriptionRL.setVisibility(View.VISIBLE);
        }

        botLayout.setVisibility(View.VISIBLE);
        ivManualBot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!isNetworkAvailable()) {
                    Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                    return;
                }
                getBotOptions();
            }
        });


        etCustName.setHint(Restring.getString(FuguChatActivity.this, R.string.deal_name));
        etCustEmail.setHint(Restring.getString(FuguChatActivity.this, R.string.email));
        etCustPhone.setHint(Restring.getString(FuguChatActivity.this, R.string.phone));
        etCustCompanyName.setHint(Restring.getString(FuguChatActivity.this, R.string.company));
        etLeadOwner.setHint(Restring.getString(FuguChatActivity.this, R.string.lead_owner));
        etNotes.setHint(Restring.getString(FuguChatActivity.this, R.string.notes));

        editDeal.setText(Restring.getString(FuguChatActivity.this, R.string.edit_deal));
        assignCheckbox.setText(Restring.getString(FuguChatActivity.this, R.string.assign_the_deal_to_me));
        btnBack.setText(Restring.getString(FuguChatActivity.this, R.string.back));
        tvCustNameTitle.setText(Restring.getString(FuguChatActivity.this, R.string.tap_to_view_info));
        recordViewSetup();


    }

    private void recordViewSetup() {
        record_button.setRecordView(record_view);
        recordingUtil = new RecordingUtil(this, this);

        record_view.setCancelBounds(8);


        record_view.setSmallMicColor(Color.parseColor("#c2185b"));

        //prevent recording under one Second
        record_view.setLessThanSecondAllowed(false);


        record_view.setSlideToCancelText(Restring.getString(this, R.string.slide_to_cancel));


        record_view.setCustomSounds(R.raw.record_start, R.raw.record_finished, 0);

        record_view.setOnRecordListener(new OnRecordListener() {
            @Override
            public void onStart() {
                try {
                    etMsg.setVisibility(View.GONE);
                    itemLayout.setVisibility(View.GONE);
                    record_view.setVisibility(View.VISIBLE);
                    recordingUtil.startRecording();
                } catch (IOException e) {
                    e.printStackTrace();
                }


            }

            @Override
            public void onCancel() {

                recordingUtil.cancelRecording();
            }

            @Override
            public void onFinish(long recordTime, boolean limitReached) {
                etMsg.setVisibility(View.VISIBLE);
                itemLayout.setVisibility(View.VISIBLE);
                record_view.setVisibility(View.GONE);
                recordingUtil.stopRecording();

            }

            @Override
            public void onLessThanSecond() {
                etMsg.setVisibility(View.VISIBLE);
                itemLayout.setVisibility(View.VISIBLE);
                record_view.setVisibility(View.GONE);
                recordingUtil.cancelRecording();

            }
        });

        record_view.setOnBasketAnimationEndListener(new OnBasketAnimationEnd() {
            @Override
            public void onAnimationEnd() {
                etMsg.setVisibility(View.VISIBLE);
                itemLayout.setVisibility(View.VISIBLE);
                record_view.setVisibility(View.GONE);
            }
        });

        record_view.setRecordPermissionHandler(new RecordPermissionHandler() {
            @Override
            public boolean isPermissionGranted() {
                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
                    return true;
                }

                boolean recordPermissionAvailable = true;


                String[] perms = {"android.permission.READ_EXTERNAL_STORAGE",
                        "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"};
                for (String perm : perms) {

                    if (ContextCompat.checkSelfPermission(FuguChatActivity.this, perm)
                            != PackageManager.PERMISSION_GRANTED) {
                        recordPermissionAvailable = false;
                    }

                }

                if (recordPermissionAvailable) {
                    return true;
                }


                EasyPermissions.requestPermissions(
                        FuguChatActivity.this,
                        Restring.getString(FuguChatActivity.this, R.string.vw_rationale_storage),
                        FuguAppConstant.RC_READ_EXTERNAL_STORAGE,
                        "android.permission.READ_EXTERNAL_STORAGE",
                        "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"
                );

                return false;

            }
        });

    }


    private void hideO2OViews() throws Exception {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ivAttachment.setVisibility(View.GONE);
//                rlText.setVisibility(View.GONE);
//                rlPrivate.setVisibility(View.GONE);
//                botLayout.setVisibility(View.GONE);
//                rlCanned.setVisibility(View.GONE);
//                paymentLayout.setVisibility(View.GONE);
            }
        });
    }

    private void clearNotification(int channelId) {
        try {
            NotificationUtils.clearNotifications(FuguChatActivity.this, channelId);
            CommonData.removeNotificationChannel(channelId);
            NotificationDatabase.INSTANCE.removeNotifications(channelId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendFaye(Bot bot) {
        if (bot != null) {
            bottomSheetFragment.dismiss();
            String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
            if (bot.getMessageType() == USER_CONCENT_MESSAGE || bot.getMessageType() == FEEDBACK_MESSAGE)
                muid = "";
            sendMessage(bot.getMessage(), bot.getMessageType(), "", "", bot, false, null, "",
                    muid, -1, null, 0);
        }
    }

    private void getBotOptions() {
        hideKeyboard();
        HashMap<String, String> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
        params.put("user_id", String.valueOf(conversation.getUserId()));
        params.put(Constants.CHANNEL_ID, String.valueOf(conversation.getChannelId()));

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build();

        progress_wheel.setVisibility(View.VISIBLE);
        progress_wheel.spin();
        ivManualBot.setVisibility(View.GONE);

        Logger.INSTANCE.apiRequest("/api/agent/getAllBotActions", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getBotOptions(commonParams.getMap()).enqueue(new ResponseResolver<GetAllBots>() {
            @Override
            public void success(GetAllBots getTagsResponse) {
                Logger.INSTANCE.apiResponse("/api/agent/getAllBotActions", "");
                try {
                    if (getTagsResponse.getData().size() > 0) {
                        bottomSheetFragment = new BottomSheetFragment(getTagsResponse.getData());
                        bottomSheetFragment.show(getSupportFragmentManager(), bottomSheetFragment.getTag());
                    } else {
                        tvAssignNotify.setVisibility(View.VISIBLE);
                        tvAssignNotify.setText(Html.fromHtml(Restring.getString(FuguChatActivity.this, R.string.no_bot_found)));
                        tvAssignNotify.setBackgroundColor(getResources().getColor(R.color.red));
                        tvAssignNotify.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_report_problem, 0, 0, 0);
                        goneAssignLayout();

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                progress_wheel.setVisibility(View.GONE);
                ivManualBot.setVisibility(View.VISIBLE);
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("/api/agent/getAllBotActions", error.getMessage());
                progress_wheel.setVisibility(View.GONE);
                ivManualBot.setVisibility(View.VISIBLE);
            }
        });
    }


    private void showRvTaggedList(RecyclerView taggedRV) {
        if (messageType == PRIVATE_NOTE) {
            taggedRV.setVisibility(View.VISIBLE);
            if (showTaggedAgents.isEmpty()) {
                viewBlack.setVisibility(View.GONE);
                viewBlack.setBackgroundColor(getResources().getColor(R.color.white));
            } else {
                viewBlack.setVisibility(View.VISIBLE);
                viewBlack.setBackgroundColor(getResources().getColor(R.color.black_50));
            }
            viewBlack.setBackgroundColor(ContextCompat.getColor(getApplicationContext(), R.color.black_50));
            taggedRV.animate().translationY(0.0f).setDuration(100000);
        }
    }

    private void fetchIntentData() {
        if (conversation.isDisableReply() || isP2PChat) {
            cvTypeMessage.setVisibility(View.GONE);
        }
        botChatAssign.setVisibility(View.GONE);
        if (conversation.isDisableReply() && conversation.isBotEnabled()) {
            botChatAssign.setVisibility(View.VISIBLE);
        }

        chatClicked = getIntent().getStringExtra(CHAT_CLICKED);
        status = conversation.getStatus().equals(MessageMode.OPEN_CHAT.getOrdinal()) ? MessageMode.CLOSED_CHAT.getOrdinal() : MessageMode.OPEN_CHAT.getOrdinal();
        if (status == MessageMode.OPEN_CHAT.getOrdinal()) {
            ivCloseConv.setVisibility(View.GONE);
        }
        if (!isFromGetConversation)
            tvTitle.setText(conversation.getLabel());

        pushChannelId = conversation.getChannelId();
        clearNotification(conversation.getChannelId());
        currentChannelId = conversation.getChannelId();

        if (CommonData.getUnsentMessageMapByChannel(conversation.getChannelId()) != null) {
            unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(conversation.getChannelId());
        }

        if (conversation.getUserId() != null && conversation.getUserId() < 1) {
            llCollapsingLayout.setVisibility(View.GONE);
        }

        try {
            stopAlarmRing();
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            if (conversation.getChannelId() > 0) {
                onChannelUpdate(conversation.getChannelId());
            }
        } catch (Exception e) {

        }

        try {
            if (currentChannelId > 0) {
                String message = CommonData.getTypedMessage(currentChannelId);
                Log.e("channelId", "message = " + message);
                if (!TextUtils.isEmpty(message)) {
                    etMsg.setText(message);
                    ivSend.setVisibility(View.VISIBLE);
                    record_button.setVisibility(View.GONE);
                    record_view.setVisibility(View.GONE);
                    if (etMsg.getText().toString().trim().isEmpty()) {
                        etMsg.setVisibility(View.GONE);
                        checkAudioButton();
                    }
                    CommonData.saveTypedMessage(currentChannelId, "");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean channelCreated = false;

    private void parseData() throws Exception {
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                //android.os.Process.setThreadPriority(android.os.Process.THREAD_PRIORITY_BACKGROUND);
                if (CommonData.getMessageResponse(conversation.getChannelId()) != null
                        && CommonData.getMessageResponse(conversation.getChannelId()).getData().getMessages().size() > 0) {
                    FuguGetMessageResponse response = CommonData.getMessageResponse(conversation.getChannelId());

                    try {
                        checkValidMsg = response.getData().getRestrictPersonalInfo();
                    } catch (Exception e) {

                    }
                    videoCustomerName = response.getData().getCustomerName();
                    videoAgentName = response.getData().getAgentName();
                    isChatAssignToMe = (response.getData().getUserId() == HippoApplication.getInstance().getUserData().getUserId().intValue()) ? true : false;

                    try {
                        isVideoCallEnable = false;
                        if (HippoApplication.getInstance().getUserData().isVideoCallEnabled()
                                && response != null && response.getData() != null && response.getData().isAllowVideoCall()) {
                            isVideoCallEnable = true;
                        }
                    } catch (Exception e) {

                    }

                    try {
                        isAudioCallEnable = false;
                        if (HippoApplication.getInstance().getUserData().isAudioCallEnabled()
                                && response != null && response.getData() != null && response.getData().isAllowAudioCall()) {
                            isAudioCallEnable = true;
                        }
                    } catch (Exception e) {

                    }


                    Log.e(TAG, "System.currentTimeMillis(): " + System.currentTimeMillis());
                    showLoading = false;
                    sentMessages = new LinkedHashMap<>();
                    unsentMessages = new LinkedHashMap<>();
                    fuguMessageList.clear();

                    if (CommonData.getSentMessageByChannel(conversation.getChannelId()) != null) {
                        sentMessages = CommonData.getSentMessageByChannel(conversation.getChannelId());
                        fuguMessageList.addAll(sentMessages.values());
                    }

                    List<String> reverseOrderedKeys = new ArrayList<String>(sentMessages.keySet());
                    Collections.reverse(reverseOrderedKeys);
                    sentAtUTC = "";
                    for (String key : reverseOrderedKeys) {
                        if (sentMessages.get(key).isDateView()) {
                            sentAtUTC = key;
                            break;
                        }
                    }

                    if (CommonData.getUnsentMessageByChannel(conversation.getChannelId()) != null) {
                        unsentMessages = CommonData.getUnsentMessageByChannel(conversation.getChannelId());
                        if (unsentMessages == null)
                            unsentMessages = new LinkedHashMap<>();

                        for (String key : unsentMessages.keySet()) {
                            Message message = unsentMessages.get(key);
                            String time = message.getSentAtUtc();
                            int expireTimeCheck = message.getIsMessageExpired();

                            if (message.getMessageType() != IMAGE_MESSAGE && expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                                message.setIsMessageExpired(1);
                                try {
                                    JSONObject messageJson = unsentMessageMapNew.get(key);
                                    messageJson.put("is_message_expired", 1);
                                    messageJson.put(USER_IMAGE, getUserImage());
                                    unsentMessageMapNew.put(key, messageJson);
                                } catch (Exception e) {
                                    //e.printStackTrace();
                                }
                            } else if (message.getMessageType() == IMAGE_MESSAGE) {
                                JSONObject messageJson = unsentMessageMapNew.get(key);
                                if (messageJson == null) {
                                    //message.setUploadStatus(UPLOAD_FAILED);
                                    message.setMessageStatus(MESSAGE_IMAGE_RETRY);
                                }
                            } else if (message.getMessageType() == FILE_MESSAGE) {
                                try {
                                    if (!isMyServiceRunning(UploadingService.class)) {
                                        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(FuguChatActivity.this).getString(FuguAppConstant.KEY, ""), fileuploadType);
                                        if (expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                                            if (fileuploadModels != null) {
                                                for (int i = 0; i < fileuploadModels.size(); i++) {
                                                    if (fileuploadModels.get(i).getMuid().equalsIgnoreCase(key)) {
                                                        fileuploadModels.remove(i);
                                                        String data = new Gson().toJson(fileuploadModels, fileuploadType);
                                                        Log.e(TAG, "In setMessageExpired after update: " + data);
                                                        Prefs.with(FuguChatActivity.this).save(KEY, data);
                                                        break;
                                                    }
                                                }
                                            }
                                            message.setIsMessageExpired(1);
                                            message.setUploadStatus(UPLOAD_FAILED);
                                            try {
                                                JSONObject messageJson = unsentMessageMapNew.get(key);
                                                messageJson.put("is_message_expired", 1);
                                                messageJson.put(USER_IMAGE, getUserImage());
                                                unsentMessageMapNew.put(key, messageJson);
                                            } catch (Exception e) {
                                                //e.printStackTrace();
                                            }

                                        } else if (fileuploadModels != null) {

                                        }
                                    }
                                } catch (Exception e) {

                                }
                            }
                        }
                        CommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
                        CommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

                        for (String key : unsentMessages.keySet()) {
                            Message listItem = unsentMessages.get(key);
                            String time = listItem.getSentAtUtc();
                            String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                            //String date = dateUtils.getDate(loaclDate);
                            if (!sentAtUTC.equalsIgnoreCase(localDate)) {
                                fuguMessageList.add(new Message(localDate, true));
                                sentAtUTC = localDate;
                                System.out.println("Date: " + localDate);
                            }
                            fuguMessageList.add(unsentMessages.get(key));
                        }

                    }

                    Log.e(TAG, "System.currentTimeMillis(): " + System.currentTimeMillis());


                    try {
                        if (HippoApplication.getInstance().getUserData().isVideoCallEnabled() &&
                                response.getData() != null && response.getData().isAllowVideoCall()) {
                            if ((isO2oChat && (conversation.getUserId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue()
                                    || conversation.getAgentId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue())) || HippoApplication.getInstance().getUserData().getUserId().intValue() == response.getData().getUserId()) {
                                isVideoView = true;
                            } else
                                isVideoView = false;

                        }
                    } catch (Exception e) {
                        isVideoView = false;

                        e.printStackTrace();
                    }

                    try {
                        if (HippoApplication.getInstance().getUserData().isAudioCallEnabled() && response.getData() != null && response.getData().isAllowAudioCall()) {
                            if ((isO2oChat && (conversation.getUserId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue()
                                    || conversation.getAgentId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue())) || HippoApplication.getInstance().getUserData().getUserId().intValue() == response.getData().getUserId()) {
                                isAudioView = true;
                            } else
                                isAudioView = false;
                        }
                    } catch (Exception e) {
                        isAudioView = false;

                    }

                } else {
                    showLoading = true;
                }

                processNextSteps();
            }
        });

        thread.start();
    }


    private void processNextSteps() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (isAudioView) {
                    ivAudioView.setVisibility(View.VISIBLE);
                }

                if (isVideoView) {
                    ivVideoView.setVisibility(View.VISIBLE);
                }

                if (!showLoading) {
                    setUserData(CommonData.getMessageResponse(conversation.getChannelId()).getData());
                    setRecyclerViewData();
                    llRoot.setVisibility(View.VISIBLE);
                }

                if (conversation != null && !TextUtils.isEmpty(conversation.getPushMessage())) {
                    sendMessage(conversation.getPushMessage(), TEXT_MESSAGE, "", "",
                            null, false, null, "", null);
                    conversation.setPushMessage("");
                }

                Log.e(TAG, "System.currentTimeMillis(): " + System.currentTimeMillis());

                if (conversation.getStatus() != null && conversation.getStatus() == 0) {
                    cvTypeMessage.setVisibility(View.GONE);
                    tvClosed.setVisibility(View.VISIBLE);
                }


                if (isNetworkAvailable()) {
                    if (isCreateO2OChat && conversation.getChannelId().intValue() < 0) {
                        if (isMerchantChat) {
                            createAgentSupportChannel(email, transactionId, gtTags, initiated_by_agent);
                        } else {
                            createViaEmail(email);
                        }
                    } else {
                        getMessages();
                    }
                } else {
                    setConnectionMessage(3);
                }
            }
        });


    }


    private void setUpUI() {
        try {
            parseData();
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (conversation.getStatus() != null && conversation.getStatus() == 0) {
            cvTypeMessage.setVisibility(View.GONE);
            tvClosed.setVisibility(View.VISIBLE);
        } else {
            if (conversation.isDisableReply() || isP2PChat) {
                cvTypeMessage.setVisibility(View.GONE);
            }
            botChatAssign.setVisibility(View.GONE);
            if (conversation.isDisableReply() && conversation.isBotEnabled()) {
                botChatAssign.setVisibility(View.VISIBLE);
            }
        }
    }

    TextWatcher textWatcherFalse = new TextWatcher() {

        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {

        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {

        }

        @Override
        public void afterTextChanged(Editable s) {

        }
    };
    TextWatcher textWatcher = new TextWatcher() {
        private final long DELAY = 3000; // milliseconds
        private Timer timer = new Timer();

        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            //Log.v("onTextChanged", "--> " + charSequence);
            if (charSequence.length() > 0) {
                ivSend.setVisibility(View.VISIBLE);
                record_button.setVisibility(View.GONE);
                record_view.setVisibility(View.GONE);
                ivSend.setClickable(true);
                ivSend.setAlpha(1f);
            } else {
                visibilityGone(rvTagged);
                ivSend.setClickable(false);
                ivSend.setAlpha(0.5f);
                if (isPrivateClicked) {
                    ivSend.setVisibility(View.VISIBLE);
                    record_button.setVisibility(View.GONE);
                    record_view.setVisibility(View.GONE);
                } else {
                    checkAudioButton();
                }
            }

            if (isO2oChat) {
                return;
            }
            if (messageType == PRIVATE_NOTE) {
                if (showTaggedAgents.isEmpty()) {
                    viewBlack.setVisibility(View.GONE);
                    viewBlack.setBackgroundColor(getResources().getColor(R.color.white));
                } else {
                    viewBlack.setVisibility(View.VISIBLE);
                    viewBlack.setBackgroundColor(getResources().getColor(R.color.black_50));
                }
            } else {
                viewBlack.setVisibility(View.GONE);
                viewBlack.setBackgroundColor(getResources().getColor(R.color.white));
            }

            try {
                char currentChar = charSequence.charAt(i); // currently typed character
                if (String.valueOf(currentChar).equals("/")) {
                    if (charSequence.length() > 0 && HippoApplication.getInstance().getUserData().getBusinessProperty().isSavedReply()) {
                        openSavedReply(charSequence);
                    }
                }
            } catch (Exception e) {
                // error
            }

        }

        @Override
        public void afterTextChanged(Editable editable) {

            if (isTyping != 1) {
                Log.d(LOG_TAG, isTyping + "started typing");
                // publish start typing event

                if (!etMsg.getText().toString().isEmpty() && !isMessageInEditMode) {
                    isTyping = 1;
                    publishOnFaye(Restring.getString(FuguChatActivity.this, R.string.empty), messageType, getString(R.string.empty), getString(R.string.empty), DEFAULT_NOTIFICATION_TYPE);
                }
            }
            timer.cancel();
            timer = new Timer();
            timer.schedule(
                    new TimerTask() {
                        @Override
                        public void run() {
                            Log.d(LOG_TAG, isTyping + "stopped typing");
                            //publish stopped typing event
                            if (isTyping == 1 && !isMessageInEditMode) {
                                isTyping = 2;
                                publishOnFaye(getString(R.string.empty), messageType, getString(R.string.empty), getString(R.string.empty), DEFAULT_NOTIFICATION_TYPE);
                            }
                        }
                    },
                    DELAY
            );
        }
    };

    private void checkAudioButton() {

        if (HippoConfig.getInstance().getAttributes() != null &&
                HippoConfig.getInstance().getAttributes().getAdditionalInfo() != null &&
                HippoConfig.getInstance().getAttributes().getAdditionalInfo().hideAudioRecordingButton()){
            record_button.setVisibility(View.GONE);
            record_view.setVisibility(View.GONE);
            ivSend.setVisibility(View.VISIBLE);
        }else {
            record_button.setVisibility(View.VISIBLE);
            record_view.setVisibility(View.VISIBLE);
            ivSend.setVisibility(View.GONE);
        }
    }

    private void stateChangeListeners() {
        if (!HippoApplication.getInstance().getUserData().getBusinessProperty().isSavedReply()) {
            etMsg.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_normal_message));
        } else {
            etMsg.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_message));
        }
        etMsg.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View view, boolean b) {
            }
        });

        etMsg.addTextChangedListener(textWatcher);

        llRoot.setOnKeyBoardStateChanged(new CustomRelative.OnKeyboardOpened() {
            @Override
            public boolean onKeyBoardStateChanged(boolean isVisible) {
                if (isVisible && fuguMessageAdapter != null && fuguMessageAdapter.getItemCount() > 0) {
                    //scrollListToBottom();
                    rlScrollBottom.setVisibility(View.GONE);
                    scrollBottomCount = 0;
                }
                return false;
            }
        });
    }

    public void setSubscribeChannel() {
        try {
            if (conversation.getChannelId() != null && conversation.getChannelId() > -1) {
                ConnectionManager.INSTANCE.initFayeConnection();
                ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(conversation.getChannelId()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkUnsentMessageStatus(RefreshDone done) {
        index = -1;
        if (unsentMessages == null)
            unsentMessages = new LinkedHashMap<>();
        for (String key : unsentMessages.keySet()) {
            Message listItem = unsentMessages.get(key);
            String time = listItem.getSentAtUtc();
            int expireTimeCheck = listItem.getIsMessageExpired();
            if (expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                listItem.setIsMessageExpired(1);
                try {
                    JSONObject messageJson = unsentMessageMapNew.get(key);
                    messageJson.put("is_message_expired", 1);
                    if (!isMyServiceRunning(UploadingService.class) && listItem.getMessageType() == FILE_MESSAGE) {
                        listItem.setUploadStatus(UPLOAD_FAILED);
                    }
                    messageJson.put(USER_IMAGE, getUserImage());
                    unsentMessageMapNew.put(key, messageJson);
                    if (index == -1)
                        index = messageJson.optInt("message_index", -1);
                } catch (Exception e) {
                    //e.printStackTrace();
                }
            }
        }
        CommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
        CommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

        if (index > -1 && fuguMessageAdapter != null) {
            try {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        fuguMessageAdapter.notifyItemRangeChanged(index, fuguMessageList.size());
                    }
                });
            } catch (Exception e) {

            }
        }

        if (done != null) {
            done.onRefreshComplete();
        }
    }

    private void updateFeedback(final int position, final boolean scrollDown) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (scrollDown) {
                        fuguMessageAdapter.notifyDataSetChanged();
                        scrollListToBottom();
                    } else {
                        fuguMessageAdapter.notifyItemChanged(position);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    boolean messageSending = false;
    boolean messageSendingRecursion = false;
    boolean hasRead = false;
    String cardMuid = "";

    public void onConnectedServer() {
        if (conversation.getChannelId() > -1) {
            //ConnectionManager.INSTANCE.unsubScribeChannel("/" + String.valueOf(conversation.getChannelId()));
            ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(conversation.getChannelId()));
            publishMessage(prepareMessageJson(1), false);
            getMessages(false, true);

            if (unsentMessages != null && unsentMessages.size() > 0) {
                onPongReceived();
            }
        }
    }

    public void onWebSocketError() {
        messageSending = false;
        messageSendingRecursion = false;
    }

    String lastMuid = "";

    public void onErrorReceived(String msg, String channel) {
        Log.e(TAG, ">>>>>>>>>>>>>>>>>> onErrorReceived <<<<<<<<<<<<<<<<<<<<");
        try {
            if (!channel.equalsIgnoreCase("/" + String.valueOf(conversation.getChannelId()))) {
                Log.e(TAG, "Other channel id message received");
                return;
            }
            ActivityManager mngr = (ActivityManager) getSystemService(ACTIVITY_SERVICE);
            List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
            if (!taskList.get(0).topActivity.getClassName().equals("com.hippoagent.activities.FuguChatActivity")) {
                Log.e(TAG, "FuguChatActivity false");
                return;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            final JSONObject messageJson = new JSONObject(msg);
            if (messageJson.has("statusCode")) {
                if (messageJson.optInt("statusCode") == 420) {
                    String muid = messageJson.optString("muid", "");
                    if (!TextUtils.isEmpty(muid)) {
                        unsentMessageMapNew.remove(muid);
                        Message message = unsentMessages.get(muid);

                        int messageIndex = message.getMessageIndex();
                        try {
                            if (fuguMessageList.get(messageIndex).getType() == TYPE_HEADER
                                    && (messageIndex + 1 < fuguMessageList.size())) {
                                messageIndex = messageIndex + 1;
                                fuguMessageList.get(messageIndex + 1).setMessageStatus(MESSAGE_SENT);
                            } else if (messageIndex < fuguMessageList.size()) {
                                fuguMessageList.get(messageIndex).setMessageStatus(MESSAGE_SENT);
                            }
                        } catch (Exception e) {
                            try {
                                for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                                    if (!fuguMessageList.get(i).isDateView()) {
                                        Message currentMessage = fuguMessageList.get(i);
                                        if (currentMessage.getMuid().equals(muid)) {
                                            messageIndex = i;
                                            try {
                                                if (fuguMessageList.get(messageIndex).getType() == TYPE_HEADER
                                                        && (messageIndex + 1 < fuguMessageList.size())) {
                                                    Log.v("onReceivedMessage", "in if 3");
                                                    messageIndex = messageIndex + 1;
                                                    fuguMessageList.get(messageIndex + 1).setMessageStatus(MESSAGE_SENT);
                                                } else if (messageIndex < fuguMessageList.size()) {
                                                    Log.v("onReceivedMessage", "in elseIf 1");
                                                    fuguMessageList.get(messageIndex).setMessageStatus(MESSAGE_SENT);
                                                }
                                            } catch (Exception e1) {
                                                e1.printStackTrace();
                                            }
                                            break;
                                        }
                                    }
                                }
                            } catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }

                        Message listItem = unsentMessages.get(muid);
                        if (listItem == null)
                            return;
                        listItem.setMessageStatus(MESSAGE_SENT);

                        List<String> reverseOrderedKeys = new ArrayList<>(sentMessages.keySet());
                        Collections.reverse(reverseOrderedKeys);
                        String tempSentAtUTC = "";
                        for (String key : reverseOrderedKeys) {
                            if (sentMessages.get(key).isDateView()) {
                                tempSentAtUTC = key;
                                break;
                            }
                        }
                        String time = listItem.getSentAtUtc();
                        String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                        if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                            sentMessages.put(localDate, new Message(localDate, true));
                        }

                        sentMessages.put(muid, listItem);
                        unsentMessageMapNew.remove(muid);
                        unsentMessages.remove(muid);
                        pageStart = pageStart + 1;
                        if (unsentMessageMapNew.size() == 0 && isNetworkStateChanged) {
                            pageStart = 1;
                            isNetworkStateChanged = false;
                        }

                        final int finalMessageIndex = messageIndex;
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    Log.e(TAG, "notifyItemChanged at: " + finalMessageIndex);
                                    fuguMessageAdapter.updateList(fuguMessageList);
                                    fuguMessageAdapter.notifyItemChanged(finalMessageIndex);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });


                        messageSending = false;
                    }
                } else if (messageJson.optInt("statusCode") == 413 && messageJson.has("showError")
                        && messageJson.optBoolean("showError")) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            tvAssignNotify.setVisibility(View.VISIBLE);
                            tvAssignNotify.setText(messageJson.optString("customMessage"));
                            tvAssignNotify.setBackgroundColor(getResources().getColor(R.color.red));
                            tvAssignNotify.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_report_problem, 0, 0, 0);
                            goneAssignLayout();
                            //isBlock = true;
                            unsentMessageMapNew.clear();
                            unsentMessages.clear();
                            fuguMessageList.remove(fuguMessageList.size() - 1);
                            messageSending = false;
                            messageSendingRecursion = false;
                            rvMessages.getRecycledViewPool().clear();
                            if (fuguMessageAdapter != null) {
                                fuguMessageAdapter.notifyDataSetChanged();
                            }
                        }
                    });
                } else if (messageJson.optInt("statusCode") == 417) {
                    String message = messageJson.optString("message", "");
                    String muid = messageJson.optString("muid", "");

                    if (lastMuid.equals(muid))
                        return;
                    if (!TextUtils.isEmpty(message)) {
                        ToastUtil.getInstance(FuguChatActivity.this).showToast(message);
                    }

                    messageSendingRecursion = false;
                    messageSending = false;

                    unsentMessageMapNew.remove(muid);
                    unsentMessageMap.remove(muid);
                    unsentMessages.remove(muid);
                    sentMessages.remove(muid);


                    int index = fuguMessageList.indexOf(new Message(muid));
                    String msgTxt = fuguMessageList.get(index).getMessage();
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            isMessageInEditMode = true;
                            //etMsg.addTextChangedListener(textWatcherFalse);
                            try {
                                etMsg.setText("");
                                etMsg.setText("" + msgTxt);
                                //etMsg.addTextChangedListener(textWatcher);
                                fuguMessageList.remove(index);
                                if (fuguMessageAdapter != null) {
                                    fuguMessageAdapter.updateList(fuguMessageList);
                                    fuguMessageAdapter.notifyItemRemoved(index);
                                }
                            } catch (Exception e) {

                            }
                            isMessageInEditMode = false;
                        }
                    });

                    lastMuid = muid;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onReceivedMessage(String msg, String channel) {
        Log.e(TAG, "***************************************" + msg);
        if (TextUtils.isEmpty(msg))
            return;
        if (channel.replace("/", "").equalsIgnoreCase(String.valueOf(conversation.getChannelId()))) {
            setRecieverMsg(msg);

            boolean isSelf = false;

            try {
                final JSONObject messageJson = new JSONObject(msg);

                if (messageJson.has("error")) {
                    return;
                }

                if (messageJson.has("user_id") && !messageJson.optString("user_id").equals(String.valueOf(String.valueOf(HippoApplication.getInstance().getUserData().getUserId())))
                        && messageJson.has("on_subscribe")) {
                    onSubscribe = messageJson.getInt("on_subscribe");
                    //Log.e("onReceivedMessage onSubscribe", "==" + onSubscribe);
                }

                try {
                    if (messageJson.optInt("message_type", 0) == 14) {
                        if (messageJson.has("message_status") && messageJson.has("message_index")
                                && messageJson.getInt("message_status") == MESSAGE_UNSENT) {

                            updateUnsendData(messageJson);
                            return;
                        } else {
                            for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                                if (fuguMessageList.get(i).getType() == FUGU_RATING_VIEW) {
                                    Message currentMessage = fuguMessageList.get(i);
                                    Log.e("MUID", currentMessage.getMuid() + " = " + messageJson.getString("muid"));
                                    if (!TextUtils.isEmpty(currentMessage.getMuid()) && currentMessage.getMuid().equals(messageJson.getString("muid"))) {
                                        currentMessage.setRatingGiven(messageJson.getInt("rating_given"));
                                        currentMessage.setComment(messageJson.getString("comment"));
                                        currentMessage.setIsRatingGiven(messageJson.getInt("is_rating_given"));
                                        currentMessage.setTotalRating(messageJson.getInt("total_rating"));
                                        updateFeedback(i, false);

                                        try {
                                            new Handler().postDelayed(new Runnable() {
                                                @Override
                                                public void run() {
                                                    getDealInfo();
                                                }
                                            }, API_DELAY_TIME);
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }

                                        return;
                                    }
                                }
                            }
                        }

                    } else if (messageJson.optInt(MESSAGE_TYPE, 0) == USER_CONCENT_MESSAGE
                            && messageJson.optInt("message_status") != MESSAGE_UNSENT) {
                        for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                            if (fuguMessageList.get(i).getType() == HIPPO_USER_CONCENT_VIEW) {
                                Message currentMessage = fuguMessageList.get(i);
                                if (!TextUtils.isEmpty(currentMessage.getMuid()) && currentMessage.getMuid().equals(messageJson.getString("muid"))) {
                                    currentMessage.setIsActive(messageJson.optInt("is_active"));
                                    currentMessage.setRepliedBy(messageJson.optString("replied_by"));
                                    currentMessage.setRepliedUserImage(messageJson.optString("replied_user_image"));
                                    currentMessage.setSelectedBtnId(messageJson.optString("selected_btn_id"));
                                    updateFeedback(i, false);
                                    Log.e(TAG, "updaed ***************************************");
                                    return;
                                }
                            }
                        }
                    } else if (messageJson.optInt(MESSAGE_TYPE) == AGENT_CARD_VIEW) {
                        if (messageJson.has("custom_action") && !TextUtils.isEmpty(messageJson.optJSONObject("custom_action").optString("selected_id", ""))) {
                            for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                                if (fuguMessageList.get(i).getType() == HIPPO_PAYMENT_VIEW) {
                                    Message currentMessage = fuguMessageList.get(i);
                                    if (!TextUtils.isEmpty(currentMessage.getMuid()) && currentMessage.getMuid().equals(messageJson.optString("muid"))) {
                                        String selectedId = messageJson.optJSONObject("custom_action").optString("selected_id", "");
                                        currentMessage.getCustomAction().setSelectedId(selectedId);
                                        sentMessages.put(messageJson.optString("muid", ""), currentMessage);
                                        fuguMessageList.get(i).getCustomAction().setSelectedId(selectedId);
                                        updateFeedback(i, false);
                                        return;
                                    } else {
                                        return;
                                    }
                                }
                            }
                        }
                    } else if (messageJson.optInt(MESSAGE_TYPE) == MULTI_SELECTION) {
                        if (messageJson.has("custom_action") && messageJson.optJSONObject("custom_action").optInt("is_replied", 0) == 1) {
                            for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                                if (fuguMessageList.get(i).getOriginalMessageType() == MULTI_SELECTION) {
                                    Message currentMessage = fuguMessageList.get(i);
                                    if (!TextUtils.isEmpty(currentMessage.getMuid()) && currentMessage.getMuid().equals(messageJson.optString("muid"))) {
                                        int isReplyed = messageJson.optJSONObject("custom_action").optInt("is_replied", 0);
                                        currentMessage.getCustomAction().setIsReplied(isReplyed);
                                        sentMessages.put(messageJson.optString("muid", ""), currentMessage);
                                        fuguMessageList.get(i).getCustomAction().setIsReplied(isReplyed);
                                        updateFeedback(i, false);
                                        return;
                                    } else {
                                        return;
                                    }
                                }
                            }
                        }
                    }
                } catch (Exception e) {
                    //e.printStackTrace();
                }

                if (messageJson.optInt("message_type", 0) == 14 && messageJson.getInt("is_rating_given") == 1) {
                    return;
                }

                try {
                    int userType = messageJson.optInt("user_type");
                    if (isO2oChat) {
//                        if (messageJson.optInt("user_id") == HippoApplication.getInstance().getUserData().getUserId()) {
                        isSelf = isSelf(ownerId, HippoApplication.getInstance().getUserData().getUserId().intValue(), messageJson.optInt("user_id"));
//                        }
                    } else {
                        if (userType == UserType.AGENT.getOrdinal() || userType == UserType.SYSTEM.getOrdinal()) {
                            isSelf = true;
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (messageJson.optInt(NOTIFICATION_TYPE, 0) == READ_MESSAGE) {
                    // Read functionality
                    hasRead = false;
                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        if (fuguMessageList.get(i).getType() == ListItem.ITEM_TYPE_SELF && messageJson.optInt(USER_TYPE) == 1) {
                            if (fuguMessageList.get(i).getMessageStatus() != MESSAGE_UNSENT) {
                                fuguMessageList.get(i).setMessageStatus(MESSAGE_READ);
                                hasRead = true;
                            }
                        }
                    }
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                rvMessages.getRecycledViewPool().clear();
                                if (fuguMessageAdapter != null && hasRead) {
                                    fuguMessageAdapter.notifyDataSetChanged();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                } else if (messageJson.optInt(NOTIFICATION_TYPE, 0) == BOT_FORM_MESSAGE) {
                    int disableReply = messageJson.optInt("disable_reply", -1);
                    int botRunning = messageJson.optInt("is_bot_in_progress", 0);
                    if (conversation != null) {
                        conversation.setDisableReply(disableReply);
                        conversation.setBotEnabled(botRunning);
                    }
                    try {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                if (disableReply == 1) {
                                    cvTypeMessage.setVisibility(View.GONE);
                                } else if (disableReply == 0) {
                                    cvTypeMessage.setVisibility(View.VISIBLE);
                                }
                                hasBotRunning = false;
                                botChatAssign.setVisibility(View.GONE);
                                if (disableReply == 1 && botRunning == 1) {
                                    hasBotRunning = true;
                                    botChatAssign.setVisibility(View.VISIBLE);
                                }
                            }
                        });
                    } catch (Exception e) {

                    }

                    return;
                } else if (messageJson.optInt(NOTIFICATION_TYPE, 0) == 13) {
                    if (hasBotRunning) {
                        updateUI(messageJson);
                    }
                } else if (messageJson.optInt(NOTIFICATION_TYPE, 0) == 24) {
                    updateEdittedMessage(messageJson);
                    return;
                } else {
                    if (messageJson.optInt("is_typing") == 0 &&
                            (messageJson.has("message") && !messageJson.getString("message").isEmpty()
                                    || (messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty()) ||
                                    (messageJson.has("url") && !messageJson.getString("url").isEmpty()) || messageJson.has(CUSTOM_ACTION))
                            && (messageJson.getInt("message_type") == TEXT_MESSAGE
                            || messageJson.getInt("message_type") == PRIVATE_NOTE
                            || messageJson.getInt("message_type") == IMAGE_MESSAGE
                            || messageJson.getInt(MESSAGE_TYPE) == FILE_MESSAGE
                            || messageJson.getInt(MESSAGE_TYPE) == ACTION_MESSAGE_NEW
                            || messageJson.getInt(MESSAGE_TYPE) == USER_CONCENT_MESSAGE
                            || messageJson.getInt(MESSAGE_TYPE) == AGENT_CARD_VIEW
                            || messageJson.getInt(MESSAGE_TYPE) == MULTI_SELECTION
                            || messageJson.getInt("message_type") == FEEDBACK_MESSAGE)) {


                        if (isSelf && messageJson.has("message_status") && messageJson.has("message_index")
                                && messageJson.getInt("message_status") == MESSAGE_UNSENT) {
                            Log.e(TAG, "sent ***************************************");
                            messageIndex = messageJson.getInt("message_index");
                            try {
                                if (fuguMessageList.get(messageJson.getInt("message_index")).getType() == ListItem.TYPE_HEADER
                                        && (messageJson.getInt("message_index") + 1 < fuguMessageList.size())) {
                                    fuguMessageList.get(messageJson.getInt("message_index") + 1)
                                            .setMessageStatus(MESSAGE_SENT);
                                    messageIndex = messageIndex + 1;
                                } else if (messageJson.getInt("message_index") < fuguMessageList.size()) {
                                    fuguMessageList.get(messageJson.getInt("message_index"))
                                            .setMessageStatus(MESSAGE_SENT);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }


                            Message listItem = unsentMessages.get(messageJson.getString("muid"));
                            if (listItem == null)
                                return;
                            listItem.setMessageStatus(MESSAGE_SENT);

                            if (messageJson.has("thumbnail_url")) {
                                listItem.setThumbnailUrl(messageJson.optString("thumbnail_url"));
                                listItem.setUrl(messageJson.optString("image_url"));
                                listItem.setFileUrl(messageJson.optString("image_url"));
                                if (messageJson.has("url"))
                                    listItem.setFileUrl(messageJson.optString("url"));
                            }

                            List<String> reverseOrderedKeys = new ArrayList<>(sentMessages.keySet());
                            Collections.reverse(reverseOrderedKeys);
                            String tempSentAtUTC = "";
                            for (String key : reverseOrderedKeys) {
                                if (sentMessages.get(key).isDateView()) {
                                    tempSentAtUTC = key;
                                    break;
                                }
                            }
                            String time = listItem.getSentAtUtc();
                            String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                            if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                                sentMessages.put(localDate, new Message(localDate, true));
                            }

                            sentMessages.put(messageJson.getString("muid"), listItem);
                            unsentMessageMapNew.remove(messageJson.getString("muid"));
                            unsentMessages.remove(messageJson.getString("muid"));

                            Log.e(TAG, "Remainning keys: " + unsentMessageMapNew.keySet());

                            if (unsentMessageMapNew.size() == 0 && isNetworkStateChanged) {
                                pageStart = 1;
                                getMessages();
                                isNetworkStateChanged = false;
                            }

                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        fuguMessageAdapter.notifyItemChanged(messageIndex);
                                    } catch (Exception e) {
                                        fuguMessageAdapter.notifyDataSetChanged();
                                        e.printStackTrace();
                                    }
                                }
                            });

                            messageSending = false;
                            sendMessages();
                        } else {
                            String localDate = dateUtils.convertToLocal(messageJson.getString("date_time"), inputFormat, outputFormat);
                            //String date = dateUtils.getDate(localDate);

                            if (!sentAtUTC.equalsIgnoreCase(localDate)) {
                                sentMessages.put(localDate, new Message(localDate, true));
                                fuguMessageList.add(new Message(localDate, true));
                                sentAtUTC = localDate;
                                dateItemCount = dateItemCount + 1;
                            }
                            boolean isAttachment = false;
                            if (messageJson.has("document_type")) {
                                if (messageJson.has("url") && !messageJson.getString("url").isEmpty())
                                    isAttachment = true;
                                if (messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty())
                                    isAttachment = true;

                            }

                            if (isAttachment) {
                                if (messageJson.getString("document_type").equalsIgnoreCase("image")) {
                                    messageJson.put(MESSAGE_TYPE, IMAGE_MESSAGE);
                                } else {
                                    messageJson.put(MESSAGE_TYPE, FILE_MESSAGE);
                                }
                            }


                            String url = "";
                            if (messageJson.getInt(MESSAGE_TYPE) == IMAGE_MESSAGE) {
                                url = messageJson.optString("image_url", "");
                            } else if (messageJson.getInt(MESSAGE_TYPE) == FILE_MESSAGE) {
                                url = messageJson.optString("url", "");
                            }

                            Message message = new Message(messageJson.getString("full_name"),
                                    Integer.parseInt(messageJson.getString("user_id")),
                                    messageJson.getString("message"),
                                    messageJson.getString("date_time"),
                                    isSelf,
                                    onSubscribe == 1 ? MESSAGE_READ : MESSAGE_SENT,
                                    fuguMessageList.size(),
                                    messageJson.has("image_url") ? messageJson.getString("image_url") : "",
                                    messageJson.has("thumbnail_url") ? messageJson.getString("thumbnail_url") : "",
                                    messageJson.getInt("message_type"),
                                    messageJson.has("user_type") ? messageJson.getInt("user_type") : UserType.AGENT.getOrdinal());

                            message.setUserImage(messageJson.optString("user_image"));
                            message.setOriginalMessageType(messageJson.optInt("message_type"));
                            message.setMessageSubType(messageJson.optInt("message_sub_type"));

                            message.setMuid(messageJson.optString("muid", UUID.randomUUID().toString()));
                            if (messageJson.has("integration_source"))
                                message.setIntegrationSource(messageJson.optInt("integration_source", 0));
                            if (messageJson.has(CUSTOM_ACTION)) {
                                message.setCustomAction(new Gson().fromJson(messageJson.getJSONObject(CUSTOM_ACTION).toString(), CustomAction.class));
                            }

                            message.setMultiLangMessage(messageJson.optString("multi_lang_message", ""));

                            if (messageJson.has("consent_action_url")) {
                                url = messageJson.optString("consent_action_url", "");
                            }

                            if (messageJson.getInt("message_type") == FEEDBACK_MESSAGE) {
                                message.setRatingGiven(messageJson.getInt("rating_given"));
                                message.setComment(messageJson.getString("comment"));
                                message.setIsRatingGiven(messageJson.getInt("is_rating_given"));
                                message.setTotalRating(messageJson.getInt("total_rating"));

                                message.setLineBeforeFeedback(CommonData.getLineFeedback("lineBeforeFeedback"));
                                message.setLineAfterFeedback_1(CommonData.getLineFeedback("lineAfterFeedback_1"));
                                message.setLineAfterFeedback_2(CommonData.getLineFeedback("lineAfterFeedback_2"));

                            } else if (messageJson.getInt("message_type") == FILE_MESSAGE) {
                                message.setFileName(messageJson.optString("file_name"));
                                message.setFileSize(messageJson.optString("file_size"));
                                message.setUrl(messageJson.optString("image_url"));
                                message.setFileUrl(messageJson.optString("url"));
                                message.setThumbnailUrl(messageJson.optString("thumbnail_url"));
                                message.setDocumentType(messageJson.optString("document_type"));
                                String fileExt = Utils.getExtension(messageJson.optString("url"));
                                if (!TextUtils.isEmpty(fileExt))
                                    message.setFileExtension(fileExt);
                            } else if (messageJson.getInt(MESSAGE_TYPE) == USER_CONCENT_MESSAGE) {
                                List<ContentValue> contentValue = new ArrayList<>();
                                JSONArray contentvaluesArray = messageJson.getJSONArray("content_value");
                                if (contentvaluesArray != null) {
                                    for (int a = 0; a < contentvaluesArray.length(); a++) {
                                        JSONObject object = contentvaluesArray.getJSONObject(a);
                                        ContentValue contentValue1 = new ContentValue();
                                        contentValue1.setBtnId(object.optString("btn_id"));
                                        contentValue1.setBtnColor(object.optString("btn_color"));
                                        contentValue1.setBtnTitle(object.optString("btn_title"));
                                        contentValue1.setBtnSelectedColor(object.optString("btn_selected_color"));
                                        contentValue1.setBtnTitleColor(object.optString("btn_title_color"));
                                        contentValue1.setBtnTitleSelectedColor(object.optString("btn_title_selected_color"));
                                        contentValue.add(contentValue1);
                                    }
                                }

                                message.setIsActive(messageJson.optInt("is_active"));
                                message.setSelectedBtnId(messageJson.optString("selected_btn_id"));
                                //message.setMessageType(USER_CONCENT_MESSAGE_LOCAL);
                                message.setRepliedBy(messageJson.optString("replied_by"));
                                message.setRepliedUserImage(messageJson.optString("replied_user_image"));
                                message.setContentValue(contentValue);
                            } else if (message.getMessageType() == AGENT_CARD_VIEW) {

                                if (!messageJson.has(CUSTOM_ACTION) || cardMuid.equalsIgnoreCase(messageJson.optString("muid", ""))) {
                                    cardMuid = "";
                                    return;
                                }
                                cardMuid = message.getMuid();
                            } else if (message.getMessageType() == PRIVATE_NOTE
                                    && messageJson.has("document_type")
                                    && !messageJson.optString("document_type").isEmpty()) {
                                message.setFileName(messageJson.optString("file_name"));
                                message.setFileSize(messageJson.optString("file_size"));
                                message.setUrl(messageJson.optString("image_url"));
                                message.setFileUrl(messageJson.optString("url"));
                                message.setThumbnailUrl(messageJson.optString("thumbnail_url"));
                                message.setDocumentType(messageJson.optString("document_type"));
                                String fileExt = Utils.getExtension(messageJson.optString("url"));
                                if (!TextUtils.isEmpty(fileExt))
                                    message.setFileExtension(fileExt);
                            }


                            int listMessageType = getType(messageJson.optInt("message_type"), isSelf, messageJson.optString("document_type"));
                            message.setMessageType(listMessageType);

                            message = addAboveUserId(message);

                            Log.v(TAG, "***********muid : " + messageJson.optString("muid", "@@"));
                            if (!sentMessages.containsKey(messageJson.optString("muid", ""))) {
                                Log.v(TAG, "***********************");
                                sentMessages.put(messageJson.optString("muid", ""), message);
                                fuguMessageList.add(message);
                            }

                            if (!isSelf && messageJson.getInt("message_type") != FEEDBACK_MESSAGE) {
                                sendReadAcknowledgement();
                            }


                            try {
                                if (messageJson.has("consent_action_url"))
                                    openUrl(messageJson.optString("consent_action_url", ""), conversation.getChannelId());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                    }
                }

                if (!messageJson.optString("user_id").equals(String.valueOf(String.valueOf(HippoApplication.getInstance().getUserData().getUserId()))) &&
                        onSubscribe == 1 && messageJson.optString("message").isEmpty() && messageJson.has("on_subscribe") && messageJson.optInt(USER_TYPE) == 1) {

                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        if (fuguMessageList.get(i).getType() == ListItem.ITEM_TYPE_SELF && messageJson.optInt(USER_TYPE) == 1 &&
                                fuguMessageList.get(i).getMessageStatus() == MESSAGE_SENT) {
                            fuguMessageList.get(i).setMessageStatus(MESSAGE_READ);
                        }
                    }

                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                rvMessages.getRecycledViewPool().clear();
                                fuguMessageAdapter.notifyDataSetChanged();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }

                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            if (messageJson.optInt("message_type") == TEXT_MESSAGE
                                    || messageJson.optInt("message_type") == PRIVATE_NOTE
                                    || messageJson.optInt("message_type") == IMAGE_MESSAGE
                                    || messageJson.optInt(MESSAGE_TYPE) == FILE_MESSAGE
                                    || messageJson.optInt("message_type") == FEEDBACK_MESSAGE
                                    || messageJson.optInt(MESSAGE_TYPE) == USER_CONCENT_MESSAGE
                                    || messageJson.optInt(MESSAGE_TYPE) == AGENT_CARD_VIEW
                                    || messageJson.optInt(MESSAGE_TYPE) == MULTI_SELECTION
                                    || messageJson.optInt(MESSAGE_TYPE) == ACTION_MESSAGE_NEW) {
                                if ((messageJson.has(IS_TYPING) && messageJson.getInt(IS_TYPING) == 0) &&
                                        (!messageJson.getString("message").isEmpty() ||
                                                (messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty()) ||
                                                (messageJson.has("url") && !messageJson.getString("url").isEmpty()) ||
                                                messageJson.optInt(MESSAGE_TYPE) == USER_CONCENT_MESSAGE ||
                                                messageJson.optInt(MESSAGE_TYPE) == AGENT_CARD_VIEW ||
                                                messageJson.optInt(MESSAGE_TYPE) == MULTI_SELECTION ||
                                                messageJson.has(CUSTOM_ACTION))) {
                                    updateRecycler(Integer.parseInt(messageJson.getString("user_id")));

                                } else if ((messageJson.getInt("is_typing") == 1) &&
                                        !messageJson.getString("user_id").equals(String.valueOf(HippoApplication.getInstance().getUserData().getUserId()))) {
                                    if (layoutManager != null) {
                                        if (layoutManager.findLastVisibleItemPosition() >= fuguMessageList.size() - 2) {
                                            startAnim();
                                        }
                                    }
                                } else {
                                    stopAnim();
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });


            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

    }

    public void onPongReceived() {
        checkUnsentMessageStatus(new RefreshDone() {
            @Override
            public void onRefreshComplete() {
                sendMessages();
            }
        });

        try {
            if (retryLayout.getVisibility() == View.VISIBLE) {
                setConnectionMessage(0);
            }
        } catch (Exception e) {

        }
    }

    private void updateUnsendData(JSONObject messageJson) throws Exception {
        messageIndex = messageJson.getInt("message_index");
        try {
            if (fuguMessageList.get(messageJson.getInt("message_index")).getType() == ListItem.TYPE_HEADER
                    && (messageJson.getInt("message_index") + 1 < fuguMessageList.size())) {
                fuguMessageList.get(messageJson.getInt("message_index") + 1)
                        .setMessageStatus(MESSAGE_SENT);
                messageIndex = messageIndex + 1;
            } else if (messageJson.getInt("message_index") < fuguMessageList.size()) {
                fuguMessageList.get(messageJson.getInt("message_index"))
                        .setMessageStatus(MESSAGE_SENT);
            }
        } catch (Exception e) {
            //e.printStackTrace();
            try {
                for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                    if (fuguMessageList.get(i).getType() == FUGU_RATING_VIEW) {
                        Message currentMessage = fuguMessageList.get(i);
                        if (currentMessage.getMuid().equals(messageJson.getString("muid"))) {
                            messageIndex = i;
                            fuguMessageList.get(messageIndex).setMessageStatus(MESSAGE_SENT);
                        }
                    }
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        Message listItem = unsentMessages.get(messageJson.getString("muid"));
        if (listItem == null)
            return;
        listItem.setMessageStatus(MESSAGE_SENT);

        List<String> reverseOrderedKeys = new ArrayList<>(sentMessages.keySet());
        Collections.reverse(reverseOrderedKeys);
        String tempSentAtUTC = "";
        for (String key : reverseOrderedKeys) {
            if (sentMessages.get(key).isDateView()) {
                tempSentAtUTC = key;
                break;
            }
        }
        String time = listItem.getSentAtUtc();
        String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
        if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
            sentMessages.put(localDate, new Message(localDate, true));
        }

        sentMessages.put(messageJson.getString("muid"), listItem);
        unsentMessageMapNew.remove(messageJson.getString("muid"));
        unsentMessages.remove(messageJson.getString("muid"));

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    fuguMessageAdapter.notifyItemChanged(messageIndex);
                } catch (Exception e) {
                    fuguMessageAdapter.notifyDataSetChanged();
                    e.printStackTrace();
                }
            }
        });

        messageSending = false;
        sendMessages();
    }

    private void updateUI(final JSONObject messageJson) {
        try {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        hasBotRunning = false;
                        cvTypeMessage.setVisibility(View.VISIBLE);
                        botChatAssign.setVisibility(View.GONE);
                        GetAgentsResponse.Agents agent = null;
                        List<OtherUser> otherUsers = new ArrayList<>();
                        try {
                            JSONArray array = messageJson.optJSONArray("all_users");
                            for (int i = 0; i < array.length(); i++) {
                                JSONObject object = array.getJSONObject(i);
                                if (conversation.getUserId().compareTo(object.optInt("user_id")) == 0) {
                                    OtherUser user = new OtherUser();
                                    user.setFullName(object.optString("full_name"));
                                    user.setUserId(object.optInt("user_id"));
                                    user.setUserImage(object.optString("user_image", ""));
                                    otherUsers.add(user);
                                } else if (HippoApplication.getInstance().getUserData().getUserId().compareTo(object.optInt("user_id")) == 0) {
                                    agent = new GetAgentsResponse.Agents();
                                    agent.setUserImage(object.optString("user_image", ""));
                                    agent.setFullName(object.optString("full_name"));
                                    agent.setUserId(object.optInt("user_id"));
                                }
                            }
                            if (agent != null) {
                                boolean isFlag = true;
                                for (GetAgentsResponse.Agents agent1 : HippoApplication.getInstance().getAgentsResponse().getData().getAgents()) {
                                    if (agent1.getUserId() == agent.getUserId()) {
                                        agent1.setFullName(agent.getFullName());
                                        agent1.setUserImage(agent.getUserImage());
                                        isFlag = false;
                                        break;
                                    }
                                }

                                if (isFlag) {
                                    HippoApplication.getInstance().getAgentsResponse().getData().getAgents().add(agent);
                                }
                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }


                        if (otherUsers.size() > 0) {
                            String agentName = otherUsers.get(0).getFullName();
                            Integer userId = otherUsers.get(0).getUserId();

                            conversation.setUserId(userId);
                            conversation.setAgentName(agentName);
                            conversation.setAgentId(userId);
                            conversation.setDisableReply(0);

                            try {
                                if (HippoApplication.getInstance().getUserData().isVideoCallEnabled()
                                        && messageJson.optInt("allow_audio_call") == 1) {
                                    if (isO2oChat && (conversation.getUserId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue()
                                            || conversation.getAgentId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue())) {
                                        ivVideoView.setVisibility(View.VISIBLE);
                                    }
                                } else {
                                    ivVideoView.setVisibility(View.GONE);
                                }

                                if (HippoApplication.getInstance().getUserData().isAudioCallEnabled() && messageJson.optInt("allow_video_call") == 1) {
                                    if (isO2oChat && conversation.getAgentId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue()) {
                                        ivAudioView.setVisibility(View.VISIBLE);
                                    }
                                } else {
                                    ivAudioView.setVisibility(View.GONE);
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setRecieverMsg(String msg) {
        boolean isSelf = false;
        try {
            JSONObject messageJson = new JSONObject(msg);

            if (messageJson.has("user_id") && !messageJson.optString("user_id").equals(String.valueOf(HippoApplication.getInstance().getUserData().getUserId())) && messageJson.has("on_subscribe")) {
                onSubscribe = messageJson.getInt("on_subscribe");
            }

            try {
                if (messageJson.optInt("message_type", 0) == 14) {
                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        if (fuguMessageList.get(i).getType() == FUGU_RATING_VIEW) {
                            Message currentMessage = fuguMessageList.get(i);
                            Log.e("MUID", currentMessage.getMuid() + " = " + messageJson.getString("muid"));
                            if (!TextUtils.isEmpty(currentMessage.getMuid()) && currentMessage.getMuid().equals(messageJson.getString("muid"))) {
                                currentMessage.setRatingGiven(messageJson.getInt("rating_given"));
                                currentMessage.setComment(messageJson.getString("comment"));
                                currentMessage.setIsRatingGiven(messageJson.getInt("is_rating_given"));
                                currentMessage.setTotalRating(messageJson.getInt("total_rating"));

//                                currentMessage.setLineAfterFeedback_1(messageJson.optString("line_after_feedback_1"));
//                                currentMessage.setLineAfterFeedback_2(messageJson.optString("line_after_feedback_2"));

                                sentMessages.put(messageJson.getString("muid"), currentMessage);
                                unsentMessageMapNew.remove(messageJson.getString("muid"));
                                unsentMessages.remove(messageJson.getString("muid"));

                                updateFeedback(i, false);

                                try {
                                    new Handler().postDelayed(new Runnable() {
                                        @Override
                                        public void run() {
                                            getDealInfo();
                                        }
                                    }, API_DELAY_TIME);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                                return;
                            }
                        }
                    }
                }
            } catch (Exception e) {
                //e.printStackTrace();
            }

            if (messageJson.optInt("message_type", 0) == 14 && messageJson.getInt("is_rating_given") == 1) {
                return;
            }

        } catch (JSONException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JSONObject prepareMessageJson(int onSubscribe) {
        JSONObject messageJson = new JSONObject();

        try {
            messageJson.put("user_id", String.valueOf(HippoApplication.getInstance().getUserData().getUserId()));
            messageJson.put("full_name", String.valueOf(HippoApplication.getInstance().getUserData().getFullName()));
            messageJson.put("is_typing", isTyping);
            messageJson.put("message", "");
            messageJson.put("message_type", TEXT_MESSAGE);
            messageJson.put(USER_TYPE, String.valueOf(UserType.AGENT.getOrdinal()));
            messageJson.put("on_subscribe", onSubscribe);
            messageJson.put("channel_id", conversation.getChannelId());

            String localDate = DateUtils.getInstance().getFormattedDate(
                    new Date());
            messageJson.put("date_time", DateUtils.getInstance().convertToUTC(localDate));


        } catch (JSONException e) {
            e.printStackTrace();
        }

        return messageJson;
    }


    private void addMessageToList(String message, int messageType, String imageUrl, String thumbnailUrl,
                                  String localPath, FileuploadModel fileDetails, String muid, int index, Bot bot, int messageSubType) {

        try {
            String localDate = DateUtils.getInstance().getFormattedDate(new Date());
            String localDate1 = DateUtils.getInstance().getFormattedDate(new Date(), outputFormat);

            if (!sentAtUTC.equalsIgnoreCase(localDate1)) {
                fuguMessageList.add(new Message(localDate1, true));
                sentAtUTC = localDate1;
                dateItemCount = dateItemCount + 1;
            }

            int updatedmessagetype = messageType;
            if (isPrivateClicked)
                updatedmessagetype = this.messageType;
            Message messageObj = new Message(HippoApplication.getInstance().getUserData().getFullName(),
                    HippoApplication.getInstance().getUserData().getUserId(),
                    message,
                    DateUtils.getInstance().convertToUTC(localDate),
                    true,
                    MESSAGE_UNSENT,
                    fuguMessageList.size(),
                    imageUrl.isEmpty() ? localPath : imageUrl,
                    thumbnailUrl.isEmpty() ? localPath : thumbnailUrl,
                    updatedmessagetype,
                    UserType.AGENT.getOrdinal());

            messageObj.setUserImage(getUserImage());
            messageObj.setOriginalMessageType(updatedmessagetype);
            messageObj.setMuid(muid);
            messageObj.setIsMessageExpired(0);
            messageObj.setLocalImagePath(localPath);
            messageObj.setIntegrationSource(0);
            messageObj.setMessageSubType(messageSubType);

            if (fileDetails != null) {
                messageObj.setFileName(fileDetails.getFileName());
                messageObj.setFileSize(fileDetails.getFileSizeReadable());
                messageObj.setFileExtension(fileDetails.getFileMime());
                messageObj.setFilePath(fileDetails.getFilePath());
                messageObj.setFileUrl(fileDetails.getFilePath());
                messageObj.setDocumentType(fileDetails.getDocumentType());
                messageObj.setUploadStatus(UPLOAD_IN_PROGRESS);
                if (fileDetails.getDimns() != null && fileDetails.getDimns().size() > 1) {
                    messageObj.setImageHeight(fileDetails.getDimns().get(0));
                    messageObj.setImageWidth(fileDetails.getDimns().get(1));
                }
            }
            if (bot != null) {
                if (messageType == FEEDBACK_MESSAGE) {
                    messageObj.setMultiLangMessage("{{{RATING_AND_REVIEW}}}");
                    messageObj.setComment("");
                    messageObj.setRatingGiven(0);
                    messageObj.setIsRatingGiven(0);
                    messageObj.setTotalRating(5);
                    messageObj.setLineBeforeFeedback(CommonData.getLineFeedback("lineBeforeFeedback"));
                    messageObj.setLineAfterFeedback_1(CommonData.getLineFeedback("lineBeforeFeedback_1"));
                    messageObj.setLineAfterFeedback_2(CommonData.getLineFeedback("lineAfterFeedback_2"));
                } else if (messageType == BOT_FORM_MESSAGE) {
                    messageObj.setContentValue(bot.getContentValue());
                    messageObj.setValues((ArrayList<String>) bot.getValues());
                } else if (messageType == USER_CONCENT_MESSAGE) {
                    messageObj.setContentValue(bot.getContentValue());
                    messageObj.setIsActive(bot.getIsActive());
                    messageObj.setSelectedBtnId(bot.getSelectedBtnId());
                }
            }

            String docType = "";
            if (fileDetails != null)
                docType = fileDetails.getDocumentType();
            boolean isSelf = true;
            if (isO2oChat) {
                isSelf = isSelf(ownerId, HippoApplication.getInstance().getUserData().getUserId().intValue(), messageObj.getUserId().intValue());
            }
            int listMessageType = getType(messageType, isSelf, docType);
            messageObj.setMessageType(listMessageType);
            if (isPrivateClicked)
                messageObj.setMessageType(listMessageType);


            if (mentions != null && mentions.getInsertedMentions() != null && mentions.getInsertedMentions().size() != 0) {

                taggedUsers = new ArrayList<>();

                for (Mentionable mention : mentions.getInsertedMentions()) {
                    if (!taggedUsers.contains((int) mention.getUserId())) {
                        taggedUsers.add((int) mention.getUserId());
                    }
                }
                messageObj.setTaggedUsers(taggedUsers);
            }

            // TODO: 2020-01-01 for above and below logic 
            if (fuguMessageList.size() > 0) {
                String preMuid = fuguMessageList.get(fuguMessageList.size() - 1).getMuid();
                messageObj.setAboveUserId(fuguMessageList.get(fuguMessageList.size() - 1).getUserId());
                messageObj.setAboveMuid(preMuid);

                int preIndex = fuguMessageList.size() - 1;
                fuguMessageList.get(preIndex).setBelowMuid(muid);
                fuguMessageList.get(preIndex).setBelowUserId(userId);

                if (sentMessages.containsKey(preMuid)) {
                    sentMessages.put(preMuid, fuguMessageList.get(preIndex));
                } else if (unsentMessages.containsKey(preMuid)) {
                    unsentMessages.put(preMuid, fuguMessageList.get(preIndex));
                }

            }

            fuguMessageList.add(messageObj);
            unsentMessages.put(muid, messageObj);
            if (fileDetails == null)
                etMsg.setText("");
            updateRecycler(HippoApplication.getInstance().getUserData().getUserId());

            scrollListToBottom();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMessage(String message, int messageType, String imageUrl, String thumbnailUrl,
                             Bot bot, boolean isPrivateNotes, ArrayList<Integer> ids, String localPath, FileuploadModel fileuploadModel) {
        sendMessage(message, messageType, imageUrl, thumbnailUrl, bot, isPrivateNotes, ids, localPath, null, -1, fileuploadModel, 0);
    }

    private void sendMessage(String message, int messageType, String imageUrl, String thumbnailUrl,
                             Bot bot, boolean isPrivateNotes, ArrayList<Integer> ids, String localPath, FileuploadModel fileuploadModel, int messageSubType) {
        sendMessage(message, messageType, imageUrl, thumbnailUrl, bot, isPrivateNotes, ids, localPath, null, -1, fileuploadModel, messageSubType);
    }

    private void sendMessage(String message, int messageType, String url, String thumbnailUrl,
                             Bot bot, boolean isPrivateNotes, ArrayList<Integer> ids, String localPath, String localMuid, int localIndex, FileuploadModel fileuploadModel, int messageSubType) {

//        if (isO2oChat) {
//            String doctype = "";
//            if (fileuploadModel != null)
//                fileuploadModel.getDocumentType();
//
//            messageType = getType(messageType, isSelf(ownerId, HippoApplication.getInstance().getUserData().getUserId()), doctype);
//        }
        String initialMessage = message.trim();
        String removsinglequote = initialMessage;
        if (HippoApplication.getInstance().getUserData().getBusinessProperty().isEncodeToHtml()) {
            String removeLt = initialMessage.replaceAll("<", "&lt;");
            String removeGt = removeLt.replaceAll(">", "&gt;");
            String removeQuotes = removeGt.replaceAll("\"", "&quot;");
            removsinglequote = removeQuotes.replaceAll("'", "&#39;");
        }

        String localDate = DateUtils.getInstance().getFormattedDate(new Date());
        int index = fuguMessageList.size();
        if (localIndex > 0)
            index = localIndex;
        String muid;
        if (TextUtils.isEmpty(localMuid)) {
            muid = UUID.randomUUID().toString() + "." + new Date().getTime();
            if (fileuploadModel != null && !TextUtils.isEmpty(fileuploadModel.getMuid())) {
                muid = fileuploadModel.getMuid();
            }
            addMessageToList(removsinglequote, messageType, url, thumbnailUrl, localPath, fileuploadModel, muid, index, bot, messageSubType);
        } else {
            muid = localMuid;
        }
        try {
            JSONObject messageJson = new JSONObject();
            if (HippoApplication.getInstance().getUserData().getFullName() != null) {
                messageJson.put("full_name", HippoApplication.getInstance().getUserData().getFullName());
            }
            messageJson.put("muid", muid);
            messageJson.put("is_message_expired", 0);
            messageJson.put("message", removsinglequote);
            messageJson.put("message_type", messageType);
            originalMessageType = messageType;
            if (isPrivateClicked)
                messageJson.put("message_type", this.messageType);
            messageJson.put(USER_TYPE, UserType.AGENT.getOrdinal());
            messageJson.put(USER_IMAGE, getUserImage());
            if (messageSubType > 0)
                messageJson.put(MESSAGE_SUB_TYPE, messageSubType);
            messageJson.put("date_time", DateUtils.getInstance().convertToUTC(localDate));
            messageJson.put("message_index", index);
            if (isPrivateNotes) {
                messageJson.put("tagged_users", ids);
            }

            if (messageType == IMAGE_MESSAGE) {
                if (!url.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                    messageJson.put(IMAGE_URL, url);
                    messageJson.put(THUMBNAIL_URL, thumbnailUrl);
                } else if (!TextUtils.isEmpty(localPath)) {
                    messageJson.put("local_url", localPath);
                }
                if (fileuploadModel != null && fileuploadModel.getDimns() != null && fileuploadModel.getDimns().size() > 0) {
                    messageJson.put("image_height", fileuploadModel.getDimns().get(0));
                    messageJson.put("image_width", fileuploadModel.getDimns().get(1));
                } else {
                    messageJson.put("image_height", 700);
                    messageJson.put("image_width", 700);
                }
                messageJson.put("file_name", fileuploadModel.getFileName());
                messageJson.put("document_type", fileuploadModel.getDocumentType());

            } else if (messageType == FILE_MESSAGE || messageType == FILE_PDF_MESSAGE) {
                if (!url.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                    messageJson.put("url", url);
                    messageJson.put(THUMBNAIL_URL, thumbnailUrl);
                } else if (!TextUtils.isEmpty(localPath)) {
                    messageJson.put("local_url", localPath);
                }
                messageJson.put("file_name", fileuploadModel.getFileName());
                messageJson.put("file_size", fileuploadModel.getFileSizeReadable());
                messageJson.put("document_type", fileuploadModel.getDocumentType());
            }

            messageJson.put("is_typing", TYPING_SHOW_MESSAGE);
            messageJson.put("message_status", MESSAGE_UNSENT);
            messageJson.put("user_id", HippoApplication.getInstance().getUserData().getUserId());
            messageJson.put("user_type", UserType.AGENT.getOrdinal());

            if (messageType == FEEDBACK_MESSAGE) {
                messageJson.put("multi_lang_message", "{{{RATING_AND_REVIEW}}}");
                messageJson.put("rating_given", 0);
                messageJson.put("total_rating", 5);
                messageJson.put("comment", "");
                messageJson.put("is_rating_given", 0);
                messageJson.put("line_before_feedback", CommonData.getLineFeedback("lineBeforeFeedback"));
                messageJson.put("line_after_feedback_1", CommonData.getLineFeedback("lineAfterFeedback_1"));
                messageJson.put("line_after_feedback_2", CommonData.getLineFeedback("lineAfterFeedback_2"));

            } else if (messageType == BOT_FORM_MESSAGE) {
                JSONArray jsonArray = new JSONArray();

                try {
                    for (int a = 0; a < bot.getContentValue().size(); a++) {
                        JSONObject jsonObj = new JSONObject();
                        jsonObj.put("bot_id", bot.getContentValue().get(a).getBot_id());
                        jsonObj.put("data_type", new JSONArray(bot.getContentValue().get(a).getData_type()));
                        jsonObj.put("params", new JSONArray(bot.getContentValue().get(a).getParams()));
                        jsonObj.put("questions", new JSONArray(bot.getContentValue().get(a).getQuestions()));

                        jsonArray.put(jsonObj);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                //messageJson.put("bot_id", bot.getBotId());
                messageJson.put("content_value", jsonArray);
                messageJson.put("values", new JSONArray(bot.getValues()));

                Log.e(TAG, "messageJson = " + new Gson().toJson(messageJson));

            } else if (messageType == USER_CONCENT_MESSAGE) {
                JSONArray jsonArray = new JSONArray();
                try {
                    JSONArray array = new JSONArray();
                    for (int a = 0; a < bot.getContentValue().size(); a++) {
                        JSONObject item = new JSONObject();
                        item.put("btn_color", bot.getContentValue().get(a).getBtnColor());
                        item.put("btn_id", bot.getContentValue().get(a).getBtnId());
                        item.put("btn_selected_color", bot.getContentValue().get(a).getBtnSelectedColor());
                        item.put("btn_title", bot.getContentValue().get(a).getBtnTitle());
                        item.put("btn_title_color", bot.getContentValue().get(a).getBtnTitleColor());
                        item.put("btn_title_selected_color", bot.getContentValue().get(a).getBtnTitleSelectedColor());
                        array.put(item);
                    }
                    messageJson.put("content_value", array);
                } catch (Exception e) {
                    e.printStackTrace();
                }

                messageJson.put("message_type", USER_CONCENT_MESSAGE);
                messageJson.put("bot_id", bot.getBotId());
                messageJson.put("bot_name", bot.getBotName());
                messageJson.put("action_id", bot.getActionId());
                messageJson.put("is_active", bot.getIsActive());
                messageJson.put("selected_btn_id", bot.getSelectedBtnId());


                Log.e(TAG, "messageJson = " + new Gson().toJson(messageJson));
            }

            Log.e(TAG, "messageJson = " + new Gson().toJson(messageJson));

            unsentMessageMapNew.put(muid, messageJson);


            if (conversation != null && conversation.getChannelId() != null)
                CommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

            if (messageType == IMAGE_MESSAGE || messageType == FILE_MESSAGE) {
                if (!TextUtils.isEmpty(localPath)) {
                    fileuploadModel.setMuid(muid);
                    fileuploadModel.setMessageIndex(index);
                    fileuploadModel.setChannelId(currentChannelId);
                    Log.e(TAG, "messageJson = " + new Gson().toJson(messageJson));
                    fileuploadModel.setMessageObject(messageJson);
                    Log.d(TAG, "fileuploadModel = " + new Gson().toJson(fileuploadModel));
                    uploadFile(fileuploadModel);
                } else {
                    if (isNetworkAvailable()) {
                        sendMessages();
                    }
                }
            } else {
                if (!messageSendingRecursion && isNetworkAvailable()) {
                    sendMessages();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    int sendingTry = 0;
    private LinkedHashMap<String, JSONObject> unsentMessageMap = new LinkedHashMap<>();

    private synchronized void sendMessages() {
        //if (HippoApplication.getmClient() != null && HippoApplication.getmClient().isConnectedServer())
        {
            if (unsentMessageMapNew == null || unsentMessageMapNew.size() == 0)
                messageSendingRecursion = false;

            sendingTry = sendingTry + 1;
            if (sendingTry == 3) {
                messageSendingRecursion = false;
                messageSending = false;
            }

            try {
                if (unsentMessageMapNew.keySet().iterator().hasNext()) {
                    String key = unsentMessageMapNew.keySet().iterator().next();
                    Log.e(TAG, "key: " + key);
                    JSONObject messageJson = unsentMessageMapNew.get(key);

                    if (!messageJson.getString("message").isEmpty() && !messageJson.getString("message").equalsIgnoreCase("n/a")
                            && (messageJson.optInt(MESSAGE_TYPE) == IMAGE_MESSAGE || messageJson.optInt(MESSAGE_TYPE) == FILE_MESSAGE)) {
                        messageJson.put(MESSAGE_TYPE, TEXT_MESSAGE);
                        messageJson.remove(THUMBNAIL_URL);

                    }


                    if (messageJson.optInt("is_message_expired", 0) == 1) {
                        unsentMessageMap.put(key, messageJson);
                        unsentMessageMapNew.remove(key);
                        sendMessages();
                    } else {
                        int messageType = messageJson.optInt(MESSAGE_TYPE);
                        if (!messageSending && messageJson.optInt("is_message_expired", 0) == 0 && (messageType != IMAGE_MESSAGE && messageType != FILE_MESSAGE && messageType != FILE_PDF_MESSAGE && checkIfAttachment(messageJson))) {
                            Log.e(TAG, "Sending: " + new Gson().toJson(messageJson));
                            sendingTry = 0;
                            messageSending = true;
                            messageJson.put(USER_IMAGE, getUserImage());
                            if ((originalMessageType == IMAGE_MESSAGE || originalMessageType == FILE_MESSAGE || originalMessageType == FILE_PDF_MESSAGE)) {
                                getmsgJsonIfPrivate(messageJson);
                                if ((messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty()) || (messageJson.has("url") && !messageJson.getString("url").isEmpty()))
                                    publishMessage(messageJson, true);
                            } else {
                                publishMessage(messageJson, true);
                            }
                        }
                        if (!messageSending && messageJson.optInt("is_message_expired", 0) == 0 && (messageType == IMAGE_MESSAGE || messageType == FILE_MESSAGE || messageType == FILE_PDF_MESSAGE)) {

                            String localPath = messageJson.optString("local_url", "");
                            String url = messageJson.optString("url");
                            String muid = messageJson.optString("muid");
                            if (messageType == FILE_PDF_MESSAGE)
                                messageJson.putOpt(MESSAGE_TYPE, FILE_MESSAGE);
                            //int index = messageJson.optInt(MESSAGE_INDEX);
                            if (!TextUtils.isEmpty(url)) {
                                localPath = null;
                                messageJson.remove("local_url");
                            }
                            if (!TextUtils.isEmpty(localPath)) {
                                //uploadFileServerCall(localPath, "image/*", index, muid);
                                for (String muidKey : unsentMessageMapNew.keySet()) {
                                    JSONObject newMessageJson = unsentMessageMapNew.get(muidKey);
                                    if (newMessageJson.optInt("is_message_expired", 0) == 1) {
                                        unsentMessageMap.put(muidKey, newMessageJson);
                                        unsentMessageMapNew.remove(muidKey);
                                        sendMessages();
                                        return;
                                    } else {
                                        int newMessageType = newMessageJson.optInt(MESSAGE_TYPE);
                                        if (!messageSending && newMessageJson.optInt("is_message_expired", 0) == 0
                                                && ((!TextUtils.isEmpty(newMessageJson.optString("url", "")))
                                                || (newMessageType != IMAGE_MESSAGE && newMessageType != FILE_MESSAGE))) {
                                            sendingTry = 0;
                                            messageSending = true;
                                            newMessageJson.put(USER_IMAGE, getUserImage());
                                            publishMessage(newMessageJson, true);
                                            return;
                                        } else if (!messageSending && newMessageJson.optInt("is_message_expired", 0) == 0
                                                && (newMessageType == IMAGE_MESSAGE || newMessageType == FILE_MESSAGE)) {
                                            continue;
                                        }
                                    }
                                }
                            } else {
                                sendingTry = 0;
                                messageSending = true;
                                messageJson.put(USER_IMAGE, getUserImage());
                                publishMessage(messageJson, true);
                            }
                        }
                    }
                } else if (unsentMessageMap.size() > 0) {
                    unsentMessageMapNew.putAll(unsentMessageMap);
                    unsentMessageMap.clear();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        /*else {
            try {
                connectAgainToServer();
            } catch (Exception e) {

            }
        }*/
    }

    private void publishMessage(JSONObject messageJson, boolean isEncription) {
        Log.e("published messgage>>>>>> ", "publishmsg>>>" + messageJson.toString());
        ConnectionManager.INSTANCE.publish("/" + String.valueOf(conversation.getChannelId()), messageJson, isEncription);

    }

    private void getmsgJsonIfPrivate(JSONObject messageJson) {
        try {


            String localPath = messageJson.optString("local_url", "");
            String url = messageJson.optString("url");
            String muid = messageJson.optString("muid");
            if (originalMessageType == FILE_PDF_MESSAGE)
                messageJson.putOpt(MESSAGE_TYPE, FILE_MESSAGE);
            //int index = messageJson.optInt(MESSAGE_INDEX);
            if (!TextUtils.isEmpty(url)) {
                localPath = null;
                messageJson.remove("local_url");
            }
            if (!TextUtils.isEmpty(localPath)) {
                //uploadFileServerCall(localPath, "image/*", index, muid);
                for (String muidKey : unsentMessageMapNew.keySet()) {
                    JSONObject newMessageJson = unsentMessageMapNew.get(muidKey);
                    if (newMessageJson.optInt("is_message_expired", 0) == 1) {
                        unsentMessageMap.put(muidKey, newMessageJson);
                        unsentMessageMapNew.remove(muidKey);
                        sendMessages();
                        return;
                    } else {
                        int newMessageType = newMessageJson.optInt(MESSAGE_TYPE);
                        if (!messageSending && newMessageJson.optInt("is_message_expired", 0) == 0
                                && ((!TextUtils.isEmpty(newMessageJson.optString("url", "")))
                                || (originalMessageType != IMAGE_MESSAGE && originalMessageType != FILE_MESSAGE))) {
                            sendingTry = 0;
                            messageSending = true;
                            newMessageJson.put(USER_IMAGE, getUserImage());
//                            ConnectionManager.INSTANCE.publish("/" + String.valueOf(conversation.getChannelId()), newMessageJson);
                            return;
                        } else if (!messageSending && newMessageJson.optInt("is_message_expired", 0) == 0
                                && (originalMessageType == IMAGE_MESSAGE || originalMessageType == FILE_MESSAGE)) {
                            continue;
                        }
                    }
                }
            } else {
                sendingTry = 0;
                messageSending = true;
                messageJson.put(USER_IMAGE, getUserImage());
//                ConnectionManager.INSTANCE.publish("/" + String.valueOf(conversation.getChannelId()), messageJson);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkIfAttachment(JSONObject messageJson) {
        try {
            if (messageJson.has("document_type")) {
                if (messageJson.get("document_type") != null && !messageJson.getString("document_type").isEmpty()) {
                    if (messageJson.get("url") != null && !messageJson.getString("url").isEmpty()) {
                        return true;
                    } else if (messageJson.get("image_url") != null && !messageJson.getString("url").isEmpty()) {
                        return true;
                    } else {
                        return false;
                    }
                } else
                    return true;

            } else
                return true;
        } catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void publishOnFaye(String message, int messageType, String imageUrl, String thumbnailUrl, int notificationType) {
        publishOnFaye(message, messageType, imageUrl, thumbnailUrl, notificationType, null, false, null);
    }

    private void publishOnFaye(String message, int messageType, String imageUrl, String thumbnailUrl,
                               int notificationType, Bot bot, boolean isPrivateNotes, ArrayList<Integer> ids) {
        String removsinglequote = message.trim();
        String localDate = DateUtils.getInstance().getFormattedDate(new Date());

        try {

            if (isNetworkAvailable()) {

                JSONObject messageJson = new JSONObject();

                if (notificationType == READ_MESSAGE) {
                    messageJson.put("notification_type", notificationType);
                    messageJson.put("channel_id", conversation.getChannelId());
                } else {
                    if (HippoApplication.getInstance().getUserData().getFullName() != null) {
                        messageJson.put("full_name", HippoApplication.getInstance().getUserData().getFullName());
                    }

                    messageJson.put("message", removsinglequote);
                    messageJson.put("message_type", messageType);
                    messageJson.put(USER_TYPE, UserType.AGENT.getOrdinal());
                    messageJson.put("date_time", DateUtils.getInstance().convertToUTC(localDate));
                    messageJson.put("message_index", fuguMessageList.size() - 1);
                    if (isPrivateNotes) {
                        messageJson.put("tagged_users", ids);
                    }

                    if (messageType == IMAGE_MESSAGE && !imageUrl.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                        messageJson.put("image_url", imageUrl);
                        messageJson.put("thumbnail_url", thumbnailUrl);
                    }

                    if (messageType == TEXT_MESSAGE) {
                        messageJson.put("is_typing", isTyping);
                    } else {
                        messageJson.put("is_typing", TYPING_SHOW_MESSAGE);
                    }

                    messageJson.put("message_status", MESSAGE_UNSENT);
                }
                messageJson.put("user_id", HippoApplication.getInstance().getUserData().getUserId());
                messageJson.put("user_type", UserType.AGENT.getOrdinal());

                Log.v("messageJson", "messageJson = " + new Gson().toJson(messageJson));


                messageJson.put(USER_IMAGE, getUserImage());
                publishMessage(messageJson, (messageType != 0 && !message.isEmpty()));
                if (isTyping == TYPING_SHOW_MESSAGE && messageType == TEXT_MESSAGE) {
                    isTyping = TypingMode.TYPING_START.getOrdinal();
                }


                /*if (HippoApplication.getmClient() != null) {
                    if (HippoApplication.getmClient().isConnectedServer()) {
                        messageJson.put(USER_IMAGE, getUserImage());
                        ConnectionManager.INSTANCE.publish("/" + String.valueOf(conversation.getChannelId()), messageJson);
                        if (isTyping == TYPING_SHOW_MESSAGE && messageType == TEXT_MESSAGE) {
                            isTyping = TypingMode.TYPING_START.getOrdinal();
                        }
                    } else {
                        try {
                            connectAgainToServer();
                        } catch (Exception e) {

                        }
                    }
                }*/
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater menuInflater = getMenuInflater();
        if (isP2PChat) {
            menuInflater.inflate(R.menu.empty_menu, menu);
        } else {
            menuInflater.inflate(R.menu.chat_menu, menu);
        }
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        //invalidateOptionsMenu();
        try {
            if (isP2PChat) {
                return super.onPrepareOptionsMenu(menu);
            }
            MenuItem menuAddDeal = menu.findItem(R.id.menuAddDeal);
            MenuItem menuViewNotes = menu.findItem(R.id.menuViewNotes);
            MenuItem menuEditDeal = menu.findItem(R.id.menuEditDeal);
            MenuItem menuCloseChat = menu.findItem(R.id.menuCloseChat);
            MenuItem menuViewInfo = menu.findItem(R.id.menuViewInfo);
            MenuItem createTicket = menu.findItem(R.id.createTicket);

            menuAddDeal.setTitle(Restring.getString(FuguChatActivity.this, R.string.add_deal));
            menuViewNotes.setTitle(Restring.getString(FuguChatActivity.this, R.string.hippo_view_notes));
            menuEditDeal.setTitle(Restring.getString(FuguChatActivity.this, R.string.edit_deal));
            menuCloseChat.setTitle(Restring.getString(FuguChatActivity.this, R.string.close_conversation));
            menuViewInfo.setTitle(Restring.getString(FuguChatActivity.this, R.string.hippo_view_info));
            createTicket.setTitle(Restring.getString(FuguChatActivity.this, R.string.hippo_create_ticket));

            menuAddDeal.setVisible(false);
            menuViewNotes.setVisible(false);
            menuEditDeal.setVisible(false);
            menuCloseChat.setVisible(false);
            createTicket.setVisible(false);


            if (HippoApplication.getInstance().getUserData() != null) {
                try {
                    if (HippoApplication.getInstance().getUserData().getAgentType() == AgentType.AGENT.getOrdinal()
                            && HippoApplication.getInstance().getUserData().getBusinessProperty().hideCustomerData())
                        userInfoflag = true;
                } catch (Exception e) {
                }

                if (conversation.getStatus().equals(MessageMode.OPEN_CHAT.getOrdinal()) && !(conversation.getChatType()
                        && conversation.getUserId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue()))
                    menuCloseChat.setVisible(true);

                if (HippoApplication.getInstance().getUserData().getBusinessProperty().IsErpnextTicketEnabled())
                    createTicket.setVisible(true);


                if (isO2oChat || !(conversation.getStatus().equals(MessageMode.OPEN_CHAT.getOrdinal()) &&
                        !(conversation.getChatType()
                                && conversation.getUserId().intValue() == HippoApplication.getInstance()
                                .getUserData().getUserId().intValue())))
                    createTicket.setVisible(false);


                if (btnViewNotes.getVisibility() == View.VISIBLE)
                    menuViewNotes.setVisible(true);
                if (!userInfoflag && btnAddDeal.getVisibility() == View.VISIBLE) {
                    if (btnAddDeal.getText().toString().equalsIgnoreCase(Restring.getString(FuguChatActivity.this, R.string.edit_deal))) {
                        menuEditDeal.setVisible(true);
                    } else {
                        menuAddDeal.setVisible(true);
                    }
                }
            }else {
                showTrialExpirePopUp();
            }
        } catch (Exception e) {

        }
        return super.onPrepareOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.home) {
            onBackPressed(); // close this context and return to preview context (if there is any)
            openDealInfo();
        } else if (itemId == R.id.menuAddDeal || itemId == R.id.menuEditDeal) {
            openDealInfo();
        } else if (itemId == R.id.menuViewInfo) {
            btnViewDetails.performClick();
        } else if (itemId == R.id.menuViewNotes) {
            dialogShowNotes();
        } else if (itemId == R.id.menuCloseChat) {
            closeChat();
        } else if (itemId == R.id.createTicket) {
            openCreateTicketActivity();
        }
        return super.onOptionsItemSelected(item);
    }

    private void openCreateTicketActivity() {
        if (!Utils.preventMultipleClicks()) {
            return;
        }
        if (conversation.getAgentId() == null)
            return;

        Intent i = new Intent(FuguChatActivity.this, CreateTicketActivity.class);
        i.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
        i.putExtra(Constants.TAGS_DATA, tagData);
        i.putExtra("deal_id", dealId);
        i.putExtra("hasBotRunning", hasBotRunning);
        if (btnHistory) {
            i.putExtra("btnHistory", true);
        }
        startActivityForResult(i, 100);
    }

    private void startAnim() {
        new Handler().post(new Runnable() {
            @Override
            public void run() {
                aviTyping.show();
                llTyping.setVisibility(View.VISIBLE);
                aviTyping.smoothToShow();
            }
        });

        // or avi.smoothToShow();
    }

    private void stopAnim() {
        llTyping.setVisibility(View.GONE);
        aviTyping.hide();
        // or avi.smoothToHide();
    }

    boolean onCallBtnHitPause = false;

    @Override
    protected void onPause() {
        super.onPause();
        pushChannelId = -1;
        if (fuguMessageAdapter != null)
            fuguMessageAdapter.onPauseActivity();
        try {
            if (conversation.getChannelId() > 0 && !TextUtils.isEmpty(etMsg.getText().toString().trim()) && !isPrivateClicked) {
                CommonData.saveTypedMessage(currentChannelId, etMsg.getText().toString().trim());
            }
        } catch (Exception e) {

        }
        try {
            handleOnPause();
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (onCallBtnHitPause) {
                onCallBtnHitPause = false;
            } else {
                handleBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        KeyboardUtil.removeKeyboardToggleListener(this);
        url = "";
    }

    private void handleOnPause() throws Exception {
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                android.os.Process.setThreadPriority(android.os.Process.THREAD_PRIORITY_BACKGROUND);
                try {
                    CommonData.setSentMessageByChannel(conversation.getChannelId(), sentMessages);
                    if (unsentMessages != null && unsentMessages.size() == 0) {
                        CommonData.removeUnsentMessageMapChannel(conversation.getChannelId());
                        CommonData.removeUnsentMessageChannel(conversation.getChannelId());
                    } else {
                        CommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);
                        CommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
                    }

                } catch (Exception e) {

                }
                Log.e(TAG, "onPause thread closed");
            }
        });

        thread.start();
    }

    private void handleBack() throws Exception {
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                android.os.Process.setThreadPriority(android.os.Process.THREAD_PRIORITY_BACKGROUND);
                try {
                    removeCallBacks();
                } catch (Exception e) {
                    e.printStackTrace();
                }

                Log.e(TAG, "Back thread closed");
            }
        });

        thread.start();

    }

    private void removeCallBacks() throws Exception {
        ConnectionManager.INSTANCE.unsubScribeChannel("/" + String.valueOf(conversation.getChannelId()));
        messagesApi.clear();
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mMessageReceiver);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mMessageReceiver1);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(fileUploadReceiver);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mProgressReceiver);

        unregisterReceiver(getMsgData);
        unregisterReceiver(getAgentData);
        unregisterReceiver(migrateUser);
    }

    @Override
    protected void onDestroy() {

        pushChannelId = -1;
        currentChannelId = -1;

        url = "";
        UnregisterBroadcast();
        super.onDestroy();
    }

    boolean onCallBtnHit = false;

    @Override
    protected void onResume() {
        super.onResume();
        if (onCallBtnHit) {
            onCallBtnHit = false;
            return;
        }
        if (HippoApplication.getInstance().getUserData() != null) {
            pushChannelId = conversation.getChannelId();
            currentChannelId = conversation.getChannelId();
            subscribeReceivers();
            try {
                stopAlarmRing();
            } catch (Exception e) {
                e.printStackTrace();
            }

            if (!isFirstTimeOpened && !isFromFilePicker) {
                if (!isMessageInEditMode) {
                    getMessages(false, true);
                }
                clearNotification(conversation.getChannelId());
            }
            isFromFilePicker = false;
            isFirstTimeOpened = false;
            KeyboardUtil.addKeyboardToggleListener(FuguChatActivity.this, this);
            if (CommonData.isListenerReset()) {
                CommonData.setFayeListener(false);
            }
        }else {
            showTrialExpirePopUp();
        }
    }

    public void createConversation(final JSONObject jsonObject) {
        HashMap<String, String> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
        params.put("initiator_en_agent_id", String.valueOf(HippoApplication.getInstance().getUserData().getEnUserId()));
        params.put("user_id", String.valueOf(conversation.getUserId()));
        params.put("chat_type", "0");

        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build();

        pbSendingImage.setVisibility(View.VISIBLE);
        checkAudioButton();

        createConversation(commonParams, jsonObject);
    }

    private void createUserConversation() {
        HashMap<String, String> params = new HashMap<>();
        params.put(Constants.ACCESS_TOKEN, String.valueOf(HippoApplication.getInstance().getUserData().getAccessToken()));
        params.put("initiator_en_agent_id", String.valueOf(HippoApplication.getInstance().getUserData().getEnUserId()));
        params.put("chat_type", "0");

        if (!TextUtils.isEmpty(transactionId)) {
            params.put("transaction_id", transactionId);
        }

        ArrayList<String> userUniqueKey = new ArrayList<>();
        userUniqueKey.add(conversation.getUserUniqueKeys());
        params.put("other_user_unique_key", new Gson().toJson(userUniqueKey));


        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build();

//        pbSendingImage.setVisibility(View.VISIBLE);
//        ivSend.setVisibility(View.GONE);

        createConversation(commonParams, null);
    }

    private void createConversation(CommonParams commonParams, final JSONObject jsonObject) {

        Logger.INSTANCE.apiRequest("/api/conversation/createConversation", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().createConversation(commonParams.getMap())
                .enqueue(new ResponseResolver<CreateConversation>(FuguChatActivity.this, jsonObject == null, true) {
                    @Override
                    public void success(CreateConversation createConversation) {
                        Logger.INSTANCE.apiResponse("/api/conversation/createConversation", "");
                        channelCreated = true;
                        conversation = new Conversation();
                        conversation.setUserId(Integer.parseInt(createConversation.getData().getUserId()));
                        conversation.setLabel(createConversation.getData().getLabel());
                        conversation.setChannelName(createConversation.getData().getChannelName());
                        conversation.setChannelId(createConversation.getData().getChannelId());
                        conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());

                        conversation.setDisableReply(createConversation.getData().getDisableReply());
                        conversation.setAgentId(HippoApplication.getInstance().getUserData().getUserId());
                        conversation.setAgentName(HippoApplication.getInstance().getUserData().getUserName());

                        checkAudioButton();

                        pbSendingImage.setVisibility(View.GONE);
                        CommonData.setlineBeforeFeedback("lineBeforeFeedback", HippoApplication.getInstance().getUserData().getLineBeforeFeedback());
                        CommonData.setlineBeforeFeedback("lineAfterFeedback_1", HippoApplication.getInstance().getUserData().getLineAfterFeedback1());
                        CommonData.setlineBeforeFeedback("lineAfterFeedback_2", HippoApplication.getInstance().getUserData().getLineAfterFeedback2());

                        setRecyclerViewData();

                        setSubscribeChannel();

                        temp = "";
                        if (!etMsg.getText().toString().trim().isEmpty()) {
                            if (isBlock) {
                                Animation animation1 = AnimationUtils.loadAnimation(FuguChatActivity.this, R.anim.shake);
                                tvAssignNotify.startAnimation(animation1);
                                return;
                            }

                            isTyping = 0;
                            if (jsonObject != null) {
                                sendMessages();
                            } else {
                                if (isPrivateClicked) {
                                    try {
                                        if (!TextUtils.isEmpty(sendPrivateNote())) {
                                            sendMessage(sendPrivateNote(), messageType, "", "",
                                                    null, true, taggedPersons(), "", null);
                                        }
                                    } catch (Exception ignored) {
                                    }
                                } else {
                                    if (!TextUtils.isEmpty(etMsg.getText().toString().trim())) {
                                        sendMessage(etMsg.getText().toString().trim(), messageType, "",
                                                "", null, false, null, "", null);
                                    }
                                }
                            }

                        }
                        if (llCollapsingLayout.getVisibility() == View.VISIBLE) {
                            if (etCustName.getVisibility() == View.VISIBLE) {
                                tvTitle.setTextSize(TypedValue.COMPLEX_UNIT_PX,
                                        getResources().getDimension(R.dimen.fugu_text_size_intermediate));
                            }
                            Log.v("scroll up on layout", "scroll up");
                            collapse(llCollapsingLayout);


                            ivNextIcon.setVisibility(View.GONE);
                            ivNextIcon.setOnClickListener(new View.OnClickListener() {
                                @Override
                                public void onClick(View v) {
                                    if (!Utils.preventMultipleClicks()) {
                                        return;
                                    }
                                    Intent i = new Intent(FuguChatActivity.this, ChannelInfoActivity.class);
                                    i.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                                    if (btnHistory && !isO2oChat) {
                                        i.putExtra("btnHistory", true);
                                    }
                                    i.putExtra("directOpen", isDirectChannel);
                                    i.putExtra("hasBotRunning", hasBotRunning);
                                    startActivityForResult(i, 100);
                                }
                            });
                        }

                        try {
                            customerPhone = getIntent().getStringExtra("customerPhone");
                            customerName = getIntent().getStringExtra("customerName");
                            customerEmail = getIntent().getStringExtra("customerEmail");
                        } catch (Exception e) {

                        }

                        pushChannelId = conversation.getChannelId();
                        currentChannelId = conversation.getChannelId();
                        isFromGetConversation = true;
                        initViews();
                        fetchIntentData();
                        if (jsonObject == null)
                            setUpUI();
                        stateChangeListeners();

                        setUpMentions(etMsg);
                        setUserDetails();
                        //getDealInfo();

                        //apiGetConversation(true, createConversation.getData().getChannelId());
                    }

                    @Override
                    public void failure(APIError error) {
                        Logger.INSTANCE.apiFailed("/api/conversation/createConversation", error.getMessage());
                        if (error.getStatusCode() == ApiResponseFlags.SESSION_EXPIRED.getOrdinal()) {
                            try {
                                Toast.makeText(FuguChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                                /*if (HippoApplication.getmClient() != null) {
                                    if (HippoApplication.getmClient().isConnectedServer()) {
                                        HippoApplication.getmClient().unsubscribeChannel(String.valueOf(conversation.getChannelId()));
                                    }
                                }*/
                                Paper.book(CommonData.name).delete(SPLabels.LATEST_VERSION);
                                HippoApplication.getInstance().logout(FuguChatActivity.this);
                                HippoApplication.getInstance().clearData();

                            } catch (Exception e) {
                                Logger.INSTANCE.apiFailed("/api/conversation/createConversation", e.getLocalizedMessage());
                                e.printStackTrace();
                            }
                        } else {
                            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                        }

                        pbSendingImage.setVisibility(View.GONE);
                        checkAudioButton();
                    }

                });
    }

    public boolean checkValidMsg(String msg) {
        if (Utils.isValidEmail(msg) || Utils.isPhoneValid(msg)) {
            return true;
        }
        return false;
    }

    private int pageEnd = 0;
    private boolean checkValidMsg = false;

    public void onClick(View v) {
        if (v.getId() == R.id.ivSend1) {
            if (checkValidMsg && !TextUtils.isEmpty(etMsg.getText().toString().trim())) {
                if (!TextUtils.isEmpty(etMsg.getText().toString().trim())) {
                    if (checkValidMsg(etMsg.getText().toString().trim())) {
                        ToastUtil.getInstance(FuguChatActivity.this).showToast(Restring.getString(FuguChatActivity.this, R.string.hippo_message_not_allow));
                        return;
                    }
                }
            }

            taggedPersons();

            sendTextMessage(etMsg.getText().toString(), 0);
        } else if (v.getId() == R.id.tvNoInternet) {
            getMessages();
        } else if (v.getId() == R.id.rlImage) {
            if (rlImage.getVisibility() == View.INVISIBLE)
                return;
            if (!isNetworkAvailable()) {
                Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                return;
            }
            selectImage(v);
        } else if (v.getId() == R.id.rlText) {
            if (messageType != TEXT_MESSAGE) {
                if (!HippoApplication.getInstance().getUserData().getBusinessProperty().isSavedReply()) {
                    etMsg.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_normal_message));
                } else {
                    etMsg.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_message));
                }
                //etMsg.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_message));
                visibilityGone(rvTagged);
                messageType = TEXT_MESSAGE;
                isPrivateClicked = false;
                rlCanned.setVisibility(View.VISIBLE);
                rlImage.setVisibility(View.VISIBLE);

                llMsgInput.setBackgroundColor(ContextCompat.getColor(this, R.color.white));
                savedPrivateNote = etMsg.getText().toString().trim();
                etMsg.setText("");
                checkAudioButton();
                etMsg.setSelection(etMsg.getText().length());
                ivPrivate.setColorFilter(ContextCompat.getColor(this, R.color.black), PorterDuff.Mode.SRC_IN);
                ivText.setColorFilter(ContextCompat.getColor(this, R.color.colorPrimary), PorterDuff.Mode.SRC_IN);
                vPrivate.setVisibility(View.INVISIBLE);
                vText.setVisibility(View.VISIBLE);
                if (!isO2oChat) {
                    botLayout.setVisibility(View.VISIBLE);
                    if (HippoApplication.getInstance().getUserData().getBusinessProperty().isAskPaymentAllowed())
                        paymentLayout.setVisibility(View.VISIBLE);
                }
                if (HippoApplication.getInstance().getUserData().getBusinessProperty().getIsEformEnabled() == 0) {
                    prescriptionRL.setVisibility(View.GONE);
                } else {
                    prescriptionRL.setVisibility(View.VISIBLE);
                }
                //HippoApplication.getInstance().trackEvent(CHAT_SCREEN, NORMAL_CHAT_CLICKED, "normal_chat");
            }
        } else if (v.getId() == R.id.rlPrivate) {
            if (messageType != PRIVATE_NOTE) {
                etMsg.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_internal_note));
                visibilityGone(rvTagged);
                isTyping = 2;
                isPrivateClicked = true;
                publishOnFaye(getString(R.string.empty), messageType,
                        getString(R.string.empty), getString(R.string.empty), DEFAULT_NOTIFICATION_TYPE);
                messageType = PRIVATE_NOTE;
                rlCanned.setVisibility(View.GONE);
//                rlImage.setVisibility(View.INVISIBLE);
                llMsgInput.setBackgroundColor(ContextCompat.getColor(this, R.color.private_note_bg));
                etMsg.setText("");

//                ivPrivate.setColorFilter(ContextCompat.getColor(this, R.color.colorPrimary), PorterDuff.Mode.SRC_IN);
//                ivText.setColorFilter(ContextCompat.getColor(this, R.color.chat_bottom_disabled_color), PorterDuff.Mode.SRC_IN);
                ivPrivate.setColorFilter(ContextCompat.getColor(this, R.color.colorPrimary), PorterDuff.Mode.SRC_IN);
                ivText.setColorFilter(ContextCompat.getColor(this, R.color.black), PorterDuff.Mode.SRC_IN);
                vPrivate.setVisibility(View.VISIBLE);
                vText.setVisibility(View.INVISIBLE);
                paymentLayout.setVisibility(View.INVISIBLE);
                botLayout.setVisibility(View.INVISIBLE);
                prescriptionRL.setVisibility(View.INVISIBLE);

                record_button.setVisibility(View.GONE);
                record_view.setVisibility(View.GONE);
                ivSend.setVisibility(View.VISIBLE);

                //HippoApplication.getInstance().trackEvent(CHAT_SCREEN, PRIVATE_CHAT_CLICKED, "private_chat");
            }
        } else if (v.getId() == R.id.rlCanned) {
            if (!isNetworkAvailable()) {
                Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                return;
            }
            showKeyboard();
            isPrivateClicked = false;
            cannedDialog = new CannedDialog(FuguChatActivity.this, new CannedDialog.Callback() {
                @Override
                public void onClick(int pos, CannedMessageResponse.Data cannedMessage) {
                    etMsg.setText(cannedMessage.getMessage().trim());
                    if (!etMsg.getText().toString().isEmpty()) {
                        InputMethodManager inputMethodManager =
                                (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                        inputMethodManager.toggleSoftInputFromWindow(
                                etMsg.getApplicationWindowToken(),
                                InputMethodManager.SHOW_FORCED, 0);
                    }
                    etMsg.setSelection(etMsg.getText().length());
                    //HippoApplication.getInstance().trackEvent(CHAT_SCREEN, SAVED_REPLIES, "saved_reply");
                }

                @Override
                public void onCancel() {

                }
            }).show();
        } else if (v.getId() == R.id.rlScrollBottom) {
            try {
                scrollListToBottom();
                rlScrollBottom.setVisibility(View.GONE);
            } catch (Exception e) {
                e.printStackTrace();
            }

        } else if (v.getId() == R.id.rlGiff) {
            rvGiffy.setVisibility(View.VISIBLE);
            RestClient.getApiInterface()
                    .getGiffs("happy", "AQFDs4BNfq44V9F6Cpa8T7Q1BoGgDUqX", 10)
                    .enqueue(new ResponseResolver<GiffyResponse>(FuguChatActivity.this, false, false) {
                        @Override
                        public void success(GiffyResponse giffyResponse) {
                            giffList = (ArrayList<Datum>) giffyResponse.getData();
                            giffyAdapter = new GiffyAdapter(FuguChatActivity.this, giffList, new GiffyAdapter.Callback() {
                                @Override
                                public void onClick(GiffyResponse giffyResponse) {
                                    Toast.makeText(FuguChatActivity.this, "got giffy", Toast.LENGTH_SHORT).show();
                                }
                            });
                            linearLayoutManager1 = new LinearLayoutManager(FuguChatActivity.this);
                            linearLayoutManager1.setStackFromEnd(true);
                            rvGiffy.setLayoutManager(linearLayoutManager1);
                            rvGiffy.setAdapter(giffyAdapter);
                        }

                        @Override
                        public void failure(APIError error) {

                        }
                    });
        } else if (v.getId() == R.id.etCustEmail) {
            goToGmail(etCustEmail.getText().toString());
        } else if (v.getId() == R.id.etCustPhone) {
            goToPhone(etCustPhone.getText().toString());
        } else if (v.getId() == R.id.rlPrescription) {
            gotoPrescriptionTemplateList();
        }
    }

    private void sendTextMessage(String text, int messageSubType) {
        if (isMessageInEditMode) {
            if (isBlock) {
                Animation animation1 = AnimationUtils.loadAnimation(this, R.anim.shake);
                tvAssignNotify.startAnimation(animation1);
                return;
            }
            isTyping = 0;
            if (!TextUtils.isEmpty(text.trim()))
                sendUpdatedMessage(text.trim());
            else
                Toast.makeText(this, "Message can't be empty", Toast.LENGTH_SHORT).show();
        } else if (conversation.getChannelId() > 0) {
            temp = "";
            if (!text.trim().isEmpty()) {
                if (isBlock) {
                    Animation animation1 = AnimationUtils.loadAnimation(this, R.anim.shake);
                    tvAssignNotify.startAnimation(animation1);
                    return;
                }

                isTyping = 0;
                if (isPrivateClicked) {
                    try {
                        sendMessage(sendPrivateNote(), messageType, "", "",
                                null, true, taggedPersons(), "", null);
                    } catch (Exception ignored) {
                    }
                } else {
                    sendMessage(text.trim(), messageType, "", "",
                            null, false, null, "", null, messageSubType);
                }


            }
            if (llCollapsingLayout.getVisibility() == View.VISIBLE) {
                if (etCustName.getVisibility() == View.VISIBLE) {
                    tvTitle.setTextSize(TypedValue.COMPLEX_UNIT_PX,
                            getResources().getDimension(R.dimen.fugu_text_size_intermediate));
                }

                Log.v("scroll up on layout", "scroll up");
                collapse(llCollapsingLayout);


                ivNextIcon.setVisibility(View.GONE);
                ivNextIcon.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (!Utils.preventMultipleClicks()) {
                            return;
                        }
                        Intent i = new Intent(FuguChatActivity.this, ChannelInfoActivity.class);
                        i.putExtra(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                        if (btnHistory && !isO2oChat) {
                            i.putExtra("btnHistory", true);
                        }
                        i.putExtra("directOpen", isDirectChannel);
                        i.putExtra("hasBotRunning", hasBotRunning);
                        startActivityForResult(i, 100);
                    }
                });
            }

            //scrollListToBottom();
            //HippoApplication.getInstance().trackEvent(CHAT_SCREEN, SEND_BUTTON_CLICKED, "send_chat");
        } else {
            if (isCreateO2OChat) {
                if (isMerchantChat) {
                    createAgentSupportChannel(email, transactionId, new ArrayList<>(), initiated_by_agent);
//                        createAgentSupportChannel(email, transactionId, gtTags, initiated_by_agent);
                } else {
                    createViaEmail(email);
                }
            } else {
                createConversation(null);
            }
        }
    }

    private void gotoPrescriptionTemplateList() {

        HashMap<String, Object> params = new HashMap<>();
        progressWheelPrescription.setVisibility(View.VISIBLE);
        progressWheelPrescription.spin();
        params.put(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken().toString());
        params.put("template_type", 1);
        params.put("fetch_predefined_labels", 1);
        params.put("channel_id", String.valueOf(conversation.getChannelId()));

        CommonParamsObj commonParams = new CommonParamsObj.Builder()
                .addAll(params)
                .build();
        Logger.INSTANCE.apiRequest("/api/business/getTemplates", new Gson().toJson(commonParams.getMap()));
        RestClient.getApiInterface().getBusinessTemplates(commonParams.getMap()).enqueue(new ResponseResolver<PrescriptionTemplateData>() {


            @Override
            public void success(PrescriptionTemplateData prescriptionTemplateData) {
                Logger.INSTANCE.apiResponse("/api/business/getTemplates", "");
                progressWheelPrescription.setVisibility(View.GONE);
                try {
                    if (prescriptionTemplateData.getData().getBusinessTemplates().size() > 0) {
                        prescriptionBottomSheetFragment = new PrescriptionBottomSheetFragment(prescriptionTemplateData, FuguChatActivity.this, String.valueOf(conversation.getChannelId()));
                        prescriptionBottomSheetFragment.show(getSupportFragmentManager(), prescriptionBottomSheetFragment.getTag());
                    } else {
                        tvAssignNotify.setVisibility(View.VISIBLE);
                        tvAssignNotify.setText(Html.fromHtml(Restring.getString(FuguChatActivity.this, R.string.no_prescription_found)));
                        tvAssignNotify.setBackgroundColor(getResources().getColor(R.color.red));
                        tvAssignNotify.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_report_problem, 0, 0, 0);
                        goneAssignLayout();

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failure(APIError error) {
                Logger.INSTANCE.apiFailed("/api/agent/getAllBotActions", error.getMessage());
                progressWheelPrescription.setVisibility(View.GONE);

            }
        });

    }

    private void updateRecycler(final int userId) {
        if (fuguMessageAdapter != null) {
            fuguMessageAdapter.updateList(fuguMessageList);
            //scrollListToBottom();
        }

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (fuguMessageAdapter != null) {
                        try {
                            fuguMessageAdapter.notifyItemInserted(fuguMessageList.size() - 1);
                            if (fuguMessageAdapter.getItemCount() > 0) {
                                int lastVisible = layoutManager.findLastVisibleItemPosition();
                                int totalItemCount = layoutManager.getItemCount();
                                boolean endHasBeenReached = lastVisible + 3 >= totalItemCount;
                                if (totalItemCount > 0 && endHasBeenReached) {
                                    scrollBottomCount = 0;
                                    scrollListToBottom();
                                } else {
                                    if (userId != HippoApplication.getInstance().getUserData().getUserId()) {
                                        rlScrollBottom.setVisibility(View.VISIBLE);
                                        tvUnread.setVisibility(View.VISIBLE);
                                        tvUnread.setText(String.valueOf(++scrollBottomCount));
                                    }
                                }
                            } else {
                                if (userId != HippoApplication.getInstance().getUserData().getUserId()) {
                                    rlScrollBottom.setVisibility(View.VISIBLE);
                                    tvUnread.setVisibility(View.VISIBLE);
                                    tvUnread.setText(String.valueOf(++scrollBottomCount));
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    boolean isApiRunning;
    private HashSet<String> messagesApi = new HashSet<>();

    private void getMessages() {
        getMessages(false, false);
    }

    int totalDateItems = 0;
    int defaultSize = 100;

    private void getMessages(final boolean flag, final boolean isFromOnResume) {
        Log.e(TAG, "get messages apis size: " + messagesApi.size());
        if (isMessageInEditMode) {
            return;
        }
        if (isApiRunning) {
            messagesApi.add("getMessages");
            return;
        }

        if (conversation.getChannelId() > 0) {
            if (isNetworkAvailable()) {
                if (!allMessagesFetched || isNetworkStateChanged || isFromOnResume) {
                    FuguGetMessageParams commonParams = new FuguGetMessageParams(HippoApplication.getInstance().getUserData().getAccessToken(),
                            conversation.getChannelId(),
                            HippoApplication.getInstance().getUserData().getEnUserId(),
                            isFromOnResume ? 1 : pageStart);

                    if (isFromOnResume && fuguMessageList.size() > defaultSize)
                        commonParams.setPageEnd(fuguMessageList.size() - dateItemCount);
                    /*try {
                        if (!showLoading && pageStart == 1) {
                            setConnectionMessage(1);
                        }
                    } catch (Exception e) {

                    }*/
                    if (showLoading)
                        showOn(FuguChatActivity.this);

                    Gson gson = new GsonBuilder().create();
                    JsonObject deviceDetailsJson = null;
                    try {
                        deviceDetailsJson = gson.toJsonTree(new DeviceDetails(getAppVersion()).getDeviceDetails()).getAsJsonObject();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    commonParams.setAppSourceType(String.valueOf(2));
                    commonParams.setAppVersion(String.valueOf(BuildConfig.VERSION_CODE));
                    commonParams.setDeviceDetails(gson.toJson(deviceDetailsJson));
                    commonParams.setDeviceId(UniqueIMEIID.getUniqueIMEIId(FuguChatActivity.this));
                    commonParams.setDeviceType(String.valueOf(ANDROID_USER));
                    if (HippoConfig.getInstance().getAttributes().getIsWhitelabel())
                     //   commonParams.setReferenceSecretKey(HippoConfig.getInstance().getAttributes().getAppKey());

                    if (!TextUtils.isEmpty(HippoConfig.getInstance().getCurrentLanguage())) {
                        commonParams.setLang(HippoConfig.getInstance().getCurrentLanguage());
                    }

                    isApiRunning = true;

                    Logger.INSTANCE.apiRequest("/api/conversation/getMessages", new Gson().toJson(commonParams));

                    RestClient.getApiInterface().getMessages(commonParams)
                            .enqueue(new ResponseResolver<FuguGetMessageResponse>(FuguChatActivity.this, false, false) {
                                @Override
                                public void success(FuguGetMessageResponse fuguGetMessageResponse) {
                                    Logger.INSTANCE.apiResponse("/api/conversation/getMessages", "");
                                    isApiRunning = false;
                                    totalDateItems = 0;
                                    //mFuguGetMessageResponse = fuguGetMessageResponse;
                                    if (fuguGetMessageResponse.getData() != null && !TextUtils.isEmpty(fuguGetMessageResponse.getData().getLabel())) {
                                        tvTitle.setText(fuguGetMessageResponse.getData().getLabel());
                                    }

                                    ivVideoView.setVisibility(View.GONE);
                                    isVideoCallEnable = false;

                                    isO2oChat = fuguGetMessageResponse.getData().isO2oType();

                                    try {
                                        checkValidMsg = fuguGetMessageResponse.getData().getRestrictPersonalInfo();
                                    } catch (Exception e) {

                                    }

                                    try {

                                        if (HippoApplication.getInstance().getUserData().isVideoCallEnabled() && fuguGetMessageResponse != null
                                                && fuguGetMessageResponse.getData() != null
                                                && fuguGetMessageResponse.getData().isAllowVideoCall()) {
                                            if ((isO2oChat &&
                                                    (conversation.getUserId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue()
                                                            || conversation.getAgentId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue()))
                                                    || HippoApplication.getInstance().getUserData().getUserId().intValue() == fuguGetMessageResponse.getData().getUserId()) {
                                                ivVideoView.setVisibility(View.VISIBLE);
                                                isVideoCallEnable = true;
                                            }
                                        }

                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }

                                    ivAudioView.setVisibility(View.GONE);
                                    isAudioCallEnable = false;
                                    try {
                                        if (HippoApplication.getInstance().getUserData().isAudioCallEnabled()
                                                && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null && fuguGetMessageResponse.getData().isAllowAudioCall()) {
                                            if ((isO2oChat && (conversation.getUserId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue()
                                                    || conversation.getAgentId().intValue() == HippoApplication.getInstance().getUserData().getUserId().intValue()))
                                                    || HippoApplication.getInstance().getUserData().getUserId().intValue() == fuguGetMessageResponse.getData().getUserId()) {
                                                ivAudioView.setVisibility(View.VISIBLE);
                                                isAudioCallEnable = true;
                                            }
                                        }

                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }

                                    try {
                                        customerPhone = fuguGetMessageResponse.getData().getCustomerPhone();
                                        customerName = fuguGetMessageResponse.getData().getCustomerName();
                                        customerEmail = fuguGetMessageResponse.getData().getCustomerEmail();
                                        setUserDetails(false);
                                    } catch (Exception e) {

                                    }

                                    cvTypeMessage.setVisibility(View.VISIBLE);
                                    hasBotRunning = false;
                                    if (fuguGetMessageResponse.getData().getDisableReply() == 1 || isP2PChat) {
                                        cvTypeMessage.setVisibility(View.GONE);
                                        hasBotRunning = true;
                                    }

                                    botChatAssign.setVisibility(View.GONE);
                                    if (fuguGetMessageResponse.getData().getDisableReply() == 1 && fuguGetMessageResponse.getData().isBotInProgress()) {
                                        botChatAssign.setVisibility(View.VISIBLE);
                                    }

                                    userId = fuguGetMessageResponse.getData().getUserId();

                                    try {
                                        if (isDirectChannel) {
                                            conversation.setStatus(fuguGetMessageResponse.getData().getStatus());
                                            conversation.setLabel(fuguGetMessageResponse.getData().getLabel());
                                            conversation.setDisableReply(fuguGetMessageResponse.getData().getDisableReply());
                                            //status = fuguGetMessageResponse.getData().getStatus();
                                            status = fuguGetMessageResponse.getData().getStatus().equals(MessageMode.OPEN_CHAT.getOrdinal()) ? MessageMode.CLOSED_CHAT.getOrdinal() : MessageMode.OPEN_CHAT.getOrdinal();
                                            if (status == MessageMode.OPEN_CHAT.getOrdinal()) {
                                                ivCloseConv.setVisibility(View.GONE);
                                            }
                                        }
                                    } catch (Exception e) {

                                    }

                                    if (fuguGetMessageResponse.getData().getMessages() != null) {
                                        tagData = fuguGetMessageResponse.getData().getTags();
                                        HippoApplication.getInstance().getUserData().setUserName(fuguGetMessageResponse.getData().getFullName());
                                        onSubscribe = fuguGetMessageResponse.getData().getOnSubscribe();

                                        LinkedHashMap<String, Message> tempMessages = new LinkedHashMap<>();
                                        LinkedHashMap<String, Message> tempSentMessages = new LinkedHashMap<>();

                                        String tempSentAtUtc = "";
                                        FuguGetMessageResponse.Data messageResponseData = fuguGetMessageResponse.getData();
                                        ownerId = messageResponseData.getOwnerId();
                                        if (conversation != null && conversation.getAgentId() == null)
                                            conversation.setAgentId(messageResponseData.getUserId());

                                        if (conversation != null && conversation.getUserId() == null)
                                            conversation.setUserId(messageResponseData.getOwnerId());

                                        if (messageResponseData.getMessages().size() < messageResponseData.getPageSize()) {
                                            allMessagesFetched = true;
                                        }

                                        setUserData(messageResponseData);
                                        if (flag) {
                                            getDealInfo();
                                            return;
                                        }

                                        int totalSize = 0;
                                        if (pageStart == 1 || isFromOnResume) {
                                            totalSize = fuguMessageList.size();
                                            fuguMessageList.clear();
                                            tempSentMessages.putAll(sentMessages);
                                            sentMessages.clear();
                                            dateItemCount = 0;
                                        }

                                        if (pageStart == 1 && !flag && !isFromOnResume) {
                                            fuguMessageList.clear();
                                            dateItemCount = 0;
                                        }

                                        Log.e(TAG, "tempSentMessages 1: " + new Gson().toJson(tempSentMessages.values()));

                                        try {

                                            if (isO2oChat) {
                                                hideO2OViews();
                                            }

                                            Integer userIId = HippoApplication.getInstance().getUserData().getUserId();
                                            for (int i = 0; i < messageResponseData.getMessages().size(); i++) {
                                                Message messageObj = fuguGetMessageResponse.getData().getMessages().get(i);
                                                boolean isSelf = false;

                                                if (isO2oChat) {
                                                    Log.v(TAG, messageObj.getUserId() + " -- " + userIId);
//                                                    if (messageObj.getUserId().equals(userIId)) {
                                                    isSelf = isSelf(messageResponseData.getOwnerId(), HippoApplication.getInstance().getUserData().getUserId().intValue(), messageObj.getUserId().intValue());
//                                                    }
                                                } else {
                                                    if (messageObj.getUserType() != null) {
                                                        if (messageObj.getUserType() == UserType.AGENT.getOrdinal() || messageObj.getUserType() == UserType.SYSTEM.getOrdinal()) {
                                                            isSelf = true;
                                                        }
                                                    }
                                                }

                                                String localDate = dateUtils.convertToLocal(messageObj.getSentAtUtc(), inputFormat, outputFormat);
                                                //String date = dateUtils.getDate(localDate);

                                                if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {
                                                    tempMessages.put(localDate, new Message(localDate, true));
                                                    tempSentAtUtc = localDate;
                                                    dateItemCount = dateItemCount + 1;
                                                    totalDateItems = totalDateItems + 1;
                                                }

                                                String muid = messageObj.getMuid();
                                                if (TextUtils.isEmpty(muid))
                                                    muid = messageObj.getId();

                                                Message message = new Message(messageObj.getfromName(),
                                                        messageObj.getUserId(),
                                                        messageObj.getMessage(),
                                                        messageObj.getSentAtUtc(),
                                                        isSelf,
                                                        messageObj.getMessageStatus(),
                                                        i,
                                                        messageObj.getImageUrl(),
                                                        messageObj.getThumbnailUrl(),
                                                        messageObj.getMessageType(),
                                                        messageObj.getUserType());


                                                message.setUserImage(messageObj.getUserImage());
                                                message.setMessageSubType(messageObj.getMessageSubType());
                                                message.setOriginalMessageType(messageObj.getMessageType());

                                                if (messageObj.getCustomAction() != null) {
                                                    message.setCustomAction(messageObj.getCustomAction());
                                                }
                                                if (!TextUtils.isEmpty(messageObj.getMultiLangMessage()))
                                                    message.setMultiLangMessage(messageObj.getMultiLangMessage());

                                                message.setIntegrationSource(messageObj.getIntegrationSource());
                                                message.setMuid(muid);
                                                message.setCallType(messageObj.getCallType());
                                                message.setVideoCallDuration(messageObj.getVideoCallDuration());
                                                message.setMessageState(messageObj.getMessageState());

                                                if (messageObj.getMessageType() == PRIVATE_NOTE && messageObj.getDocumentType() != null && !messageObj.getDocumentType().isEmpty()) {
                                                    message.setFileExtension(messageObj.getFileExtension());
                                                    message.setFileName(messageObj.getFileName());
                                                    message.setFileSize(messageObj.getFileSize());
                                                    message.setFilePath(messageObj.getFilePath());
                                                    message.setFileUrl(messageObj.getFileUrl());
                                                    message.setDocumentType(messageObj.getDocumentType());
                                                }

                                                boolean isAttachment = false;
                                                if (messageObj.getDocumentType() != null && !messageObj.getDocumentType().isEmpty()) {
                                                    if (!messageObj.getFileUrl().isEmpty())
                                                        isAttachment = true;
                                                    if (!messageObj.getFileUrl().isEmpty())
                                                        isAttachment = true;

                                                }

//                                                if (messageObj.getDocumentType() != null && !messageObj.getDocumentType().isEmpty()) {
                                                if (isAttachment) {
                                                    message.setFileExtension(messageObj.getFileExtension());
                                                    message.setFileName(messageObj.getFileName());
                                                    message.setFileSize(messageObj.getFileSize());
                                                    message.setFilePath(messageObj.getFilePath());
                                                    message.setFileUrl(messageObj.getFileUrl());
                                                    if (messageObj.getDocumentType().equalsIgnoreCase("image")) {
                                                        message.setMessageType(IMAGE_MESSAGE);
                                                        messageObj.setMessageType(IMAGE_MESSAGE);
                                                    } else {
                                                        message.setMessageType(FILE_MESSAGE);
                                                        messageObj.setMessageType(FILE_MESSAGE);
                                                    }


                                                    message.setDocumentType(messageObj.getDocumentType());
                                                } else if (messageObj.getMessageType() == FEEDBACK_MESSAGE) {
                                                    message.setIsRatingGiven(messageObj.getIsRatingGiven());
                                                    message.setTotalRating(messageObj.getTotalRating());
                                                    message.setRatingGiven(messageObj.getRatingGiven());
                                                    message.setComment(messageObj.getComment());

//                                                    message.setLineBeforeFeedback(messageObj.getLineBeforeFeedback());
//                                                    message.setLineAfterFeedback_1(messageObj.getLineAfterFeedback_1());
//                                                    message.setLineAfterFeedback_2(messageObj.getLineAfterFeedback_2());

                                                    message.setLineBeforeFeedback(CommonData.getLineFeedback("lineBeforeFeedback"));
                                                    message.setLineAfterFeedback_1(CommonData.getLineFeedback("lineAfterFeedback_1"));
                                                    message.setLineAfterFeedback_2(CommonData.getLineFeedback("lineAfterFeedback_2"));

                                                } else if (messageObj.getMessageType() == BOT_FORM_MESSAGE) {
                                                    message.setContentValue(messageObj.getContentValue());
                                                    message.setValues(messageObj.getValues());
                                                    message.setId(messageObj.getId());
                                                } else if (messageObj.getMessageType() == USER_CONCENT_MESSAGE) {
                                                    message.setContentValue(messageObj.getContentValue());
                                                    message.setIsActive(messageObj.getIsActive());
                                                    message.setSelectedBtnId(messageObj.getSelectedBtnId());
                                                    message.setRepliedBy(messageObj.getRepliedBy());
                                                    message.setRepliedUserImage(messageObj.getRepliedUserImage());
                                                    //message.setMessageType(USER_CONCENT_MESSAGE_LOCAL);
                                                }
                                                if (isO2oChat)
                                                    isSelf = isSelf(messageResponseData.getOwnerId(), HippoApplication.getInstance().getUserData().getUserId().intValue(), message.getUserId().intValue());
                                                int messageViewType = getType(messageObj.getMessageType(), isSelf, messageObj.getDocumentType());
                                                message.setMessageType(messageViewType);

                                                if (i != 0) {
                                                    message.setAboveMuid(messageResponseData.getMessages().get(i - 1).getMuid());
                                                    message.setAboveUserId(messageResponseData.getMessages().get(i - 1).getUserId());
                                                }

                                                if (i + 1 < messageResponseData.getMessages().size()) {
                                                    message.setBelowMuid(messageResponseData.getMessages().get(i + 1).getMuid());
                                                    message.setBelowUserId(messageResponseData.getMessages().get(i + 1).getUserId());
                                                }

                                                tempMessages.put(muid, message);
                                                tempSentMessages.remove(muid);
                                                if (!TextUtils.isEmpty(messageObj.getMuid())) {
                                                    if (unsentMessageMapNew.size() > 0) {
                                                        unsentMessageMapNew.remove(messageObj.getMuid());
                                                    }
                                                    if (unsentMessages.size() > 0) {
                                                        unsentMessages.remove(messageObj.getMuid());
                                                    }
                                                }


                                            }
                                            defaultSize = messageResponseData.getPageSize();
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                            //Logger.INSTANCE.apiResponse("/api/conversation/getMessages", e.getMessage());
                                        }

                                        Log.e(TAG, "tempSentMessages 2: " + new Gson().toJson(tempSentMessages.values()));
                                        if (sentMessages.containsKey(tempSentAtUtc)) {
                                            sentMessages.remove(tempSentAtUtc);
                                            dateItemCount = dateItemCount - 1;
                                        }

                                        tempMessages.putAll(sentMessages);
                                        sentMessages.clear();
                                        sentMessages.putAll(tempMessages);

                                        // put local sent messages into updated sent list
                                        if (tempSentMessages.values().size() > 0) {
                                            long lastMessageTime = dateUtils.getTimeInLong(messageResponseData.getMessages().get(messageResponseData.getMessages().size() - 1).getSentAtUtc());
                                            if (lastMessageTime > 0) {
                                                for (String key : tempSentMessages.keySet()) {
                                                    try {
                                                        Message listItem = tempSentMessages.get(key);
                                                        long localMessageTime = dateUtils.getTimeInLong(listItem.getSentAtUtc());
                                                        Log.i(TAG, "localMessageTime: " + localMessageTime);
                                                        if (localMessageTime > lastMessageTime) {
                                                            listItem = addAboveUserId(listItem);
                                                            sentMessages.put(listItem.getMuid(), listItem);
                                                        }
                                                    } catch (Exception e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            }
                                        }

                                        tempSentMessages.clear();

                                        fuguMessageList = new ArrayList<>();
                                        fuguMessageList.addAll(sentMessages.values());

                                        for (String key : unsentMessages.keySet()) {
                                            Message listItem = unsentMessages.get(key);
                                            String time = listItem.getSentAtUtc();
                                            String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                                            boolean hasDate = false;
                                            if (!sentMessages.containsKey(localDate)) {
                                                if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {

                                                    fuguMessageList.get(index).setBelowMuid(localDate);
                                                    fuguMessageList.get(index).setBelowUserId(-2);

                                                    fuguMessageList.add(new Message(localDate, true));
                                                    tempSentAtUtc = localDate;
                                                    hasDate = true;
                                                    //System.out.println("Date 2: " + localDate);
                                                }
                                            }
                                            if (unsentMessageMapNew != null && unsentMessageMapNew.size() == 0) {
                                                CommonData.removeUnsentMessageMapChannel(currentChannelId);
                                            } else {
                                                CommonData.setUnsentMessageMapByChannel(currentChannelId, unsentMessageMapNew);
                                            }


                                            if (unsentMessages != null && unsentMessages.size() == 0) {
                                                CommonData.removeUnsentMessageChannel(currentChannelId);
                                            } else {
                                                CommonData.setUnsentMessageByChannel(currentChannelId, unsentMessages);
                                            }

                                            // update
                                            try {
                                                JSONObject messageJson = unsentMessageMapNew.get(key);
                                                if (messageJson != null) {
                                                    messageJson.put("message_index", fuguMessageList.size());
                                                    messageJson.put(USER_IMAGE, getUserImage());
                                                    unsentMessageMapNew.put(key, messageJson);
                                                }
                                                // TODO: 2020-01-01 for above and below logic
                                                //fuguMessageList.add(unsentMessages.get(key));
                                                Message message = unsentMessages.get(key);
                                                if (hasDate) {
                                                    message.setAboveUserId(-2);
                                                    message.setAboveMuid(tempSentAtUtc);
                                                } else {
                                                    message.setAboveUserId(fuguMessageList.get(fuguMessageList.size() - 1).getUserId());
                                                    message.setAboveMuid(fuguMessageList.get(fuguMessageList.size() - 1).getMuid());
                                                }
                                                fuguMessageList.get(fuguMessageList.size() - 1).setBelowUserId(message.getUserId());
                                                fuguMessageList.get(fuguMessageList.size() - 1).setBelowMuid(message.getMuid());

                                                fuguMessageList.add(message);
                                            } catch (Exception e) {

                                            }
                                        }


                                        tvNoInternet.setVisibility(View.GONE);
                                        llRoot.setVisibility(View.VISIBLE);

                                        if (pageStart == 1 || isFromOnResume) {
                                            showLoading = false;
                                            sentAtUTC = tempSentAtUtc;
                                            CommonData.setMessageResponse(conversation.getChannelId(), fuguGetMessageResponse);
                                            try {
                                                videoCustomerName = fuguGetMessageResponse.getData().getCustomerName();
                                                videoAgentName = fuguGetMessageResponse.getData().getAgentName();
                                                isChatAssignToMe = (fuguGetMessageResponse.getData().getUserId() == HippoApplication.getInstance().getUserData().getUserId().intValue()) ? true : false;
                                                try {
                                                    if (HippoApplication.getInstance().getUserData().isVideoCallEnabled()
                                                            && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null && fuguGetMessageResponse.getData().isAllowVideoCall()) {
                                                        isVideoCallEnable = true;
                                                    }
                                                } catch (Exception e) {
                                                }
                                                try {
                                                    if (HippoApplication.getInstance().getUserData().isAudioCallEnabled()
                                                            && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null && fuguGetMessageResponse.getData().isAllowAudioCall()) {
                                                        isAudioCallEnable = true;
                                                    }
                                                } catch (Exception e) {
                                                }

                                            } catch (Exception e) {

                                            }

                                            setRecyclerViewData();
                                        } else {
                                            setConnectionMessage(0);
                                            pbLoading.setVisibility(View.GONE);
                                            if (fuguMessageAdapter != null) {
                                                fuguMessageAdapter.updateList(fuguMessageList);
                                                fuguMessageAdapter.notifyItemRangeInserted(0, messageResponseData.getMessages().size() + totalDateItems - 1);
                                                fuguMessageAdapter.notifyItemChanged(messageResponseData.getMessages().size() + totalDateItems);
                                            }
                                        }
                                        pageStart = sentMessages.values().size() + 1 - dateItemCount;
                                    } else {
                                        allMessagesFetched = true;
                                    }
                                    retryLayout.setVisibility(View.GONE);
                                    pbLoading.setVisibility(View.GONE);

                                    if (!isFromOnResume)
                                        getDealInfo();

                                    hide();
                                    /*if (messagesApi != null && messagesApi.size() > 0) {
                                        if (messagesApi.contains("getMessages")) {
                                            messagesApi.remove("getMessages");
                                            getMessages(flag, isFromOnResume);
                                        }
                                    }*/
                                }

                                @Override
                                public void failure(APIError error) {
                                    Logger.INSTANCE.apiFailed("/api/conversation/getMessages", error.getMessage());
                                    isApiRunning = false;
                                    hide();
                                    if (error.getStatusCode() == FuguAppConstant.SESSION_EXPIRE) {
                                        try {
                                            Toast.makeText(FuguChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                                            if (error.getStatusCode() == ApiResponseFlags.SESSION_EXPIRED.getOrdinal()) {
                                                /*if (HippoApplication.getmClient() != null) {
                                                    if (HippoApplication.getmClient().isConnectedServer()) {
                                                        HippoApplication.getmClient().unsubscribeChannel(String.valueOf(conversation.getChannelId()));
                                                    }
                                                }*/

                                                HippoApplication.getInstance().logout(FuguChatActivity.this);
                                                HippoApplication.getInstance().clearData();
                                            }

                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    } else {
                                        if (pageStart == 1 &&
                                                (CommonData.getMessageResponse(conversation.getChannelId()) == null ||
                                                        CommonData.getMessageResponse(conversation.getChannelId()).getData().getMessages().size() == 0)) {
                                            llRoot.setVisibility(View.GONE);
                                            tvNoInternet.setVisibility(View.VISIBLE);
                                        } else {
                                            setConnectionMessage(6);
                                        }
                                        pbLoading.setVisibility(View.GONE);
                                        //setConnectionMessage(3);
                                        Toast.makeText(FuguChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                                        if (messagesApi != null && messagesApi.size() > 0) {
                                            if (messagesApi.contains("getMessages")) {
                                                messagesApi.remove("getMessages");
                                                getMessages(flag, isFromOnResume);
                                            }
                                        }
                                    }
                                }
                            });
                }
            } else {
                Toast.makeText(FuguChatActivity.this, "Connection error. Try after sometime", Toast.LENGTH_SHORT).show();
                if (pageStart == 1 &&
                        (CommonData.getMessageResponse(conversation.getChannelId()) == null ||
                                CommonData.getMessageResponse(conversation.getChannelId()).getData().getMessages().size() == 0)) {
                    llRoot.setVisibility(View.GONE);
                    tvNoInternet.setVisibility(View.VISIBLE);
                }
                setConnectionMessage(3);
                pbLoading.setVisibility(View.GONE);
            }
        }
    }

    String title = "";
    boolean isbotChatAssign = false;

    private void parseMessageAPIData(FuguGetMessageResponse fuguGetMessageResponse, boolean flag, boolean isFromOnResume) throws Exception {
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                isApiRunning = false;
                totalDateItems = 0;
                if (fuguGetMessageResponse.getData() != null && !TextUtils.isEmpty(fuguGetMessageResponse.getData().getLabel())) {
                    title = fuguGetMessageResponse.getData().getLabel();
                    //tvTitle.setText(fuguGetMessageResponse.getData().getLabel());
                }

                isVideoCallEnable = false;
                isO2oChat = fuguGetMessageResponse.getData().isO2oType();

                try {

                    if (HippoApplication.getInstance().getUserData().isVideoCallEnabled() && fuguGetMessageResponse != null
                            && fuguGetMessageResponse.getData() != null
                            && fuguGetMessageResponse.getData().isAllowVideoCall()) {
                        if (isO2oChat || HippoApplication.getInstance().getUserData().getUserId().intValue() == fuguGetMessageResponse.getData().getUserId()) {
                            isVideoCallEnable = true;
                        }
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }

                isAudioCallEnable = false;
                try {
                    if (HippoApplication.getInstance().getUserData().isAudioCallEnabled()
                            && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null && fuguGetMessageResponse.getData().isAllowAudioCall()) {
                        if (isO2oChat || HippoApplication.getInstance().getUserData().getUserId().intValue() == fuguGetMessageResponse.getData().getUserId()) {
                            isAudioCallEnable = true;
                        }
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }

                try {
                    customerPhone = fuguGetMessageResponse.getData().getCustomerPhone();
                    customerName = fuguGetMessageResponse.getData().getCustomerName();
                    customerEmail = fuguGetMessageResponse.getData().getCustomerEmail();
                } catch (Exception e) {

                }

                hasBotRunning = false;
                if (fuguGetMessageResponse.getData().getDisableReply() == 1 || isP2PChat) {
                    hasBotRunning = true;
                }

                isbotChatAssign = false;
                if (fuguGetMessageResponse.getData().getDisableReply() == 1 && fuguGetMessageResponse.getData().isBotInProgress()) {
                    isbotChatAssign = true;

                }

                userId = fuguGetMessageResponse.getData().getUserId();

                if (fuguGetMessageResponse.getData().getMessages() != null) {
                    tagData = fuguGetMessageResponse.getData().getTags();
                    HippoApplication.getInstance().getUserData().setUserName(fuguGetMessageResponse.getData().getFullName());
                    onSubscribe = fuguGetMessageResponse.getData().getOnSubscribe();

                    LinkedHashMap<String, Message> tempMessages = new LinkedHashMap<>();
                    LinkedHashMap<String, Message> tempSentMessages = new LinkedHashMap<>();

                    String tempSentAtUtc = "";
                    FuguGetMessageResponse.Data messageResponseData = fuguGetMessageResponse.getData();

                    if (conversation != null && conversation.getAgentId() == null)
                        conversation.setAgentId(messageResponseData.getUserId());

                    if (conversation != null && conversation.getUserId() == null)
                        conversation.setUserId(messageResponseData.getOwnerId());

                    if (messageResponseData.getMessages().size() < messageResponseData.getPageSize()) {
                        allMessagesFetched = true;
                    }

                    //setUserData(messageResponseData);
                    if (flag) {
                        getDealInfo();
                        return;
                    }

                    int totalSize = 0;
                    if (pageStart == 1 || isFromOnResume) {
                        totalSize = fuguMessageList.size();
                        fuguMessageList.clear();
                        tempSentMessages.putAll(sentMessages);
                        sentMessages.clear();
                        dateItemCount = 0;
                    }

                    if (pageStart == 1 && !flag && !isFromOnResume) {
                        fuguMessageList.clear();
                        dateItemCount = 0;
                    }

                    Log.e(TAG, "tempSentMessages 1: " + new Gson().toJson(tempSentMessages.values()));

                    try {

                        if (isO2oChat) {
                            hideO2OViews();
                        }

                        Integer userIId = HippoApplication.getInstance().getUserData().getUserId();
                        for (int i = 0; i < messageResponseData.getMessages().size(); i++) {
                            Message messageObj = fuguGetMessageResponse.getData().getMessages().get(i);
                            boolean isSelf = false;

                            if (isO2oChat) {
                                Log.v(TAG, messageObj.getUserId() + " -- " + userIId);
                                if (messageObj.getUserId().equals(userIId)) {
                                    isSelf = true;
                                }
                            } else {
                                if (messageObj.getUserType() != null) {
                                    if (messageObj.getUserType() == UserType.AGENT.getOrdinal() || messageObj.getUserType() == UserType.SYSTEM.getOrdinal()) {
                                        isSelf = true;
                                    }
                                }
                            }

                            String localDate = dateUtils.convertToLocal(messageObj.getSentAtUtc(), inputFormat, outputFormat);
                            //String date = dateUtils.getDate(localDate);

                            if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {
                                tempMessages.put(localDate, new Message(localDate, true));
                                tempSentAtUtc = localDate;
                                dateItemCount = dateItemCount + 1;
                                totalDateItems = totalDateItems + 1;
                            }

                            String muid = messageObj.getMuid();
                            if (TextUtils.isEmpty(muid))
                                muid = messageObj.getId();

                            Message message = new Message(messageObj.getfromName(),
                                    messageObj.getUserId(),
                                    messageObj.getMessage(),
                                    messageObj.getSentAtUtc(),
                                    isSelf,
                                    messageObj.getMessageStatus(),
                                    i,
                                    messageObj.getImageUrl(),
                                    messageObj.getThumbnailUrl(),
                                    messageObj.getMessageType(),
                                    messageObj.getUserType());


                            message.setUserImage(messageObj.getUserImage());
                            message.setMessageSubType(messageObj.getMessageSubType());
                            message.setOriginalMessageType(messageObj.getMessageType());

                            if (messageObj.getCustomAction() != null) {
                                message.setCustomAction(messageObj.getCustomAction());
                            }
                            if (!TextUtils.isEmpty(messageObj.getMultiLangMessage()))
                                message.setMultiLangMessage(messageObj.getMultiLangMessage());

                            message.setIntegrationSource(messageObj.getIntegrationSource());
                            message.setMuid(muid);
                            message.setCallType(messageObj.getCallType());
                            message.setVideoCallDuration(messageObj.getVideoCallDuration());
                            message.setMessageState(messageObj.getMessageState());
                            if (messageObj.getMessageType() == FILE_MESSAGE) {
                                message.setFileExtension(messageObj.getFileExtension());
                                message.setFileName(messageObj.getFileName());
                                message.setFileSize(messageObj.getFileSize());
                                message.setFilePath(messageObj.getFilePath());
                                message.setFileUrl(messageObj.getFileUrl());
                                message.setDocumentType(messageObj.getDocumentType());
                            } else if (messageObj.getMessageType() == FEEDBACK_MESSAGE) {
                                message.setIsRatingGiven(messageObj.getIsRatingGiven());
                                message.setTotalRating(messageObj.getTotalRating());
                                message.setRatingGiven(messageObj.getRatingGiven());
                                message.setComment(messageObj.getComment());

                                message.setLineBeforeFeedback(messageObj.getLineBeforeFeedback());
                                message.setLineAfterFeedback_1(messageObj.getLineAfterFeedback_1());
                                message.setLineAfterFeedback_2(messageObj.getLineAfterFeedback_2());

                            } else if (messageObj.getMessageType() == BOT_FORM_MESSAGE) {
                                message.setContentValue(messageObj.getContentValue());
                                message.setValues(messageObj.getValues());
                                message.setId(messageObj.getId());
                            } else if (messageObj.getMessageType() == USER_CONCENT_MESSAGE) {
                                message.setContentValue(messageObj.getContentValue());
                                message.setIsActive(messageObj.getIsActive());
                                message.setSelectedBtnId(messageObj.getSelectedBtnId());
                                message.setRepliedBy(messageObj.getRepliedBy());
                                message.setRepliedUserImage(messageObj.getRepliedUserImage());
                                //message.setMessageType(USER_CONCENT_MESSAGE_LOCAL);
                            }
                            if (isO2oChat)
                                isSelf = isSelf(messageResponseData.getOwnerId(), messageResponseData.getUserId(), message.getUserId().intValue());

                            int messageViewType = getType(messageObj.getMessageType(), isSelf, messageObj.getDocumentType());
                            message.setMessageType(messageViewType);

                            if (i != 0) {
                                message.setAboveMuid(messageResponseData.getMessages().get(i - 1).getMuid());
                                message.setAboveUserId(messageResponseData.getMessages().get(i - 1).getUserId());
                            }

                            if (i + 1 < messageResponseData.getMessages().size()) {
                                message.setBelowMuid(messageResponseData.getMessages().get(i + 1).getMuid());
                                message.setBelowUserId(messageResponseData.getMessages().get(i + 1).getUserId());
                            }

                            tempMessages.put(muid, message);
                            tempSentMessages.remove(muid);
                            if (!TextUtils.isEmpty(messageObj.getMuid())) {
                                if (unsentMessageMapNew.size() > 0) {
                                    unsentMessageMapNew.remove(messageObj.getMuid());
                                }
                                if (unsentMessages.size() > 0) {
                                    unsentMessages.remove(messageObj.getMuid());
                                }
                            }


                        }
                        defaultSize = messageResponseData.getPageSize();
                    } catch (Exception e) {
                        e.printStackTrace();
                        //Logger.INSTANCE.apiResponse("/api/conversation/getMessages", e.getMessage());
                    }

                    Log.e(TAG, "tempSentMessages 2: " + new Gson().toJson(tempSentMessages.values()));
                    if (sentMessages.containsKey(tempSentAtUtc)) {
                        sentMessages.remove(tempSentAtUtc);
                        dateItemCount = dateItemCount - 1;
                    }

                    tempMessages.putAll(sentMessages);
                    sentMessages.clear();
                    sentMessages.putAll(tempMessages);

                    // put local sent messages into updated sent list
                    if (tempSentMessages.values().size() > 0) {
                        long lastMessageTime = dateUtils.getTimeInLong(messageResponseData.getMessages().get(messageResponseData.getMessages().size() - 1).getSentAtUtc());
                        if (lastMessageTime > 0) {
                            for (String key : tempSentMessages.keySet()) {
                                try {
                                    Message listItem = tempSentMessages.get(key);
                                    long localMessageTime = dateUtils.getTimeInLong(listItem.getSentAtUtc());
                                    Log.i(TAG, "localMessageTime: " + localMessageTime);
                                    if (localMessageTime > lastMessageTime) {
                                        listItem = addAboveUserId(listItem);
                                        sentMessages.put(listItem.getMuid(), listItem);
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }

                    tempSentMessages.clear();

                    fuguMessageList = new ArrayList<>();
                    fuguMessageList.addAll(sentMessages.values());

                    for (String key : unsentMessages.keySet()) {
                        Message listItem = unsentMessages.get(key);
                        String time = listItem.getSentAtUtc();
                        String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                        boolean hasDate = false;
                        if (!sentMessages.containsKey(localDate)) {
                            if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {

                                fuguMessageList.get(index).setBelowMuid(localDate);
                                fuguMessageList.get(index).setBelowUserId(-2);

                                fuguMessageList.add(new Message(localDate, true));
                                tempSentAtUtc = localDate;
                                hasDate = true;
                                //System.out.println("Date 2: " + localDate);
                            }
                        }
                        if (unsentMessageMapNew != null && unsentMessageMapNew.size() == 0) {
                            CommonData.removeUnsentMessageMapChannel(currentChannelId);
                        } else {
                            CommonData.setUnsentMessageMapByChannel(currentChannelId, unsentMessageMapNew);
                        }


                        if (unsentMessages != null && unsentMessages.size() == 0) {
                            CommonData.removeUnsentMessageChannel(currentChannelId);
                        } else {
                            CommonData.setUnsentMessageByChannel(currentChannelId, unsentMessages);
                        }

                        // update
                        try {
                            JSONObject messageJson = unsentMessageMapNew.get(key);
                            if (messageJson != null) {
                                messageJson.put("message_index", fuguMessageList.size());
                                messageJson.put(USER_IMAGE, getUserImage());
                                unsentMessageMapNew.put(key, messageJson);
                            }
                            // TODO: 2020-01-01 for above and below logic
                            //fuguMessageList.add(unsentMessages.get(key));
                            Message message = unsentMessages.get(key);
                            if (hasDate) {
                                message.setAboveUserId(-2);
                                message.setAboveMuid(tempSentAtUtc);
                            } else {
                                message.setAboveUserId(fuguMessageList.get(fuguMessageList.size() - 1).getUserId());
                                message.setAboveMuid(fuguMessageList.get(fuguMessageList.size() - 1).getMuid());
                            }
                            fuguMessageList.get(fuguMessageList.size() - 1).setBelowUserId(message.getUserId());
                            fuguMessageList.get(fuguMessageList.size() - 1).setBelowMuid(message.getMuid());

                            fuguMessageList.add(message);
                        } catch (Exception e) {

                        }
                    }


                    tvNoInternet.setVisibility(View.GONE);
                    llRoot.setVisibility(View.VISIBLE);

                    if (pageStart == 1 || isFromOnResume) {
                        showLoading = false;
                        sentAtUTC = tempSentAtUtc;
                        CommonData.setMessageResponse(conversation.getChannelId(), fuguGetMessageResponse);
                        try {
                            videoCustomerName = fuguGetMessageResponse.getData().getCustomerName();
                            videoAgentName = fuguGetMessageResponse.getData().getAgentName();
                            isChatAssignToMe = (fuguGetMessageResponse.getData().getUserId() == HippoApplication.getInstance().getUserData().getUserId().intValue()) ? true : false;
                            try {
                                if (HippoApplication.getInstance().getUserData().isVideoCallEnabled()
                                        && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null && fuguGetMessageResponse.getData().isAllowVideoCall()) {
                                    isVideoCallEnable = true;
                                }
                            } catch (Exception e) {
                            }
                            try {
                                if (HippoApplication.getInstance().getUserData().isAudioCallEnabled()
                                        && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null && fuguGetMessageResponse.getData().isAllowAudioCall()) {
                                    isAudioCallEnable = true;
                                }
                            } catch (Exception e) {
                            }

                        } catch (Exception e) {

                        }
                        type = 1;

                    } else {
                        //setConnectionMessage(0);
                        type = 2;

                    }
                    pageStart = sentMessages.values().size() + 1 - dateItemCount;
                } else {
                    allMessagesFetched = true;
                }
                /*setConnectionMessage(0);
                retryLayout.setVisibility(View.GONE);
                pbLoading.setVisibility(View.GONE);

                if (!isFromOnResume)
                    getDealInfo();

                hide();
                if (messagesApi != null && messagesApi.size() > 0) {
                    if (messagesApi.contains("getMessages")) {
                        messagesApi.remove("getMessages");
                        getMessages(flag, isFromOnResume);
                    }
                }*/

                updateUIDate(type, fuguGetMessageResponse, flag, isFromOnResume);
            }
        });
        thread.start();
    }

    int type = 0;

    private void updateUIDate(int type, FuguGetMessageResponse fuguGetMessageResponse, boolean flag, boolean isFromOnResume) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                //tvTitle.setText(title);

                // for video call
                if (isVideoCallEnable) {
                    ivVideoView.setVisibility(View.VISIBLE);
                } else {
                    ivVideoView.setVisibility(View.GONE);
                }

                // for audio call
                if (isAudioCallEnable) {
                    ivAudioView.setVisibility(View.VISIBLE);
                } else {
                    ivAudioView.setVisibility(View.GONE);
                }

                setUserDetails(false);
                //setUserData(messageResponseData);
                setUserData(fuguGetMessageResponse.getData());

                if (hasBotRunning) {
                    cvTypeMessage.setVisibility(View.GONE);
                } else {
                    cvTypeMessage.setVisibility(View.VISIBLE);
                }

                if (isbotChatAssign) {
                    botChatAssign.setVisibility(View.VISIBLE);
                } else {
                    botChatAssign.setVisibility(View.GONE);
                }


                setConnectionMessage(0);
                retryLayout.setVisibility(View.GONE);
                pbLoading.setVisibility(View.GONE);
                if (type == 1) {
                    setRecyclerViewData();
                } else if (type == 2) {
                    pbLoading.setVisibility(View.GONE);
                    if (fuguMessageAdapter != null) {
                        fuguMessageAdapter.updateList(fuguMessageList);
                        fuguMessageAdapter.notifyItemRangeInserted(0, fuguGetMessageResponse.getData().getMessages().size() + totalDateItems - 1);
                        fuguMessageAdapter.notifyItemChanged(fuguGetMessageResponse.getData().getMessages().size() + totalDateItems);
                    }
                }

                if (!isFromOnResume)
                    getDealInfo();

                hide();
                if (messagesApi != null && messagesApi.size() > 0) {
                    if (messagesApi.contains("getMessages")) {
                        messagesApi.remove("getMessages");
                        getMessages(flag, isFromOnResume);
                    }
                }

            }
        });
    }

    private String videoCustomerName = "Customer";
    private String videoAgentName = "Agent";
    private boolean isChatAssignToMe = false;
    private boolean isVideoCallEnable = false;
    private boolean isAudioCallEnable = false;

    private void setRecyclerViewData() {
        if (fuguMessageAdapter != null) {
            fuguMessageAdapter = null;
        }
        fuguMessageAdapter = new FuguMessageAdapter(FuguChatActivity.this, fuguMessageList, rvMessages, conversation, this);
        fuguMessageAdapter.setHasStableIds(true);
        fuguMessageAdapter.setAdapterCallBack(this);

        if (fuguMessageAdapter != null) {
            CallModel callModel = new CallModel();
            callModel.setCustomerName(videoCustomerName);
            callModel.setAgentName(videoAgentName);
            callModel.setChatAssignToMe(isChatAssignToMe);
            callModel.setVideoCallEnabled(isVideoCallEnable);
            callModel.setAudioCallEnabled(isAudioCallEnable);

            fuguMessageAdapter.setCallModel(callModel);
        }

        rvMessages.setAdapter(fuguMessageAdapter);
        rvMessages.setItemAnimator(null);
        //if(!isFromResume)
        rvMessages.scrollToPosition(fuguMessageList.size() - 1);

        try {
            rlScrollBottom.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }


        fuguMessageAdapter.setOnVideoCallListener(new FuguMessageAdapter.onVideoCall() {
            @Override
            public void onVideoCallClicked(int callType) {
                try {
                    FuguGetMessageResponse fuguGetMessageResponse = CommonData.getMessageResponse(conversation.getChannelId());
                    if (HippoApplication.getInstance().getUserData().isVideoCallEnabled()
                            && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null) {
                        if (fuguGetMessageResponse.getData().isAllowVideoCall() && fuguGetMessageResponse.getData().getUserId() > 0
                                && HippoApplication.getInstance().getUserData().getUserId().intValue() == fuguGetMessageResponse.getData().getUserId()) {
                            videoCallInit(callType);
                        }
                    } else if (HippoApplication.getInstance().getUserData().isAudioCallEnabled()
                            && fuguGetMessageResponse != null && fuguGetMessageResponse.getData() != null) {
                        if (fuguGetMessageResponse.getData().isAllowAudioCall() && fuguGetMessageResponse.getData().getUserId() > 0
                                && HippoApplication.getInstance().getUserData().getUserId().intValue() == fuguGetMessageResponse.getData().getUserId()) {
                            videoCallInit(callType);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });

        fuguMessageAdapter.setOnRetryListener(new FuguMessageAdapter.OnRetryListener() {
            @Override
            public void onRetry(String file, String fileType, int messageIndex, String muid) {

            }

            @Override
            public void onMessageRetry(String muid, int position) {
                try {
                    //String updatedMuid = UUID.randomUUID().toString();

                    JSONObject jsonObject = null;
                    try {
                        jsonObject = unsentMessageMapNew.get(muid);
                        if (jsonObject == null) {
                            new AlertDialog.Builder(FuguChatActivity.this)
                                    .setMessage(Restring.getString(FuguChatActivity.this, R.string.hippo_something_wrong))
                                    .setPositiveButton(Restring.getString(FuguChatActivity.this, R.string.ok), new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(final DialogInterface dialog, final int which) {
                                            onMessageCancel(muid, position);
                                        }
                                    })
                                    .setNegativeButton(Restring.getString(FuguChatActivity.this, R.string.cancel), new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialog, int which) {

                                        }
                                    })
                                    .setCancelable(false)
                                    .show();
                            return;
                        }
                    } catch (Exception e) {

                    }
                    Message listItem = unsentMessages.get(muid);

                    //fuguMessageList.remove(position);

                    jsonObject.put("is_message_expired", 0);
                    //jsonObject.put("muid", updatedMuid);
                    jsonObject.put("message_index", position);
                    String localDate = DateUtils.getInstance().getFormattedDate(new Date());
                    jsonObject.put("date_time", DateUtils.getInstance().convertToUTC(localDate));

                    listItem.setIsMessageExpired(0);
                    listItem.setMessageIndex(position);
                    listItem.setSentAtUtc(DateUtils.getInstance().convertToUTC(localDate));
                    //listItem.setMuid(updatedMuid);

                    //unsentMessageMapNew.remove(muid);
                    //unsentMessages.remove(muid);

                    unsentMessageMapNew.put(muid, jsonObject);
                    unsentMessages.put(muid, listItem);
                    fuguMessageList.remove(position);
                    fuguMessageList.add(position, listItem);

                    updateRecycler(HippoApplication.getInstance().getUserData().getUserId());
                    if (fuguMessageAdapter != null) {
                        fuguMessageAdapter.updateList(fuguMessageList);
                        //scrollListToBottom();
                    }
                    fuguMessageAdapter.notifyItemRangeChanged(position, fuguMessageList.size());
//                    scrollListToBottom();

                    sendMessages();
                } catch (Exception e) {

                }
            }

            @Override
            public void onMessageCancel(String muid, int position) {
                fuguMessageList.remove(position);
                fuguMessageAdapter.notifyItemRemoved(position);
                boolean isItemFound = false;


                for (String key : unsentMessageMapNew.keySet()) {
                    if (key.equalsIgnoreCase(muid)) {
                        isItemFound = true;
                        continue;
                    }
                    if (isItemFound) {
                        try {
                            Message listItem = unsentMessages.get(key);
                            int index = listItem.getMessageIndex();
                            listItem.setMessageIndex(index - 1);
                            JSONObject jsonObject = unsentMessageMapNew.get(key);
                            jsonObject.put("message_index", index);
                            jsonObject.put(USER_IMAGE, getUserImage());
                            unsentMessageMapNew.put(key, jsonObject);
                            unsentMessages.put(key, listItem);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                unsentMessageMapNew.remove(muid);
                unsentMessages.remove(muid);

                try {
                    String data = Prefs.with(FuguChatActivity.this).getString(KEY, "");
                    ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(data, fileuploadType);
                    if (fileuploadModels == null)
                        return;

                    for (int i = 0; i < fileuploadModels.size(); i++) {
                        FileuploadModel fileuploadModel = fileuploadModels.get(i);
                        if (fileuploadModel.getMuid().equalsIgnoreCase(muid)) {
                            fileuploadModels.remove(i);
                            String dataNew = new Gson().toJson(fileuploadModels, fileuploadType);
                            Prefs.with(FuguChatActivity.this).save(KEY, dataNew);
                            return;
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFileMessageRetry(String muid, int position) {
                try {
                    ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(FuguChatActivity.this).getString(KEY, ""), fileuploadType);
                    if (fileuploadModels == null)
                        fileuploadModels = new ArrayList<>();

                    JSONObject jsonObject = unsentMessageMapNew.get(muid);

                    if (jsonObject == null) {
                        new AlertDialog.Builder(FuguChatActivity.this)
                                .setMessage(Restring.getString(FuguChatActivity.this, R.string.hippo_something_wrong))
                                .setPositiveButton(Restring.getString(FuguChatActivity.this, R.string.ok), new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(final DialogInterface dialog, final int which) {
                                        onMessageCancel(muid, position);
                                    }
                                })
                                .setNegativeButton(Restring.getString(FuguChatActivity.this, R.string.cancel), new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {

                                    }
                                })
                                .setCancelable(false)
                                .show();
                        return;
                    }
                    Message listItem = unsentMessages.get(muid);

                    jsonObject.put("is_message_expired", 0);
                    jsonObject.put("message_index", position);
                    String localDate = DateUtils.getInstance().getFormattedDate(new Date());
                    jsonObject.put("date_time", DateUtils.getInstance().convertToUTC(localDate));

                    listItem.setIsMessageExpired(0);
                    listItem.setMessageIndex(position);
                    listItem.setSentAtUtc(DateUtils.getInstance().convertToUTC(localDate));
                    listItem.setMessageStatus(MESSAGE_UNSENT);
                    listItem.setUploadStatus(FuguAppConstant.UPLOAD_IN_PROGRESS);

                    unsentMessageMapNew.put(muid, jsonObject);
                    unsentMessages.put(muid, listItem);
                    fuguMessageList.remove(position);
                    fuguMessageList.add(position, listItem);

                    updateRecycler(HippoApplication.getInstance().getUserData().getUserId());
                    if (fuguMessageAdapter != null) {
                        fuguMessageAdapter.updateList(fuguMessageList);
                    }
                    fuguMessageAdapter.notifyItemRangeChanged(position, fuguMessageList.size());

                    if (!TextUtils.isEmpty(jsonObject.optString("local_url"))) {
                        String fileName = jsonObject.optString("file_name");
                        String fileSize = jsonObject.optString("file_size");
                        String filePath = jsonObject.optString("local_url");

                        FileuploadModel fileuploadModel = new FileuploadModel(fileName, fileSize, filePath, muid);

                        fileuploadModel.setChannelId(conversation.getChannelId());
                        fileuploadModel.setFileUploaded(false);
                        fileuploadModel.setDocumentType(jsonObject.optString("document_type"));
                        fileuploadModel.setMessageIndex(jsonObject.optInt("message_index"));
                        fileuploadModel.setMessageType(jsonObject.optInt("message_type"));
                        fileuploadModel.setMessageObject(jsonObject);

                        uploadFile(fileuploadModel);
                    } else {
                        if (isNetworkAvailable()) {
                            sendMessages();
                        }
                    }

                    //sendMessages();
                } catch (JSONException e) {

                }
            }
        });

        // Add the scroll listener
        rvMessages.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
//                Log.v("scroll value", "---> " + dy);
                if (layoutManager.findFirstVisibleItemPosition() == 0 && fuguMessageList.size() >= 25
                        && !allMessagesFetched && pbLoading.getVisibility() == View.GONE) {
                    //pbLoading.setVisibility(View.VISIBLE);
                    setConnectionMessage(5);
                    if (unsentMessageMapNew.size() == 0) {
                        getMessages();
                    }
                } else if ((layoutManager.findLastVisibleItemPosition() == fuguMessageList.size() - 2) && (fuguMessageList.size() > 2) && (dy < 0)) {
//                    Log.v("scroll value dy", "---> " + dy);
                    rlScrollBottom.setVisibility(View.VISIBLE);
                    if (scrollBottomCount > 0) {
                        tvUnread.setVisibility(View.VISIBLE);
                    } else {
                        tvUnread.setVisibility(View.GONE);
                    }
                } else if (layoutManager.findLastVisibleItemPosition() == fuguMessageList.size() - 1) {
                    rlScrollBottom.setVisibility(View.GONE);
                    tvUnread.setVisibility(View.GONE);
                    scrollBottomCount = 0;
                }
            }
        });

        rvMessages.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                position = newState;
//                Log.v("position------------------>>>>>>>>>>>>>>>>>>>>>", String.valueOf(position));
            }
        });
    }

    @Override
    public void onBackPressed() {
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
        /*if (HippoApplication.getmClient() != null) {
            if (HippoApplication.getmClient().isConnectedServer()) {
                ConnectionManager.INSTANCE.publish("/" + String.valueOf(conversation.getChannelId()), prepareMessageJson(0));
            }
        }*/
        if (HippoApplication.getInstance().getUserData()!= null) {
            publishMessage(prepareMessageJson(0), false);
        }

        super.onBackPressed();
        //HippoApplication.getInstance().trackEvent(CHAT_SCREEN, BACK_BUTTON_CLICKED, "chat_back_button");

    }

    /**
     * Method to select an image for Position in
     * the List of AddImages
     */
    public void selectImage(View view) {
        AttachmentSheetFragment bottomSheetFragment = new AttachmentSheetFragment().newInstance(false, isPrivateClicked);
        bottomSheetFragment.show(getSupportFragmentManager(), bottomSheetFragment.getTag());
        /*FileSharingUtils fileSharingUtils = new FileSharingUtils(FuguChatActivity.this, view, keyboardVisibility, imageUtils);
        fileSharingUtils.selectFiles(new FileSharingUtils.FileSharingListner() {
            @Override
            public void onCameraOpened() {
                openCamera();
            }
        });*/
    }

    public void openScreenFromSheet(int id, String text) {
        if (id == R.id.llCamera) {
            openCamera();
        } else if (id == R.id.llGallery) {
            Intent intent1 = new Intent(FuguChatActivity.this, ImagePickActivity.class);
            startActivityForResult(intent1, Constant.REQUEST_CODE_PICK_IMAGE);
        } else if (id == R.id.llAudio) {
            Intent intent3 = new Intent(FuguChatActivity.this, AudioPickActivity.class);
            startActivityForResult(intent3, Constant.REQUEST_CODE_PICK_AUDIO);
        } else if (id == R.id.llVideo) {
            Intent intent2 = new Intent(FuguChatActivity.this, VideoPickActivity.class);
            startActivityForResult(intent2, Constant.REQUEST_CODE_PICK_VIDEO);
        } else if (id == R.id.llFiles) {
            Intent intent4 = new Intent(FuguChatActivity.this, NormalFilePickActivity.class);
            intent4.putExtra(NormalFilePickActivity.SUFFIX,
                    new String[]{"txt", "xlsx", "xls", "doc", "docX", "ppt", ".pptx", "pdf",
                            "ODT", "apk", "zip", "CSV", "SQL", "PSD"});

            startActivityForResult(intent4, Constant.REQUEST_CODE_PICK_FILE);
        } else if (id == R.id.llPayment) {
            Intent paymentIntent = new Intent(FuguChatActivity.this, HippoOldPaymentActivity.class);
            startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_OLD_PAYMENT);
        } else if (id == 5) {
            sendTextMessage(text, 1);

        }
    }

    private void copingFileToLocal(FileuploadModel fileuploadModel, String folderType) {
        copingFileToLocal(fileuploadModel, folderType, null);
    }

    private void copingFileToLocal(FileuploadModel fileuploadModel, String folderType, Uri fileUri) {
        LoadingBox.showOn(FuguChatActivity.this);
        try {
            FileManager.getInstance().copyFile(this, fileuploadModel.getFilePath(), FOLDER_TYPE.get(folderType), fileuploadModel, fileUri, new FileManager.FileCopyListener() {
                @Override
                public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {
                    if (isPrivateClicked)
                        filePreview(FuguChatActivity.this, fileuploadModel);
                    else
                        sendMessage(getString(R.string.empty), FILE_MESSAGE, "", "", null, false, null, fileuploadModel.getFilePath(), fileuploadModel);
                    LoadingBox.hide();
                }

                @Override
                public void largeFileSize() {
                    showErrorMessage(Restring.getString(FuguChatActivity.this, R.string.hippo_large_file) + " "
                                    + Utils.humanReadableSize(HippoApplication.getInstance().getUserData().getMaxFileSize(), true),
                            Restring.getString(FuguChatActivity.this, R.string.ok));
                    LoadingBox.hide();
                }

                @Override
                public void onError() {
                    showErrorMessage(Restring.getString(FuguChatActivity.this, R.string.hippo_something_wrong), "OK");
                    LoadingBox.hide();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
            LoadingBox.hide();
        }
    }

    private void filePreview(FileuploadModel fileuploadModel) {
        try {
            final Dialog dialog = new Dialog(FuguChatActivity.this, android.R.style.Theme_Translucent_NoTitleBar);
            //setting custom layout to dialog
            dialog.setContentView(R.layout.file_preview_dialog);

            Window dialogWindow = dialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
            layoutParams.dimAmount = 1.0f;

            dialogWindow.getAttributes().windowAnimations = R.style.CustomHippoDialog;

            dialogWindow.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);

            dialog.setCancelable(true);
            dialog.setCanceledOnTouchOutside(false);
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                @Override
                public void onDismiss(DialogInterface dialogInterface) {
                    isAttachmentDialogOpen = false;
                    setUpMentions(etMsg);
                }
            });


            TextView tvCross = dialog.findViewById(R.id.tvCross);
            TextView filenameTV = dialog.findViewById(R.id.filenameTV);
            rvAttachmentsMentionList = dialog.findViewById(R.id.rvattachmentTagged);
            tvCross.setText(Restring.getString(FuguChatActivity.this, R.string.close));
            filenameTV.setText(fileuploadModel.getFileName());
            isAttachmentDialogOpen = true;
            ImageView ivSend = dialog.findViewById(R.id.ivSend1);
            EditTextSelectable captionET = dialog.findViewById(R.id.captionET1);
            captionET.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_internal_note));
            setUpMentions(captionET);

            if (isPrivateClicked)
                captionET.setVisibility(View.VISIBLE);
            ivSend.setVisibility(View.VISIBLE);
            ivSend.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String caption = "N/A";
                    if (!captionET.getText().toString().trim().isEmpty())
                        caption = captionET.getText().toString().trim();
                    sendMessage(caption, FILE_MESSAGE, "", "", null, true, taggedPersons(), fileuploadModel.getFilePath(), fileuploadModel);
                    isAttachmentDialogOpen = false;
                    setUpMentions(etMsg);
                    dialog.dismiss();

                }
            });
            tvCross.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    isAttachmentDialogOpen = false;
                    setUpMentions(etMsg);
                    dialog.dismiss();
                }
            });
            dialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    boolean isCameraPermission;

    private void openCamera() {
        if (imageUtils == null)
            imageUtils = new ImageUtils(FuguChatActivity.this);
        boolean isGranted = EasyPermissions.hasPermissions(this, "android.permission.CAMERA",
                "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        isCameraPermission = true;
        if (isGranted) {
            imageUtils.startCamera();
        } else {
            EasyPermissions.requestPermissions(this, Restring.getString(FuguChatActivity.this, R.string.vw_rationale_storage),
                    RC_OPEN_CAMERA, "android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {

        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Log.e(TAG, "onRequestPermissionsResult" + requestCode);

        if (grantResults.length > 0 &&
                HippoApplication.getInstance().isPermissionGranted(FuguChatActivity.this, Manifest.permission.CAMERA)
                && HippoApplication.getInstance().isPermissionGranted(FuguChatActivity.this, Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
            switch (requestCode) {
                case PERMISSION_CONSTANT_CAMERA:
                    imageUtils.startCamera();
                    break;
            }
        }
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        switch (requestCode) {

            case 100:
                tagData = HippoApplication.getInstance().tagData;

                Bundle conData = new Bundle();
                if (data != null && data.hasExtra(Constants.CHANNEL_ID)) {
                    conData.putString(Constants.CHANNEL_ID, data.getExtras().getString(Constants.CHANNEL_ID));
                    Intent intent = new Intent();
                    intent.putExtras(conData);
                    setResult(resultCode, intent);
                    onBackPressed();
                }


                break;
            case 602:
                isFromFilePicker = true;
                break;
            case Constant.REQUEST_CODE_PICK_IMAGE:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<ImageFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_IMAGE);
                    StringBuilder builder = new StringBuilder();
                    String path = null;

                    ImageFile actualfile = list.get(0);
                    String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
                    String fileExt = Utils.getExtension(actualfile.getPath());

                    String fileName = muid;
                    if (!TextUtils.isEmpty(fileExt)) {
                        actualfile.setName(fileName + "." + fileExt);
                    }
                    actualfile.setMuid(muid);
                    String localPath = Utils.setImageFullPath(this, fileName + "_" + muid + "." + fileExt);
                    actualfile.setDestinationPath(localPath);

                    if (actualfile != null)
                        compressImage(actualfile);

                    //HippoLog.v(TAG, "Image: "+builder.toString());
                }
                break;
            case Constant.REQUEST_CODE_PICK_VIDEO:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<VideoFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_VIDEO);
                    VideoFile file = list.get(0);

                    String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
                    String fileExt = Utils.getExtension(file.getPath());
//                    String fileName = file.getName();
                    String fileName = muid;//file.getName();
                    if (!TextUtils.isEmpty(fileExt)) {
//                        fileName = file.getName() + "." + fileExt;
                        fileName = fileName + "." + fileExt;
                    }
                    FileuploadModel fileuploadModel = new FileuploadModel(fileName, String.valueOf(file.getSize()), file.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Utils.humanReadableByteCount(file.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.VIDEO.toString());
                    fileuploadModel.setMessageType(FILE_MESSAGE);

                    copingFileToLocal(fileuploadModel, VIDEO_FOLDER);

                    Log.v(TAG, "File List: " + new Gson().toJson(list));
                }
                break;
            case Constant.REQUEST_CODE_PICK_AUDIO:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<AudioFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_AUDIO);
                    if (list == null || list.size() == 0)
                        return;
                    AudioFile file = list.get(0);
                    sendAudioFile(list.get(0).getPath(), list.get(0).getSize());
                    Log.v(TAG, "File List: " + new Gson().toJson(list));
                }
                break;
            case Constant.REQUEST_CODE_PICK_FILE:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<NormalFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_FILE);
                    StringBuilder builder = new StringBuilder();
                    NormalFile file = list.get(0);

                    String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
                    String fileExt = Utils.getExtension(file.getPath());
//                    String fileName = file.getName();
//                    if (!TextUtils.isEmpty(fileExt)) {
//                        fileName = file.getName() + "." + fileExt;
//                    }

                    String fileName = muid;
                    if (!TextUtils.isEmpty(fileExt)) {
                        fileName = fileName + "." + fileExt;
                    }

                    String filePath = "";

                    FileuploadModel fileuploadModel = new FileuploadModel(fileName, String.valueOf(file.getSize()), file.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Utils.humanReadableByteCount(file.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.FILE.toString());
                    fileuploadModel.setMessageType(FILE_MESSAGE);

                    Log.v(TAG, "File: " + builder.toString());
                    Log.v(TAG, "File List: " + new Gson().toJson(list));

                    if (file.getUri() != null && !file.getUri().isEmpty())
                        copingFileToLocal(fileuploadModel, DOC_FOLDER, Uri.parse(file.getUri()));
                    else
                        copingFileToLocal(fileuploadModel, DOC_FOLDER, null);

                }
                break;
            case Constant.REQUEST_CODE_TAKE_IMAGE:
                if (resultCode == RESULT_OK) {
                    String path = CommonData.getTime();
                    ImageFile imageFile = new ImageFile();
                    imageFile.setPath(path);
                    imageFile.setDestinationPath(path);
                    imageFile.setMuid(CommonData.getImageMuid());
                    imageFile.setSize(new File(path).length());
                    imageFile.setName(Utils.extractFileNameWithSuffix(path));
                    Log.d(TAG, "camera imageFile: " + new Gson().toJson(imageFile));
                    compressImage(imageFile);
                }
                break;
            case Config.REQUEST_CODE_PICK_PAYMENT:
                if (resultCode == RESULT_OK) {
                    ArrayList<PaymentData> paymentData = (ArrayList<PaymentData>) data.getSerializableExtra("data");
                    sendPaymentRequest(paymentData);
                }
                break;

            case Config.REQUEST_CODE_PICK_OLD_PAYMENT:
                if (resultCode == RESULT_OK) {
                    OldPaymentData paymentData = (OldPaymentData) data.getSerializableExtra("data");
                    Log.v(TAG, "Data = " + new Gson().toJson(paymentData));
//                    sendPaymentRequest(paymentData);
                    sendOldPaymentRequest(paymentData);
                }
                break;
            case 22:
                prescriptionBottomSheetFragment.dismiss();
                if (resultCode == RESULT_OK) {
                    PrescriptionUrlData prescriptionUrlData = (PrescriptionUrlData) data.getExtras().getParcelable("PrescriptionUrlData");
                    FileuploadModel fileuploadModel = new FileuploadModel(prescriptionUrlData.getData().getFileName()
                            , "", "", "");
                    fileuploadModel.setDocumentType("pdf");

                    sendMessage(getString(R.string.empty), FILE_PDF_MESSAGE, prescriptionUrlData.getData().getUrl(), prescriptionUrlData.getData().getUrl(), null, false, null, "", fileuploadModel);

                }
                break;
        }
    }

    private void sendOldPaymentRequest(OldPaymentData paymentData) {
        /*if (channelId.compareTo(-1L) == 0) {
            if (mClient.isConnectedServer()) {
                if (!isConversationCreated) {
                    conversation.setChannelStatus(ChannelStatus.OPEN.getOrdinal());
                    CreateChannelAttribute attribute = new CreateChannelAttribute.Builder()
                            .setFuguGetMessageResponse(mFuguGetMessageResponse)
                            .setConversationParams(fuguCreateConversationParams)
                            .setMessageType(ACTION_MESSAGE_NEW)
                            .build();

                    createConversation(attribute);
                    //createConversation();
                    CommonData.setPaymentData(paymentData);
                    return;
                }
            } else {
                mClient.connectServer();
                Toast.makeText(FuguChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                return;
            }
        }*/
        String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
        ArrayList<DescriptionObject> descriptionObjects = new ArrayList<>();

        try {

            float totalAmount = 0;
            String localDate = DateUtils.getInstance().getFormattedDate(new Date());
            JSONObject messageJson = new JSONObject();
            messageJson.put("muid", muid);
            messageJson.put("is_message_expired", 0);
            messageJson.put("message", "");
            messageJson.put(MESSAGE_TYPE, 19);
            messageJson.put("message_status", MESSAGE_UNSENT);
            messageJson.put(DATE_TIME, DateUtils.getInstance().convertToUTC(localDate));
            messageJson.put("message_index", fuguMessageList.size() - 1);
            messageJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
            messageJson.put(USER_TYPE, ANDROID_USER);
            messageJson.put(FULL_NAME, HippoApplication.getInstance().getUserData().getFullName());
            messageJson.put(USER_ID, String.valueOf(userId));
            messageJson.put(DATE_TIME, DateUtils.getInstance().convertToUTC(localDate));

            JSONObject customAction = new JSONObject();
            customAction.put("title", paymentData.getTitle());

            customAction.put("currency_symbol", paymentData.getCurrencySymbol());


            JSONArray jsonArray = new JSONArray();
            try {
                for (int a = 0; a < paymentData.getPaymentModelData().size(); a++) {
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("header", paymentData.getPaymentModelData().get(a).getItemDescription());
                    jsonObj.put("content", paymentData.getCurrencySymbol() + " " + paymentData.getPaymentModelData().get(a).getPrice());

                    jsonArray.put(jsonObj);
                    DescriptionObject descriptionObject = new DescriptionObject();
                    descriptionObject.setHeader(paymentData.getPaymentModelData().get(a).getItemDescription());
                    descriptionObject.setContent(paymentData.getCurrencySymbol() + " " + paymentData.getPaymentModelData().get(a).getPrice());
                    descriptionObjects.add(descriptionObject);

                    totalAmount = totalAmount + Float.parseFloat(paymentData.getPaymentModelData().get(a).getPrice());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            customAction.put("amount", totalAmount);

            JSONArray actionButtons = new JSONArray();
            JSONObject actionButtonObj = new JSONObject();

            JSONObject buttonAction = new JSONObject();
            buttonAction.put("title", paymentData.getTitle());
            buttonAction.put("amount", totalAmount);
            buttonAction.put("currency_symbol", paymentData.getCurrencySymbol());
            buttonAction.put("description", jsonArray);
            buttonAction.put("reference", "");
            buttonAction.put("action_type", "NATIVE_ACTIVITY");
            buttonAction.put("transaction_id", "");

            actionButtonObj.put("button_text", "Pay");
            actionButtonObj.put("button_action", buttonAction);

            actionButtons.put(actionButtonObj);
            customAction.put("action_buttons", actionButtons);
            customAction.put("description", jsonArray);
            messageJson.put("custom_action", customAction);
            messageJson.put(USER_IMAGE, getUserImage());
//            if(HippoConfig.getInstance().getBotId() != null && HippoConfig.getInstance().getBotId() > 0) {
//                messageJson.put(BOT_GROUP_ID, HippoConfig.getInstance().getBotId());
//            }
            Log.v("custom_action", "custom_action = " + new Gson().toJson(messageJson));
            unsentMessageMapNew.put(muid, messageJson);
            if (conversation != null && conversation.getChannelId() != null)
                CommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

            if (!messageSendingRecursion && isNetworkAvailable()) {
                sendMessages();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            String localDate = DateUtils.getInstance().getFormattedDate(new Date());
            String localDate1 = DateUtils.getInstance().getFormattedDate(new Date(), outputFormat);

            if (!sentAtUTC.equalsIgnoreCase(localDate1)) {
                fuguMessageList.add(new Message(localDate1, true));
                sentAtUTC = localDate1;
                dateItemCount = dateItemCount + 1;
            }

            //Log.d("userName in SDK", "addMessageToList " + userName);


            /*Message messageObj = new Message(0,
                    HippoApplication.getInstance().getUserData().getFullName(),
                    userId,
                    "",
                    DateUtils.getInstance().convertToUTC(localDate),
                    true,
                    MESSAGE_UNSENT,
                    index,
                    "",
                    "",
                    19,
                    muid);*/

            Message messageObj = new Message(HippoApplication.getInstance().getUserData().getFullName(),
                    HippoApplication.getInstance().getUserData().getUserId(),
                    "message",
                    DateUtils.getInstance().convertToUTC(localDate),
                    true,
                    MESSAGE_UNSENT,
                    fuguMessageList.size(),
                    "",
                    "",
                    19,
                    UserType.AGENT.getOrdinal());

            messageObj.setUserImage(getUserImage());
            messageObj.setMuid(muid);
            messageObj.setIsMessageExpired(0);
            messageObj.setIntegrationSource(0);

            messageObj.setUserType(0);
            messageObj.setOriginalMessageType(19);
            boolean isSelf = true;
//            if (isO2oChat) {
//                isSelf = isSelf(ownerId, HippoApplication.getInstance().getUserData().getUserId());
//            }
            int localMessageType = getType(19, isSelf, "");
            messageObj.setMessageType(localMessageType);

            CustomAction customAction = new CustomAction();
            customAction.setTitle(paymentData.getTitle());
            customAction.setDescriptionObjects(descriptionObjects);

            ArrayList<ActionButtonModel> actionButtonObject = new ArrayList<>();
            ActionButtonModel buttonModel = new ActionButtonModel();
            buttonModel.setButtonText("Pay");
            actionButtonObject.add(buttonModel);

            customAction.setActionButtons(actionButtonObject);
            messageObj.setCustomAction(customAction);

            messageObj.setMuid(muid);
            messageObj.setIntegrationSource(0);
            messageObj.setIsMessageExpired(0);
            messageObj.setLocalImagePath(null);
            messageObj.setMessageState(MESSAGE_UNSENT);

            fuguMessageList.add(messageObj);
            unsentMessages.put(muid, messageObj);
            etMsg.setText("");
            updateRecycler(HippoApplication.getInstance().getUserData().getUserId());

            scrollListToBottom();

            Log.d("messageObj", "messageObj = " + new Gson().toJson(messageObj));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void filePreview(Activity activity, final FileuploadModel fileuploadModel) {
        try {
            final Dialog dialog = new Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar);
            //setting custom layout to dialog
            dialog.setContentView(R.layout.file_privew_dialog);

            Window dialogWindow = dialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
            layoutParams.dimAmount = 1.0f;

            dialogWindow.getAttributes().windowAnimations = R.style.CustomHippoDialog;

            dialogWindow.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);

            dialog.setCancelable(true);
            dialog.setCanceledOnTouchOutside(false);


            TextView tvCross = dialog.findViewById(R.id.tvCross);
            TextView filenameTV = dialog.findViewById(R.id.filenameTV);
            tvCross.setText(Restring.getString(FuguChatActivity.this, R.string.close));
            filenameTV.setText(fileuploadModel.getFileName());

            ImageView ivSend = dialog.findViewById(R.id.ivSend1);
            EditTextSelectable captionET = dialog.findViewById(R.id.captionET1);
            captionET.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_normal_message));
            rvAttachmentsMentionList = dialog.findViewById(R.id.rvattachmentTagged);

            if (isPrivateClicked) {
                captionET.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_internal_note));
                setUpMentions(captionET);
            } else {
                captionET.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_normal_message));
            }

            isAttachmentDialogOpen = true;
            dialog.setOnDismissListener(dialogInterface -> {
                setUpMentions(etMsg);
                isAttachmentDialogOpen = false;

            });


            ivSend.setVisibility(View.VISIBLE);
            captionET.setVisibility(View.VISIBLE);
            ivSend.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String message = "";
                    if (!captionET.getText().toString().trim().isEmpty()) {
                        message = captionET.getText().toString().trim();
                    }
                    sendMessage(message, FILE_MESSAGE, "", "", null, false, null, fileuploadModel.getFilePath(), fileuploadModel);

                    dialog.dismiss();
                }
            });
            tvCross.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dialog.dismiss();
                }
            });
            dialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    public void compressImage(final ImageFile actualFile) {
        try {
            int screenWidth = getResources().getDisplayMetrics().widthPixels;
            if (screenWidth > 1024)
                screenWidth = 1024;

            new Compressor()
                    .setMaxWidth(screenWidth)
                    .setMaxHeight(screenWidth)
                    .setQuality(75)
                    .setCompressFormat(Bitmap.CompressFormat.JPEG)
                    .setListener(new CompressorListener() {
                        @Override
                        public void onImageCompressed(File file, String path, ImageFile imageFile, ArrayList<Integer> integers) {
                            showImageDialog(FuguChatActivity.this, file, path, imageFile, integers);
                        }
                    })
                    .compressToFile(this, new File(actualFile.getPath()), actualFile);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showImageDialog(Context activity, File imgUrl, final String image, final ImageFile imageFile, final ArrayList<Integer> integers) {

        try {
            final Dialog dialog = new Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar);
            //setting custom layout to dialog
            dialog.setContentView(R.layout.image_dialog);

            Window dialogWindow = dialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
            layoutParams.dimAmount = 1.0f;

            dialogWindow.getAttributes().windowAnimations = R.style.CustomHippoDialog;

            dialogWindow.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);

            dialog.setCancelable(true);
            dialog.setCanceledOnTouchOutside(false);
            ZoomageView ivImage = dialog.findViewById(R.id.ivImage);
            ivCropImage = ivImage;
            AppCompatImageView ivCrop = dialog.findViewById(R.id.iv_crop);
            rvAttachmentsMentionList = dialog.findViewById(R.id.rvattachmentTagged);
            isAttachmentDialogOpen = true;
            dialog.setOnDismissListener(dialogInterface -> {
                setUpMentions(etMsg);
                isAttachmentDialogOpen = false;

            });

            RequestOptions options = new RequestOptions()
                    .centerCrop()
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .placeholder(R.drawable.hippo_placeholder)
                    .error(R.drawable.hippo_placeholder)
                    .fitCenter()
                    .priority(Priority.HIGH)
                    .transforms(new CenterCrop(), new RoundedCorners(3));

            Glide.with(activity).asBitmap()
                    .apply(options)
                    .load(imgUrl)
                    .into(ivImage);
            AppCompatImageView tvCross = dialog.findViewById(R.id.tvCross);

            ImageView ivSend = dialog.findViewById(R.id.ivSend1);
            EditTextSelectable captionET = dialog.findViewById(R.id.captionET1);
            if (isPrivateClicked) {
                captionET.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_internal_note));
                setUpMentions(captionET);
            } else {
                captionET.setHint(Restring.getString(FuguChatActivity.this, R.string.type_a_normal_message));
            }

            if (isPrivateClicked)
                captionET.setVisibility(View.VISIBLE);
            ivSend.setVisibility(View.VISIBLE);
            captionET.setVisibility(View.VISIBLE);
            ivCrop.setOnClickListener(crop ->{
                CropImageContractOptions contractOptions =
                        new CropImageContractOptions(Uri.fromFile(imgUrl), new CropImageOptions())
                        .setScaleType(CropImageView.ScaleType.FIT_CENTER)
                        .setOutputUri(Uri.fromFile(imgUrl));
                cropImage.launch(contractOptions);
            });
            ivSend.setOnClickListener(v -> {
                String muid = Utils.getMuid(imageFile.getName());
                if (!TextUtils.isEmpty(imageFile.getMuid())) {
                    muid = imageFile.getMuid();
                }
                FileuploadModel fileuploadModel = new FileuploadModel(imageFile.getName(), String.valueOf(imageFile.getSize()), imageFile.getPath(), muid);
                fileuploadModel.setFileSizeReadable(Utils.humanReadableByteCount(imageFile.getSize(), true));
                fileuploadModel.setDocumentType(DocumentType.IMAGE.toString());
                fileuploadModel.setMessageType(IMAGE_MESSAGE);
                fileuploadModel.setDimns(integers);
                fileuploadModel.setMuid(imageFile.getMuid());
                Log.v(TAG, "fileuploadModel: " + new Gson().toJson(fileuploadModel));
                if (isPrivateClicked) {
                    String captionText = "N/A";

                    if (!captionET.getText().toString().trim().isEmpty())
                        captionText = captionET.getText().toString().trim();

                    if (isPrivateClicked)
                        sendMessage(captionText, IMAGE_MESSAGE, "", "", null, true, taggedPersons(), imageFile.getPath(), fileuploadModel);
//                        sendMessage(getString(R.string.empty), IMAGE_MESSAGE, "", "", null, true, null, imageFile.getPath(), fileuploadModel);

                    else
                        sendMessage(getString(R.string.empty), IMAGE_MESSAGE, "", "", null, false, null, imageFile.getPath(), fileuploadModel);
                    setUpMentions(etMsg);
                    isAttachmentDialogOpen = false;
                } else {
                    String message = "";
                    if (!captionET.getText().toString().trim().isEmpty())
                        message = captionET.getText().toString().trim();
                    sendMessage(message, IMAGE_MESSAGE, "", "", null, false, null, imageFile.getPath(), fileuploadModel);

                }


                dialog.dismiss();
            });
            tvCross.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    setUpMentions(etMsg);
                    isAttachmentDialogOpen = false;
                    dialog.dismiss();
                }
            });
            dialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private final ActivityResultLauncher<CropImageContractOptions> cropImage =
            registerForActivityResult(new CropImageContract(), this::onCropImageResult);

    public void onCropImageResult(@NonNull CropImageView.CropResult result) {
        if (result.isSuccessful()) {
            Uri imgUri = result.getUriContent();
            Glide.with(this)
                    .load(imgUri)
                    .into(ivCropImage);

        }
    }
    private void performMarkConversation() {
//        String message = (status == MessageMode.OPEN_CHAT.getOrdinal() ? Restring.getString(FuguChatActivity.this, R.string.reopen_chat_message)
//                : Restring.getString(FuguChatActivity.this, R.string.close_chat_message));
//        String positive = (status == MessageMode.OPEN_CHAT.getOrdinal() ? Restring.getString(FuguChatActivity.this, R.string.reopen_caps)
//                : Restring.getString(FuguChatActivity.this, R.string.close));
        String message = Restring.getString(FuguChatActivity.this, R.string.close_chat_message);
        String positive = Restring.getString(FuguChatActivity.this, R.string.close);


        DialogPop dialogPop = new DialogPop();
        dialogPop.alertPopupWithTwoButton(FuguChatActivity.this, "", message, positive
                , Restring.getString(FuguChatActivity.this, R.string.cancel), new DialogPop.Callback() {
                    @Override
                    public void onPositiveClick() {
                        apiMarkConversation();
                    }

                    @Override
                    public void onNegativeClick() {

                    }
                });

        /*if (status == MessageMode.OPEN_CHAT.getOrdinal()) {
            //HippoApplication.getInstance().trackEvent(GAEvents.INFO_SCREEN, GAEvents.REOPEN_BUTTON_CLICKED, "info_reopen");
        } else {
            //HippoApplication.getInstance().trackEvent(GAEvents.INFO_SCREEN, GAEvents.CLOSE_BUTTON_CLICKED, "info_closed");
        }*/
    }

    private void apiMarkConversation() {
        apiMarkConversation("");
    }

    private void apiMarkConversation(String notes) {
        if (isNetworkAvailable()) {
            CommonParams.Builder builder = new CommonParams.Builder();
            builder.add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken());
            builder.add(Constants.CHANNEL_ID, String.valueOf(conversation.getChannelId()));
            builder.add(Constants.EN_USER_ID, HippoApplication.getInstance().getUserData().getEnUserId());
            builder.add(Constants.STATUS, String.valueOf(status));
            builder.add(Constants.CREATED_BY, HippoApplication.getInstance().getUserData().getFullName());
            if (!TextUtils.isEmpty(notes)) {
                builder.add(Constants.CLOSING_NOTES, notes);
            }
            if (!TextUtils.isEmpty(dealId)) {
                try {
                    if (HippoApplication.getInstance().getUserData().getBusinessProperty().getCrmIntegrationType().intValue() == 1)
                        builder.add(Constants.DEAL_ID, dealId);
                } catch (Exception e) {

                }
            }

            CommonParams commonParams = builder.build();
            Logger.INSTANCE.apiRequest("/api/conversation/markConversation", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().markConversation(commonParams.getMap())
                    .enqueue(new ResponseResolver<GetConversationResponse>(FuguChatActivity.this, true, true) {
                        @Override
                        public void success(GetConversationResponse loginResponse) {
                            Logger.INSTANCE.apiResponse("/api/conversation/markConversation", "");
                            try {
                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode()) {
                                    Bundle conData = new Bundle();
                                    conData.putString(Constants.CHANNEL_ID, String.valueOf(conversation.getChannelId()));
                                    Intent intent = new Intent();
                                    intent.putExtras(conData);
                                    if (conversation.getStatus() == MessageMode.OPEN_CHAT.getOrdinal()) {
                                        setResult(MessageMode.CLOSED_CHAT.getOrdinal(), intent);
                                    } else {
                                        setResult(MessageMode.OPEN_CHAT.getOrdinal(), intent);
                                    }

                                    onBackPressed();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                                Logger.INSTANCE.apiFailed("/api/conversation/markConversation", e.getLocalizedMessage());
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/conversation/markConversation", error.getMessage());
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * Set up mentions
     */
    private void setUpMentions(EditTextSelectable textET) {
        mentions = new Mentions.Builder(this, textET)
                .suggestionsListener(this)
                .queryListener(this)
                .highlightColor(R.color.colorPrimary)
                .build();
    }


    public void getTaggedText(GetAgentsResponse.Agents tagText, boolean isFromTag) {

        if (isPrivateClicked && isFromTag) {

            final Member mention = new Member();
            //String name = "<font color='#007BFF' contenteditable='false' >" + "@" + user.getName() + " " + "</font>";
            mention.setMentionName("@" + tagText.getFullName());
            mention.setUserId(tagText.getUserId());

            mentions.insertMention(mention);
        }
    }

    private String sendPrivateNote() {
        String editText = etMsg.getText().toString();
        String finalString = editText;
        return finalString;
    }

    private ArrayList<Integer> taggedPersons() {
        ArrayList<Integer> tagId = new ArrayList<>();
        if (mentions != null) {
            for (Mentionable member : mentions.getInsertedMentions()) {
                tagId.add((int) member.getUserId());
            }
        }

        // add elements to al, including duplicates
        Set<Integer> hs = new HashSet<>();
        hs.addAll(tagId);
        tagId.clear();
        tagId.addAll(hs);
        //HippoApplication.getInstance().trackEvent(GAEvents.CHAT_SCREEN, "Tagged send", "tag_agent_send");
        return tagId;
    }


    private void sendReadAcknowledgement() {
        if (conversation.getChannelId() > -1) {
            publishOnFaye(getString(R.string.empty), 0,
                    getString(R.string.empty), getString(R.string.empty), READ_MESSAGE);

        }
    }

    private void visibilityGone(RecyclerView rv) {
        rv.setVisibility(View.GONE);
        rv.animate().translationX(0.0f).setDuration(100000);
        viewBlack.setVisibility(View.GONE);
    }

    private void dialogShowAgents(GetAgentsResponse getAgentsResponse) {
        final Dialog dialog = new Dialog(FuguChatActivity.this, android.R.style.Theme_Translucent_NoTitleBar);
        dialog.getWindow().getAttributes().windowAnimations = R.style.Animations_LoadingDialogBottomIn;
        dialog.setContentView(R.layout.dialog_show_agents);
        WindowManager.LayoutParams layoutParams = dialog.getWindow().getAttributes();
        layoutParams.dimAmount = 0.6f;
        dialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
        ShowAgentsAdapter showAgentsAdapter;
        ImageView ivClose = (ImageView) dialog.findViewById(R.id.ivClose);
        RecyclerView rvAgents = (RecyclerView) dialog.findViewById(R.id.rvAgents);
        rvAgents.setLayoutManager(new LinearLayoutManager(FuguChatActivity.this));
        rvAgents.setItemAnimator(new DefaultItemAnimator());
        rvAgents.setHasFixedSize(false);
        ArrayList<GetAgentsResponse.Agents> agentsList = new ArrayList<>();
        if (getAgentsResponseData != null) {
            for (GetAgentsResponse.Agents agent : getAgentsResponse.getData().getAgents()) {
                if (agent.getStatus() == 1) {
                    agentsList.add(agent);
                }
                if (conversation.getAgentId() != null) {
                    if (conversation.getAgentId().equals(HippoApplication.getInstance().getUserData().getUserId())
                            && agent.getUserId() == HippoApplication.getInstance().getUserData().getUserId()) {
                        agentsList.remove(agent);
                    }
                }
            }
        }
        showAgentsAdapter = new ShowAgentsAdapter(FuguChatActivity.this, agentsList, new ChatOptionFragment.Callback() {
            @Override
            public void onClick(int position, GetAgentsResponse.Agents agent) {
                performAgentClick(agent, dialog);
            }
        });
        rvAgents.setAdapter(showAgentsAdapter);
        ivClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });
        dialog.show();
    }

    private void performAgentClick(final GetAgentsResponse.Agents agent, final Dialog dialog) {
        DialogPop dialogPop = new DialogPop();
        dialogPop.alertPopupWithTwoButton(FuguChatActivity.this, "", Restring.getString(FuguChatActivity.this, R.string.assign_agent_message),
                Restring.getString(FuguChatActivity.this, R.string.confirm), Restring.getString(FuguChatActivity.this, R.string.cancel), new DialogPop.Callback() {
                    @Override
                    public void onPositiveClick() {
                        apiAssignAgent(agent.getUserId());
                        dialog.dismiss();
                    }

                    @Override
                    public void onNegativeClick() {
                    }
                });
    }

    private void performAgentClick(final int userId, final boolean forceAssign) {
        DialogPop dialogPop = new DialogPop();
        dialogPop.alertPopupWithTwoButton(FuguChatActivity.this, "", Restring.getString(FuguChatActivity.this, R.string.self_assign_agent_message),
                Restring.getString(FuguChatActivity.this, R.string.confirm), Restring.getString(FuguChatActivity.this, R.string.cancel), new DialogPop.Callback() {
                    @Override
                    public void onPositiveClick() {
                        apiAssignAgent(userId, forceAssign);
                    }

                    @Override
                    public void onNegativeClick() {
                    }
                });
    }


    private void apiAssignAgent(int userId) {
        apiAssignAgent(userId, false);
    }

    private void apiAssignAgent(int userId, boolean forceAssign) {
        if (isNetworkAvailable()) {
            CommonParams commonParams = new CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                    .add(Constants.CHANNEL_ID, String.valueOf(conversation.getChannelId()))
                    .add(Constants.USER_ID, String.valueOf(userId))
                    .build();
            Logger.INSTANCE.apiRequest("/api/agent/assignAgent", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().assignAgent(commonParams.getMap())
                    .enqueue(new ResponseResolver<GetConversationResponse>(FuguChatActivity.this, true, true) {
                        @Override
                        public void success(GetConversationResponse loginResponse) {
                            Logger.INSTANCE.apiResponse("/api/agent/assignAgent", "");
                            try {
                                if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode()) {
                                    if (forceAssign) {
                                        // TODO: 2019-08-22 show bottom view and disable bot running

                                    } else {
                                        Bundle conData = new Bundle();
                                        conData.putString(Constants.CHANNEL_ID, String.valueOf(conversation.getChannelId()));
                                        Intent intent = new Intent();
                                        intent.putExtras(conData);
                                        setResult(Overlay.ASSIGNMENT.getOrdinal(), intent);
                                        onBackPressed();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                                Logger.INSTANCE.apiFailed("/api/agent/assignAgent", e.getLocalizedMessage());
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/agent/assignAgent", error.getMessage());
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    private void scrollListToBottom() {
        try {
            rvMessages.scrollToPosition(fuguMessageList.size() - 1);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void expand(final View v) {
        if (isO2oChat) {
            rlBulbulActions.setVisibility(View.GONE);
            rlDealViewNotes.setVisibility(View.GONE);
            //extraView.setVisibility(View.VISIBLE);
        }
//        v.setVisibility(View.VISIBLE);
//        appbarLayout.setExpanded(true, true);

        //HippoApplication.getInstance().trackEvent(GAEvents.CHAT_SCREEN, GAEvents.OPEN_SHORT_INFO, "short_info_opened");
        v.measure(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT);
        final int targetHeight = v.getMeasuredHeight();

        // Older versions of android (pre API 21) cancel animations for views with a height of 0.
        v.getLayoutParams().height = 1;
        v.setVisibility(View.VISIBLE);
        Animation a = new Animation() {
            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                v.getLayoutParams().height = interpolatedTime == 1
                        ? WindowManager.LayoutParams.WRAP_CONTENT
                        : (int) (targetHeight * interpolatedTime);
                v.requestLayout();
            }

            @Override
            public boolean willChangeBounds() {
                return true;
            }
        };

        // 1dp/ms
        a.setDuration((int) (targetHeight / v.getContext().getResources().getDisplayMetrics().density));
        v.startAnimation(a);
        //isTouched = true;
    }

    private String customerPhone, customerName, customerEmail;

    private void setUserDetails() {
        setUserDetails(true);
    }

    private void setUserDetails(boolean flag) {
        llCollapsingLayout.setVisibility(View.GONE);
        if (TextUtils.isEmpty(customerPhone)) {
            etCustPhone.setVisibility(View.GONE);
            copyPhone.setVisibility(View.GONE);
        } else {
            etCustPhone.setVisibility(View.VISIBLE);
            copyPhone.setVisibility(View.VISIBLE);
            btnViewDetails.setVisibility(View.VISIBLE);
            etCustPhone.setText(customerPhone);

            PhoneFunctions phoneFunctions = new PhoneFunctions();
            String phone = "";
            if (customerPhone.substring(0, 1).equals("+")) {
                phone = customerPhone.substring(1, customerPhone.length());
            }
            String countryCode = phoneFunctions.getCountry(getResources().getStringArray(R.array.CountryCodes)
                    , phone);
            if (countryCode != null && !countryCode.isEmpty()) {
                etCustPhone.setText("+" + countryCode + "-" + customerPhone.substring(countryCode.length() + 1));
            }
        }

        if (!TextUtils.isEmpty(customerName)) {
            if (conversation.getLabel() != null && customerName.equals(conversation.getLabel())) {
                etCustName.setVisibility(View.GONE);
                //tvTitle.setText(customerName);
            } else {
                btnViewDetails.setVisibility(View.VISIBLE);
            }
        } else {
            etCustName.setVisibility(View.GONE);
        }

        if (TextUtils.isEmpty(customerEmail)) {
            etCustEmail.setVisibility(View.GONE);
            copyEmail.setVisibility(View.GONE);
        } else {
            etCustEmail.setVisibility(View.VISIBLE);
            copyEmail.setVisibility(View.VISIBLE);
            btnViewDetails.setVisibility(View.VISIBLE);
            etCustEmail.setText(customerEmail);

            if (flag)
                getDealInfo();
        }
    }

    private void setUserData(FuguGetMessageResponse.Data messageResponseData) {
        llCollapsingLayout.setVisibility(View.GONE);


        if (!TextUtils.isEmpty(messageResponseData.getLineBeforeFeedback()))
            CommonData.setlineBeforeFeedback("lineBeforeFeedback", messageResponseData.getLineBeforeFeedback());
        if (!TextUtils.isEmpty(messageResponseData.getLineAfterFeedback_1()))
            CommonData.setlineBeforeFeedback("lineAfterFeedback_1", messageResponseData.getLineAfterFeedback_1());
        if (!TextUtils.isEmpty(messageResponseData.getLineAfterFeedback_2()))
            CommonData.setlineBeforeFeedback("lineAfterFeedback_2", messageResponseData.getLineAfterFeedback_2());


        if ((messageResponseData.getCustomerPhone() == null
                || messageResponseData.getCustomerPhone().isEmpty() || messageResponseData.getCustomerPhone().equals("")) &&
                (messageResponseData.getCustomerEmail() == null
                        || messageResponseData.getCustomerEmail().isEmpty() || messageResponseData.getCustomerEmail().equals("")) &&
                (messageResponseData.getCustomerAddress() == null
                        || messageResponseData.getCustomerAddress().isEmpty() || messageResponseData.getCustomerAddress().equals(""))) {
            //collapse(llCollapsingLayout);
            isVisibleProfile = true;
            // ivNextIcon.setVisibility(View.VISIBLE);
        } else {
            isVisibleProfile = false;
            if (messageResponseData.getCustomerPhone() == null || messageResponseData.getCustomerPhone().isEmpty() || messageResponseData.getCustomerPhone().equals("")) {
                etCustPhone.setVisibility(View.GONE);
                copyPhone.setVisibility(View.GONE);
            } else {
                // llCollapsingLayout.setVisibility(View.VISIBLE);
                etCustPhone.setVisibility(View.VISIBLE);
                copyPhone.setVisibility(View.VISIBLE);
                btnViewDetails.setVisibility(View.VISIBLE);
                etCustPhone.setText(messageResponseData.getCustomerPhone());

                PhoneFunctions phoneFunctions = new PhoneFunctions();
                String phone = "";
                if (messageResponseData.getCustomerPhone().substring(0, 1).equals("+")) {
                    phone = messageResponseData.getCustomerPhone().substring(1, messageResponseData.getCustomerPhone().length());
                }
                String countryCode = phoneFunctions.getCountry(getResources().getStringArray(R.array.CountryCodes)
                        , phone);
                if (countryCode != null && !countryCode.isEmpty()) {
                    etCustPhone.setText("+" + countryCode + "-" + messageResponseData.getCustomerPhone().substring(countryCode.length() + 1));
                }

            }

            if (messageResponseData.getCustomerName() != null || !messageResponseData.getCustomerName().isEmpty() || !messageResponseData.getCustomerName().equals("")) {
                if (conversation.getLabel() != null && messageResponseData.getCustomerName().equals(conversation.getLabel())) {
                    etCustName.setVisibility(View.GONE);
                    //tvTitle.setText(messageResponseData.getCustomerName());
                } else {
                    btnViewDetails.setVisibility(View.VISIBLE);
                }
            } else {
                etCustName.setVisibility(View.GONE);
            }

            if (messageResponseData.getCustomerEmail() == null || messageResponseData.getCustomerEmail().isEmpty() || messageResponseData.getCustomerEmail().equals("")) {
                etCustEmail.setVisibility(View.GONE);
                copyEmail.setVisibility(View.GONE);
            } else {
                //llCollapsingLayout.setVisibility(View.VISIBLE);
                etCustEmail.setVisibility(View.VISIBLE);
                copyEmail.setVisibility(View.VISIBLE);
                btnViewDetails.setVisibility(View.VISIBLE);
                etCustEmail.setText(messageResponseData.getCustomerEmail());
            }

            if (messageResponseData.getCustomerAddress() == null || messageResponseData.getCustomerAddress().isEmpty() || messageResponseData.getCustomerAddress().equals(" ")) {
                tvCustLocation.setVisibility(View.GONE);
            } else {
                //llCollapsingLayout.setVisibility(View.VISIBLE);
                tvCustLocation.setVisibility(View.GONE);
                btnViewDetails.setVisibility(View.VISIBLE);
                tvCustLocation.setText(messageResponseData.getCustomerAddress());
            }
        }
    }

    private void setAssignTaskLocaly(FuguGetMessageResponse fuguGetMessageResponse) {
        try {
            if (conversation != null && conversation.getAgentId() != null) {
                if (!conversation.getAgentId().equals(fuguGetMessageResponse.getData().getUserId())) {
                    if (fuguGetMessageResponse.getData().getUserId() == HippoApplication.getInstance().getUserData().getUserId()) {
                        String txt = Restring.getString(FuguChatActivity.this, R.string.hippo_assigned_to) + " " + Restring.getString(FuguChatActivity.this, R.string.hippo_you);
                        tvAssignNotify.setVisibility(View.VISIBLE);
                        tvAssignNotify.setText(Html.fromHtml(txt));
                        tvAssignNotify.setBackgroundColor(getResources().getColor(R.color.green));
                        tvAssignNotify.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_self_assign, 0, 0, 0);
                        goneAssignLayout();
                        if (!isO2oChat) {
                            Bundle conData = new Bundle();
                            conData.putString(Constants.CHANNEL_ID, String.valueOf(fuguGetMessageResponse.getData().getChannelId()));
                            Intent intent = new Intent();
                            intent.putExtras(conData);
                            setResult(Overlay.ASSIGNMENT.getOrdinal(), intent);
                        }
                    } else if (!fuguGetMessageResponse.getData().getAgentName().equals("") &&
                            fuguGetMessageResponse.getData().getUserId() != HippoApplication.getInstance().getUserData().getUserId()) {
                        String txt = Restring.getString(FuguChatActivity.this, R.string.hippo_assigned_to) + " " + fuguGetMessageResponse.getData().getAgentName();
                        tvAssignNotify.setVisibility(View.VISIBLE);
                        tvAssignNotify.setText(Html.fromHtml(txt));
                        tvAssignNotify.setBackgroundColor(getResources().getColor(R.color.assign_color));
                        tvAssignNotify.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_self_assign, 0, 0, 0);
                        if (!isO2oChat) {
                            Bundle conData = new Bundle();
                            conData.putString(Constants.CHANNEL_ID, String.valueOf(fuguGetMessageResponse.getData().getChannelId()));
                            Intent intent = new Intent();
                            intent.putExtras(conData);
                            setResult(Overlay.ASSIGNMENT.getOrdinal(), intent);
                        }
                    }
                    try {
                        conversation.setAgentId(fuguGetMessageResponse.getData().getUserId());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isApiGetAgents = false;

    private void apiGetAgents() {
        if (isNetworkAvailable()) {
            if (isApiGetAgents) {
                messagesApi.add("apiGetAgents");
                return;
            }
            CommonParams commonParams = new CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken() == null ? "" : HippoApplication.getInstance().getUserData().getAccessToken())
                    .add(Constants.BUSINESS_ID, String.valueOf(HippoApplication.getInstance().getUserData().getBusinessId()))
                    .build();

            isApiGetAgents = true;
            String value = new Gson().toJson(commonParams.getMap());
            Logger.INSTANCE.apiRequest("/api/agent/getAgents", value);
            RestClient.getApiInterface().getAgents(commonParams.getMap())
                    .enqueue(new ResponseResolver<GetAgentsResponse>(FuguChatActivity.this, false, true) {
                        @Override
                        public void success(GetAgentsResponse getAgentsResponse) {
                            Logger.INSTANCE.apiResponse("/api/agent/getAgents", "");
                            try {
                                if (getAgentsResponse != null && getAgentsResponse.getData() != null &&
                                        getAgentsResponse.getData().getAgents() != null && getAgentsResponse.getData().getAgents().size() > 0) {
                                    parseAgentData(getAgentsResponse);
                                } else {
                                    isApiGetAgents = false;
                                    try {
                                        if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getAgentsResponse.getStatuscode()) {
                                            Paper.book(CommonData.name).delete(SPLabels.AGENTS);
                                            Paper.book(CommonData.name).write(SPLabels.AGENTS, getAgentsResponse);
                                            HippoApplication.getInstance().setAgentsResponse(getAgentsResponse);
                                            getAgentsResponseData = (GetAgentsResponse) Paper.book(CommonData.name).read(SPLabels.AGENTS);
                                        }
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }

                                    if (messagesApi != null && messagesApi.size() > 0) {
                                        if (messagesApi.contains("apiGetAgents")) {
                                            messagesApi.remove("apiGetAgents");
                                            apiGetAgents();
                                        }
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/agent/getAgents", error.getMessage());
                            isApiGetAgents = false;
                            if (messagesApi != null && messagesApi.size() > 0) {
                                if (messagesApi.contains("apiGetAgents")) {
                                    messagesApi.remove("apiGetAgents");
                                    apiGetAgents();
                                }
                            }
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    private void parseAgentData(GetAgentsResponse getAgentsResponse) throws Exception {
        new ParseAgents(new OnAgentParseCallback() {
            @Override
            public void onCallbackListener(@NotNull ArrayList<GetAgentsResponse.Agents> allAgents) {
                isApiGetAgents = false;
                try {
                    getAgentsResponse.getData().setAgents(allAgents);

                    if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getAgentsResponse.getStatuscode()) {
                        Paper.book(CommonData.name).delete(SPLabels.AGENTS);
                        Paper.book(CommonData.name).write(SPLabels.AGENTS, getAgentsResponse);
                        HippoApplication.getInstance().setAgentsResponse(getAgentsResponse);
                        getAgentsResponseData = (GetAgentsResponse) Paper.book(CommonData.name).read(SPLabels.AGENTS);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (messagesApi != null && messagesApi.size() > 0) {
                    if (messagesApi.contains("apiGetAgents")) {
                        messagesApi.remove("apiGetAgents");
                        apiGetAgents();
                    }
                }
            }
        }).execute(getAgentsResponse);
    }

    public RecyclerView getRvMessages() {
        return rvMessages;
    }

    private void goToGmail(String mail) {
        if (!Utils.preventMultipleClicks()) {
            return;
        }
        Intent emailIntent = new Intent(Intent.ACTION_SENDTO, Uri.fromParts(
                "mailto", mail, null));
        startActivity(Intent.createChooser(emailIntent, Restring.getString(FuguChatActivity.this, R.string.hippo_send_email)));
    }

    private void goToPhone(String phone) {
        if (!Utils.preventMultipleClicks()) {
            return;
        }
        Intent phoneIntent = new Intent(Intent.ACTION_DIAL, Uri.fromParts(
                "tel", phone, null));
        startActivity(phoneIntent);
    }

    private void goneAssignLayout() {
        Handler handler = new Handler();
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                tvAssignNotify.setVisibility(View.GONE);
            }
        }, 3000);
    }

    private void handleChatTypeCase(Intent intent) {
        if (intent.getStringExtra("data") != null) {
            Log.v("agent--->>>", String.valueOf(HippoApplication.getInstance().getUserData().getAgentType()));
            if (intent.getStringExtra("data").equals(Restring.getString(FuguChatActivity.this, R.string.my_chats)) &&
                    HippoApplication.getInstance().getUserData().getAgentType() != AgentType.ADMIN.getOrdinal()) {
                isBlock = true;
            } else {
                isBlock = false;
            }
        }
        if (intent.getStringExtra("data") != null)
            if (intent.getStringExtra("data").equals(Restring.getString(FuguChatActivity.this, R.string.all_chats))) {
                goneAssignLayout();

            }
    }

    private void changeAssignTextBackground(String txt, int color, int drawable) {
        tvAssignNotify.setVisibility(View.VISIBLE);
        tvAssignNotify.setText(Html.fromHtml(txt));
        tvAssignNotify.setBackgroundColor(color);
        tvAssignNotify.setCompoundDrawablesWithIntrinsicBounds(drawable, 0, 0, 0);
    }

    private void openSavedPlan() {
        Intent paymentIntent = new Intent(FuguChatActivity.this, PlansActivity.class);
        startActivityForResult(paymentIntent, Config.REQUEST_CODE_PICK_PAYMENT);
        //new SavedPlanDialog(FuguChatActivity.this).show();
    }

    private void openSavedReply(CharSequence editable) {
        final String msgTxt = editable.toString();
        final int cursorPosition = etMsg.getSelectionStart();
        if (msgTxt.substring(msgTxt.length() - 1).equals("/")) {
            showKeyboard();
            cannedDialog = new CannedDialog(FuguChatActivity.this, new CannedDialog.Callback() {
                @Override
                public void onClick(int pos, CannedMessageResponse.Data cannedMessage) {
                    if (msgTxt.length() == 1) {
                        etMsg.setText(cannedMessage.getMessage().trim());
                        etMsg.setSelection(etMsg.getText().length());
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                InputMethodManager input = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                                input.toggleSoftInput(InputMethodManager.SHOW_IMPLICIT, 0);
                            }
                        }, 500);

                    } else {
                        etMsg.setText(etMsg.getText().toString().substring(0, cursorPosition - 1)
                                + " "
                                + cannedMessage.getMessage().trim()
                                + " "
                                + etMsg.getText().toString().substring(cursorPosition));
                        etMsg.setSelection(etMsg.getText().length());
                        etMsg.setFocusable(true);
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                InputMethodManager input = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                                input.toggleSoftInput(InputMethodManager.SHOW_IMPLICIT, 0);
                            }
                        }, 500);

                    }
                    //HippoApplication.getInstance().trackEvent(CHAT_SCREEN, SAVED_REPLIES, "saved_reply");
                }

                @Override
                public void onCancel() {
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            InputMethodManager input = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                            input.toggleSoftInput(InputMethodManager.SHOW_IMPLICIT, 0);
                        }
                    }, 500);
                }
            }).show();
            this.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE);
        } else if (cursorPosition > 0 && msgTxt.substring(cursorPosition - 1, cursorPosition).equals("/")) {
            showKeyboard();
            cannedDialog = new CannedDialog(FuguChatActivity.this, new CannedDialog.Callback() {
                @Override
                public void onClick(int pos, CannedMessageResponse.Data cannedMessage) {
                    if (msgTxt.length() == 1) {
                        etMsg.setText(cannedMessage.getMessage().trim());
                        etMsg.setSelection(etMsg.getText().length());
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                InputMethodManager input = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                                input.toggleSoftInput(InputMethodManager.SHOW_IMPLICIT, 0);
                            }
                        }, 500);
                    } else {
                        etMsg.setText(etMsg.getText().toString().substring(0, cursorPosition - 1)
                                + " "
                                + cannedMessage.getMessage().trim()
                                + " "
                                + etMsg.getText().toString().substring(cursorPosition));
                        etMsg.setSelection(cursorPosition + cannedMessage.getMessage().trim().length());
                        etMsg.setFocusable(true);
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                InputMethodManager input = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                                input.toggleSoftInput(InputMethodManager.SHOW_IMPLICIT, 0);
                            }
                        }, 500);
                    }
                    //HippoApplication.getInstance().trackEvent(CHAT_SCREEN, SAVED_REPLIES, "saved_reply");
                }

                @Override
                public void onCancel() {
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            InputMethodManager input = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                            input.toggleSoftInput(InputMethodManager.SHOW_IMPLICIT, 0);
                        }
                    }, 500);
                }
            }).show();
            this.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE);
        }
    }

    private void showKeyboard() {
        // Check if no view has focus:
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager inputManager = (InputMethodManager) this.getSystemService(Context.INPUT_METHOD_SERVICE);
            inputManager.showSoftInput(etMsg, InputMethodManager.HIDE_IMPLICIT_ONLY);
        }
    }


    private void hideKeyboard() {
        // Check if no view has focus:
        try {
            View view = this.getCurrentFocus();
            if (view != null) {
                InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getDealInfo() {
        getDealInfo(false);
    }

    private GetDealInfo dealInfo;

    private void getDealInfo(boolean flag) {
        if (isO2oChat)
            return;

        if (HippoApplication.getInstance().getUserData().getBusinessProperty().getCrmIntegrationType() == null
                || HippoApplication.getInstance().getUserData().getBusinessProperty().getCrmIntegrationType() == 0) {
            invalidateOptionsMenu();
            return;
        }


        try {
            if (isNetworkAvailable()) {
                CommonParams commonParams = new CommonParams.Builder()
                        .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken() == null ? "" : HippoApplication.getInstance().getUserData().getAccessToken())
                        .add(Constants.EMAIL, etCustEmail.getText().toString().isEmpty() ? null : etCustEmail.getText().toString())
                        .add("crm_type", HippoApplication.getInstance().getUserData().getBusinessProperty().getCrmIntegrationType())
                        .build();
                Logger.INSTANCE.apiRequest("/api/bulbul/getDealInfo", new Gson().toJson(commonParams.getMap()));
                RestClient.getApiInterface().getDealInfo(commonParams.getMap())
                        .enqueue(new ResponseResolver<GetDealInfo>(FuguChatActivity.this, flag, true) {


                            @Override
                            public void success(GetDealInfo getDealInfo) {
                                Logger.INSTANCE.apiResponse("/api/bulbul/getDealInfo", "");
                                notesList.clear();
                                dealInfo = null;
                                dealInfo = getDealInfo;
                                if (getDealInfo != null) {
                                    for (com.hippoagent.model.get_deal_info.Datum notes : getDealInfo.getData().getData()) {
                                        // if (agent.getStatus() == 1) {
                                        if (!TextUtils.isEmpty(notes.getNotes()))
                                            notesList.add(notes);
                                        // }
                                    }

                                    try {
                                        followesList = (ArrayList<FollowerDatum>) getDealInfo.getData().getData().get(0).getFollowerData();
                                    } catch (Exception e) {

                                    }

                                    if (dialog != null && dialog.isShowing()) {
                                        showNotesAdapter = new ShowNotesAdapter(FuguChatActivity.this, notesList);
                                        rvNotes.setAdapter(showNotesAdapter);
                                        rvNotes.smoothScrollToPosition(notesList.size() - 1);
                                        if (notesList.size() < 1) {
                                            rvNotes.setVisibility(View.GONE);
                                            ibAddNotes.setVisibility(View.VISIBLE);
                                        } else {
                                            rvNotes.setVisibility(View.VISIBLE);
                                            ibAddNotes.setVisibility(View.GONE);
                                        }
                                    }
                                }
                                LoadingBox.showOn(FuguChatActivity.this);
                                boolean isEditable = false;
                                try {
                                    Pattern p = Pattern.compile("\\d+");
                                    Matcher m = p.matcher(HippoApplication.getInstance().getUserData().getBusinessProperty().getEditUserInfoAccess());
                                    while (m.find()) {
                                        System.out.println(m.group());
                                        if (HippoApplication.getInstance().getUserData().getAgentType().intValue() == Integer.parseInt(m.group())) {
                                            isEditable = true;
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                                btnViewNotes.setVisibility(View.GONE);
                                btnAddDeal.setVisibility(View.GONE);
                                if ((getDealInfo.getData().getCrmIntegrationType().intValue() == 1
                                        || getDealInfo.getData().getCrmIntegrationType().intValue() == 2)
                                        && (getDealInfo.getData().getData() == null || getDealInfo.getData().getData().size() == 0)) {
                                    btnViewNotes.setVisibility(View.GONE);
                                    btnAddDeal.setVisibility(View.VISIBLE);
                                    editDeal.setVisibility(View.VISIBLE);
                                    btnAddDeal.setText(Restring.getString(FuguChatActivity.this, R.string.add_deal));
                                    editDeal.setText(Restring.getString(FuguChatActivity.this, R.string.add_deal));
                                    etCustName.setEnabled(false);
                                    etCustName.setFocusableInTouchMode(false);
                                    etCustEmail.setEnabled(false);
                                    etCustEmail.setFocusableInTouchMode(false);
                                    //                                vwCustEmail.setVisibility(View.GONE);
                                    //                                vwCustPhone.setVisibility(View.GONE);
                                    rlBulbulActions.setVisibility(View.GONE);
                                    // TODO: 2020-01-06
                                    //rlDealViewNotes.setVisibility(View.VISIBLE);
                                } else if ((getDealInfo.getData().getCrmIntegrationType().intValue() == 0 || ((getDealInfo.getData().getCrmIntegrationType().intValue() == 1
                                        || getDealInfo.getData().getCrmIntegrationType().intValue() == 2) && getDealInfo.getData().getData() != null && getDealInfo.getData().getData().size() > 0))) {
                                    btnAddDeal.setVisibility(View.GONE);
                                    editDeal.setVisibility(View.GONE);
                                    if (isEditable) {
                                        btnAddDeal.setVisibility(View.VISIBLE);
                                        editDeal.setVisibility(View.VISIBLE);
                                    }
                                    btnAddDeal.setText(Restring.getString(FuguChatActivity.this, R.string.edit_deal));
                                    editDeal.setText(Restring.getString(FuguChatActivity.this, R.string.edit_deal));

                                    if (getDealInfo.getData().getData() != null && getDealInfo.getData().getData().size() > 0) {
                                        if (getDealInfo.getData().getCrmIntegrationType().intValue() == 1) {
                                            btnViewNotes.setVisibility(View.VISIBLE);
                                            dealId = getDealInfo.getData().getData().get(0).getDealId().toString();

                                            if (!getDealInfo.getData().getData().get(0).getAssignName().isEmpty()) {
                                                etLeadOwner.setVisibility(View.VISIBLE);
                                                etLeadOwner.setText(getDealInfo.getData().getData().get(0).getAssignName());
                                            }
                                            if (!TextUtils.isEmpty(getDealInfo.getData().getData().get(0).getStage())) {
                                                etNotes.setVisibility(View.VISIBLE);
                                                etNotes.setText(getDealInfo.getData().getData().get(0).getStage());
                                            }
                                            if (getDealInfo.getData().getData().get(0).getContactInfo().size() > 0) {
                                                if (getDealInfo.getData().getData().get(0).getContactInfo().get(0).getEmail().size() > 0) {
                                                    if (!getDealInfo.getData().getData().get(0).getContactInfo().get(0).getEmail().get(0).getEmail().isEmpty()) {
                                                        etCustEmail.setVisibility(View.VISIBLE);
                                                        copyEmail.setVisibility(View.VISIBLE);
                                                        etCustEmail.setText(getDealInfo.getData().getData().get(0).getContactInfo().get(0).getEmail().get(0).getEmail());
                                                    }
                                                }
                                                if (TextUtils.isEmpty(customerPhone)) {
                                                    if (getDealInfo.getData().getData().get(0).getContactInfo().get(0).getPhone().size() > 0) {
                                                        if (!getDealInfo.getData().getData().get(0).getContactInfo().get(0).getPhone().get(0).getPhone().isEmpty()) {
                                                            etCustPhone.setVisibility(View.VISIBLE);
                                                            copyPhone.setVisibility(View.VISIBLE);
                                                            customerPhone = getDealInfo.getData().getData().get(0).getContactInfo().get(0).getPhone().get(0).getPhone();
                                                            etCustPhone.setText(customerPhone);
                                                        }
                                                    }
                                                } else {
                                                    etCustPhone.setVisibility(View.VISIBLE);
                                                    copyPhone.setVisibility(View.VISIBLE);
                                                    etCustPhone.setText(customerPhone);
                                                }

                                            }
                                            try {
                                                if (getDealInfo.getData().getData().get(0).getOrganizationInfo().size() > 0) {
                                                    if (!TextUtils.isEmpty(getDealInfo.getData().getData().get(0).getOrganizationInfo().get(0).getName())) {
                                                        etCustCompanyName.setVisibility(View.VISIBLE);
                                                        etCustCompanyName.setText(getDealInfo.getData().getData().get(0).getOrganizationInfo().get(0).getName());
                                                    } else {
                                                        etCustCompanyName.setVisibility(View.GONE);
                                                    }
                                                }
                                            } catch (Exception e) {
                                                etCustCompanyName.setVisibility(View.GONE);
                                            }
                                        } else if (getDealInfo.getData().getCrmIntegrationType().intValue() == 2) {
                                            btnViewNotes.setVisibility(View.GONE);
                                            dealId = getDealInfo.getData().getData().get(0).getProspectID();
                                            try {
                                                if (!TextUtils.isEmpty(getDealInfo.getData().getData().get(0).getCompany())) {
                                                    etCustCompanyName.setVisibility(View.VISIBLE);
                                                    etCustCompanyName.setText(getDealInfo.getData().getData().get(0).getCompany());
                                                } else {
                                                    etCustCompanyName.setVisibility(View.GONE);
                                                }
                                            } catch (Exception e) {
                                                etCustCompanyName.setVisibility(View.GONE);
                                            }
                                            etLeadOwner.setVisibility(View.GONE);
                                            etNotes.setVisibility(View.GONE);
                                        }

                                        followersUI();

                                    }

                                    etCustName.setVisibility(View.GONE);
                                    //vwCustName.setVisibility(View.GONE);
                                    etCustName.setEnabled(false);
                                    etCustName.setFocusableInTouchMode(false);

                                    if (etCustEmail.getText().toString().isEmpty()) {
                                        etCustEmail.setVisibility(View.GONE);
                                        copyEmail.setVisibility(View.GONE);
                                    } else {
                                        etCustEmail.setVisibility(View.VISIBLE);
                                        copyEmail.setVisibility(View.VISIBLE);
                                    }
                                    //vwCustEmail.setVisibility(View.GONE);
                                    etCustEmail.setEnabled(false);
                                    etCustEmail.setFocusableInTouchMode(false);
                                    etCustEmail.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View view) {
                                            goToGmail(etCustEmail.getText().toString());
                                        }
                                    });

                                    if (etCustPhone.getText().toString().isEmpty()) {
                                        etCustPhone.setVisibility(View.GONE);
                                        copyPhone.setVisibility(View.GONE);
                                    } else {
                                        etCustPhone.setVisibility(View.VISIBLE);
                                        copyPhone.setVisibility(View.VISIBLE);
                                    }
                                    //vwCustPhone.setVisibility(View.GONE);
                                    etCustPhone.setEnabled(false);
                                    etCustPhone.setFocusableInTouchMode(false);
                                    etCustPhone.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View view) {
                                            goToPhone(etCustPhone.getText().toString());
                                        }
                                    });

                                    if (etCustCompanyName.getText().toString().isEmpty()) {
                                        etCustCompanyName.setVisibility(View.GONE);
                                    } else {
                                        etCustCompanyName.setVisibility(View.VISIBLE);
                                    }
                                    //vwCustCompanyName.setVisibility(View.GONE);
                                    etCustCompanyName.setEnabled(false);
                                    etCustCompanyName.setFocusableInTouchMode(false);

                                    assignCheckbox.setVisibility(View.GONE);
                                    //vwNotes.setVisibility(View.GONE);

                                    rlBulbulActions.setVisibility(View.GONE);
                                    // TODO: 2020-01-06
                                    //rlDealViewNotes.setVisibility(View.VISIBLE);
                                }

                                invalidateOptionsMenu();
                                LoadingBox.hide();
                            }

                            @Override
                            public void failure(APIError error) {
                                Logger.INSTANCE.apiFailed("/api/bulbul/getDealInfo", error.getMessage());
                                LoadingBox.hide();
                                Log.e("error", "error");
                            }
                        });
            } else {
                Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void followersUI() {
        if (followesList != null && followesList.size() > 0) {
            llFollowers.setVisibility(View.VISIBLE);
            followername.setVisibility(View.VISIBLE);
            if (followesList.size() == 1) {
                followersMore.setVisibility(View.GONE);
                followername.setText(followesList.get(0).getName());
            } else if (followesList.size() == 2) {
                followersMore.setVisibility(View.VISIBLE);
                try {
                    followername.setText(followesList.get(0).getName().split(" ")[0] + " ");
                } catch (Exception e) {
                    followername.setText(followesList.get(0).getName());
                }
                followersMore.setText(Html.fromHtml("<u> and 1 more</u></font>"));
            } else {
                followersMore.setVisibility(View.VISIBLE);
                try {
                    followername.setText(followesList.get(0).getName().split(" ")[0] + " ");
                } catch (Exception e) {
                    followername.setText(followesList.get(0).getName());
                }
                String value = followesList.size() - 1 + " more";
                followersMore.setText(Html.fromHtml("<u> and " + value + "</u></font>"));
            }
        } else {
            llFollowers.setVisibility(View.GONE);
        }
    }

    public void pushDealToBulbul(CommonParams.Builder builder, final JSONObject object) {
        if (isNetworkAvailable()) {
            CommonParams commonParams = builder
                    .add("channel_id", conversation.getChannelId())
                    .add("message", lastMessage)
                    .add("user_id", conversation.getUserId())
                    .build();


            RestClient.getApiInterface().addDealToBulbul(commonParams.getMap())
                    .enqueue(new ResponseResolver<AddDeal>(FuguChatActivity.this, false, true) {
                        @Override
                        public void success(AddDeal addDeal) {
                            Logger.INSTANCE.apiResponse("/api/bulbul/addDeal", "");
                            LoadingBox.showOn(FuguChatActivity.this);
                            try {
                                //tvTitle.setText(addDeal.getData().getFullName());
                                LoadingBox.hide();
                                getDealInfo(true);
                            } catch (Exception e) {
                                Logger.INSTANCE.apiFailed("/api/bulbul/addDeal", e.getLocalizedMessage());
                                LoadingBox.hide();
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/bulbul/addDeal", error.getMessage());
                            LoadingBox.hide();
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    @Deprecated
    private void addDealToBulbul() {

        if (isNetworkAvailable()) {
            JSONObject contactInfo = null, companyInfo = null, messageData = null;
            JSONArray tagsArray = null;
            try {
                contactInfo = new JSONObject();
                JSONArray email = new JSONArray();
                JSONObject emailObj = new JSONObject();
                emailObj.put("email", etCustEmail.getText().toString().isEmpty() ? "" : etCustEmail.getText().toString());
                email.put(emailObj);

                JSONArray phone = new JSONArray();
                JSONObject phoneObj = new JSONObject();
                phoneObj.put("phone", etCustPhone.getText().toString().isEmpty() ? "" : etCustPhone.getText().toString());
                phone.put(phoneObj);

                contactInfo.put("email", email);
                contactInfo.put("phone", phone);
                contactInfo.put("name", etCustName.getText().toString().isEmpty() ? "" : etCustName.getText().toString());

                tagsArray = new JSONArray();
                JSONObject tagObject = new JSONObject();
                tagObject.put("tag_name", "chat lead");
                tagsArray.put(tagObject);

                companyInfo = new JSONObject();
                companyInfo.put("name", etCustCompanyName.getText().toString().isEmpty() ? "" : etCustCompanyName.getText().toString());

                messageData = new JSONObject();
                Message currentOrderItem = null;
                messageData.put("message", "message");
            } catch (JSONException e) {
                Log.e("JSONException of addDealToBulbul", e.getMessage());
            }

            int assignTo = 0;
            if (assignCheckbox.isChecked())
                assignTo = 1;

            LoadingBox.showOn(FuguChatActivity.this);
            CommonParams commonParams = new CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken() == null ? "" : HippoApplication.getInstance().getUserData().getAccessToken())
                    .add("contact_info", contactInfo)
                    .add("tags", tagsArray)
                    .add("deal_name", etCustName.getText().toString().isEmpty() ? "" : etCustName.getText().toString())
                    .add("created_by", HippoApplication.getInstance().getUserData().getFullName())
                    .add("organization_data", companyInfo)
                    .add("channel_id", conversation.getChannelId())
                    .add("message", lastMessage)
                    .add("user_id", conversation.getUserId())
                    .add("crm_type", HippoApplication.getInstance().getUserData().getBusinessProperty().getCrmIntegrationType())
                    .add("assign_to_me", assignTo)
                    .build();
            Logger.INSTANCE.apiRequest("/api/bulbul/addDeal", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().addDealToBulbul(commonParams.getMap())
                    .enqueue(new ResponseResolver<AddDeal>(FuguChatActivity.this, false, true) {
                        @Override
                        public void success(AddDeal addDeal) {
                            Logger.INSTANCE.apiResponse("/api/bulbul/addDeal", "");
                            LoadingBox.showOn(FuguChatActivity.this);
                            try {
                                //tvTitle.setText(addDeal.getData().getFullName());
                                LoadingBox.hide();
                                getDealInfo(true);
                            } catch (Exception e) {
                                Logger.INSTANCE.apiFailed("/api/bulbul/addDeal", e.getLocalizedMessage());
                                LoadingBox.hide();
                                e.printStackTrace();
                            }

                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/bulbul/addDeal", error.getMessage());
                            LoadingBox.hide();
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    private void updateDeal() {
        if (isNetworkAvailable()) {
            JSONArray tagsArray = null;
            try {
                tagsArray = new JSONArray();
                JSONObject tagObject = new JSONObject();
                tagObject.put("tag_name", "chat lead");
                tagsArray.put(tagObject);
            } catch (JSONException e) {

            }
            LoadingBox.showOn(FuguChatActivity.this);
            CommonParams commonParams = new CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken() == null ? "" : HippoApplication.getInstance().getUserData().getAccessToken())
                    .add("deal_id", dealId)
                    .add("tags", tagsArray)
                    .add("notes", notes)
                    .add("crm_type", HippoApplication.getInstance().getUserData().getBusinessProperty().getCrmIntegrationType())
                    .add("created_by", String.valueOf(HippoApplication.getInstance().getUserData().getFullName()))
                    .build();
            Logger.INSTANCE.apiRequest("/api/bulbul/updateDeal", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().updateDeal(commonParams.getMap())
                    .enqueue(new ResponseResolver<UpdateDeal>(FuguChatActivity.this, false, true) {
                        @Override
                        public void success(UpdateDeal getAgentsResponse) {
                            Logger.INSTANCE.apiResponse("/api/bulbul/updateDeal", "");
                            LoadingBox.hide();
                            try {
                                getDealInfo(true);
                            } catch (Exception e) {
                                Logger.INSTANCE.apiFailed("/api/bulbul/updateDeal", e.getLocalizedMessage());
                                e.printStackTrace();
                                LoadingBox.hide();
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/bulbul/updateDeal", error.getMessage());
                            LoadingBox.hide();
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    private void editUserDetails(boolean flag) {
        editUserDetails(flag, etCustEmail.getText().toString(), etCustPhone.getText().toString());
    }

    public void editUserDetails(final boolean flag, String email, String custPhone) {
        if (isNetworkAvailable()) {
            if (flag)
                LoadingBox.showOn(FuguChatActivity.this);

            CommonParams commonParams = new CommonParams.Builder()
                    .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken() == null ? "" : HippoApplication.getInstance().getUserData().getAccessToken())
                    .add("user_id", conversation.getUserId())
                    .add("email", email)
                    .add("phone_number", custPhone)
                    .build();

            Logger.INSTANCE.apiRequest("/api/users/editUserDetails", new Gson().toJson(commonParams.getMap()));
            RestClient.getApiInterface().editUserDetails(commonParams.getMap())
                    .enqueue(new ResponseResolver<EditUserDetails>(FuguChatActivity.this, false, true) {
                        @Override
                        public void success(EditUserDetails editUserDetails) {
                            Logger.INSTANCE.apiResponse("/api/users/editUserDetails", "");
                            if (!flag)
                                LoadingBox.showOn(FuguChatActivity.this);
                            try {
                                if (!TextUtils.isEmpty(email))
                                    etCustEmail.setText(email);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                            getDealInfo();
                            customerPhone = etCustPhone.getText().toString();
                            FuguGetMessageResponse fuguGetMessageResponse = CommonData.getMessageResponse(conversation.getChannelId());
                            fuguGetMessageResponse.getData().setCustomerPhone(customerPhone);
                            CommonData.setMessageResponse(conversation.getChannelId(), fuguGetMessageResponse);
                            //LoadingBox.hide();
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/users/editUserDetails", error.getMessage());
                            LoadingBox.hide();
                            Log.e("error", "error");
                        }
                    });
        } else {
            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    private void dialogShowFollowers() {
        dialog = new Dialog(FuguChatActivity.this, android.R.style.Theme_Translucent_NoTitleBar);
        dialog.getWindow().getAttributes().windowAnimations = R.style.Animations_LoadingDialogBottomIn;
        dialog.setContentView(R.layout.activity_follower);
        WindowManager.LayoutParams layoutParams = dialog.getWindow().getAttributes();
        layoutParams.dimAmount = 0.6f;
        dialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);

        RecyclerView recyclerView = dialog.findViewById(R.id.recyclerView);
        FollowerAdapter adapter = new FollowerAdapter(followesList);
        recyclerView.setAdapter(adapter);
        ImageView ivClose = dialog.findViewById(R.id.ivClose);
        ivClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });

        dialog.show();
    }

    private void dialogShowNotes() {
        dialog = new Dialog(FuguChatActivity.this, android.R.style.Theme_Translucent_NoTitleBar);
        dialog.getWindow().getAttributes().windowAnimations = R.style.Animations_LoadingDialogBottomIn;
        dialog.setContentView(R.layout.dialog_show_notes);
        WindowManager.LayoutParams layoutParams = dialog.getWindow().getAttributes();
        layoutParams.dimAmount = 0.6f;
        dialog.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
        ImageView ivClose = (ImageView) dialog.findViewById(R.id.ivClose);
        Button btAddNote = (Button) dialog.findViewById(R.id.btAddNote);
        Button btCancelNote = (Button) dialog.findViewById(R.id.btCancelNote);
        final EditText etTypeANote = (EditText) dialog.findViewById(R.id.etTypeANote);
        try {
            TextView tvTitle = dialog.findViewById(R.id.tvTitle);
            tvTitle.setText(Restring.getString(FuguChatActivity.this, R.string.notes));
            btAddNote.setText(Restring.getString(FuguChatActivity.this, R.string.hippo_add));
            btCancelNote.setText(Restring.getString(FuguChatActivity.this, R.string.cancel));
            etTypeANote.setHint(Restring.getString(FuguChatActivity.this, R.string.hippo_type_a_note));
        } catch (Exception e) {

        }

        rvNotes = (RecyclerView) dialog.findViewById(R.id.rvNotes);
        ibAddNotes = (ImageButton) dialog.findViewById(R.id.ibAddNotes);
        rvNotes.setLayoutManager(new LinearLayoutManager(FuguChatActivity.this));
        rvNotes.setItemAnimator(new DefaultItemAnimator());
        rvNotes.setHasFixedSize(false);
        showNotesAdapter = new ShowNotesAdapter(FuguChatActivity.this, notesList);
        rvNotes.setAdapter(showNotesAdapter);
        if (notesList.size() < 1) {
            rvNotes.setVisibility(View.GONE);
            ibAddNotes.setVisibility(View.VISIBLE);
        } else {
            rvNotes.setVisibility(View.VISIBLE);
            ibAddNotes.setVisibility(View.GONE);
        }
        ibAddNotes.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                etTypeANote.requestFocus();
            }
        });
        btAddNote.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (etTypeANote.getText().toString().isEmpty()) {
                    Toast.makeText(getApplicationContext(), "*Please add note.", Toast.LENGTH_SHORT).show();
                } else {
                    notes = etTypeANote.getText().toString();
                    updateDeal();
                    etTypeANote.setText("");
                    //dialog.dismiss();

                }
            }
        });
        btCancelNote.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.dismiss();
            }
        });
        ivClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
            }
        });
        dialog.show();
    }

    public void closeBottomSheet() {
        bottomSheetFragment.dismiss();
    }

    @Override
    public void onQueryReceived(String query, EditText textET) {
        if (messageType != PRIVATE_NOTE)
            return;

        showTaggedAgents = new ArrayList<>();
        if (query != null && !query.trim().equalsIgnoreCase("")) {
            String queryLower = query.toLowerCase(Locale.US);
            if (getAgentsResponseData.getData().getAgents() != null && !getAgentsResponseData.getData().getAgents().isEmpty()) {
                for (GetAgentsResponse.Agents member : getAgentsResponseData.getData().getAgents()) {
                    if (member.getFullName().toLowerCase().startsWith(queryLower)) {
                        showTaggedAgents.add(member);
                    }
                }
            }

        }

        // show all suggestions in case of empty query ( @ should be there )
        int length = textET.getText().length();
        if (length != 0) {
            char lastChar = textET.getText().charAt(length - 1);
            if (String.valueOf(lastChar).equalsIgnoreCase("@") && query != null && query.trim().isEmpty()) {
                // load entire list
                showTaggedAgents.clear();
                if (getAgentsResponseData.getData() != null && getAgentsResponseData.getData().getAgents() != null && !getAgentsResponseData.getData().getAgents().isEmpty()) {
                    showTaggedAgents.addAll(getAgentsResponseData.getData().getAgents());
                }
            }
        }
        if (isAttachmentDialogOpen)
            showMentionsList(rvAttachmentsMentionList);
        else
            showMentionsList(rvTagged);
    }

    @Override
    public void displaySuggestions(boolean display) {
        if (messageType == PRIVATE_NOTE) {
            if (display) {
                if (isAttachmentDialogOpen)
                    showRvTaggedList(rvAttachmentsMentionList);
                else
                    showRvTaggedList(rvTagged);
            } else {
                if (isAttachmentDialogOpen)
                    visibilityGone(rvAttachmentsMentionList);
                else
                    visibilityGone(rvTagged);
            }
        } else {
            visibilityGone(rvTagged);
        }
    }


    /**
     * Toggle the mentions list's visibility if there are search results returned for search
     * query. Shows the empty list view
     */
    private void showMentionsList(RecyclerView taggedRV) {
        if (showTaggedAgents.isEmpty()) {
            visibilityGone(taggedRV);
            return;
        } else {
            showRvTaggedList(taggedRV);
            if (fuguTagAdapter == null) {
                fuguTagAdapter = new FuguTagAdapter(FuguChatActivity.this, showTaggedAgents
                        , "", new FuguTagAdapter.Callback() {
                    @Override
                    public void onClick(GetAgentsResponse.Agents agent) {
                        getTaggedText(agent, true);
                        //HippoApplication.getInstance().trackEvent(GAEvents.CHAT_SCREEN, "Tagged selected", "tag_agent_selected");
                    }
                });
            } else {
                fuguTagAdapter.setData(showTaggedAgents);
            }

            linearLayoutManager1 = new LinearLayoutManager(FuguChatActivity.this);
            linearLayoutManager1.setStackFromEnd(true);
            linearLayoutManager1.scrollToPositionWithOffset(0, 0);
            taggedRV.setLayoutManager(linearLayoutManager1);
            for (int i = 0; i < showTaggedAgents.size(); i++) {
                if (HippoApplication.getInstance().getUserData().getUserId() == showTaggedAgents.get(position).getUserId()) {
                    showTaggedAgents.remove(position);
                }
            }
            taggedRV.setAdapter(fuguTagAdapter);
        }
    }

    @Override
    public void onPermissionsGranted(int i, @NonNull List<String> list) {
        if (isCameraPermission) {
            if (imageUtils == null)
                imageUtils = new ImageUtils(FuguChatActivity.this);
            imageUtils.startCamera();
            isCameraPermission = false;
        } else {

        }
    }

    @Override
    public void onPermissionsDenied(int i, @NonNull List<String> perms) {
        if (EasyPermissions.somePermissionPermanentlyDenied(this, perms)) {
            new AppSettingsDialog.Builder(this).build().show();
        } else {
            Toast.makeText(FuguChatActivity.this, "Please grant permission", Toast.LENGTH_SHORT).show();
            //finish();
        }
    }

    @Override
    public void onToggleSoftKeyboard(boolean isVisible) {
        keyboardVisibility = isVisible;
    }

    @Override
    public void onConcentClicked(Message message) {
        Log.v(TAG, "message = " + new Gson().toJson(message));
    }

    public void openCallUrl(String message) {
        HippoConfig.getInstance().connectCallWithUrl(this, message, currentChannelId + "");
    }

    @Override
    public void onRecordedFile(@NotNull String filepath, long fileSize) {
        sendAudioFile(filepath, fileSize);

    }

    private void sendAudioFile(String filepath, long fileSize) {
        String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
        String fileExt = Utils.getExtension(filepath);

        String fileName = muid;
        if (!TextUtils.isEmpty(fileExt)) {
            fileName = fileName + "." + fileExt;
        }
        FileuploadModel fileuploadModel = new FileuploadModel(fileName, String.valueOf(fileSize), filepath, muid);
        fileuploadModel.setFileSizeReadable(Utils.humanReadableByteCount(fileSize, true));
        fileuploadModel.setDocumentType(DocumentType.AUDIO.toString());
        fileuploadModel.setMessageType(FILE_MESSAGE);

        copingFileToLocal(fileuploadModel, AUDIO_FOLDER);
    }

    @Override
    public void onRecordFileError() {
        Toast.makeText(this, "error", Toast.LENGTH_LONG).show();

    }


    public static class ShowNotesAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private Activity activity;
        private ArrayList<com.hippoagent.model.get_deal_info.Datum> notesList;

        public ShowNotesAdapter(Activity activity, ArrayList<com.hippoagent.model.get_deal_info.Datum> notes) {
            this.activity = activity;
            this.notesList = notes;
        }

        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_notes, parent, false);
            return new ViewHolder(v);
        }

        @Override
        public void onBindViewHolder(RecyclerView.ViewHolder viewholder, int position) {
            if (viewholder instanceof ViewHolder) {
                ViewHolder holder = (ViewHolder) viewholder;
                com.hippoagent.model.get_deal_info.Datum notes = notesList.get(position);
                holder.tvNotes.setTag(position);
                holder.tvNotes.setText(position + 1 + ". " + notes.getNotes());

            }
        }

        @Override
        public int getItemCount() {
            if (notesList == null || notesList.size() == 0) {
                return 0;
            } else {
                return notesList.size();
            }
        }

        public class ViewHolder extends RecyclerView.ViewHolder {
            public TextView tvNotes;

            public ViewHolder(final View itemView) {
                super(itemView);
                tvNotes = (TextView) itemView.findViewById(R.id.tvNotes);
            }
        }
    }

    public class GetMsgData extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            int notificationType = intent.getIntExtra(NOTIFICATION_TYPE, 3);
            if (notificationType == READ_MESSAGE) {
                // Read functionality
                for (int i = 0; i < fuguMessageList.size(); i++) {
                    if (fuguMessageList.get(i).getType() == ListItem.ITEM_TYPE_SELF) {
                        if (fuguMessageList.get(i).getMessageStatus() == MESSAGE_SENT) {
                            fuguMessageList.get(i).setMessageStatus(MESSAGE_READ);
                        }
                    }
                }
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            rvMessages.getRecycledViewPool().clear();
                            if (fuguMessageAdapter != null) {
                                fuguMessageAdapter.notifyDataSetChanged();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                JSONObject msgData = null;
                String channelId = "";
                try {
                    msgData = new JSONObject(intent.getStringExtra("msgData"));
                    channelId = msgData.getString("channel_id");
                } catch (JSONException e) {
                    e.printStackTrace();
                }

                if (msgData != null && channelId.equals(String.valueOf(conversation.getChannelId().toString()))) {

                    if (msgData.optInt("assigned_by") == msgData.optInt("assigned_to")
                            && HippoApplication.getInstance().getUserData().getUserId() == msgData.optInt("assigned_to")) {
                        userId = msgData.optInt("assigned_to");
                        Log.v("assign----->>>>", "self");
                        //String txt = "This chat has been <b>Assigned</b> to you";
                        String txt = Restring.getString(FuguChatActivity.this, R.string.hippo_assigned_to) + " " + Restring.getString(FuguChatActivity.this, R.string.hippo_you);
                        changeAssignTextBackground(txt, getResources().getColor(R.color.green), R.drawable.ic_self_assign);
                        goneAssignLayout();


                    } else if (msgData.optInt("assigned_by") == msgData.optInt("assigned_to")
                            && HippoApplication.getInstance().getUserData().getUserId() != msgData.optInt("assigned_to")) {
                        try {
                            Log.v("done with----->>>>", msgData.get("message").toString());
                            String txt = msgData.get("assigned_by_name").toString() + " " + Restring.getString(FuguChatActivity.this, R.string.hippo_assigned_to_themselves);
                            changeAssignTextBackground(txt, getResources().getColor(R.color.assign_color), R.drawable.ic_other_assign);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        handleChatTypeCase(intent);
                    } else {
                        try {
                            Log.v("done with----->>>>", msgData.get("message").toString());
                            String txt = msgData.get("message").toString();
                            changeAssignTextBackground(txt, getResources().getColor(R.color.assign_color), R.drawable.ic_other_assign);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        handleChatTypeCase(intent);
                    }
                    try {
                        conversation.setAgentId(msgData.optInt("assigned_to"));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private class GetAgentData extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent != null) {
                    apiGetAgents();
                }
            } catch (Exception e) {

            }
        }
    }

    private class MigrateData extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            int notificationType = intent.getIntExtra(NOTIFICATION_TYPE, 7);
            Log.e(TAG, "MigrateData: " + notificationType);
            if (notificationType == USER_MIGRATION) {
                try {
                    JSONObject msgData;
                    if (intent != null) {
                        msgData = new JSONObject(intent.getStringExtra("msgData"));
                        if (msgData.optInt("user_id") == conversation.getUserId().intValue()) {
                            conversation.setUserId(msgData.optInt("migrated_to"));
                            String fullName = msgData.optString("full_name");
                            conversation.setLabel(fullName);

                            tvTitle.setText(fullName);
                            videoCustomerName = fullName;
                            customerName = fullName;
                            //customerPhone, customerName
                            customerEmail = msgData.optString("email");
                            etCustEmail.setText(customerEmail);
                            setUserDetails();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class UPdateData extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent != null) {
                    String msgData = "";
                    String channelId = "";
                    try {
                        msgData = intent.getStringExtra("msgData");
                        channelId = intent.getStringExtra("channel_id");
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    onReceivedMessage(msgData, channelId);
                    //Toast.makeText(FuguChatActivity.this, "asdfghjk", Toast.LENGTH_SHORT).show();
                }
            } catch (Exception e) {

            }

        }
    }

    public void openChatScreen() {

    }

    private void getConversation() {

    }

    @Override
    public void onUserInteraction() {
        super.onUserInteraction();
        try {
            stopAlarmRing();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopAlarmRing() throws Exception {
        try {
            if (isMyServiceRunning(AudioPlay.class)) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        Intent intent = new Intent(FuguChatActivity.this, AudioPlay.class);
                        intent.putExtra("channelId", pushChannelId);
                        intent.putExtra("type", AppManager.AudioType.STOP);
                        startService(intent);
                    }
                }, 50);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public interface RefreshDone {
        void onRefreshComplete();
    }

    private void setConnectionMessage(int status) {
        if (isNetworkAvailable()) {
            switch (status) {
                case 0:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.GONE);
                        }
                    });
                    break;
                case 2:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            progressWheel.setVisibility(View.GONE);
                            retryLayout.setBackgroundColor(Color.parseColor("#FFA500"));
                            btnRetry.setText(Restring.getString(FuguChatActivity.this, R.string.fugu_connecting));
                            new Handler().postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    retryLayout.setBackgroundColor(Color.parseColor("#00FF00"));
                                    btnRetry.setText(Restring.getString(FuguChatActivity.this, R.string.fugu_connected));
                                    retryLayout.setVisibility(View.GONE);
                                }
                            }, 1500);
                        }
                    });
                    break;
                case 3:
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.GONE);
                            btnRetry.setText(Restring.getString(FuguChatActivity.this, R.string.hippo_no_internet_connected));
                            retryLayout.setBackgroundColor(Color.parseColor("#FF0000"));
                            //enableButtons();
                        }
                    });
                    break;
                case 6:
                    retryLayout.setVisibility(View.VISIBLE);
                    retryLayout.setBackgroundColor(Color.parseColor("#FBE799"));
                    new GeneralFunctions().spannableRetryText(btnRetry, Restring.getString(FuguChatActivity.this, R.string.error_msg_yellow_bar), Restring.getString(FuguChatActivity.this, R.string.retry));
                    retryLayout.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            progressWheel.setVisibility(View.VISIBLE);
                            getMessages();
                            new Handler().postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    progressWheel.setVisibility(View.INVISIBLE);
                                }
                            }, 1000);
                        }
                    });
                    break;
            }
        } else {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    retryLayout.setVisibility(View.VISIBLE);
                    progressWheel.setVisibility(View.GONE);
                    btnRetry.setText(Restring.getString(FuguChatActivity.this, R.string.hippo_no_internet_connected));
                    retryLayout.setBackgroundColor(Color.parseColor("#FF0000"));
                    //enableButtons();
                }
            });
        }
    }

    private Dialog progressDialog;
    private TextView tvProgress;
    private TextView innerProgress;

    /**
     * Method to show the progress dialog with a message
     *
     * @param activity
     * @return
     */
    public void showOn(Activity activity) {

        try {
            /* Check if the last instance is alive */
            if (progressDialog != null)
                if (progressDialog.isShowing()) {
                    tvProgress.setText(Restring.getString(FuguChatActivity.this, R.string.fugu_loading));
                    return;
                }

            /*  Ends Here   */

            progressDialog = new Dialog(activity, R.style.Theme_AppCompat_Translucent_Hippo);

            progressDialog.setContentView(R.layout.fugu_dialog_progress);

            tvProgress = (TextView) progressDialog.findViewById(R.id.tvProgress);
            innerProgress = (TextView) progressDialog.findViewById(R.id.progress);
            tvProgress.setText(Restring.getString(FuguChatActivity.this, R.string.fugu_loading));
            innerProgress.setText("");

            ((FuguAgentProgressWheel) progressDialog.findViewById(R.id.progress_wheel)).spin();

            Window dialogWindow = progressDialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
            layoutParams.dimAmount = 0.0f;
            dialogWindow.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
            progressDialog.setCancelable(false);
            progressDialog.setCanceledOnTouchOutside(false);

            progressDialog.show();

        } catch (Exception e) {
            e.printStackTrace();
            Log.e("PROGRESS DIALOG", "EXCEPTION: " + e.getMessage());
        }
    }

    /**
     * Dismisses the Progress Dialog
     */
    public boolean hide() {

        Log.e("PROGRESS DIALOG", "DISMISSED");

        if (progressDialog != null)
            if (progressDialog.isShowing()) {

                try {
                    progressDialog.dismiss();
                } catch (Exception ex) {
                    Log.e("Dismiss Loading Dialog", ex.toString());
                }
                progressDialog = null;
                tvProgress = null;
                innerProgress = null;
                return true;
            }

        return false;
    }

    private void videoCallInit(int callType) {
        ConfCallInit(callType);

        /*String fullname = "";
        String image = "";

        FuguGetMessageResponse response = CommonData.getMessageResponse(conversation.getChannelId());

        if (response != null && response.getData() != null) {
            fullname = response.getData().getCustomerName();
        }

        if (response != null && response.getData() != null && response.getData().getOtherUsers() != null
                && response.getData().getOtherUsers().size() > 0) {
            fullname = response.getData().getOtherUsers().get(0).getFullName();
            image = response.getData().getOtherUsers().get(0).getUserImage();
        }

        HippoCallConfig.getInstance().onCallClick(FuguChatActivity.this, callType, Long.valueOf(currentChannelId),
                Long.valueOf(HippoApplication.getInstance().getUserData().getUserId()),
                true, true, fullname, image);*/
    }


    private void uploadFile(FileuploadModel fileuploadModel) {

        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
        if (fileuploadModels == null)
            fileuploadModels = new ArrayList<>();
        fileuploadModels.add(fileuploadModel);
        String data = new Gson().toJson(fileuploadModels, fileuploadType);
        //Log.e(TAG, "data = " + data);

        Prefs.with(this).save(KEY, data);
        if (!isMyServiceRunning(UploadingService.class)) {
            Intent intent = new Intent(FuguChatActivity.this, UploadingService.class);
            intent.setAction("start");
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                startForegroundService(intent);
            } else {
                startService(intent);
            }
        } else {
            //ToastUtil.getInstance(this).showToast("Already running");
        }
    }

    private BroadcastReceiver mProgressReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                int position = intent.getIntExtra(FuguAppConstant.HIPPO_POSITION, 0);
                String muid = intent.getStringExtra(FuguAppConstant.MESSAGE_UNIQUE_ID);
                Message message = fuguMessageList.get(position);
                if (message.getMuid().equals(muid)) {
                    message.setCurrentprogress(intent.getIntExtra(FuguAppConstant.HIPPO_PROGRESS, 0));
                    message.setUploadStatus(intent.getIntExtra(FuguAppConstant.HIPPO_STATUS_UPLOAD, 1));
                    message.setDownloadStatus(intent.getIntExtra(FuguAppConstant.HIPPO_STATUS_UPLOAD, 1));
                    if (fuguMessageAdapter != null)
                        fuguMessageAdapter.checkHolderAndUpdateProgress(message, position);
                } else {
                    for (int i = fuguMessageList.size() - 1; i > 0; i--) {
                        message = fuguMessageList.get(position);
                        if (message.getMuid().equals(muid)) {
                            position = i;
                            message.setCurrentprogress(intent.getIntExtra(FuguAppConstant.HIPPO_PROGRESS, 0));
                            message.setUploadStatus(intent.getIntExtra(FuguAppConstant.HIPPO_STATUS_UPLOAD, 1));
                            message.setDownloadStatus(intent.getIntExtra(FuguAppConstant.HIPPO_STATUS_UPLOAD, 1));
                            if (fuguMessageAdapter != null)
                                fuguMessageAdapter.checkHolderAndUpdateProgress(message, position);
                            break;
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private BroadcastReceiver fileUploadReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            int status = intent.getIntExtra(BROADCAST_STATUS, 0);
            switch (status) {
                case BroadCastStatus.UPLOADED_SUCESSFULLY:
                    if (currentChannelId == intent.getIntExtra("channelId", -2)) {
                        String muid = intent.getStringExtra("muid");
                        int messageIndex = intent.getIntExtra("messageIndex", 0);
                        String imageUrl = intent.getStringExtra("image_url");
                        String thumbnailUrl = intent.getStringExtra("thumbnail_url");
                        FileuploadModel fileuploadModel = new Gson().fromJson(intent.getStringExtra("fileuploadModel"), FileuploadModel.class);

                        unsentMessageMapNew.put(muid, fileuploadModel.getMessageObject());

                        Message listItem = unsentMessages.get(fileuploadModel.getMuid());
                        if (listItem == null)
                            return;
                        Message message = listItem;
                        message.setMessageStatus(MESSAGE_FILE_UPLOADED);
                        message.setFileUrl(imageUrl);
                        message.setUrl(imageUrl);
                        message.setLocalImagePath("");
                        message.setThumbnailUrl(thumbnailUrl);
                        message.setUploadStatus(UPLOAD_COMPLETED);

                        unsentMessages.put(muid, message);

                        try {
                            fuguMessageList.get(messageIndex).setMessageStatus(MESSAGE_FILE_UPLOADED);
                            fuguMessageAdapter.notifyItemChanged(messageIndex);
                            if (!messageSendingRecursion && isNetworkAvailable()) {
                                sendMessages();
                            }
                        } catch (Exception e) {
                            try {
                                for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                                    Message currentMessage = fuguMessageList.get(i);
                                    if (currentMessage.getMuid().equals(muid)) {
                                        messageIndex = i;
                                        fuguMessageList.get(messageIndex).setMessageStatus(MESSAGE_FILE_UPLOADED);
                                        fuguMessageAdapter.notifyItemChanged(messageIndex);
                                        if (!messageSendingRecursion && isNetworkAvailable()) {
                                            sendMessages();
                                        }
                                        break;
                                    }
                                }
                            } catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                    break;
                case BroadCastStatus.UPLOADING_FAILED:
                    if (currentChannelId == intent.getIntExtra("channelId", -2)) {
                        String muid = intent.getStringExtra("muid");
                        int messageIndex = intent.getIntExtra("messageIndex", 0);
                        String imageUrl = intent.getStringExtra("image_url");
                        String thumbnailUrl = intent.getStringExtra("thumbnail_url");
                        FileuploadModel fileuploadModel = new Gson().fromJson(intent.getStringExtra("fileuploadModel"), FileuploadModel.class);

                        unsentMessageMapNew.put(muid, fileuploadModel.getMessageObject());

                        Message message = unsentMessages.get(fileuploadModel.getMuid());
                        if (message == null)
                            return;
                        message.setMessageStatus(MESSAGE_FILE_RETRY);
                        message.setFileUrl(imageUrl);
                        message.setUrl(imageUrl);
                        message.setLocalImagePath(fileuploadModel.getFilePath());
                        message.setThumbnailUrl(thumbnailUrl);
                        message.setUploadStatus(UPLOAD_FAILED);

                        unsentMessages.put(muid, message);

                        try {
                            fuguMessageList.get(messageIndex).setMessageStatus(MESSAGE_FILE_RETRY);
                            fuguMessageAdapter.notifyItemChanged(messageIndex);
                        } catch (Exception e) {
                            try {
                                for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                                    Message currentMessage = fuguMessageList.get(i);
                                    if (currentMessage.getMuid().equals(muid)) {
                                        messageIndex = i;
                                        fuguMessageList.get(messageIndex).setMessageStatus(MESSAGE_FILE_RETRY);
                                        fuguMessageAdapter.notifyItemChanged(messageIndex);
                                        break;
                                    }
                                }
                            } catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                    break;
                case BroadCastStatus.PUBLISHED:

                    break;
                case BroadCastStatus.CREATE_CHANNEL:
//                    if(CommonData.isFirstTimeCreated()) {
//                        CommonData.setFirstTimeCreated(false);
//                        final FileuploadModel fileuploadModel = new Gson().fromJson(intent.getStringExtra("fileuploadModel"), FileuploadModel.class);
//                        runOnUiThread(new Runnable() {
//                            @Override
//                            public void run() {
//                                createConversation(fileuploadModel.getMessageObject(), fileuploadModel.getLabelId());
//                            }
//                        });
//
//                    }
                    break;
                case BroadCastStatus.MESSAGE_EXPIRED:
                    String muid = intent.getStringExtra("muid");
                    int messageIndex = intent.getIntExtra("messageIndex", 0);

                    if (unsentMessages == null)
                        unsentMessages = new LinkedHashMap<>();

                    Message listItem = unsentMessages.get(muid);
                    if (listItem != null) {
                        listItem.setIsMessageExpired(1);
                        listItem.setUploadStatus(UPLOAD_FAILED);
                    }

                    try {
                        JSONObject messageJson = unsentMessageMapNew.get(muid);
                        messageJson.put("is_message_expired", 1);
                        unsentMessageMapNew.put(muid, messageJson);
                        index = messageJson.optInt("message_index", -1);
                        fuguMessageAdapter.notifyItemChanged(index);
                    } catch (Exception e) {
                        //e.printStackTrace();
                    }

                    CommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
                    CommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

                    break;
                case BroadCastStatus.FILE_TYPE_NOT_ALLOWED:
                    String muidd = intent.getStringExtra("muid");
                    String errorMessage = intent.getStringExtra("errorMessage");
                    int channelId = intent.getIntExtra("channelId", -2);
                    int messageIndexx = intent.getIntExtra("messageIndex", 0);
                    if (currentChannelId == intent.getIntExtra("channelId", -2)) {

                        unsentMessages.remove(muidd);
                        unsentMessageMapNew.remove(muidd);
                        fuguMessageList.remove(messageIndexx);
                        if (fuguMessageList.size() > 0) {
                            if (fuguMessageList.get(fuguMessageList.size() - 1).getMessageType() == 0) {
                                fuguMessageList.remove(fuguMessageList.size() - 1);
                            }
                        }
                        fuguMessageAdapter.notifyDataSetChanged();
                    } else {
                        LinkedHashMap<String, JSONObject> unsent = CommonData.getUnsentMessageMapByChannel(channelId);
                        LinkedHashMap<String, Message> unsentmsg = CommonData.getUnsentMessageByChannel(channelId);

                        unsent.remove(muidd);
                        unsentmsg.remove(unsentmsg);
                        CommonData.setUnsentMessageMapByChannel(channelId, unsent);
                        CommonData.setUnsentMessageByChannel(channelId, unsentmsg);
                    }
                    Toast.makeText(FuguChatActivity.this, errorMessage, Toast.LENGTH_SHORT).show();

                    break;
                default:

                    break;
            }
        }
    };


    public boolean checkPermission() {
        return EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    /**
     * Read external storage file
     */
    @AfterPermissionGranted(RC_READ_EXTERNAL_STORAGE)
    public void readExternalStorage() {
        boolean isGranted = EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        if (isGranted) {
            //openFileIntent();
        } else {
            EasyPermissions.requestPermissions(this, Restring.getString(FuguChatActivity.this, R.string.vw_rationale_storage),
                    RC_READ_EXTERNAL_STORAGE, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    private void onChannelUpdate(int channelId) throws Exception {
        new ChannelInfoRepo(FuguChatActivity.this, 0).updateChannelInfo(channelId);
    }

    private String userImage = "";

    private String getUserImage() {
        if (TextUtils.isEmpty(userImage))
            userImage = HippoApplication.getInstance().getUserData().getUserImage();
        return userImage;
    }

    boolean isMessageInEditMode = false;
    private String firstEditMuid = "";
    int editPosition = -1;

    public void cancelEditing() {
        cancelEditing("");
    }

    public void cancelEditing(String message) {
        int position = editPosition;
        if (position == -1) {
            for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                Message msg = fuguMessageList.get(i);
                if (msg.getMuid().equalsIgnoreCase(firstEditMuid)) {
                    position = i;
                    break;
                }
            }
        }
        if (position == -1) {
            return;
        }
        fuguMessageList.get(position).setEditMode(false);
        fuguMessageAdapter.notifyItemChanged(position);
        etMsg.setText("");
        firstEditMuid = "";
        editPosition = -1;
        isMessageInEditMode = false;
        if (!isO2oChat)
            ivAttachment.setVisibility(View.VISIBLE);
        ivCancelEdit.setVisibility(View.GONE);
        ivSend.setImageResource(R.drawable.ic_new_send);
        checkAudioButton();
        ivSend.setVisibility(View.GONE);
    }

    public void editText(int position) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                int pos = position;
                if (pos > fuguMessageList.size() - 1) {
                    pos = fuguMessageList.size() - 1;
                }
                fuguMessageAdapter.setOnLongClickValue(false);
                if (isMessageInEditMode && editPosition > -1) {
                    fuguMessageList.get(editPosition).setEditMode(false);
                    fuguMessageAdapter.notifyItemChanged(editPosition);
                    firstEditMuid = "";
                    etMsg.setText("");
                }

                editPosition = pos;
                isMessageInEditMode = true;

                Message message = fuguMessageList.get(pos);
                message.setEditMode(true);
                fuguMessageAdapter.notifyItemChanged(pos);
                ivAttachment.setVisibility(View.GONE);
                ivCancelEdit.setVisibility(View.VISIBLE);
                ivSend.setImageResource(R.drawable.success);
                ivSend.setVisibility(View.VISIBLE);
                record_button.setVisibility(View.GONE);
                record_view.setVisibility(View.GONE);
                etMsg.setText(message.getMessage());
                etMsg.requestFocus();
                firstEditMuid = message.getMuid();
                new Handler().post(new Runnable() {
                    @Override
                    public void run() {
                        etMsg.setSelection(message.getMessage().length());
                        KeyboardUtil.toggleKeyboardVisibility(FuguChatActivity.this, false);
                    }
                });

            }
        });
    }

    public void copyToClipBoard(String text) {
        ClipboardManager clipboard = (ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE);
        ClipData clip = ClipData.newPlainText("", text);
        clipboard.setPrimaryClip(clip);
        Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.hippo_copy_to_clipboard), Toast.LENGTH_SHORT).show();
    }

    public void copyText(int position, boolean isReplied) {
        try {
            Message messageObj = fuguMessageList.get(position);
            int selectedPosition = 0;
            if (messageObj.getMessageType() == USER_CONCENT_MESSAGE_LOCAL && isReplied) {
                String selectedBtnId = "";
                if (!TextUtils.isEmpty(messageObj.getSelectedBtnId())) {
                    selectedBtnId = messageObj.getSelectedBtnId();
                }

                for (int i = 0; i < messageObj.getContentValue().size(); i++) {
                    if (selectedBtnId.equalsIgnoreCase(messageObj.getContentValue().get(i).getBtnId())) {
                        selectedPosition = i;
                        break;
                    }
                }
            }

            fuguMessageAdapter.setOnLongClickValue(false);
            ClipboardManager clipboard = (ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE);
            String message = messageObj.getMessage().replace("<br/>", "hippoLineBreak").replace("<br>", "hippoLineBreak").replace("\n", "hippoLineBreak");
            if (isReplied) {
                message = messageObj.getContentValue().get(selectedPosition).getBtnTitle();
            }
            ClipData clip = ClipData.newPlainText("", Html.fromHtml(message).toString().replace("hippoLineBreak", "\n"));
            clipboard.setPrimaryClip(clip);
        } catch (Exception e) {
            fuguMessageAdapter.setOnLongClickValue(false);
            ClipboardManager clipboard = (ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE);
            Message messageObj = fuguMessageList.get(fuguMessageList.size() - 1);
            String message = messageObj.getMessage().replace("<br/>", "hippoLineBreak").replace("<br>", "hippoLineBreak").replace("\n", "hippoLineBreak");
            ClipData clip = ClipData.newPlainText("", Html.fromHtml(message).toString().replace("hippoLineBreak", "\n"));
            clipboard.setPrimaryClip(clip);

            e.printStackTrace();
        }
    }

    public void setOnLongClickValue() {
        fuguMessageAdapter.setOnLongClickValue(false);
    }

    private void sendUpdatedMessage(String messageStr) {
        int position = editPosition;
        if (position == -1) {
            for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                Message msg = fuguMessageList.get(i);
                if (msg.getMuid().equalsIgnoreCase(firstEditMuid)) {
                    position = i;
                    break;
                }
            }
        }
        if (position == -1) {
            return;
        }

        Message savedMessage;
        boolean isUnsentMessage = false;
        savedMessage = sentMessages.get(firstEditMuid);
        if (savedMessage == null) {
            savedMessage = unsentMessages.get(firstEditMuid);
            if (savedMessage != null)
                isUnsentMessage = true;
        }


        if (isUnsentMessage) {
            savedMessage.setMessage(messageStr);
            unsentMessages.put(firstEditMuid, savedMessage);
            fuguMessageList.get(position).setMessage(messageStr);
            fuguMessageList.get(position).setEditMode(false);
            //fuguMessageList.get(position).setIsEdited(1);
            fuguMessageAdapter.notifyItemChanged(position);
            etMsg.setText("");
            firstEditMuid = "";
            editPosition = -1;
            isMessageInEditMode = false;
            if (!isO2oChat)
                ivAttachment.setVisibility(View.VISIBLE);
            ivCancelEdit.setVisibility(View.GONE);
            ivSend.setImageResource(R.drawable.ic_new_send);
        } else {
            if (isNetworkAvailable()) {
                updateMessage(messageStr);
//                CommonParams commonParams = new CommonParams.Builder()
//                        .add(Constants.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken() == null ? "" : HippoApplication.getInstance().getUserData().getAccessToken())
//                        .add("user_id", conversation.getUserId())
//                        .add("channel_id", conversation.getChannelId())
//                        .add("message_muid", firstEditMuid)
//                        .add("task_status", )
//                        .add("message", messageStr)
//                        .build();
//                Message finalSavedMessage = savedMessage;
//                int finalPosition = position;
//                RestClient.getApiInterface().editMessage(commonParams.getMap()).enqueue(new ResponseResolver<Message>() {
//                    @Override
//                    public void success(Message message) {
//                        if (finalSavedMessage != null) {
//                            finalSavedMessage.setMessage(messageStr);
//                            finalSavedMessage.setIsEdited(1);
//                            sentMessages.put(firstEditMuid, finalSavedMessage);
//                        }
//
//                        fuguMessageList.get(finalPosition).setMessage(message.getMessage());
//                        fuguMessageList.get(finalPosition).setEditMode(false);
//                        fuguMessageList.get(finalPosition).setIsEdited(1);
//                        fuguMessageAdapter.notifyItemChanged(finalPosition);
//                        etMsg.setText("");
//                        firstEditMuid = "";
//                        editPosition = -1;
//                        isMessageInEditMode = false;
//                        if(!isO2oChat)
//                            ivAttachment.setVisibility(View.VISIBLE);
//                        ivCancelEdit.setVisibility(View.GONE);
//                        ivSend.setImageResource(R.drawable.ic_new_send);
//                    }
//
//                    @Override
//                    public void failure(APIError error) {
//                        fuguMessageList.get(finalPosition).setEditMode(false);
//                        fuguMessageList.get(finalPosition).setIsEdited(0);
//                        fuguMessageAdapter.notifyItemChanged(finalPosition);
//                        etMsg.setText("");
//                        firstEditMuid = "";
//                        editPosition = -1;
//                        isMessageInEditMode = false;
//                        if(!isO2oChat)
//                            ivAttachment.setVisibility(View.VISIBLE);
//                        ivCancelEdit.setVisibility(View.GONE);
//                        ivSend.setImageResource(R.drawable.ic_new_send);
//                    }
//                });
            }
        }

//        fuguMessageList.get(position).setMessage(message);
//        fuguMessageList.get(position).setEditMode(false);
//        fuguMessageList.get(position).setIsEdited(1);
//        fuguMessageAdapter.notifyItemChanged(position);
//        etMsg.setText("");
//        firstEditMuid = "";
//        editPosition = -1;
//        isMessageInEditMode = false;
//        ivAttachment.setVisibility(View.VISIBLE);
//        ivCancelEdit.setVisibility(View.GONE);
//        ivSend.setImageResource(R.drawable.ic_send);


    }


    @Override
    public void showImageDialog(Activity context, String imgUrl, ImageView imageView, Message message) {
        try {

            if (!Utils.preventMultipleClicks()) {
                return;
            }

            String thumbUrl = message.getThumbnailUrl();
            String fileUrl = message.getImageUrl();

            if (!message.getThumbnailUrl().isEmpty())
                thumbUrl = message.getThumbnailUrl();
            else if (!message.getImageUrl().isEmpty())
                thumbUrl = message.getImageUrl();
            else if (!message.getFileUrl().isEmpty())
                thumbUrl = message.getFileUrl();

            if (!message.getImageUrl().isEmpty())
                fileUrl = message.getImageUrl();
            else if (!message.getFileUrl().isEmpty())
                fileUrl = message.getFileUrl();


            Intent imageIntent = new Intent(context, ImageDisplayActivity.class);
            Image image = new Image(fileUrl, thumbUrl, message.getMuid(), message.getSentAtUtc(), "");
            imageIntent.putExtra("image", image);
            imageIntent.putExtra("image", image);
            String imageTransitionName = "";
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                imageTransitionName = imageView.getTransitionName();
            }
            Pair<View, String> pair1 = Pair.create(imageView, imageView.getTransitionName());
            ActivityOptionsCompat options = ActivityOptionsCompat.
                    makeSceneTransitionAnimation(this, pair1);

            //ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation(context, imageView, message.getMuid());
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                startActivityForResult(imageIntent, 602, options.toBundle());
            } else {
                startActivityForResult(imageIntent, 602);
            }
//                showImageDialog(mContext, message.image_url, (selfImageMessageViewHolder.ivImageMessage.drawable as BitmapDrawable).bitmap)
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final int TEXT_MESSAGE = 1;
    private static final int ASSIGNMENT_MESSAGE = 2;
    private static final int PRIVATE_NOTE = 3;
    private static final int IMAGE_MESSAGE = 10;
    private static final int FILE_MESSAGE = 11;
    private static final int FEEDBACK_MESSAGE = 14;
    private static final int BOT_TEXT_MESSAGE = 15;
    private static final int BOT_BUTTON_MESSAGE = 16;
    private static final int BOT_FORM_MESSAGE = 17;
    private static final int VIDEO_CALL = 18;
    private static final int ACTION_MESSAGE_NEW = 19;
    private static final int USER_CONCENT_MESSAGE = 20;
    private static final int AGENT_CARD_VIEW = 22;
    private static final int MULTI_SELECTION = 23;
    private static final int FILE_PDF_MESSAGE = 24;


    public int getType(int messageType, boolean isSelf, String docType) {
        switch (messageType) {
            case IMAGE_MESSAGE:
                if (isSelf)
                    return HIPPO_IMAGE_SENT;
                else
                    return HIPPO_IMAGE_RECEIVED;
            case TEXT_MESSAGE:
                if (isSelf)
                    return ITEM_TYPE_SELF;
                else
                    return ITEM_TYPE_OTHER;
            case BOT_TEXT_MESSAGE:
            case BOT_BUTTON_MESSAGE:
                return ITEM_TYPE_SELF;
            case ASSIGNMENT_MESSAGE:
                return ITEM_ASSIGNMENT;
            case PRIVATE_NOTE:
                return ITEM_TYPE_SELF;
            case FEEDBACK_MESSAGE:
                return FUGU_RATING_VIEW;
            case BOT_FORM_MESSAGE:
                return LEAD_FORM_VIEW;
            case VIDEO_CALL:
                if (isSelf) {
                    return FUGU_VIDEO_CALL_VIEW;
                } else {
                    return FUGU_OTHER_VIDEO_CALL_VIEW;
                }
            case ACTION_MESSAGE_NEW:
                return CUSTOM_VIEW_TYPE;
            case FILE_MESSAGE:
                if (isSelf) {
                    if (docType.equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString())) {
                        return HIPPO_VIDEO_MESSGAE_SELF;
                    } else {
                        return HIPPO_FILE_SENT_VIEW;
                    }
                } else {
                    if (docType.equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString())) {
                        return HIPPO_VIDEO_MESSGAE_OTHER;
                    } else {
                        return HIPPO_FILE_RECEIVED_VIEW;
                    }
                }
            case USER_CONCENT_MESSAGE:
                return HIPPO_USER_CONCENT_VIEW;
            case AGENT_CARD_VIEW:
                return HIPPO_PAYMENT_VIEW;
            case MULTI_SELECTION:
                return HIPPO_MULTISELECTION_VIEW;
        }
        return -1;
    }

    public void sendPaymentRequest(ArrayList<PaymentData> paymentData) {

        Log.w("paymentData", "paymentData ====================> " + new Gson().toJson(paymentData));
        paymentProgressWheel.setVisibility(View.VISIBLE);
        paymentProgressWheel.spin();
        ivPaymentBtn.setVisibility(View.GONE);

        MakePayment makePayment = new MakePayment();
        makePayment.setAccess_token(HippoApplication.getInstance().getUserData().getAccessToken() == null ? "" : HippoApplication.getInstance().getUserData().getAccessToken());
        makePayment.setChannel_id(conversation.getChannelId());
        makePayment.setItems(paymentData);
        makePayment.setIs_message_only(1);
        /*if (paymentData != null && paymentData.size() > 1) {
            makePayment.setIs_message_only(1);
        }*/
        Log.e("PaymentData", "makePayment = " + new Gson().toJson(makePayment));

        createPaymentLink(makePayment);

    }

    private void createPaymentLink(MakePayment makePayment) {
        if (isNetworkAvailable()) {
            if (!TextUtils.isEmpty(HippoConfig.getInstance().getCurrentLanguage())) {
                makePayment.setLang(HippoConfig.getInstance().getCurrentLanguage());
            }
            Logger.INSTANCE.apiRequest("/api/payment/sendPaymentUrl", new Gson().toJson(makePayment));
            RestClient.getApiInterface().createPaymentLink(makePayment)
                    .enqueue(new ResponseResolver<CommonResponse>(FuguChatActivity.this, false, false) {
                        @Override
                        public void success(CommonResponse editUserDetails) {
                            Logger.INSTANCE.apiResponse("/api/users/editUserDetails", "");
                            paymentProgressWheel.setVisibility(View.GONE);
                            ivPaymentBtn.setVisibility(View.VISIBLE);
                        }

                        @Override
                        public void failure(APIError error) {
                            Logger.INSTANCE.apiFailed("/api/users/editUserDetails", error.getMessage());
                            LoadingBox.hide();
                            if (!TextUtils.isEmpty(error.getMessage()))
                                Toast.makeText(FuguChatActivity.this, "" + error.getMessage(), Toast.LENGTH_SHORT).show();
                            ivPaymentBtn.setVisibility(View.VISIBLE);
                            paymentProgressWheel.setVisibility(View.GONE);
                            Log.e("error", "error");
                        }
                    });
        } else {
            paymentProgressWheel.setVisibility(View.GONE);
            ivPaymentBtn.setVisibility(View.VISIBLE);
            Toast.makeText(FuguChatActivity.this, Restring.getString(FuguChatActivity.this, R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    private void closeChat() {
        if (conversation.getStatus() == MessageMode.OPEN_CHAT.getOrdinal()
                && HippoApplication.getInstance().getUserData().getBusinessProperty().isClosingReasonEnabled()
                && !TextUtils.isEmpty(dealId)
                && HippoApplication.getInstance().getUserData().getBusinessProperty().getCrmIntegrationType() == 1) {
            performMarkConversationWithMessage();
        } else {
            performMarkConversation();
        }
    }

    private void performMarkConversationWithMessage() {

        String title = Restring.getString(FuguChatActivity.this, R.string.hippo_close_conversation);
        String message = Restring.getString(FuguChatActivity.this, R.string.hippo_closing_notes);
        DialogPop dialogPop = new DialogPop();
        dialogPop.alertPopupWithEditText(FuguChatActivity.this, "", message, Restring.getString(FuguChatActivity.this, R.string.close)
                , Restring.getString(FuguChatActivity.this, R.string.cancel), new DialogPop.CallbackListener() {
                    @Override
                    public void onPositiveClick(String notes) {
                        apiMarkConversation(notes);
                    }

                    @Override
                    public void onNegativeClick() {

                    }
                });
    }

    private void openDealInfo() {
        DealinfoFragment fragment = new DealinfoFragment();
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty(editDeal.getText().toString()) && editDeal.getText().toString().equalsIgnoreCase(Restring.getString(FuguChatActivity.this, R.string.add_deal)))
            bundle.putBoolean("add_deal", true);
        if (dealInfo != null) {
            bundle.putString("dealInfo", new Gson().toJson(dealInfo));
        }
        fragment.setArguments(bundle);
        fragment.show(getSupportFragmentManager().beginTransaction(), "fragment_dialog");

        if (llCollapsingLayout.getVisibility() == View.VISIBLE)
            collapse(llCollapsingLayout);

    }

    private void ConfCallInit(int callType) {
        String fullname = "";
        String image = "";

        FuguGetMessageResponse response = CommonData.getMessageResponse(conversation.getChannelId());

        if (response != null && response.getData() != null) {
            fullname = response.getData().getCustomerName();
        }

        if (response != null && response.getData() != null && response.getData().getOtherUsers() != null
                && response.getData().getOtherUsers().size() > 0) {
            fullname = response.getData().getOtherUsers().get(0).getFullName();
            image = response.getData().getOtherUsers().get(0).getUserImage();
        }

        if (!isMyServiceRunning(OngoingCallService.class)) {
            onConfCallClick(FuguChatActivity.this, callType, Long.valueOf(conversation.getChannelId()),
                    HippoApplication.getInstance().getUserData().getUserId(),
                    true, true, fullname, image);
        }
    }


    private void onConfCallClick(Context context, int callType, Long channelId, Integer userId, boolean isAgentFlow,
                                 boolean isAllowCall, String fullname, String image) {

        onCallBtnHit = true;
        onCallBtnHitPause = true;
        com.hippoagent.hippocall.model.Message turnCredentials = new AppContants().getTurnCredentials();
        String activityLaunchState = WebRTCCallConstants.AcitivityLaunchState.SELF.toString();
        String messageUniqueId = UUID.randomUUID().toString();
        String typeCall = WebRTCCallConstants.CallType.VIDEO.toString();
        if (callType == 2)
            typeCall = WebRTCCallConstants.CallType.AUDIO.toString();

        String myName = HippoApplication.getInstance().getUserData().getFullName();
        String myImage = HippoApplication.getInstance().getUserData().getUserImage();
        String jitsiLink = "";
        if (HippoApplication.getInstance().getUserData().getBusinessProperty().getCallingType().equalsIgnoreCase("3")) {
            jitsiLink = getRandomString();
        }

        VideoCallModel videoCallModel = new VideoCallModel(channelId,
                image, fullname, userId, -1, fullname,
                turnCredentials.getTurnApiKey(),
                turnCredentials.getUsername(),
                turnCredentials.getCredentials(),
                (ArrayList<String>) (turnCredentials.getIceServers().getStun()),
                (ArrayList<String>) (turnCredentials.getIceServers().getTurn()),
                activityLaunchState,
                messageUniqueId,
                typeCall, "", jitsiLink, "", myName, myImage);

        HippoCallConfig.getInstance().onConfCallClick(this, videoCallModel);

    }

    private String getRandomString() {
        String ALLOWED_CHARACTERS = "0123456789qwertyuiopasdfghjklzxcvbnm";

        Random random = new Random();
        StringBuilder sb = new StringBuilder(8);
        for (int i = 0; i < 8; ++i)
            sb.append(ALLOWED_CHARACTERS.charAt(random.nextInt(ALLOWED_CHARACTERS.length())));
        return sb.toString();
    }

    private void createViaEmail(String email) {
        CommonParams commonParams = new CommonParams.Builder()
                .add(FuguAppConstant.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .add("chat_with_email", email)
                .build();

        RestClient.getApiInterface().createO2OConversation(commonParams.getMap()).enqueue(new ResponseResolver<CreateConversation>(FuguChatActivity.this, true, false) {
            @Override
            public void success(CreateConversation createConversation) {
                conversation = new Conversation();
                conversation.setChannelId(createConversation.getData().getChannelId());
                conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());

                checkAudioButton();

                pushChannelId = conversation.getChannelId();
                currentChannelId = conversation.getChannelId();
                isFromGetConversation = true;

                setSubscribeChannel();
                getMessages();
            }

            @Override
            public void failure(APIError error) {
                String errorMsg = TextUtils.isEmpty(error.getMessage()) ? Restring.getString(FuguChatActivity.this, R.string.hippo_something_wrong) : error.getMessage();
                Toast.makeText(FuguChatActivity.this, errorMsg, Toast.LENGTH_SHORT).show();
            }
        });
    }


    private void createAgentSupportChannel(String email, String transactionId, ArrayList<String> groupingTags) {
        createAgentSupportChannel(email, transactionId, groupingTags, false);
    }

    private void createAgentSupportChannel(String email, String transactionId, ArrayList<String> groupingTags, boolean initiated_by_agent) {


        if (groupingTags.size() == 0) {
            ToastUtil.getInstance(FuguChatActivity.this).showToast(Restring.getString(FuguChatActivity.this, R.string.grouping_tags_cannot_be_empty));
            return;
        }

        CommonParams.Builder params = new CommonParams.Builder();
        params.add(FuguAppConstant.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken());
        params.add("transaction_id", transactionId);

        if (initiated_by_agent) {
            params.add("initiated_by_agent", "1");
            params.add("other_user_email", email);
        }

        if (groupingTags != null && groupingTags.size() > 0)
            params.add("grouping_tags", new Gson().toJson(groupingTags));

        if (isCreateChannelByTransactionId)
            params.add("single_channel_by_transaction_id", 1);

        CommonParams commonParams = params.build();
        RestClient.getApiInterface().createAgentSupportChannel(commonParams.getMap()).enqueue(new ResponseResolver<CreateConversation>(FuguChatActivity.this, true, false) {
            @Override
            public void success(CreateConversation createConversation) {
                conversation = new Conversation();
                conversation.setChannelId(createConversation.getData().getChannelId());
                conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());
                status = MessageMode.CLOSED_CHAT.getOrdinal();
                if (isMerchantChat)
                    conversation.setChatType(2);

                checkAudioButton();

                pushChannelId = conversation.getChannelId();
                currentChannelId = conversation.getChannelId();
                isFromGetConversation = true;

                setSubscribeChannel();
                getMessages();
            }

            @Override
            public void failure(APIError error) {
                String errorMsg = TextUtils.isEmpty(error.getMessage()) ? Restring.getString(FuguChatActivity.this, R.string.hippo_something_wrong) : error.getMessage();
                Toast.makeText(FuguChatActivity.this, errorMsg, Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void updateMessage(final String message) {
        MessageUpdate.INSTANCE.updateMessage(FuguChatActivity.this, conversation.getChannelId(),
                firstEditMuid, 2, message, new OnMessageUpdate() {

                    @Override
                    public void onUpdatefailed() {
                        cancelEditing();
                    }

                    @Override
                    public void onUpdateListener() {
                        cancelEditing();
                    }
                });
    }

    public void deleteMessage(int position, String muid, int messageStatus) {
        firstEditMuid = muid;
        editPosition = position;

        MessageUpdate.INSTANCE.updateMessage(FuguChatActivity.this, conversation.getChannelId(),
                muid, 1, "", new OnMessageUpdate() {

                    @Override
                    public void onUpdatefailed() {
                        //sendAndupdateMessage("");

                    }

                    @Override
                    public void onUpdateListener() {

                    }
                });
    }

    private void updateEdittedMessage(JSONObject messageJson) {
        String muid = messageJson.optString("muid");
        Message msg = sentMessages.get(muid);
        if (editPosition == -1) {
            if (muid.equalsIgnoreCase(fuguMessageList.get(msg.getMessageIndex()).getMuid()))
                editPosition = msg.getMessageIndex();
            else {
                for (int i = fuguMessageList.size() - 1; i >= 0; i--) {
                    Message currentMessage = fuguMessageList.get(i);
                    if (currentMessage.getMuid().equals(muid)) {
                        editPosition = i;
                        break;
                    }
                }
            }
        }
        Message message = fuguMessageList.get(editPosition);
        if (messageJson.optInt("status") == 2) {
            fuguMessageList.get(editPosition).setMessage(messageJson.optString("edited_message"));
            fuguMessageList.get(editPosition).setMessageState(5);
            sentMessages.get(muid).setMessage(messageJson.optString("edited_message"));
            sentMessages.get(muid).setMessageState(5);
        } else if (messageJson.optInt("status") == 1) {
            fuguMessageList.get(editPosition).setMessage("Message has been deleted");
            fuguMessageList.get(editPosition).setMessageState(4);
            fuguMessageList.get(editPosition).setMessageType(TEXT_MESSAGE);
            sentMessages.get(muid).setMessage("Message has been deleted");
            sentMessages.get(muid).setMessageState(4);
        }
        fuguMessageAdapter.updateList(fuguMessageList);
        try {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    fuguMessageAdapter.notifyItemChanged(editPosition);
                    Log.e("editPosition", "*************************************** " + editPosition);
                    editPosition = -1;
                }
            });
        } catch (Exception e) {

        }


    }

    private boolean isShareclick = false;

    private void registerBroadcast() {
        LocalBroadcastManager.getInstance(this).registerReceiver(mLinkShare, new IntentFilter("URL SHARED"));
    }

    private void UnregisterBroadcast() {
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mLinkShare);
    }

    private BroadcastReceiver mLinkShare = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("URL SHARED")) {
                if (intent.hasExtra("roomUrl") && !isShareclick) {
                    isShareclick = true;

                    createUrl(intent.getStringExtra("roomUrl"));
                }
            }
        }
    };

    private void createUrl(String url) {
        if (HippoApplication.getInstance().getUserData().getBusinessProperty().getIsCallInviteEnabled() == 1) {
            CommonParamsObj params = new CommonParamsObj.Builder()
                    .add(ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                    .add("en_creator_id", HippoApplication.getInstance().getUserData().getEnUserId())
                    .add("creator_id", HippoApplication.getInstance().getUserData().getUserId())
                    .add("meet_url", url)
                    .build();
            RestClient.getApiInterface().createInviteLink(params.getMap()).enqueue(new ResponseResolver<ShareUrlModel>() {
                @Override
                public void success(ShareUrlModel shareUrlModel) {
                    isShareclick = false;
                    Utils.shareCallUrl(shareUrlModel.getData().getMeetUrl(), FuguChatActivity.this);
                }

                @Override
                public void failure(APIError error) {
                    isShareclick = false;

                }


            });
        }
    }

}