package com.hippoagent.activities

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import android.view.View
import androidx.fragment.app.Fragment
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.eventbus.*
import com.hippoagent.fragments.LauncherFragment
import com.hippoagent.helper.BusEvents
import com.hippoagent.helper.ConnectionManager
import com.hippoagent.helper.FayeMessage
import com.hippoagent.model.Conversation
import com.hippoagent.model.GetConversationResponse
import com.hippoagent.services.HippoService
import com.hippoagent.utils.Constants
import com.hippoagent.utils.Log
import com.google.gson.Gson
import com.hippoagent.HippoConfig
import com.squareup.otto.Subscribe
import kotlinx.android.synthetic.main.home_activity.*
import org.json.JSONObject



/**
 * Created by gurmail on 2019-12-27.
 * @author gurmail
 */
class HomeActivity: BaseActivity() {

    var notifiacrionClicked: Boolean = false
    public fun isNotifiacrionClicked() :Boolean {
        return notifiacrionClicked;
    }

    public fun setNotifiacrionClick(flag: Boolean) {
        this.notifiacrionClicked = flag
    }


    var isFromFilter: Boolean = false
    var conversation: Conversation? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.home_activity)

        isFromFilter = false

        //startHippoService()
        HippoApplication.getInstance().isAppOpen = 1

        BusProvider.getInstance().register(this);

        if (intent.hasExtra(Constants.CONVERSATION)) {
            conversation = Gson().fromJson(intent.getStringExtra(Constants.CONVERSATION), Conversation::class.java)
            if (conversation != null && conversation!!.getChannelId() > 0) {
                notifiacrionClicked = true
                val intent = Intent(this@HomeActivity, FuguChatActivity::class.java)
                intent.putExtra(Constants.CONVERSATION, Gson().toJson(conversation, Conversation::class.java))
                intent.flags = Intent.FLAG_ACTIVITY_CLEAR_TOP or Intent.FLAG_ACTIVITY_NEW_TASK
                //TODO: 2019-12-30
                //intent.putExtra(GAEvents.CHAT_CLICKED, tvTitle.getText().toString())
                startActivity(intent)
            }
        }

        if (savedInstanceState == null) {
            supportFragmentManager.beginTransaction()
                    .replace(R.id.container, LauncherFragment.newInstance())
                    .commitNow()
        }



    }

    override fun updateOnActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {

    }

    override fun getDrawerLayout(): View {
        return mainLayout
    }

    override fun showUpdate(flag: Boolean) {

    }

    override fun onStart() {
        super.onStart()

    }

    override fun onStop() {
        super.onStop()

    }

    override fun onResume() {
        super.onResume()
        BusProvider.getInstance().post(OnResume())
    }

    override fun onBackPressed() {
        if(pagerPosition == 0) {
            super.onBackPressed()
            //finishAffinity()
        } else {
            BusProvider.getInstance().post(FragmentEvent(3, 0))
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        HippoApplication.getInstance().isAppOpen = null
        BusProvider.getInstance().unregister(this)
    }

    @Subscribe public fun onUpdateEvent(event: UpdateEvent) {
        when(event.type) {
            4 -> pagerPosition(event.position)
            else -> {

            }
        }
    }

    var pagerPosition = 0
    private fun pagerPosition(pagerPosition: Int) {
        this.pagerPosition = pagerPosition
    }

    @Subscribe
    public fun onButtonClick(events: ButtonClick) {
        if(events.eventType == 1) {
            if(events.buttonClicked == 1) {
                onBackPressed()
            }
        }
    }

}