package com.hippoagent.activities

import android.app.Activity
import android.app.Dialog
import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.text.TextUtils
import android.view.View
import android.view.WindowManager
import android.widget.ImageView
import android.widget.TextView
import android.widget.Toast
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.bumptech.glide.Priority
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.load.resource.bitmap.CenterCrop
import com.bumptech.glide.load.resource.bitmap.RoundedCorners
import com.bumptech.glide.request.RequestOptions

import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.adapters.MediaFileItemAdapter
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.model.FileuploadModel
import com.hippoagent.model.Image
import com.hippoagent.model.attachmentData.AttachmentDataList
import com.hippoagent.model.attachmentData.AttachmentResponse
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.Log
import com.hippoagent.utils.Utils
import com.hippoagent.utils.filePicker.FileManager
import com.hippoagent.utils.zoomview.ZoomageView
import kotlinx.android.synthetic.main.activity_media_list.*
import kotlinx.android.synthetic.main.fragment_add_card.*
import java.io.File
import java.text.SimpleDateFormat
import java.util.*

class MediaListActivity : FuguBaseActivity(), MediaFileItemAdapter.ItemListener {

    private var mediaAdapter: MediaFileItemAdapter? = null
    private lateinit var activity: Activity
    private var channelID: String? = ""
    private var page_start = 0
    private var row_count = 30
    var dataList = ArrayList<AttachmentDataList>()
    var isNextPage = true
    var apiInProgress = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_media_list)
        setSupportActionBar(my_toolbar)
        setToolbar(my_toolbar, getString(R.string.shared_media))
        activity = this

        my_toolbar.setNavigationOnClickListener {
            onBackPressed()
        }

        channelID = intent.getStringExtra("channelID")


        getMediaLIst(page_start, row_count);
    }

    private fun getMediaLIst(pageStart: Int, pageEnd: Int) {

        val params: CommonParams.Builder = CommonParams.Builder()
        params.add("access_token", HippoApplication.getInstance().userData.accessToken.toString())
        params.add("channel_id", channelID)
        params.add("page_start", pageStart)
        params.add("row_count", pageEnd)

        params.add("device_details", CommonData.deviceDetails(this))
        val paramMap = params.build()
        apiInProgress = true
        RestClient.getApiInterface().getAttachmentList(paramMap.map).enqueue(object : ResponseResolver<AttachmentResponse>(this, true, true) {
            override fun success(t: AttachmentResponse?) {
                apiInProgress = false

                if (pageStart == 0)
                    dataList.clear()
                if (t != null) {
                    dataList.addAll(t.data)
                    if (t.data.size < row_count - 1)
                        isNextPage = false;
                }

                if (mediaAdapter != null)
                    sharedMediaRV.adapter?.notifyDataSetChanged()
                else
                    setAdapter()
            }

            override fun failure(error: APIError?) {
                apiInProgress = false

            }
        })


    }

    private fun setAdapter() {
        val manager = GridLayoutManager(this, 3, GridLayoutManager.VERTICAL, false)
        sharedMediaRV.layoutManager = manager
        mediaAdapter = MediaFileItemAdapter(this, dataList, this);
        sharedMediaRV.adapter = mediaAdapter

        if (dataList.size > 0) {
            noDataFound.visibility = View.GONE
            sharedMediaRV.visibility = View.VISIBLE
        } else {
            noDataFound.visibility = View.VISIBLE
            sharedMediaRV.visibility = View.GONE
        }
        sharedMediaRV.addOnScrollListener(object : RecyclerView.OnScrollListener() {
            override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                super.onScrollStateChanged(recyclerView, newState)

            }

            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                if (dy > 0) {
                    if (isNextPage && !apiInProgress) {
                        page_start = dataList.size + 1
                        getMediaLIst(page_start, row_count)
                    }
                }
            }
        })


    }

    override fun onItemClick(item: AttachmentDataList?, imageView: View) {
        if (item != null) {
//            showImageDialog(this, item.imageUrl)
            if (item?.document_type != null && !item?.document_type.isEmpty() && !item?.document_type.contains("image")) {
                openFile(item)
            } else {
                openImage(item, imageView)
            }
        }
    }

//    var request: Request? = null
//    var fetch: Fetch? = null
//    private fun getExtrasForRequest(request: Request): Extras {
//        val extras = MutableExtras()
//        extras.putBoolean("testBoolean", true)
//        extras.putString("testString", "test")
//        extras.putFloat("testFloat", Float.MIN_VALUE)
//        extras.putDouble("testDouble", Double.MIN_VALUE)
//        extras.putInt("testInt", Int.MAX_VALUE)
//        extras.putLong("testLong", Long.MAX_VALUE)
//        return extras
//    }


    private fun openImage(item: AttachmentDataList?, imageView: View?) {
        try {
            if (!Utils.preventMultipleClicks()) {
                return
            }
            val imageIntent = Intent(activity, ImageDisplayActivity::class.java)
            var imageurl = item?.imageUrl
            if (item?.imageUrl != null && !item?.imageUrl.isEmpty())
                imageurl = item?.imageUrl
            else
                imageurl = item?.url
            val image = Image(imageurl, item?.thumbnailUrl, item?.getMuid(), "", "")
            imageIntent.putExtra("image", image)
//            val options = ActivityOptionsCompat.makeSceneTransitionAnimation(activity, imageView!!, "")
            startActivity(imageIntent/*, options.toBundle()*/)
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }

    private fun openFile(item: AttachmentDataList?) {
        try {
            if (item?.document_type.equals(FuguAppConstant.DocumentType.AUDIO.toString(), ignoreCase = true)) {
                return
            }
            val fname = Utils.getFileName(item?.getFileName(), item?.getMuid())
            val localPath = FileManager.getInstance().getLocalPath(this, fname, FuguAppConstant.FOLDER_TYPE[item?.document_type])
            if (!TextUtils.isEmpty(localPath)) {

                var docType = ""
                if (!item!!.document_type.isEmpty()) {
                    docType = item.document_type
                }
                if (docType.contains("video")) {
                    val intent = Intent(activity, VideoPlayerActivity::class.java)
                    intent.putExtra("url", localPath)
                    intent.putExtra("title", item?.fileName)
                    activity.startActivity(intent)
                } else {

                    FileManager.getInstance().openFileInDevice(activity, localPath, object : FileManager.FileCopyListener {
                        override fun onCopingFile(flag: Boolean, fileuploadModel: FileuploadModel) {}
                        override fun largeFileSize() {}
                        override fun onError() {
                            Toast.makeText(activity, getString(R.string.no_handler), Toast.LENGTH_LONG).show()
                        }
                    })
                }
            } else {
                var docType = "image"
                if (!item!!.document_type.isEmpty()) {
                    docType = item.document_type
                }
                var fileName: String = item.getFileName()

                if (TextUtils.isEmpty(fileName)) {
                    val timeStamp = SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(Date())
                    fileName = "Hippochat_$timeStamp.jpg"
                }
                val fullPath = Utils.getOrCreateDirectoryPath(this, FuguAppConstant.FOLDER_TYPE[docType])

                downloadFileFromUrl(fullPath, fileName, item)
            }
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }

    }

    //    private fun downloadFileFromUrl(dirPath: String, fileName: String, list: AttachmentDataList) {
//        var fileName = fileName
//        if (!fileName.contains(list.muid)) {
//            val muid = list.muid
//            val ext = Utils.getExtension(fileName)
//            val name = Utils.extractFileNameWithoutSuffix(fileName)
//            fileName = name + "_" + muid + "." + ext
//        }
//        PRDownloader.download(list.url, dirPath, fileName)
//                .build()
//                .setOnStartOrResumeListener {
//                    progressPB.visibility = View.VISIBLE
//                    Log.v("FuguMessageAdapter.TAG", "OnStartOrResumeListener")
//                }
//                .setOnProgressListener { progress ->
////                    val cProgress = (progress.currentBytes * 100 / progress.totalBytes).toInt()
////                                        message.currentprogress = cProgress
////                    message.downloadStatus = DownloadStatus.DOWNLOAD_IN_PROGRESS.downloadStatus
//                }
//                .start(object : OnDownloadListener {
//                    override fun onDownloadComplete() {
//                        progressPB.visibility = View.GONE
//                        openFile(list)
////                        message.downloadStatus = DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus
////                        val mIntent: Intent = getIntentExtraData(position, 100, message.muid, DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus)
////                        LocalBroadcastManager.getInstance(activity).sendBroadcast(mIntent)
//                    }
//
//                    override fun onError(error: Error) {
//                        progressPB.visibility = View.GONE
//
////                        message.downloaddStatus = DownloadStatus.DOWNLOAD_FAILED.downloadStatus
////                        val mIntent: Intent = getIntentExtraData(position, 0, message.muid, DownloadStatus.DOWNLOAD_FAILED.downloadStatus)
////                        LocalBroadcastManager.getInstance(activity).sendBroadcast(mIntent)
//                    }
//                })
//    }
    private fun downloadFileFromUrl(dirPath: String, fileName: String, list: AttachmentDataList) {
//        var fileName = fileName
//        if (!fileName.contains(list.muid)) {
//            val muid = list.muid
//            val ext = Utils.getExtension(fileName)
//            val name = Utils.extractFileNameWithoutSuffix(fileName)
//            fileName = name + "_" + muid + "." + ext
//        }
//
//        request = Request(list.url, dirPath + File.separator + fileName)
//        request?.extras = getExtrasForRequest(request!!)
//        val config: FetchConfiguration = FetchConfiguration.Builder(activity).preAllocateFileOnCreation(false).build()
//
//        fetch.run {
//            Fetch.setDefaultInstanceConfiguration(config)
//        }
//        fetch = Fetch.getDefaultInstance()
//
//        fetch!!.attachFetchObserversForDownload(request!!.id, object : FetchObserver<Download> {
//            override fun onChanged(data: Download, reason: Reason) {
//                if (request!!.id == data.id) {
//                    if (reason == Reason.DOWNLOAD_COMPLETED) {
//                        progressPB.visibility = View.GONE
//                        openFile(list)
//                        return
//                    } else if (reason == Reason.DOWNLOAD_ERROR) {
//                        progressPB.visibility = View.GONE
//                        return
//                    }
//                }
//            }
//        }).enqueue(request!!, Func { result ->
//            request = result
//        }, Func { android.util.Log.e(">>>", ">>>>>>>>>>>>") })


    }


    private fun showImageDialog(activity: Context, url: String) {
        try {
            val dialog = Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar)
            //setting custom layout to dialog
            dialog.setContentView(R.layout.image_dialog)
            val dialogWindow = dialog.window
            val layoutParams = dialogWindow!!.attributes
            layoutParams.dimAmount = 1.0f
            dialogWindow.attributes.windowAnimations = R.style.CustomDialog
            dialogWindow.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)
            dialog.setCancelable(true)
            dialog.setCanceledOnTouchOutside(false)
            val ivImage: ZoomageView = dialog.findViewById(R.id.ivImage)
            val options = RequestOptions()
                    .centerCrop()
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .placeholder(R.drawable.hippo_placeholder)
                    .error(R.drawable.hippo_placeholder)
                    .fitCenter()
                    .priority(Priority.HIGH)
                    .transforms(CenterCrop(), RoundedCorners(3))
            Glide.with(activity).asBitmap()
                    .apply(options)
                    .load(url)
                    .into(ivImage)
            val tvCross = dialog.findViewById<TextView>(R.id.tvCross)
            val ivSend = dialog.findViewById<ImageView>(R.id.ivSend1)
            ivSend.visibility = View.GONE

            tvCross.setOnClickListener { dialog.dismiss() }
            dialog.show()
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }


}