package com.hippoagent.activities

import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.datastructure.MessageMode
import com.hippoagent.dialogs.ListSheetDialogFragment
import com.hippoagent.dialogs.MultiSheetSelect
import com.hippoagent.eventbus.BusProvider
import com.hippoagent.eventbus.ConnectionMessage
import com.hippoagent.eventbus.ReceivedMessage
import com.hippoagent.fragments.HomeFragment
import com.hippoagent.helper.BusEvents
import com.hippoagent.helper.ConnectionManager
import com.hippoagent.helper.FayeMessage
import com.hippoagent.utils.Log
import com.squareup.otto.Subscribe
import kotlinx.android.synthetic.main.activity_container.filter
import kotlinx.android.synthetic.main.activity_container.ivBack
import kotlinx.android.synthetic.main.activity_container.tvUserName2
import org.json.JSONObject

/**
 * Created by gurmail on 26/11/20.
 * @author gurmail
 */
class   MerchantActivity : FuguBaseActivity() {

    var filters = ArrayList<MultiSheetSelect>()
    var filtersStatus = ArrayList<MultiSheetSelect>()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_container)
        val fragment = HomeFragment()

        val bundle = Bundle()
        val messageMod = MessageMode.OPEN_CHAT.getOrdinal()
        bundle.putInt("position", 10)
        bundle.putInt("selectedMode", messageMod)
        bundle.putString("param2", "")
        fragment.arguments = bundle

        tvUserName2?.text = getString(R.string.support)
        ivBack.setOnClickListener {
            onBackPressed()
        }



        filters.add(MultiSheetSelect(0, "All chats", true, true, true))
        filters.add(MultiSheetSelect(1, "My chats only", true, false, true))
        filters.add(MultiSheetSelect(2, "Unassigned", true, false, true))
        filters.add(MultiSheetSelect(3, "My support chat", true, false, true))

        filtersStatus.add(MultiSheetSelect(1, "Open Chats", true, false, true))
        filtersStatus.add(MultiSheetSelect(2, "Closed Chats", true, false, true))

        filter.setOnClickListener {
            ListSheetDialogFragment.newInstance(0, "Select an option", filters,filtersStatus)!!.show(supportFragmentManager, ListSheetDialogFragment.TAG)
        }

//        supportFragmentManager.beginTransaction()
//                .add(R.id.container, fragment, fragment.tag).commitNow()

        supportFragmentManager.beginTransaction()
                .add(R.id.container, fragment, MerchantActivity::class.java.simpleName)
                .addToBackStack(MerchantActivity::class.java.simpleName)
                .commitAllowingStateLoss()

        BusProvider.getInstance().register(this)
    }

    override fun onResume() {
        super.onResume()

    }

    override fun onDestroy() {
        super.onDestroy()
        BusProvider.getInstance().unregister(this)
    }

    override fun onBackPressed() {
        if (supportFragmentManager.backStackEntryCount < 2) {
            finish()
        } else {
            super.onBackPressed()
        }
    }

    public fun applyFilter(isReset: Boolean, selectedPos: Int, selectedStatus: ArrayList<Int>?) {
        if (getHomeFragment() != null) {
            if (isReset) {
                filter.setImageResource(R.drawable.ic_filter_unslected)
            } else {
                filter.setImageResource(R.drawable.ic_filter)
            }
            getHomeFragment().applyFilter(isReset, selectedPos,selectedStatus )
        }
    }

    public fun getHomeFragment(): HomeFragment {
        return supportFragmentManager.findFragmentByTag(MerchantActivity::class.java.simpleName) as HomeFragment
    }

    @Subscribe
    public fun onFayeMessage(events: FayeMessage) {
        when(events.type) {
            BusEvents.CONNECTED_SERVER.toString()       -> subscribeChannels()
            BusEvents.RECEIVED_MESSAGE.toString()       -> onReceivedMessage(events.message, events.channelId)
            BusEvents.PONG_RECEIVED.toString()          -> onPongReceived()
        }
    }

    private fun subscribeChannels() {
        if (HippoApplication.getInstance().userData != null && !TextUtils.isEmpty(HippoApplication.getInstance().userData.userChannel)) {
            ConnectionManager.subScribeChannel("/" + HippoApplication.getInstance().userData.userChannel.toString())
            ConnectionManager.subScribeChannel("/" + HippoApplication.getInstance().userData.appSecretKey.toString() + "/agentsRefresh")
            ConnectionManager.subScribeChannel("/" + HippoApplication.getInstance().userData.appSecretKey.toString() + "/agentRefresh")
            ConnectionManager.subScribeChannel("/" + HippoApplication.getInstance().userData.appSecretKey.toString() + "/userMigration")
        }
    }

    fun onPongReceived() {
        try {
            BusProvider.getInstance().post(ConnectionMessage(0))
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private fun onReceivedMessage(msg: String?, channel: String?) {
        Log.e("MerchantActivity", ">>>>>>>>>>>>>>>>>>>>>>>>MerchantActivity: $msg")
        if (TextUtils.isEmpty(msg))
            return

        try {
            val jsonObject = JSONObject(msg)
            if (jsonObject.optInt("channel_type") == 9 && jsonObject.optInt("chat_type") == 2) {
                if(channel.equals("/" + HippoApplication.getInstance().userData.userChannel.toString())) {
                    BusProvider.getInstance().post(ReceivedMessage(10, jsonObject))
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }

    }

}