package com.hippoagent.activities

import android.os.Bundle
import android.text.TextUtils
import com.hippoagent.HippoApplication
import com.hippoagent.R
//import com.hippoagent.fragments.AddCardFragment
import com.hippoagent.fragments.PaymentAgentFragment
import com.hippoagent.model.payment.ActiveAgent
import com.hippoagent.model.payment.PaymentModel
import com.hippoagent.retrofit.APIError
import com.hippoagent.retrofit.CommonParams
import com.hippoagent.retrofit.ResponseResolver
import com.hippoagent.retrofit.RestClient
import com.hippoagent.utils.filelogger.Logger
import com.google.gson.Gson
import com.hippoagent.langs.Restring
import kotlinx.android.synthetic.main.activity_payment.*
import java.math.RoundingMode
import java.text.DecimalFormat
import java.util.ArrayList

/**
 * Created by gurmail on 23/04/19.
 * @author gurmail
 */
class PaymentViewActivity : FuguBaseActivity() {

    var agents: ArrayList<ActiveAgent>? = null
    var baseAmount: Double = 0.0;
    var errorMessage: String = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_payment)

        setSupportActionBar(my_toolbar)
        if(HippoApplication.getInstance().userData.expiryInfo.isAskCardDetails) {
            setToolbar(my_toolbar, Restring.getString(this, R.string.hippo_payment))
        } else {
            setToolbar(my_toolbar, Restring.getString(this, R.string.hippo_verify_details))
        }

        getAgentData()

        my_toolbar.setNavigationOnClickListener {
            onBackPressed()
        }
    }

    fun updateTitle(title: String) {
        updateToolbar(my_toolbar, title)
    }

    fun openPaymentAgent(count: Int, total: Double) {
        val bundle = Bundle()
        bundle.putSerializable("agents", agents)
        bundle.putInt("count", count)
        bundle.putDouble("total", total)
        val fragment: PaymentAgentFragment = PaymentAgentFragment()
        fragment.arguments = bundle

        supportFragmentManager.beginTransaction()
                .add(R.id.main_layout, fragment, PaymentAgentFragment::class.java.name)
                .addToBackStack(PaymentAgentFragment::class.java.name)
                .commitAllowingStateLoss()
    }

    fun openAddCardView() {
        val bundle = Bundle()
        bundle.putSerializable("agents", agents)
//        val fragment: AddCardFragment = AddCardFragment()
//        fragment.arguments = bundle
//
//        supportFragmentManager.beginTransaction()
//                .add(R.id.main_layout, fragment, AddCardFragment::class.java.name)
//                .addToBackStack(AddCardFragment::class.java.name)
//                .commitAllowingStateLoss()
    }

    override fun onResume() {
        super.onResume()
    }

    override fun onPause() {
        super.onPause()
    }

    override fun onBackPressed() {
        if(supportFragmentManager.backStackEntryCount < 2) {
          finish()
        } else {
            super.onBackPressed()
        }
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    fun getAgentData() {
        val params: CommonParams = CommonParams.Builder()
                .add("access_token", HippoApplication.getInstance().userData.accessToken)
                .build()

        Logger.apiRequest("/api/billing/getProperties", Gson().toJson(params.map))
        RestClient.getApiInterface().getPayemtAgent(params.map).enqueue(object : ResponseResolver<PaymentModel>(this, true, false) {
            override fun success(paymentModel: PaymentModel) {
                Logger.apiResponse("/api/billing/getProperties", "")
                agents = ArrayList()
                if (paymentModel.data?.activeAgents != null && paymentModel.data?.activeAgents!!.size > 0) {
                    val activeAgent: ActiveAgent = ActiveAgent()
                    activeAgent.status = -100
                    activeAgent.fullName = "Active Agent"
                    if (paymentModel.data?.activeAgents!!.size > 1) {
                        activeAgent.fullName = "Active Agents"
                    }
                    activeAgent.isChecked = false
                    agents!!.add(activeAgent)
                    agents!!.addAll(paymentModel.data.activeAgents)
                }

                if (paymentModel.data?.invitedAgents != null && paymentModel.data?.invitedAgents!!.size > 0) {
                    val activeAgent: ActiveAgent = ActiveAgent()
                    activeAgent.status = -101
                    activeAgent.fullName = "Invited Agent"
                    if (paymentModel.data?.invitedAgents!!.size > 1) {
                        activeAgent.fullName = "Invited Agents"
                    }
                    activeAgent.isChecked = false
                    agents!!.add(activeAgent)
                    agents!!.addAll(paymentModel.data.invitedAgents)
                }

                baseAmount = paymentModel.data?.properties?.agentBased!!

                var count: Int? = 0
                for (agent in agents!!) {
                    if (agent.isChecked && agent.status > -1)
                        count = count?.plus(1)
                }
                var total: Double? = 0.0
                if (count!! > 0) {
                    total = roundOffDecimal(count * baseAmount)
                }

                if(HippoApplication.getInstance().userData.expiryInfo.isAskCardDetails) {
                    openAddCardView()
                } else {
                    openPaymentAgent(count, total!!)
                }
            }

            override fun failure(error: APIError) {
                errorMessage = if (!TextUtils.isEmpty(error.message)) error.message else "Something went wrong"
                Logger.apiFailed("/api/billing/getProperties", errorMessage)
                val bundle = Bundle()
                bundle.putString("errorMessage", errorMessage)
                val fragment: PaymentAgentFragment = PaymentAgentFragment()
                fragment.arguments = bundle

                supportFragmentManager.beginTransaction()
                        .add(R.id.main_layout, fragment, PaymentAgentFragment::class.java.name)
                        .addToBackStack(PaymentAgentFragment::class.java.name)
                        .commitAllowingStateLoss()
            }
        })
    }



    fun roundOffDecimal(number: Double?): Double {
        try {
            val df = DecimalFormat("#.##")
            df.roundingMode = RoundingMode.HALF_UP
            return df.format(number).toDouble()
        } catch (e: Exception) {
            return number!!
        }
    }


}