package com.hippoagent.activities;

import static com.hippoagent.datastructure.FuguAppConstant.ACCESS_TOKEN;
import static io.socket.global.Global.encodeURIComponent;

import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import android.Manifest;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.app.PictureInPictureParams;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.util.Rational;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.PermissionRequest;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;

import com.hippoagent.BuildConfig;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.confcall.HippoAudioManager;
import com.hippoagent.confcall.HungUpBroadcast;
import com.hippoagent.confcall.OngoingCallService;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.hippocall.VideoCallModel;
import com.hippoagent.hippocall.WebRTCCallConstants;
import com.hippoagent.model.videoSdk.VideoSkdData;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.UniqueIMEIID;
import com.nabinbhandari.android.permissions.PermissionHandler;
import com.nabinbhandari.android.permissions.Permissions;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.SurfaceViewRenderer;


public class VideoSdkMeetingActivity extends AppCompatActivity {
    //    private Meeting meeting;
    private SurfaceViewRenderer svrLocal;
    private VideoCallModel videoCallModel;
    private String token = "";
    private String meetingId;
    private String participantName;
    private boolean webcamEnabled = true;
    private WebView myWebView;
    private TextView connectingTV;
    private boolean showVideoButton;


    @SuppressLint("SetJavaScriptEnabled")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN |
                        WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED |
                        WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON,
                WindowManager.LayoutParams.FLAG_FULLSCREEN |
                        WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED |
                        WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
        setContentView(R.layout.activity_video_sdk_meeting);

        connectingTV = findViewById(R.id.connectingTV);
        myWebView = findViewById(R.id.wvWebsite);

        if (!getIntent().getExtras().containsKey("from_calling_push")) {
            if (getIntent().hasExtra("videoCallModel")) {
                videoCallModel = (VideoCallModel) getIntent().getExtras().getParcelable("videoCallModel");
            }

            token = getIntent().getStringExtra("token");
            meetingId = getIntent().getStringExtra("meetingId");
            participantName = videoCallModel.getFullName();

            if (getIntent().getExtras().containsKey("showVideoButton")) {
                showVideoButton = true;
            }


//            LocalBroadcastManager.getInstance(this).registerReceiver(mVideoConferenceHungup, new IntentFilter(FuguAppConstant.VIDEO_CONFERENCE_HUNGUP_INTENT));
            LocalBroadcastManager.getInstance(this).registerReceiver(mHungUpBroadCAst, new IntentFilter("CALL_HANGUP"));

            checkPermissions();
        }


    }

    private void setWebView() {


//        myWebView = new WebView(this);
//        setContentView(myWebView);

        WebSettings webSettings = myWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);


        myWebView.setWebViewClient(new MyWebViewClient());
        myWebView.setWebChromeClient(new WebChromeClient() {

            @Override
            public void onPermissionRequest(final PermissionRequest request) {
                runOnUiThread(new Runnable() {
                    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
                    @Override
                    public void run() {
                        request.grant(request.getResources());

                    }
                });
            }

        });
        myWebView.getSettings().setMediaPlaybackRequiresUserGesture(false);


        String isVideo = "false";
        String switchWebCam = "false";
        String userName = "Visitor";

        if (videoCallModel.getCallType().equalsIgnoreCase("AUDIO")) {
            isVideo = "false";
            switchWebCam = "false";
        } else {
            isVideo = "true";
            switchWebCam = "true";
        }

        if (showVideoButton)
            switchWebCam = "true";

        if (!videoCallModel.getMyname().isEmpty())
            userName = videoCallModel.getMyname();

        Uri.Builder builder = new Uri.Builder();


        builder.scheme("https")
//                .authority("call.zujonow.com")
                .authority("embed.videosdk.live")
                .appendPath("rtc-js-prebuilt/0.1.12")
                .appendQueryParameter("name", userName)
                .appendQueryParameter("micEnabled", "true")
                .appendQueryParameter("webcamEnabled", isVideo)
                .appendQueryParameter("chatEnabled", "false")
                .appendQueryParameter("screenShareEnabled", "false")
                .appendQueryParameter("meetingId", meetingId)
                .appendQueryParameter("pollEnabled", "false")
                .appendQueryParameter("whiteBoardEnabled", "false")
                .appendQueryParameter("redirectOnLeave", "https://hippochat.io")
                .appendQueryParameter("participantCanToggleSelfWebcam", switchWebCam)
                .appendQueryParameter("participantCanToggleSelfMic", "true")
                .appendQueryParameter("raiseHandEnabled", "true")
                .appendQueryParameter("token", token)
                .appendQueryParameter("brandingEnabled", "false")
                .appendQueryParameter("participantCanToggleOtherMic", "true")
                .appendQueryParameter("recordingEnabled", "false")
                .appendQueryParameter("joinScreenEnabled", "false")
                .appendQueryParameter("recordingWebhookUrl", "");


        String url = builder.build().toString();
        Log.e("callurl>>>", url);
        myWebView.loadUrl(url);
    }

    @Override
    public void onUserLeaveHint() {
        if (supportsPiPMode()) {
            setToPip();
        }
    }

    public boolean supportsPiPMode() {
        return Build.VERSION.SDK_INT >= Build.VERSION_CODES.O;
    }


    private void setToPip() {
        if (Build.VERSION.SDK_INT >= 26) {
            //Trigger PiP mode
            try {
                Rational rational = new Rational(300,
                        500);
                PictureInPictureParams mParams = new PictureInPictureParams.Builder()
                        .setAspectRatio(rational)
                        .build();
                enterPictureInPictureMode(mParams);
            } catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }


    private final PermissionHandler permissionHandler = new PermissionHandler() {
        @Override
        public void onGranted() {
            if (!token.isEmpty())
                setWebView();
            else
                getToken();

        }
    };

    private void getToken() {
        CommonParams params = new CommonParams.Builder()
                .add(ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .add("request_token", 1)
                .build();
        RestClient.getApiInterface().getVideoSdkToken(params.getMap()).enqueue(new ResponseResolver<VideoSkdData>(this, false, true) {
            @Override
            public void success(VideoSkdData jsonObject) {
                Log.e("getVideoSdkToken", jsonObject.getData().getToken());
                token = jsonObject.getData().getToken();
//                getMeetId();
                setWebView();

            }

            @Override
            public void failure(APIError error) {

            }


        });
    }

    private void getMeetId() {

        CommonParams params = new CommonParams.Builder()
                .add(ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .add("meet_url", meetingId)
                .add("validate_meet", 1)
                .add("meet_token", token)
                .build();
        RestClient.getApiInterface().getVideoSdkToken(params.getMap()).enqueue(new ResponseResolver<VideoSkdData>(this, false, true) {
            @Override
            public void success(VideoSkdData jsonObject) {
                Log.e("getVideoSdkToken", jsonObject.getData().toString());
                meetingId = jsonObject.getData().getMeetingId();
                setWebView();
            }

            @Override
            public void failure(APIError error) {
            }
        });


    }

    private void checkPermissions() {
        String[] permissions = {
                Manifest.permission.INTERNET,
                Manifest.permission.RECORD_AUDIO,
                Manifest.permission.CAMERA,
                Manifest.permission.MODIFY_AUDIO_SETTINGS
        };
        String rationale = "Please provide permissions`";
        Permissions.Options options =
                new Permissions.Options().setRationaleDialogTitle("Info").setSettingsDialogTitle("Warning");
        Permissions.check(this, permissions, rationale, options, permissionHandler);
    }


    @Override
    public void onBackPressed() {
//        super.onBackPressed();

        showAlertDialog();


    }

    private void showAlertDialog() {
        new AlertDialog.Builder(this)
                .setTitle("Alert")
                .setMessage("Are you sure you want to end this call")

                // Specifying a listener allows you to take an action before dismissing the dialog.
                // The dialog is automatically dismissed when a dialog button is clicked.
                .setPositiveButton(android.R.string.yes, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int which) {
                        finishAct();
                    }
                })

                // A null listener allows the button to dismiss the dialog and take no further action.
                .setNegativeButton(android.R.string.no, null)
                .show();
    }

    private void finishAct() {
        endcall();
        finish();
        super.onBackPressed();

    }


    @Override
    protected void onDestroy() {

        endcall();
        super.onDestroy();
    }

    private void endcall() {
        HippoAudioManager.getInstance(this).stop(false);


        Intent hungupIntent = new Intent(this, HungUpBroadcast.class);
        hungupIntent.putExtra("action", "hungupCall");
        hungupIntent.putExtra(
                WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(),
                getDeviceDetails().toString()
        );
        hungupIntent.putExtra(FuguAppConstant.INVITE_LINK, videoCallModel.getInviteLink());
        hungupIntent.putExtra(FuguAppConstant.JITSI_URL, videoCallModel.getJitsiLink());
        hungupIntent.putExtra(FuguAppConstant.CHANNEL_ID, videoCallModel.getChannelId());
        hungupIntent.putExtra("muid", OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        hungupIntent.putExtra("auth0", OngoingCallService.NotificationServiceState.INSTANCE.getAuthObj());

        sendBroadcast(hungupIntent);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mVideoConferenceHungup);
    }


    private class MyWebViewClient extends WebViewClient {
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return onOverrideUrlLoading(view, request.getUrl().toString());
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return onOverrideUrlLoading(view, url);
        }

        @Override
        public void onPageFinished(WebView view, String url) {

            super.onPageFinished(view, url);
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            myWebView.setVisibility(View.VISIBLE);
            connectingTV.setVisibility(View.GONE);

            super.onPageStarted(view, url, favicon);
        }
    }

    private boolean onOverrideUrlLoading(WebView view, String url) {
        Log.e("URL", url + "");


        UrlQuerySanitizer sanitizer = new UrlQuerySanitizer(url);

        Log.e("url>>>", url);
        view.loadUrl(url);


        if (url.contains("https://hippochat.io")) {
            Intent mIntent = new Intent("CALL TERMINATED");
            LocalBroadcastManager.getInstance(this).sendBroadcast(mIntent);
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    finish();
                }
            }, 2000);
        }


        return true;
    }


    private JSONObject getDeviceDetails() {
        JSONObject devicePayload = new JSONObject();
        try {
            devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(this));
            devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER);
            devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME);
            devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(this));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return devicePayload;
    }

    private BroadcastReceiver mVideoConferenceHungup = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            finish();
        }

    };
    private BroadcastReceiver mHungUpBroadCAst = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            LocalBroadcastManager.getInstance(VideoSdkMeetingActivity.this).unregisterReceiver(mHungUpBroadCAst);
            finish();
        }

    };


}