package com.hippoagent.activities

import android.app.DownloadManager
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.view.View
import com.hippoagent.R
import com.hippoagent.utils.Log
import kotlinx.android.synthetic.main.activity_webview.*
import android.os.Environment.DIRECTORY_DOWNLOADS
import android.app.DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED
import android.content.Context
import android.os.Build
import android.os.Environment
import android.webkit.*
import android.webkit.URLUtil.guessFileName
import android.widget.Toast


/**
 * Created by gurmail on 14/06/19.
 * @author gurmail
 */
class WebviewActivity : FuguBaseActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_webview)

        setSupportActionBar(my_toolbar)

        var url = intent.getStringExtra("url")
        val title: String = intent.getStringExtra("title").toString()

        setToolbar(my_toolbar, title)

        my_toolbar.setNavigationOnClickListener {
            onBackPressed()
        }

        pbWebPageLoader.visibility = View.VISIBLE

        val settings = webView.settings
        settings.domStorageEnabled = true
        settings.javaScriptEnabled = true

        settings.setAppCachePath(getApplicationContext().getCacheDir().getAbsolutePath());
        settings.setCacheMode(WebSettings.LOAD_DEFAULT);
        settings.setDatabaseEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setLoadWithOverviewMode(true);
        webView.addJavascriptInterface(JavaScriptInterface(this), "Android");
        settings.setPluginState(WebSettings.PluginState.ON);

        webView.webViewClient = WebViewClient()
        url?.let { webView.loadUrl(it) }
        webView.webViewClient = object : WebViewClient() {

            override fun onPageFinished(view: WebView, url: String) {
                super.onPageFinished(view, url)
                try {
                    if (pbWebPageLoader != null)
                        pbWebPageLoader.visibility = View.INVISIBLE
                } catch (e: Exception) {
                }
            }

            override fun shouldOverrideUrlLoading(view: WebView?, request: WebResourceRequest?): Boolean {
                if(Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
                    //return shouldOverrideUrlLoading(view, Uri.parse(url));
                    if (Uri.parse(url).scheme == "blob") {
                        webView.loadUrl(request.toString().substring(5));
                    }
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        }



        webView.setDownloadListener { url, userAgent, contentDisposition, mimeType, contentLength ->
            Log.v("TAG", "url = $url")
//            Log.v("TAG", "url = ${JavaScriptInterface.getBase64StringFromBlobUrl(url)}")

            var webpage = Uri.parse(url)

            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                webpage = Uri.parse("http://$url")
            }

            //webView.loadUrl(JavaScriptInterface.getBase64StringFromBlobUrl(url));
            try {
                val request = DownloadManager.Request(webpage)

                request.setMimeType(mimeType)
                //------------------------COOKIE!!------------------------
                val cookies = CookieManager.getInstance().getCookie(url)
                request.addRequestHeader("cookie", cookies)
                //------------------------COOKIE!!------------------------
                request.addRequestHeader("User-Agent", userAgent)
                request.setDescription("Downloading file...")
                request.setTitle(URLUtil.guessFileName(url, contentDisposition, mimeType))
                request.allowScanningByMediaScanner()
                request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED)
                request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, URLUtil.guessFileName(url, contentDisposition, mimeType))
                val dm = getSystemService(Context.DOWNLOAD_SERVICE) as DownloadManager
                dm!!.enqueue(request)
                Toast.makeText(applicationContext, "Downloading File", Toast.LENGTH_LONG).show()
            } catch (e: Exception) {
            }
        }

    }

    private fun shouldOverrideUrlLoading(view: WebView, request: Uri): Boolean {
        if (request.scheme == "blob") {
            webView.loadUrl(request.toString().substring(5));
        }
        return true
    };

    override fun onResume() {
        super.onResume()

    }

    override fun onPause() {
        super.onPause()

    }

    override fun onBackPressed() {
        super.onBackPressed()

    }

    override fun onDestroy() {
        super.onDestroy()

    }
}