//package com.hippoagent.adapters;
//
//import android.app.Activity;
//import androidx.core.content.ContextCompat;
//import androidx.recyclerview.widget.RecyclerView;
//import android.view.LayoutInflater;
//import android.view.View;
//import android.view.ViewGroup;
//import android.widget.LinearLayout;
//import android.widget.TextView;
//
//import com.hippoagent.R;
//import com.hippoagent.model.LoginResponse.Tag;
//import com.hippoagent.model.graph.AgentsDatum;
//
//import java.util.ArrayList;
//
///**
// * Created by ankit on 12/07/17.
// */
//
//public class AgentAnalyticsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
//    private Activity activity;
//    private ArrayList<AgentsDatum> agentsList;
//
//    public AgentAnalyticsAdapter(Activity activity, ArrayList<AgentsDatum> agentsList) {
//        this.activity = activity;
//        this.agentsList = agentsList;
//    }
//
//    @Override
//    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
//        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item_agent_data, parent, false);
//        return new ViewHolder(v);
//    }
//
//    @Override
//    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
//        if (viewHolder instanceof ViewHolder) {
//            final ViewHolder holder = (ViewHolder) viewHolder;
//            AgentsDatum agentResponse = agentsList.get(position);
//
//            if (position % 2 == 0) {
//                holder.root.setBackgroundColor(ContextCompat.getColor(activity, R.color.agent_analytics_bg));
//            } else {
//                holder.root.setBackgroundColor(ContextCompat.getColor(activity, R.color.white));
//            }
//
//            holder.tvAgentName.setText(agentResponse.getAgentName());
//            holder.tvAssigned.setText(agentResponse.getCurrentlyAssigned() + "");
//            holder.tvReplied.setText(agentResponse.getCurrentlyReplied() + "");
//            holder.tvClosed.setText(agentResponse.getCurrentlyClosed() + "");
//            Double temp1 = agentResponse.getAvgFirstResponse();
//            holder.tvAvgFirstReponseTime.setText(getTimeInMinutes(temp1.intValue()) + "");
//        }
//    }
//
//    @Override
//    public int getItemCount() {
//        return (agentsList == null ? 0 : agentsList.size());
//    }
//
//    public class ViewHolder extends RecyclerView.ViewHolder {
//        public LinearLayout root;
//        public TextView tvAgentName, tvAssigned, tvReplied, tvClosed, tvAvgFirstReponseTime, tvAvgCloseTime;
//
//
//        public ViewHolder(final View itemView) {
//            super(itemView);
//            root = (LinearLayout) itemView.findViewById(R.id.root);
//            tvAgentName = (TextView) itemView.findViewById(R.id.tvAgentName);
//            tvAssigned = (TextView) itemView.findViewById(R.id.tvAssigned);
//            tvReplied = (TextView) itemView.findViewById(R.id.tvReplied);
//            tvClosed = (TextView) itemView.findViewById(R.id.tvClosed);
//            tvAvgFirstReponseTime = (TextView) itemView.findViewById(R.id.tvAvgFirstReponseTime);
//            tvAvgCloseTime = (TextView) itemView.findViewById(R.id.tvAvgCloseTime);
//        }
//    }
//
//    private String getTimeInMinutes(int seconds) {
//        String timeString = "";
//        if (seconds > 59) {
//            int minutes = seconds / 60;
//            if (minutes > 0) {
//                timeString = minutes + "m ";
//            }
//
//            int remainingSeconds = seconds % 60;
//            if (remainingSeconds > 0) {
//                timeString = timeString + remainingSeconds + "s";
//            }
//        } else {
//            timeString = seconds + "s";
//        }
//
//        return timeString;
//    }
//
//    public interface Callback {
//        void onClick(int position, Tag tag);
//    }
//}
