package com.hippoagent.adapters;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;

import androidx.annotation.NonNull;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.text.Html;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.RelativeSizeSpan;
import android.text.style.URLSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;

import com.hippoagent.HippoApplication;
import com.hippoagent.R;
import com.hippoagent.activities.FuguChatActivity;
import com.hippoagent.activities.ImageDisplayActivity;
import com.hippoagent.activities.VideoPlayerActivity;
import com.hippoagent.database.CommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.fragments.BottomSheetMsgFragment;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.CallModel;
import com.hippoagent.model.ContentValue;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.CustomAction;
import com.hippoagent.model.FileuploadModel;
import com.hippoagent.model.Image;
import com.hippoagent.model.Message;
import com.hippoagent.utils.BetterLinkMovementMethod;
import com.hippoagent.utils.ColorPicker.ColorGenerator;
import com.hippoagent.utils.ColorPicker.TextDrawable;
import com.hippoagent.utils.CommonMediaPlayer;
import com.hippoagent.utils.DateUtils;
import com.hippoagent.utils.FuguColorConfig;
import com.hippoagent.utils.GridDividerItemDecoration;
import com.hippoagent.utils.LoadImageFile;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.RatingBar;
import com.hippoagent.utils.RoundedCornersTransformation;
import com.hippoagent.utils.URLSpanNoUnderline;
import com.hippoagent.utils.Utils;
import com.hippoagent.utils.filePicker.FileManager;
import com.hippoagent.utils.loadingBox.FuguAgentProgressWheel;
import com.hippoagent.utils.loadingBox.LoadingBox;
import com.google.android.flexbox.FlexDirection;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.google.android.flexbox.JustifyContent;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


import org.jetbrains.annotations.NotNull;


import kotlin.TypeCastException;

/**
 * Created by Bhavya Rattan on 02/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class FuguMessageAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements FuguAppConstant,
        ListItem, OnRecyclerListener, UserConcentListener {

    private static final String TAG = FuguMessageAdapter.class.getSimpleName();
    private FuguChatActivity context;
    private DateUtils dateUtil = DateUtils.getInstance();
    private OnRetryListener mOnRetry;
    private FuguColorConfig fuguColorConfig;
    private Conversation conversation;
    private onVideoCall onVideoCall;
    private String customerName;
    private String agentName;
    private boolean isChatAssignToMe = false;
    private boolean isVideoCallEnabled = true;
    private boolean isAudioCallEnabled = false;
    private int agentId;

    @NonNull
    private List<Message> items = Collections.emptyList();
    private RecyclerView recyclerView;
    private OnUserConcent onUserConcent;

    private final static ColorMatrix BW_MATRIX = new ColorMatrix();
    private final static ColorMatrixColorFilter BW_FILTER;

    static {
        BW_MATRIX.setSaturation(0);
        BW_FILTER = new ColorMatrixColorFilter(BW_MATRIX);
    }

    private boolean onLongClick = false;

    public void setOnLongClickValue(Boolean onLongClick) {
        this.onLongClick = onLongClick;
    }


    public FuguMessageAdapter(FuguChatActivity context, @NonNull List<Message> items, RecyclerView recyclerView,
                              Conversation conversation, OnUserConcent onUserConcent) {
        this.items = items;
        this.recyclerView = recyclerView;
        this.context = context;
        this.fuguColorConfig = CommonData.getColorConfig();
        this.conversation = conversation;
        this.onUserConcent = onUserConcent;

        myOptions = RequestOptions
                .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                .placeholder(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder))
                .dontAnimate()
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .error(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder));
    }

    @Override
    public void onUserConcent(int position, String btnId, Message message) {
        if (onUserConcent != null)
            onUserConcent.onConcentClicked(message);
    }

    public interface onVideoCall {
        void onVideoCallClicked(int callType);
    }

    public interface OnUserConcent {
        void onConcentClicked(Message message);
    }

    public void setOnVideoCallListener(FuguMessageAdapter.onVideoCall onVideoCall) {
        this.onVideoCall = onVideoCall;
    }

    public void setCallModel(CallModel callModel) {
        customerName = callModel.getCustomerName();
        agentName = callModel.getAgentName();
        isChatAssignToMe = callModel.isChatAssignToMe();
        isVideoCallEnabled = callModel.isVideoCallEnabled();
        isAudioCallEnabled = callModel.isAudioCallEnabled();
    }

    public void updateList(@NonNull List<Message> items) {
        this.items = items;
    }

    public void setOnRetryListener(OnRetryListener OnRetryListener) {
        mOnRetry = OnRetryListener;
    }

    public interface OnRetryListener {
        public void onRetry(String file, String fileType, final int messageIndex, String muid);

        public void onMessageRetry(String muid, int position);

        public void onMessageCancel(String muid, int position);

        void onFileMessageRetry(String muid, int position);
    }

    private AdapterCallback adapterCallBack;

    public void setAdapterCallBack(AdapterCallback adapterCallBack) {
        this.adapterCallBack = adapterCallBack;
    }

    public interface AdapterCallback {
        public void showImageDialog(Activity context, String imgUrl, ImageView imageView, Message message);
    }

    @Override
    public void onItemLongClick(View viewClicked, View parentView, int position, boolean isRight) {
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                if (!onLinkLongClick) {
                    int positionInList = recyclerView.getChildLayoutPosition(parentView);
                    if (positionInList != RecyclerView.NO_POSITION) {
                        if (!Utils.preventMultipleClicks()) {
                            return;
                        }
                        Message message = items.get(positionInList);
                        if (message.getMessageState() == 4) {
                            return;
                        }
                        BottomSheetMsgFragment sheetMsgFragment = BottomSheetMsgFragment.newInstance(positionInList, message, message.getUserId().compareTo(HippoApplication.getInstance().getUserData().getUserId()) == 0, isRight);
                        sheetMsgFragment.show(context.getSupportFragmentManager(), BottomSheetMsgFragment.class.getSimpleName());
                    }
                } else {
                    onLinkLongClick = false;
                }
            }
        }, 100);

    }

    private void openBottomSheet() {

    }

    @Override
    public long getItemId(int position) {
        try {
            return items.get(position).getMessageIndex();
        } catch (Exception e) {
            return position;
        }
    }

    @Override
    public void onItemClick(View viewClicked, View parentView, int position) {
        int positionInList = recyclerView.getChildLayoutPosition(parentView);
        if (positionInList != RecyclerView.NO_POSITION) {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Message otherVideoMessage = items.get(positionInList);
            String fname = Utils.getFileName(otherVideoMessage.getFileName(), otherVideoMessage.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(context, fname, FOLDER_TYPE.get(otherVideoMessage.getDocumentType()));
            Intent intent = new Intent(context, VideoPlayerActivity.class);
            intent.putExtra("url", localPath);
            intent.putExtra("title", otherVideoMessage.getFileName());
            context.startActivity(intent);
        }
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View normalView;
        switch (viewType) {
            case TYPE_HEADER:
                normalView = LayoutInflater.from(context).inflate(R.layout.fugu_item_message_date, parent, false);
                return new DateViewHolder(normalView);
            case ITEM_TYPE_OTHER:
                normalView = LayoutInflater.from(context).inflate(R.layout.afugu_item_message_left, parent, false);
                return new OtherMessageViewHolder(normalView, this);
            case ITEM_TYPE_SELF:
                normalView = LayoutInflater.from(context).inflate(R.layout.fugu_item_message_right, parent, false);
                return new SelfMessageViewHolder(normalView, this);
            case ITEM_ASSIGNMENT:
                normalView = LayoutInflater.from(context).inflate(R.layout.fugu_item_assignment, parent, false);
                return new AssignmentViewHolder(normalView);
            case FUGU_RATING_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_feedback_dialog, parent, false);
                return new RatingViewHolder(normalView);
            case LEAD_FORM_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.lead_layout_item, parent, false);
                return new LeadFormViewHolder(normalView);
            case FUGU_VIDEO_CALL_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_video_self_side, parent, false);
                return new SelfVideoViewHolder(normalView);
            case FUGU_OTHER_VIDEO_CALL_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_video_other_side, parent, false);
                return new VideoViewHolder(normalView);
            case CUSTOM_VIEW_TYPE:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_layout_custom_action, parent, false);
                return new CustomViewHolder(normalView);
            case HIPPO_FILE_SENT_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_file_sent, parent, false);
                return new SentFileViewHolder(normalView);
            case HIPPO_FILE_RECEIVED_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_file_received, parent, false);
                return new ReceivedFileViewHolder(normalView);
            case HIPPO_VIDEO_MESSGAE_SELF:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_item_video_self, parent, false);
                return new SelfVideoMessageViewHolder(normalView, this);
            case HIPPO_VIDEO_MESSGAE_OTHER:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_item_video_other, parent, false);
                return new OtherVideoMessageViewHolder(normalView, this);
            case HIPPO_USER_CONCENT_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_user_concent, parent, false);
                return new UserConcentViewHolder(normalView, this);
            case HIPPO_IMAGE_RECEIVED:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_item_video_other, parent, false);
                return new OtherVideoMessageViewHolder(normalView, this);
            case HIPPO_IMAGE_SENT:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_item_video_self, parent, false);
                return new SelfVideoMessageViewHolder(normalView, this);
            case HIPPO_PAYMENT_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_payment_view, parent, false);
                return new PaymentView(normalView);
            case HIPPO_MULTISELECTION_VIEW:
                normalView = LayoutInflater.from(context).inflate(R.layout.hippo_multi_selection_view, parent, false);
                return new MultiSelectionView(normalView);
            default:
                normalView = LayoutInflater.from(context).inflate(R.layout.empty_layout_item, parent, false);
                return new EmptyViewHolder(normalView);
        }
        //return null;
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        final int itemType = getItemViewType(position);
        if (itemType == FUGU_VIDEO_CALL_VIEW) {
            final SelfVideoViewHolder videoViewHolder = (SelfVideoViewHolder) holder;
            Message videoMessage = items.get(position);


            String message = "";
            if (videoMessage.getMessageState() != null && videoMessage.getMessageState().intValue() == 2) {
                videoViewHolder.callAgain.setText(Restring.getString(context, R.string.hippo_call_back));
                if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                    message = Restring.getString(context, R.string.hippo_missed_call);
                    videoViewHolder.tvDuration.setText(Restring.getString(context, R.string.hippo_voice_call));
                } else {
                    message = Restring.getString(context, R.string.hippo_missed_call);
                    videoViewHolder.tvDuration.setText(Restring.getString(context, R.string.hippo_video_call));
                }
            } else {
                videoViewHolder.callAgain.setText(Restring.getString(context, R.string.call_again));//call_again
                if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = Restring.getString(context, R.string.hippo_voice_call_ended);
                else
                    message = Restring.getString(context, R.string.hippo_video_call_ended);
            }

            videoViewHolder.tvMsg.setText(message);


            if (videoMessage.getSentAtUtc().isEmpty()) {
                videoViewHolder.tvTime.setVisibility(View.GONE);
            } else {
                videoViewHolder.tvTime.setText(DateUtils.getTime(dateUtil.convertToLocal(videoMessage.getSentAtUtc())));
                videoViewHolder.tvTime.setVisibility(View.VISIBLE);
            }
            if (videoMessage.getVideoCallDuration() > 0) {
                videoViewHolder.ivCallIcon.setVisibility(View.VISIBLE);
                videoViewHolder.tvDuration.setVisibility(View.VISIBLE);
                videoViewHolder.tvDuration.setText(convertSeconds(videoMessage.getVideoCallDuration()) + "");

            }

            boolean buttonFlag = false;
            if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                if (!isChatAssignToMe || !HippoApplication.getInstance().getUserData().isAudioCallEnabled()
                        || !isAudioCallEnabled) {
                    buttonFlag = true;
                }
            } else {
                if (!isChatAssignToMe || !HippoApplication.getInstance().getUserData().isVideoCallEnabled()
                        || !isVideoCallEnabled) {
                    buttonFlag = true;
                }
            }


            if (buttonFlag) {
                videoViewHolder.callAgain.setVisibility(View.GONE);
                videoViewHolder.dividerView.setVisibility(View.GONE);
            }
            videoViewHolder.callAgain.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (onVideoCall != null) {
                        int callType = FuguAppConstant.VIDEO_CALL_VIEW;
                        if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                            callType = FuguAppConstant.AUDIO_CALL_VIEW;
                        }
                        onVideoCall.onVideoCallClicked(callType);
                    }
                }
            });

            String userNameText71 = "";

            try {
                if (!TextUtils.isEmpty(videoMessage.getfromName())) {
                    userNameText71 = videoMessage.getfromName().trim();
                }
            } catch (Exception e) {
                userNameText71 = videoMessage.getfromName();
            }

            videoViewHolder.tvUserName.setText(userNameText71);
            setUserName(videoViewHolder.tvUserName);
            loadUserImage(videoViewHolder.userImage, userNameText71, videoMessage.getUserImage());

        } else if (itemType == FUGU_OTHER_VIDEO_CALL_VIEW) {
            final VideoViewHolder videoOtherViewHolder = (VideoViewHolder) holder;
            Message videoOtherMessage = items.get(position);

            if (videoOtherMessage.getSentAtUtc().isEmpty()) {
                videoOtherViewHolder.tvTime.setVisibility(View.GONE);
            } else {
                videoOtherViewHolder.tvTime.setText(DateUtils.getTime(dateUtil.convertToLocal(videoOtherMessage.getSentAtUtc())));
                videoOtherViewHolder.tvTime.setVisibility(View.VISIBLE);
            }

            String message = "";
            if (videoOtherMessage.getMessageState() != null && videoOtherMessage.getMessageState().intValue() == 2) {
                videoOtherViewHolder.callAgain.setText(Restring.getString(context, R.string.hippo_call_back));
                if (!TextUtils.isEmpty(videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                    message = Restring.getString(context, R.string.hippo_missed_call);
                    videoOtherViewHolder.tvDuration.setText(Restring.getString(context, R.string.hippo_voice_call));
                } else {
                    message = Restring.getString(context, R.string.hippo_missed_call);
                    videoOtherViewHolder.tvDuration.setText(Restring.getString(context, R.string.hippo_video_call));
                }
            } else {
                videoOtherViewHolder.callAgain.setText(Restring.getString(context, R.string.call_again));
                if (!TextUtils.isEmpty(videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = Restring.getString(context, R.string.hippo_voice_call_ended);
                else
                    message = Restring.getString(context, R.string.hippo_video_call_ended);
            }

            videoOtherViewHolder.tvMsg.setText(message);


            if (videoOtherMessage.getVideoCallDuration() > 0) {
                videoOtherViewHolder.ivCallIcon.setVisibility(View.VISIBLE);
                videoOtherViewHolder.tvDuration.setVisibility(View.VISIBLE);
                videoOtherViewHolder.tvDuration.setText(convertSeconds(videoOtherMessage.getVideoCallDuration()) + "");
            }

            boolean buttonFlag = false;
            if (!TextUtils.isEmpty(videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                if (!isChatAssignToMe || !HippoApplication.getInstance().getUserData().isAudioCallEnabled()
                        || !isAudioCallEnabled) {
                    buttonFlag = true;
                }
            } else {
                if (!isChatAssignToMe || !HippoApplication.getInstance().getUserData().isVideoCallEnabled()
                        || !isVideoCallEnabled) {
                    buttonFlag = true;
                }
            }
            videoOtherViewHolder.callAgain.setVisibility(View.VISIBLE);
            videoOtherViewHolder.callDivider.setVisibility(View.VISIBLE);
            if (buttonFlag) {
                videoOtherViewHolder.callAgain.setVisibility(View.GONE);
                videoOtherViewHolder.callDivider.setVisibility(View.GONE);
            }

            String userNameText7 = "";

            try {
                if (!TextUtils.isEmpty(videoOtherMessage.getfromName())) {
                    userNameText7 = videoOtherMessage.getfromName().trim();
                }
            } catch (Exception e) {
                userNameText7 = videoOtherMessage.getfromName();
            }

            videoOtherViewHolder.tvUserName.setVisibility(View.VISIBLE);
            videoOtherViewHolder.userImage.setVisibility(View.VISIBLE);
            videoOtherViewHolder.tvUserName.setText(userNameText7 + "");
            loadUserImage(videoOtherViewHolder.userImage, userNameText7, videoOtherMessage.getUserImage());
            setUserName(videoOtherViewHolder.tvUserName);
            videoOtherViewHolder.callAgain.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (onVideoCall != null) {
                        int callType = FuguAppConstant.VIDEO_CALL_VIEW;
                        if (!TextUtils.isEmpty(videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                            callType = FuguAppConstant.AUDIO_CALL_VIEW;
                        }
                        onVideoCall.onVideoCallClicked(callType);
                    }
                }
            });

            if (videoOtherMessage.getMessageState() != null && videoOtherMessage.getMessageState().intValue() == 2) {
                videoOtherViewHolder.llChat.setBackgroundResource(R.drawable.missed_call_other);
                videoOtherViewHolder.ivCallIcon.setImageResource(R.drawable.ic_missed_call);
            } else {
                videoOtherViewHolder.llChat.setBackgroundResource(R.drawable.call_other);
                videoOtherViewHolder.ivCallIcon.setImageResource(R.drawable.ic_call_received_white);
            }


        } else if (itemType == TYPE_HEADER) {
            final DateViewHolder dateViewHolder = (DateViewHolder) holder;
            Message headerItem = items.get(position);
            if (headerItem.getDate().isEmpty()) {
                dateViewHolder.tvDate.setVisibility(View.GONE);
            } else {
                String date = DateUtils.getInstance().getDate(headerItem.getDate());
                if (date.equalsIgnoreCase("Today")) {
                    date = Restring.getString(context, R.string.hippo_today);
                } else if (date.equalsIgnoreCase("Yesterday")) {
                    date = Restring.getString(context, R.string.hippo_yesterday);
                }
                dateViewHolder.tvDate.setText(date);
                dateViewHolder.tvDate.setVisibility(View.VISIBLE);
            }
        } else if (itemType == ITEM_TYPE_OTHER) {
            final OtherMessageViewHolder otherMessageViewHolder = (OtherMessageViewHolder) holder;
            final Message currentOrderItem = items.get(position);
            if (position == items.size() - 1) {
                final Message lastMessage = items.get(position);
                context.lastMessage = lastMessage.getMessage();
            }

            if (currentOrderItem.getMessage().isEmpty()) {
                otherMessageViewHolder.tvMsg.setVisibility(View.INVISIBLE);
                LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
                params2.weight = 1.0f;
                params2.gravity = Gravity.END;
                params2.bottomMargin = pxToDp(3);
                otherMessageViewHolder.rlMessages.setLayoutParams(params2);
                //otherMessageViewHolder.tvMsg.setTextSize(pxToDp(3));
            } else {
                otherMessageViewHolder.tvMsg.setText(currentOrderItem.getMessage());
                String msg = currentOrderItem.getMessage().replace(" ", "&nbsp;");
                if (currentOrderItem.getMessageState() == 5) {
                    String editStr = Restring.getString(context, R.string.hippo_edited);
                    msg = msg + " <font  color='grey'><small> (" + editStr + ")</small></font>";
                } else if (currentOrderItem.getMessageState() == 4) {
                    String deletedStr = Restring.getString(context, R.string.hippo_message_deleted);
                    String name = currentOrderItem.getfromName();
                    msg = "<font  color='grey'><i>" + name + " " + deletedStr + " </i></font>";
                }
                otherMessageViewHolder.tvMsg.setText(Html.fromHtml(msg.replace("\n", "<br /> ")));
                otherMessageViewHolder.tvMsg.setVisibility(View.VISIBLE);
            }

            otherMessageViewHolder.tvUserName.setText(currentOrderItem.getfromName());
            setIntegrationSource(otherMessageViewHolder.messageSourceType, otherMessageViewHolder.messageSourceType1, otherMessageViewHolder.messageSourceType2, currentOrderItem.getIntegrationSource());

            if (currentOrderItem.getSentAtUtc().isEmpty()) {
                otherMessageViewHolder.tvTime.setVisibility(View.GONE);
            } else {
                otherMessageViewHolder.tvTime.setText(dateUtil.getTime(dateUtil.convertToLocal(currentOrderItem.getSentAtUtc())));
                otherMessageViewHolder.tvTime.setVisibility(View.VISIBLE);
            }

            String userNameText = "";

            if (!TextUtils.isEmpty(currentOrderItem.getfromName())) {
                userNameText = currentOrderItem.getfromName().trim();
            }

            int typePre = 0;
            if (position > 0)
                typePre = getItemViewType(position - 1);
            int typeNext = -1;
            if (position + 1 != items.size())
                typeNext = getItemViewType(position + 1);

            boolean hasImage = checkLeftImage(position, typePre, typeNext, currentOrderItem);
            otherMessageViewHolder.userImage.setVisibility(View.INVISIBLE);
            otherMessageViewHolder.tvUserName.setVisibility(View.GONE);
//            otherMessageViewHolder.tvUserName.setVisibility(View.VISIBLE);
//            otherMessageViewHolder.tvUserName.setText(userNameText);

            if (hasImage) {
                otherMessageViewHolder.tvUserName.setVisibility(View.VISIBLE);
                otherMessageViewHolder.tvUserName.setText(userNameText);
                otherMessageViewHolder.userImage.setVisibility(View.VISIBLE);
                loadUserImage(otherMessageViewHolder.userImage, userNameText, currentOrderItem.getUserImage());
                setUserName(otherMessageViewHolder.tvUserName);
                otherMessageViewHolder.llRoot.setPadding(0, pxToDp(20), 0, pxToDp(2));
            } else {
                otherMessageViewHolder.llRoot.setPadding(0, pxToDp(2), 0, pxToDp(2));
            }

            if (!currentOrderItem.getThumbnailUrl().isEmpty()) {
                LoadImageFile.getInstance().loadImage(context, currentOrderItem.getThumbnailUrl(), otherMessageViewHolder.ivMsgImage);
                otherMessageViewHolder.rlImageMessage.setVisibility(View.VISIBLE);

            } else {
                otherMessageViewHolder.rlImageMessage.setVisibility(View.GONE);
            }

            otherMessageViewHolder.rlImageMessage.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (adapterCallBack != null)
                        adapterCallBack.showImageDialog(context, currentOrderItem.getImageUrl(), otherMessageViewHolder.ivMsgImage, currentOrderItem);
                    else
                        showImageDialog(context, currentOrderItem.getImageUrl(), otherMessageViewHolder.ivMsgImage, currentOrderItem);
                }
            });

            if (currentOrderItem.getMessageSubType() == 1) {
                otherMessageViewHolder.callLinkView.setVisibility(View.VISIBLE);
                otherMessageViewHolder.rlMessages.setVisibility(View.GONE);
            } else {
                otherMessageViewHolder.callLinkView.setVisibility(View.GONE);
                otherMessageViewHolder.rlMessages.setVisibility(View.VISIBLE);

            }

            otherMessageViewHolder.callLinkView.setTag(position);
            otherMessageViewHolder.callLinkView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    int pos = (int) view.getTag();
                    if (context instanceof FuguChatActivity)
                        ((FuguChatActivity) context).openCallUrl(items.get(pos).getMessage());
                }
            });


            if (currentOrderItem.getMessageState() == 4) {
                otherMessageViewHolder.rlImageMessage.setVisibility(View.GONE);
            }

        } else if (itemType == ITEM_TYPE_SELF) {
            final SelfMessageViewHolder selfMessageViewHolder = (SelfMessageViewHolder) holder;
            final Message currentOrderItem = items.get(position);


            if (currentOrderItem.getOriginalMessageType() == PRIVATE_NOTE) {
                selfMessageViewHolder.llChat.setBackgroundResource(R.drawable.chat_self_bg_private);
                selfMessageViewHolder.rlImageMessage.setVisibility(View.GONE);
                if (currentOrderItem.getDocumentType() != null && currentOrderItem.getDocumentType().equalsIgnoreCase(DocumentType.VIDEO.toString())) {
                    selfMessageViewHolder.llfileMessage.setVisibility(View.GONE);
                    selfMessageViewHolder.rlSelfImageMessage.setVisibility(View.VISIBLE);
                    setVideoView(currentOrderItem, selfMessageViewHolder, position);
                } else if (currentOrderItem.getDocumentType() != null && currentOrderItem.getDocumentType().equalsIgnoreCase(DocumentType.IMAGE.toString())) {
                    selfMessageViewHolder.llfileMessage.setVisibility(View.GONE);
                    selfMessageViewHolder.rlSelfImageMessage.setVisibility(View.VISIBLE);
                    setImageView(currentOrderItem, selfMessageViewHolder, position);
                } else if (currentOrderItem.getDocumentType() != null /*&& currentOrderItem.getDocumentType().equalsIgnoreCase(DocumentType.FILE.toString())*/) {
                    selfMessageViewHolder.llfileMessage.setVisibility(View.VISIBLE);
                    selfMessageViewHolder.rlSelfImageMessage.setVisibility(View.GONE);
                    setFileTypeView(currentOrderItem, selfMessageViewHolder, position);
                } else {
                    selfMessageViewHolder.llfileMessage.setVisibility(View.GONE);
                    selfMessageViewHolder.rlSelfImageMessage.setVisibility(View.GONE);

                }
            } else {
                selfMessageViewHolder.rlImageMessage.setVisibility(View.GONE);
                selfMessageViewHolder.rlSelfImageMessage.setVisibility(View.GONE);
                selfMessageViewHolder.llfileMessage.setVisibility(View.GONE);
                selfMessageViewHolder.llChat.setBackgroundResource(R.drawable.chat_self_bg);
            }

            selfMessageViewHolder.tvName.setText(currentOrderItem.getfromName());
            if (currentOrderItem.getMessage().isEmpty()) {
                selfMessageViewHolder.tvMsg.setVisibility(View.INVISIBLE);
                LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                        ViewGroup.LayoutParams.MATCH_PARENT);
                params2.weight = 1.0f;
                params2.gravity = Gravity.END;
                selfMessageViewHolder.rlMessages.setLayoutParams(params2);
                //selfMessageViewHolder.tvMsg.setTextSize(pxToDp(3));
            } else {
                String messageText = currentOrderItem.getMessage();
                if (currentOrderItem.getMessageState() == 5) {
                    String editStr = Restring.getString(context, R.string.hippo_edited);
                    messageText = messageText + " <font  color='grey'><small> (" + editStr + ")</small></font>";
                } else if (currentOrderItem.getMessageState() == 4) {
                    String you = Restring.getString(context, R.string.hippo_you);
                    String deletedStr = Restring.getString(context, R.string.hippo_message_deleted);
                    messageText = "<font  color='grey'><i>" + you + " " + deletedStr + " </i></font>";
                }
                setTextMessage(selfMessageViewHolder.tvMsg, messageText);
                if (messageText.equalsIgnoreCase("n/a") || messageText.isEmpty())
                    selfMessageViewHolder.tvMsg.setVisibility(View.GONE);
                else
                    selfMessageViewHolder.tvMsg.setVisibility(View.VISIBLE);
            }

            if (currentOrderItem.getSentAtUtc().isEmpty()) {
                selfMessageViewHolder.tvTime.setVisibility(View.GONE);
            } else {
                selfMessageViewHolder.tvTime.setText(dateUtil.getTime(dateUtil.convertToLocal(currentOrderItem.getSentAtUtc())));
                selfMessageViewHolder.tvTime.setVisibility(View.VISIBLE);
            }

            int typePre = 0;
            if (position > 0)
                typePre = getItemViewType(position - 1);
            int typeNext = -1;
            if (position + 1 != items.size())
                typeNext = getItemViewType(position + 1);
            boolean hasImage = checkRightImage(position, typePre, typeNext, currentOrderItem);
            if (hasImage) {
                selfMessageViewHolder.tvName.setVisibility(View.VISIBLE);
                selfMessageViewHolder.userImage.setVisibility(View.VISIBLE);
                loadUserImage(selfMessageViewHolder.userImage, currentOrderItem.getfromName(), currentOrderItem.getUserImage());
                setUserName(selfMessageViewHolder.tvName);
                selfMessageViewHolder.llRoot.setPadding(0, pxToDp(20), 0, pxToDp(2));
            } else {
                selfMessageViewHolder.userImage.setVisibility(View.INVISIBLE);
                selfMessageViewHolder.tvName.setVisibility(View.GONE);
                selfMessageViewHolder.llRoot.setPadding(0, pxToDp(2), 0, pxToDp(2));
            }

            setIntegrationSource(selfMessageViewHolder.messageSourceType, selfMessageViewHolder.messageSourceType1, selfMessageViewHolder.messageSourceType2, currentOrderItem.getIntegrationSource());
            setMessageStatus(selfMessageViewHolder.ivMessageState_msg, currentOrderItem.getMessageStatus(), false);


//            try {
//                switch (currentOrderItem.getMessageStatus()) {
//                    case MESSAGE_UNSENT:
//                    case MESSAGE_IMAGE_RETRY:
//                    case MESSAGE_FILE_RETRY:
//                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
//                        selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
//                        break;
//                    case MESSAGE_READ:
//                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
//                        selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
//                        break;
//                    case MESSAGE_SENT:
//                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
//                        selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
//                        break;
//                    case MESSAGE_DELIVERED:
//                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
//                        selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
//                        break;
//                    default:
//                        selfMessageViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
//                        selfMessageViewHolder.ivMessageState.setVisibility(View.VISIBLE);
//                        break;
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            }

            selfMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (mOnRetry != null) {
                        selfMessageViewHolder.pbLoading.setVisibility(View.VISIBLE);
                        selfMessageViewHolder.btnRetry.setVisibility(View.GONE);
                        String muid = currentOrderItem.getMuid();
                        mOnRetry.onRetry(currentOrderItem.getImageUrl(), "image/*", currentOrderItem.getMessageIndex(), muid);
                    }
                }
            });

            if (currentOrderItem.getIsMessageExpired() == 1 && currentOrderItem.getOriginalMessageType() != 10) {
                selfMessageViewHolder.llRetry.setVisibility(View.VISIBLE);
                selfMessageViewHolder.tvTryAgain.setTag(position);
                selfMessageViewHolder.tvCancel.setTag(position);
                selfMessageViewHolder.tvTryAgain.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        if (mOnRetry != null) {
                            String muid = currentOrderItem.getMuid();
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            //int pos = (int) view.getTag();
                            mOnRetry.onMessageRetry(muid, pos);
                            //selfMessageViewHolder.llRetry.setVisibility(View.GONE);
                        }
                    }
                });

                selfMessageViewHolder.tvCancel.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        //int pos = (int) view.getTag();
                        int pos = selfMessageViewHolder.getAdapterPosition();
                        if (mOnRetry != null) {
                            String muid = currentOrderItem.getMuid();
                            mOnRetry.onMessageCancel(muid, pos);
                        }
                    }
                });
            } else {
                selfMessageViewHolder.llRetry.setVisibility(View.GONE);
            }

            selfMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (mOnRetry != null) {
                        selfMessageViewHolder.pbLoading.setVisibility(View.VISIBLE);
                        selfMessageViewHolder.btnRetry.setVisibility(View.GONE);
                        String muid = currentOrderItem.getMuid();
                        int pos = selfMessageViewHolder.getAdapterPosition();
                        mOnRetry.onFileMessageRetry(muid, pos);
                    }
                }
            });

            selfMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnRetry != null) {
                        String muid = currentOrderItem.getMuid();
                        int pos = selfMessageViewHolder.getAdapterPosition();
                        mOnRetry.onMessageCancel(muid, pos);
                    }
                }
            });
            if (currentOrderItem.getMessageState() == 4) {
                selfMessageViewHolder.rlImageMessage.setVisibility(View.GONE);
            }

            if (currentOrderItem.getMessageSubType() == 1) {
                selfMessageViewHolder.callLinkView.setVisibility(View.VISIBLE);
                selfMessageViewHolder.rlMessages.setVisibility(View.GONE);
            } else {
                selfMessageViewHolder.callLinkView.setVisibility(View.GONE);
                selfMessageViewHolder.rlMessages.setVisibility(View.VISIBLE);

            }

            selfMessageViewHolder.callLinkView.setTag(position);
            selfMessageViewHolder.callLinkView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    int pos = (int) view.getTag();
                    if (context instanceof FuguChatActivity)
                        ((FuguChatActivity) context).openCallUrl(items.get(pos).getMessage());
                }
            });


            if (currentOrderItem.getMessageSubType() == 1) {
                selfMessageViewHolder.callLinkView.setVisibility(View.VISIBLE);
                selfMessageViewHolder.rlMessages.setVisibility(View.GONE);
            } else {
                selfMessageViewHolder.callLinkView.setVisibility(View.GONE);
                selfMessageViewHolder.rlMessages.setVisibility(View.VISIBLE);

            }

            selfMessageViewHolder.callLinkView.setTag(position);
            selfMessageViewHolder.callLinkView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    int pos = (int) view.getTag();
                    if (context instanceof FuguChatActivity)
                        ((FuguChatActivity) context).openCallUrl(items.get(pos).getMessage());
                }
            });


        } else if (itemType == HIPPO_USER_CONCENT_VIEW) {
            final UserConcentViewHolder userConcentViewHolder = (UserConcentViewHolder) holder;
            final Message userConcentMessage = items.get(position);

            setBotSelfView(userConcentViewHolder.tvNameRight, userConcentViewHolder.tvMsgRight, userConcentViewHolder.tvTimeRight,
                    userConcentViewHolder.llRootRight, userConcentViewHolder.llChatRight, userConcentViewHolder.rlMessagesRight, position, userConcentMessage);

            loadUserImage(userConcentViewHolder.userImageRight, userConcentMessage.getfromName(), userConcentMessage.getUserImage());
            setUserName(userConcentViewHolder.tvNameRight);
            String selectedBtnId = "";
            if (!TextUtils.isEmpty(userConcentMessage.getSelectedBtnId())) {
                selectedBtnId = userConcentMessage.getSelectedBtnId();
            }

            if (TextUtils.isEmpty(selectedBtnId)) {
                userConcentViewHolder.recyclerView.setVisibility(View.VISIBLE);
                userConcentViewHolder.tvTagsTime.setVisibility(View.VISIBLE);
                userConcentViewHolder.leftrootview.setVisibility(View.GONE);

                if (userConcentMessage.getSentAtUtc().isEmpty()) {
                    userConcentViewHolder.tvTagsTime.setVisibility(View.GONE);
                } else {
                    userConcentViewHolder.tvTagsTime.setText(dateUtil.getTime(dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
                    userConcentViewHolder.tvTagsTime.setVisibility(View.VISIBLE);
                }

                TagsAdapter tagsAdapter = new TagsAdapter((ArrayList<ContentValue>) userConcentMessage.getContentValue());
                FlexboxLayoutManager flayoutManager = new FlexboxLayoutManager(context);
                flayoutManager.setFlexDirection(FlexDirection.ROW);
                flayoutManager.setJustifyContent(JustifyContent.FLEX_START);
                userConcentViewHolder.recyclerView.setLayoutManager(flayoutManager);
                userConcentViewHolder.recyclerView.setAdapter(tagsAdapter);

            } else {
                userConcentViewHolder.leftrootview.setVisibility(View.VISIBLE);
                userConcentViewHolder.recyclerView.setVisibility(View.GONE);
                userConcentViewHolder.tvTagsTime.setVisibility(View.GONE);

                int selectedPosition = 0;
                for (int i = 0; i < userConcentMessage.getContentValue().size(); i++) {
                    if (selectedBtnId.equalsIgnoreCase(userConcentMessage.getContentValue().get(i).getBtnId())) {
                        selectedPosition = i;
                        break;
                    }
                }

                setBotOtherView(position, selectedPosition, userConcentViewHolder, userConcentMessage);
            }

            int typePre = 0;
            if (position > 0)
                typePre = getItemViewType(position - 1);
            int typeNext = -1;
            if (position + 1 != items.size())
                typeNext = getItemViewType(position + 1);
            boolean hasImage = checkUserConsent(position, typePre, typeNext, userConcentMessage);

            userConcentViewHolder.userImageRight.setVisibility(View.INVISIBLE);
            userConcentViewHolder.tvNameRight.setVisibility(View.GONE);
            if (hasImage) {
                userConcentViewHolder.userImageRight.setVisibility(View.VISIBLE);
                userConcentViewHolder.tvNameRight.setVisibility(View.VISIBLE);
                loadUserImage(userConcentViewHolder.userImageRight, userConcentMessage.getfromName(), userConcentMessage.getUserImage());
                setUserName(userConcentViewHolder.tvNameRight);
                userConcentViewHolder.llRootRight.setPadding(0, pxToDp(20), 0, pxToDp(2));
            } else {
                userConcentViewHolder.llRootRight.setPadding(0, pxToDp(20), 0, pxToDp(2));
            }

            try {
                switch (userConcentMessage.getMessageStatus()) {
                    case MESSAGE_UNSENT:
                    case MESSAGE_IMAGE_RETRY:
                    case MESSAGE_FILE_RETRY:
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(View.VISIBLE);
                        break;
                    case MESSAGE_READ:
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(View.VISIBLE);
                        break;
                    case MESSAGE_SENT:
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(View.VISIBLE);
                        break;
                    case MESSAGE_DELIVERED:
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(View.VISIBLE);
                        break;
                    default:
                        userConcentViewHolder.ivMessageStateRight.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                        userConcentViewHolder.ivMessageStateRight.setVisibility(View.VISIBLE);
                        break;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        } else if (itemType == ITEM_ASSIGNMENT) {
            final AssignmentViewHolder assignmentViewHolder = (AssignmentViewHolder) holder;
            final Message currentOrderItem = items.get(position);
            String message = currentOrderItem.getMessage();
            try {
                if (!TextUtils.isEmpty(currentOrderItem.getMultiLangMessage())) {
                    Pattern pattern = Pattern.compile("\\{\\{\\{(.*?)\\}\\}\\}");
                    Matcher matcher = pattern.matcher(currentOrderItem.getMultiLangMessage());
                    if (matcher.find()) {
                        String key = matcher.group(1);
                        String value = Restring.getString(key);
                        if (!TextUtils.isEmpty(value)) {
                            String oldStr = "{{{" + key + "}}}";
                            message = currentOrderItem.getMultiLangMessage().replace(oldStr, value);
                        }
                    }
                }
            } catch (Exception e) {

            }
            assignmentViewHolder.tvAssignment.setText(Html.fromHtml(message));
        } else if (itemType == FUGU_RATING_VIEW) {
            final RatingViewHolder viewHolder = (RatingViewHolder) holder;
            final Message currentMessage = items.get(position);
            if (currentMessage.isRatingGiven()) {
                viewHolder.ratingView1.setVisibility(View.GONE);
                viewHolder.ratingView2.setVisibility(View.VISIBLE);

                int totalStar = currentMessage.getTotalRating();
                int givenStar = currentMessage.getRatingGiven();
                viewHolder.selectedStar.setText(givenStar + "/" + totalStar);
                if (TextUtils.isEmpty(currentMessage.getComment())) {
                    viewHolder.comment.setVisibility(View.GONE);
                } else {
                    viewHolder.comment.setText(currentMessage.getComment());
                    viewHolder.comment.setVisibility(View.VISIBLE);
                }
                viewHolder.thanksText.setText(Restring.getString(context, R.string.hippo_thanks_feedback));

            } else {
                viewHolder.ratingView1.setVisibility(View.VISIBLE);
                viewHolder.ratingView2.setVisibility(View.GONE);
                viewHolder.ratingView.setRating(0);
            }
            String message = currentMessage.getMessage();
            try {
                if (!TextUtils.isEmpty(currentMessage.getMultiLangMessage())) {
                    Pattern pattern = Pattern.compile("\\{\\{\\{(.*?)\\}\\}\\}");
                    Matcher matcher = pattern.matcher(currentMessage.getMultiLangMessage());
                    if (matcher.find()) {
                        String key = matcher.group(1);
                        String value = Restring.getString(key);
                        if (!TextUtils.isEmpty(value)) {
                            String oldStr = "{{{" + key + "}}}";
                            message = currentMessage.getMultiLangMessage().replace(oldStr, value);
                        }
                    }
                }
            } catch (Exception e) {

            }

            viewHolder.title.setText(message);
            viewHolder.userName.setText(currentMessage.getfromName());
            loadUserImage(viewHolder.userImage, currentMessage.getfromName(), currentMessage.getUserImage());
            setUserName(viewHolder.userName);
        } else if (itemType == LEAD_FORM_VIEW) {
            LeadFormViewHolder viewHolder = (LeadFormViewHolder) holder;
            Message currentMessage = items.get(position);
            setLeadFormData(viewHolder.lead_form_data, currentMessage);

            viewHolder.tvUserName.setText(currentMessage.getfromName());
            loadUserImage(viewHolder.userImage, currentMessage.getfromName(), currentMessage.getUserImage());
            setUserName(viewHolder.tvUserName);

        } else if (itemType == CUSTOM_VIEW_TYPE) {
            CustomViewHolder customViewHolder = (CustomViewHolder) holder;
            Message currentOrderItem = items.get(position);
            CustomAction customAction = currentOrderItem.getCustomAction();

            customViewHolder.userName.setText(currentOrderItem.getfromName());
            setUserName(customViewHolder.userName);
            loadUserImage(customViewHolder.userImage, currentOrderItem.getfromName(), currentOrderItem.getUserImage());


            if (customAction != null) {
                // title
                if (customAction.getTitle() != null && !TextUtils.isEmpty(customAction.getTitle())) {
                    customViewHolder.tvActionTitle.setVisibility(View.VISIBLE);
                    customViewHolder.tvActionTitle.setText(customAction.getTitle());
                    customViewHolder.tvActionTitle.setTextColor(fuguColorConfig.getFuguPrimaryTextMsgFrom());
                } else {
                    customViewHolder.tvActionTitle.setVisibility(View.GONE);
                }

                // title description
                if (customAction.getTitleDescription() != null && !TextUtils.isEmpty(customAction.getTitleDescription())) {
                    customViewHolder.tvActionTitleDescription.setVisibility(View.VISIBLE);
                    customViewHolder.tvActionTitleDescription.setText(customAction.getTitleDescription());
                    customViewHolder.tvActionTitleDescription.setTextColor(fuguColorConfig.getFuguPrimaryTextMsgFrom());
                } else {
                    customViewHolder.tvActionTitleDescription.setVisibility(View.GONE);
                }

                // image
                if (customAction.getImageUrl() != null && !TextUtils.isEmpty(customAction.getImageUrl())) {
                    //customViewHolder.llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_bottom);
                    customViewHolder.ivActionImage.setVisibility(View.VISIBLE);
                    LoadImageFile.getInstance().loadImage(context, customAction.getImageUrl(),
                            R.drawable.placeholder, customViewHolder.ivActionImage, 1);
                } else {
                    customViewHolder.ivActionImage.setVisibility(View.GONE);
                    //customViewHolder.llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_all_sides);
                }

//                drawable2 = (GradientDrawable) customViewHolder.llTextualContent.getBackground();
//                drawable2.setColor(fuguColorConfig.getFuguBgMessageFrom());

                // description
                if (customAction.getDescriptionObjects() != null && customAction.getDescriptionObjects().size() != 0) {
                    customViewHolder.rvActionDescription.setVisibility(View.VISIBLE);
                    customViewHolder.rvActionDescription.setLayoutManager(new LinearLayoutManager(context));
                    customViewHolder.rvActionDescription.setNestedScrollingEnabled(false);
                    customViewHolder.rvActionDescription.setAdapter(new CustomActionDescriptionAdapter(context,
                            customAction.getDescriptionObjects()));
                } else {
                    customViewHolder.rvActionDescription.setVisibility(View.GONE);
                }
                // buttons
                if (customAction.getActionButtons() != null && customAction.getActionButtons().size() != 0) {
                    customViewHolder.vwActionButtonDivider.setVisibility(View.VISIBLE);
                    customViewHolder.rvActionButtons.setVisibility(View.VISIBLE);
                    customViewHolder.rvActionButtons.setNestedScrollingEnabled(false);

                    // set span size of grid
                    int span = 2;
                    int size = customAction.getActionButtons().size();
                    if (size == 1) {
                        span = 1;
                    } else if (size % 3 == 0) {
                        span = 3;
                    } else {
                        span = 2;
                    }

                    customViewHolder.rvActionButtons.setLayoutManager(new GridLayoutManager(context, span));
                    customViewHolder.rvActionButtons.addItemDecoration(new GridDividerItemDecoration(context));
                    customViewHolder.rvActionButtons.setAdapter(new CustomActionButtonsAdapter(context,
                            customAction.getActionButtons()));
                } else {
                    customViewHolder.vwActionButtonDivider.setVisibility(View.GONE);
                    customViewHolder.rvActionButtons.setVisibility(View.GONE);
                }
            }
        } else if (itemType == HIPPO_FILE_SENT_VIEW) {
            final SentFileViewHolder sentFileViewHolder = (SentFileViewHolder) holder;
            final Message fileSentMessage = items.get(position);
            //setSelfMessageBackground(sentFileViewHolder.llRoot, sentFileViewHolder.llMessage, position);
            setIntegrationSource(sentFileViewHolder.messageSourceType, sentFileViewHolder.messageSourceType1, sentFileViewHolder.messageSourceType2, fileSentMessage.getIntegrationSource());
            sentFileViewHolder.circleProgress.setBarColor(ContextCompat.getColor(context, R.color.colorPrimary));
            String fileExt = Utils.getExtension(fileSentMessage.getFileName());

            if (fileSentMessage.getMessage() != null && !fileSentMessage.getMessage().isEmpty() && !fileSentMessage.getMessage().equalsIgnoreCase("n/a")) {
                setMessageText(sentFileViewHolder.tvMsg, fileSentMessage);
                sentFileViewHolder.tvMsg.setVisibility(View.VISIBLE);
            } else {
                sentFileViewHolder.tvMsg.setVisibility(View.GONE);
            }


            if (TextUtils.isEmpty(fileExt))
                fileExt = Utils.getExtension(fileSentMessage.getFileUrl());

            Integer dimage = IMAGE_MAP.get(fileExt.toLowerCase());
            if (dimage != null) {
                sentFileViewHolder.ivFileImage.setImageResource(dimage);
            } else {
                sentFileViewHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
            }
            sentFileViewHolder.tvFileName.setText(fileSentMessage.getFileName());
            if (fileExt.length() > 4) {
                fileExt = fileExt.substring(0, 4) + "..";
            }
            sentFileViewHolder.tvFileExtension.setText(fileExt);
            if (!TextUtils.isEmpty(fileSentMessage.getFileSize())) {
                try {
                    sentFileViewHolder.tvFileSize.setText(fileSentMessage.getFileSize());
                } catch (Exception e) {
                    sentFileViewHolder.tvFileSize.setText(fileSentMessage.getFileSize());
                }
            }

            messageStatusTick(sentFileViewHolder.ivMessageState, fileSentMessage);
            setFileUploadStatus(sentFileViewHolder.ivFileImage, sentFileViewHolder.ivFilePlay, sentFileViewHolder.circleProgress, sentFileViewHolder.ivFileDownload, sentFileViewHolder.ivFileUpload, fileSentMessage, position);
            setDownloadClick(sentFileViewHolder.ivFileDownload, sentFileViewHolder.circleProgress, fileSentMessage, position);
            setUploadClick(sentFileViewHolder.ivFileUpload, sentFileViewHolder.circleProgress, fileSentMessage);
            sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
            if (!fileSentMessage.isAudioPlaying()) {
                sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
            } else {
                sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
            }
            setFileCLickListener(sentFileViewHolder.llMessage, fileSentMessage, sentFileViewHolder.ivFilePlay, position);
            sentFileViewHolder.ivFileUpload.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int pos = sentFileViewHolder.getAdapterPosition();
                    if (mOnRetry != null)
                        mOnRetry.onFileMessageRetry(fileSentMessage.getMuid(), pos);
                }
            });

            if (fileSentMessage.getSentAtUtc().isEmpty()) {
                sentFileViewHolder.tvFileTime.setVisibility(View.GONE);
            } else {
                sentFileViewHolder.tvFileTime.setText(dateUtil.getTime(dateUtil.convertToLocal(fileSentMessage.getSentAtUtc())));
                sentFileViewHolder.tvFileTime.setVisibility(View.VISIBLE);
            }


            int typePre = 0;
            if (position > 0)
                typePre = getItemViewType(position - 1);
            int typeNext = -1;
            if (position + 1 != items.size())
                typeNext = getItemViewType(position + 1);
            boolean hasImage = checkRightImage(position, typePre, typeNext, fileSentMessage);

            if (hasImage) {
                sentFileViewHolder.tvName.setText(fileSentMessage.getfromName());
                sentFileViewHolder.tvName.setVisibility(View.VISIBLE);
                sentFileViewHolder.userImage.setVisibility(View.VISIBLE);
                loadUserImage(sentFileViewHolder.userImage, fileSentMessage.getfromName(), fileSentMessage.getUserImage());
                setUserName(sentFileViewHolder.tvName);
                sentFileViewHolder.llRoot.setPadding(0, pxToDp(20), 0, pxToDp(2));
            } else {
                sentFileViewHolder.userImage.setVisibility(View.INVISIBLE);
                sentFileViewHolder.tvName.setVisibility(View.GONE);
                sentFileViewHolder.llRoot.setPadding(0, pxToDp(2), 0, pxToDp(2));
            }

            if (fileSentMessage.getOriginalMessageType() == PRIVATE_NOTE) {
                sentFileViewHolder.llMessage.setBackgroundResource(R.drawable.chat_self_bg_private);
            } else {
                sentFileViewHolder.llMessage.setBackgroundResource(R.drawable.chat_self_bg);
            }


        } else if (itemType == HIPPO_FILE_RECEIVED_VIEW) {
            final ReceivedFileViewHolder fHolder = (ReceivedFileViewHolder) holder;
            final Message fileReceivedMessage = items.get(position);

            fHolder.progressBar.setBarColor(ContextCompat.getColor(context, R.color.colorPrimary));
            setIntegrationSource(fHolder.messageSourceType, fHolder.messageSourceType1, fHolder.messageSourceType2, fileReceivedMessage.getIntegrationSource());


            if (fileReceivedMessage.getMessage() != null && !fileReceivedMessage.getMessage().isEmpty() && !fileReceivedMessage.getMessage().equalsIgnoreCase("n/a")) {
                setMessageText(fHolder.tvMsg, fileReceivedMessage);

                fHolder.tvMsg.setVisibility(View.VISIBLE);
            } else
                fHolder.tvMsg.setVisibility(View.GONE);

            String fuserNameText = "";
            if (!TextUtils.isEmpty(fileReceivedMessage.getfromName())) {
                fuserNameText = fileReceivedMessage.getfromName().trim();
            }
            String receivedFileExt = Utils.getExtension(fileReceivedMessage.getFileUrl());
            Integer dimage1 = IMAGE_MAP.get(receivedFileExt.toLowerCase());
            if (dimage1 != null) {
                fHolder.ivFileImage.setImageResource(dimage1);
            } else {
                fHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
            }
            fHolder.tvFileName.setText(fileReceivedMessage.getFileName());

            String fileExt = TextUtils.isEmpty(fileReceivedMessage.getFileExtension()) ? receivedFileExt : fileReceivedMessage.getFileExtension();
            if (fileExt.length() > 4) {
                fileExt = fileExt.substring(0, 4) + "..";
            }
            fHolder.tvFileExtension.setText(fileExt);

            fHolder.tvFileSize.setText(fileReceivedMessage.getFileSize());
            setFileDownLoadStatus(fHolder.ivFileImage, fHolder.ivFilePlay, fHolder.progressBar, fHolder.ivFileDownload, fHolder.ivFileUpload, fileReceivedMessage, position);
            setDownloadClick(fHolder.ivFileDownload, fHolder.progressBar, fileReceivedMessage, position);
            if (!fileReceivedMessage.isAudioPlaying()) {
                fHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
            } else {
                fHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
            }
            setFileCLickListener(fHolder.llMessage, fileReceivedMessage, fHolder.ivFilePlay, position);
            if (fileReceivedMessage.getSentAtUtc().isEmpty()) {
                fHolder.tvFileTime.setVisibility(View.GONE);
            } else {
                fHolder.tvFileTime.setText(dateUtil.getTime(dateUtil.convertToLocal(fileReceivedMessage.getSentAtUtc())));
                fHolder.tvFileTime.setVisibility(View.VISIBLE);
            }

            int typePre = 0;
            if (position > 0)
                typePre = getItemViewType(position - 1);
            int typeNext = -1;
            if (position + 1 != items.size())
                typeNext = getItemViewType(position + 1);

            boolean hasImage = checkLeftImage(position, typePre, typeNext, fileReceivedMessage);
            fHolder.userImage.setVisibility(View.INVISIBLE);
            fHolder.tvUserName.setVisibility(View.GONE);
            if (hasImage) {
                fHolder.tvUserName.setVisibility(View.VISIBLE);
                fHolder.tvUserName.setText(fileReceivedMessage.getfromName());
                fHolder.userImage.setVisibility(View.VISIBLE);
                loadUserImage(fHolder.userImage, fileReceivedMessage.getfromName(), fileReceivedMessage.getUserImage());
                setUserName(fHolder.tvUserName);
                fHolder.llRoot.setPadding(0, pxToDp(20), 0, pxToDp(2));
            } else {
                fHolder.llRoot.setPadding(0, pxToDp(2), 0, pxToDp(2));
            }

        } else if (itemType == HIPPO_VIDEO_MESSGAE_SELF) {
            final SelfVideoMessageViewHolder selfVideoMessageViewHolder = (SelfVideoMessageViewHolder) holder;
            final Message selfVideoMessage = items.get(position);
            //setSelfMessageBackground(selfVideoMessageViewHolder.llRoot, selfVideoMessageViewHolder.llImageMessage, position);

            if (selfVideoMessage.getMessage() != null && !selfVideoMessage.getMessage().isEmpty() && !selfVideoMessage.getMessage().equalsIgnoreCase("n/a")) {
                setMessageText(selfVideoMessageViewHolder.tvImgWithText, selfVideoMessage);
                selfVideoMessageViewHolder.tvImgWithText.setVisibility(View.VISIBLE);
            } else {
                selfVideoMessageViewHolder.tvImgWithText.setVisibility(View.GONE);

            }


            setIntegrationSource(selfVideoMessageViewHolder.messageSourceType, selfVideoMessageViewHolder.messageSourceType1, selfVideoMessageViewHolder.messageSourceType2, selfVideoMessage.getIntegrationSource());
            selfVideoMessageViewHolder.circle_progress.setBarColor(ContextCompat.getColor(context, R.color.fugu_secondary_text_msg_you));

            setTime(selfVideoMessageViewHolder.tvImageTime, selfVideoMessage.getSentAtUtc());
            setMessageStatus(selfVideoMessageViewHolder.ivMessageState, selfVideoMessage.getMessageStatus(), true);
            if (!TextUtils.isEmpty(selfVideoMessage.getThumbnailUrl())) {
                setImage(context, selfVideoMessageViewHolder.ivImageMsg, selfVideoMessage.getThumbnailUrl());
            } else {
                selfVideoMessageViewHolder.ivImageMsg.setVisibility(View.GONE);
            }

            int typePre = 0;
            if (position > 0)
                typePre = getItemViewType(position - 1);
            int typeNext = -1;
            if (position + 1 != items.size())
                typeNext = getItemViewType(position + 1);
            boolean hasImage = checkRightImage(position, typePre, typeNext, selfVideoMessage);


            if (hasImage) {
                selfVideoMessageViewHolder.userName.setVisibility(View.VISIBLE);
                selfVideoMessageViewHolder.userImage.setVisibility(View.VISIBLE);
                loadUserImage(selfVideoMessageViewHolder.userImage, selfVideoMessage.getfromName(), selfVideoMessage.getUserImage());
                setUserName(selfVideoMessageViewHolder.userName);
                selfVideoMessageViewHolder.llRoot.setPadding(0, pxToDp(20), 0, pxToDp(2));
            } else {
                selfVideoMessageViewHolder.userImage.setVisibility(View.INVISIBLE);
                selfVideoMessageViewHolder.userName.setVisibility(View.GONE);
                selfVideoMessageViewHolder.llRoot.setPadding(0, pxToDp(2), 0, pxToDp(2));
            }

            selfVideoMessageViewHolder.ivPlay.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (!Utils.preventMultipleClicks()) {
                        return;
                    }

                    String fname = Utils.getFileName(selfVideoMessage.getFileName(), selfVideoMessage.getMuid());
                    String localPath = FileManager.getInstance().getLocalPath(context, fname, FOLDER_TYPE.get(selfVideoMessage.getDocumentType()));
                    if (TextUtils.isEmpty(localPath))
                        localPath = selfVideoMessage.getFileUrl();
                    Intent intent = new Intent(context, VideoPlayerActivity.class);
                    intent.putExtra("url", localPath);
                    intent.putExtra("title", selfVideoMessage.getFileName());
                    context.startActivity(intent);
                }
            });
            setVideoUiStatus(true, selfVideoMessage, selfVideoMessageViewHolder.llDownload, selfVideoMessageViewHolder.ivPlay,
                    selfVideoMessageViewHolder.btnRetry, selfVideoMessageViewHolder.btnCancel, selfVideoMessageViewHolder.circle_progress, false);

            selfVideoMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int pos = selfVideoMessageViewHolder.getAdapterPosition();
                    if (mOnRetry != null)
                        mOnRetry.onMessageCancel(selfVideoMessage.getMuid(), pos);
                }
            });

            selfVideoMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int pos = selfVideoMessageViewHolder.getAdapterPosition();
                    if (mOnRetry != null)
                        mOnRetry.onFileMessageRetry(selfVideoMessage.getMuid(), pos);
                }
            });
            selfVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    selfVideoMessageViewHolder.circle_progress.setVisibility(View.VISIBLE);
                    selfVideoMessageViewHolder.llDownload.setVisibility(View.GONE);

                    String docType = "video";
                    if (selfVideoMessage.getOriginalMessageType() == FILE_MESSAGE) {
                        docType = selfVideoMessage.getDocumentType();
                    }

                    String fileName = selfVideoMessage.getFileName();


                    if (TextUtils.isEmpty(fileName)) {
                        String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                        fileName = "Hippochat_" + timeStamp + ".jpg";
                    }

                    String fullPath = Utils.getDirectoryPath(context, FOLDER_TYPE.get(docType));
                    File file = new File(fullPath);
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    int downloadId = downloadFileFromUrl(fullPath, fileName, selfVideoMessage, position, selfVideoMessage.getFileUrl());

                    selfVideoMessage.setDownloadId(downloadId);
                }
            });
        } else if (itemType == HIPPO_VIDEO_MESSGAE_OTHER) {
            final OtherVideoMessageViewHolder otherVideoMessageViewHolder = (OtherVideoMessageViewHolder) holder;
            final Message otherVideoMessage = items.get(position);

            if (otherVideoMessage.getMessage() != null && !otherVideoMessage.getMessage().isEmpty() && !otherVideoMessage.getMessage().equalsIgnoreCase("n/a")) {
                setMessageText(otherVideoMessageViewHolder.tvImgWithText, otherVideoMessage);
                otherVideoMessageViewHolder.tvImgWithText.setVisibility(View.VISIBLE);
            } else {
                otherVideoMessageViewHolder.tvImgWithText.setVisibility(View.GONE);

            }

            otherVideoMessageViewHolder.progressBar.setBarColor(ContextCompat.getColor(context, R.color.colorPrimary));
            setTime(otherVideoMessageViewHolder.tvImageTime, otherVideoMessage.getSentAtUtc());
            if (!TextUtils.isEmpty(otherVideoMessage.getThumbnailUrl())) {
                setImage(context, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage.getThumbnailUrl());
            } else {
                otherVideoMessageViewHolder.ivImageMsg.setVisibility(View.GONE);
            }
            //setImageHeightAndWidth(otherVideoMessageViewHolder.ivImageMsg, otherVideoMessageViewHolder.rlImageMessage, otherVideoMessageViewHolder.llImageMessage, otherVideoMessage, true);
            setVideoDownloadStatus(otherVideoMessageViewHolder.llDownload, otherVideoMessageViewHolder.ivPlay, otherVideoMessageViewHolder.tvFileSize, otherVideoMessageViewHolder.progressBar, otherVideoMessage, position);

            setIntegrationSource(otherVideoMessageViewHolder.messageSourceType, otherVideoMessageViewHolder.messageSourceType1, otherVideoMessageViewHolder.messageSourceType2, otherVideoMessage.getIntegrationSource());

            String vuserNameText = "";
            if (!TextUtils.isEmpty(otherVideoMessage.getfromName())) {
                vuserNameText = otherVideoMessage.getfromName().trim();
            }


            int typePre = 0;
            if (position > 0)
                typePre = getItemViewType(position - 1);
            int typeNext = -1;
            if (position + 1 != items.size())
                typeNext = getItemViewType(position + 1);

            boolean hasImage = checkLeftImage(position, typePre, typeNext, otherVideoMessage);
            otherVideoMessageViewHolder.userImage.setVisibility(View.INVISIBLE);
            otherVideoMessageViewHolder.tvUserName.setVisibility(View.GONE);
            if (hasImage) {
                otherVideoMessageViewHolder.tvUserName.setVisibility(View.VISIBLE);
                otherVideoMessageViewHolder.tvUserName.setText(vuserNameText);
                otherVideoMessageViewHolder.userImage.setVisibility(View.VISIBLE);
                loadUserImage(otherVideoMessageViewHolder.userImage, vuserNameText, otherVideoMessage.getUserImage());
                setUserName(otherVideoMessageViewHolder.tvUserName);
                otherVideoMessageViewHolder.llRoot.setPadding(0, pxToDp(20), 0, pxToDp(2));
            } else {
                otherVideoMessageViewHolder.llRoot.setPadding(0, pxToDp(2), 0, pxToDp(2));
            }


            otherVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (context.isNetworkAvailable()) {
                        otherVideoMessageViewHolder.progressBar.setVisibility(View.VISIBLE);
                        otherVideoMessageViewHolder.llDownload.setVisibility(View.GONE);

                        String docType = "video";
                        if (otherVideoMessage.getOriginalMessageType() == FILE_MESSAGE) {
                            docType = otherVideoMessage.getDocumentType();
                        }

                        String fileName = otherVideoMessage.getFileName();

                        if (TextUtils.isEmpty(fileName)) {
                            String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                            fileName = "Hippochat_" + timeStamp + ".jpg";
                        }

                        String fullPath = Utils.getDirectoryPath(context, FOLDER_TYPE.get(docType));
                        File file = new File(fullPath);
                        if (!file.exists()) {
                            file.mkdir();
                        }
                        int downloadId = downloadFileFromUrl(fullPath, fileName, otherVideoMessage, position, otherVideoMessage.getFileUrl());

                        otherVideoMessage.setDownloadId(downloadId);
                    } else {
                        Toast.makeText(context, context.getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                    }
                }
            });
        } else if (itemType == HIPPO_IMAGE_RECEIVED) {
            final OtherVideoMessageViewHolder otherVideoMessageViewHolder = (OtherVideoMessageViewHolder) holder;
            final Message otherVideoMessage = items.get(position);

            otherVideoMessageViewHolder.progressBar.setBarColor(ContextCompat.getColor(context, R.color.colorPrimary));
            setTime(otherVideoMessageViewHolder.tvImageTime, otherVideoMessage.getSentAtUtc());

            if (otherVideoMessage.getMessage() != null && !otherVideoMessage.getMessage().isEmpty() && !otherVideoMessage.getMessage().equalsIgnoreCase("n/a")) {
                setMessageText(otherVideoMessageViewHolder.tvImgWithText, otherVideoMessage);
                otherVideoMessageViewHolder.tvImgWithText.setVisibility(View.VISIBLE);
            } else {
                otherVideoMessageViewHolder.tvImgWithText.setVisibility(View.GONE);

            }

            //setVideoDownloadStatus(otherVideoMessageViewHolder.llDownload, otherVideoMessageViewHolder.ivPlay, otherVideoMessageViewHolder.tvFileSize, otherVideoMessageViewHolder.progressBar, otherVideoMessage, position);

            otherVideoMessageViewHolder.llDownload.setVisibility(View.GONE);
            otherVideoMessageViewHolder.ivPlay.setVisibility(View.GONE);
            otherVideoMessageViewHolder.tvFileSize.setVisibility(View.GONE);


            setIntegrationSource(otherVideoMessageViewHolder.messageSourceType, otherVideoMessageViewHolder.messageSourceType1, otherVideoMessageViewHolder.messageSourceType2, otherVideoMessage.getIntegrationSource());
            String vuserNameText = otherVideoMessage.getfromName();

            int typePre = 0;
            if (position > 0)
                typePre = getItemViewType(position - 1);
            int typeNext = -1;
            if (position + 1 != items.size())
                typeNext = getItemViewType(position + 1);

            boolean hasImage = checkLeftImage(position, typePre, typeNext, otherVideoMessage);
            otherVideoMessageViewHolder.userImage.setVisibility(View.INVISIBLE);
            otherVideoMessageViewHolder.tvUserName.setVisibility(View.GONE);
            if (hasImage) {
                otherVideoMessageViewHolder.tvUserName.setVisibility(View.VISIBLE);
                otherVideoMessageViewHolder.tvUserName.setText(vuserNameText);
                otherVideoMessageViewHolder.userImage.setVisibility(View.VISIBLE);
                loadUserImage(otherVideoMessageViewHolder.userImage, vuserNameText, otherVideoMessage.getUserImage());
                setUserName(otherVideoMessageViewHolder.tvUserName);
                otherVideoMessageViewHolder.llRoot.setPadding(0, pxToDp(20), 0, pxToDp(2));
            } else {
                otherVideoMessageViewHolder.llRoot.setPadding(0, pxToDp(2), 0, pxToDp(2));
            }


            //setImageHeightAndWidth(otherVideoMessageViewHolder.ivImageMsg, otherVideoMessageViewHolder.rlImageMessage, otherVideoMessageViewHolder.llImageMessage, otherVideoMessage, true);

            if (!TextUtils.isEmpty(otherVideoMessage.getThumbnailUrl()) || !TextUtils.isEmpty(otherVideoMessage.getFileUrl())) {
                if (!TextUtils.isEmpty(otherVideoMessage.getThumbnailUrl()))
                    setImage(context, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage.getThumbnailUrl());
                else if (!TextUtils.isEmpty(otherVideoMessage.getFileUrl()))
                    setImage(context, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage.getFileUrl());
            } else {
                otherVideoMessageViewHolder.ivImageMsg.setVisibility(View.GONE);
            }

            otherVideoMessageViewHolder.ivImageMsg.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String imageurl = otherVideoMessage.getImageUrl();
                    if (!otherVideoMessage.getImageUrl().isEmpty())
                        imageurl = otherVideoMessage.getImageUrl();
                    else if (!otherVideoMessage.getFileUrl().isEmpty())
                        imageurl = otherVideoMessage.getFileUrl();
                    if (adapterCallBack != null) {
                        adapterCallBack.showImageDialog(context, imageurl, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage);
                    } else {
                        showImageDialog(context, imageurl, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage);
                    }
                }
            });


        } else if (itemType == HIPPO_IMAGE_SENT) {
            final SelfVideoMessageViewHolder selfImageMessageViewHolder = (SelfVideoMessageViewHolder) holder;
            final Message selfVideoMessage = items.get(position);

            if (selfVideoMessage.getMessage() != null && !selfVideoMessage.getMessage().isEmpty() && !selfVideoMessage.getMessage().equalsIgnoreCase("n/a")) {
                setMessageText(selfImageMessageViewHolder.tvImgWithText, selfVideoMessage);
                selfImageMessageViewHolder.tvImgWithText.setVisibility(View.VISIBLE);
            } else {
                selfImageMessageViewHolder.tvImgWithText.setVisibility(View.GONE);

            }

            setIntegrationSource(selfImageMessageViewHolder.messageSourceType, selfImageMessageViewHolder.messageSourceType1, selfImageMessageViewHolder.messageSourceType2, selfVideoMessage.getIntegrationSource());
            selfImageMessageViewHolder.circle_progress.setBarColor(ContextCompat.getColor(context, R.color.colorPrimary));

            setTime(selfImageMessageViewHolder.tvImageTime, selfVideoMessage.getSentAtUtc());
            setMessageStatus(selfImageMessageViewHolder.ivMessageState, selfVideoMessage.getMessageStatus(), true);


            if (!TextUtils.isEmpty(selfVideoMessage.getThumbnailUrl()) || !TextUtils.isEmpty(selfVideoMessage.getFileUrl())) {
                if (!TextUtils.isEmpty(selfVideoMessage.getThumbnailUrl()))
                    setImage(context, selfImageMessageViewHolder.ivImageMsg, selfVideoMessage.getThumbnailUrl());
                else if (!TextUtils.isEmpty(selfVideoMessage.getFileUrl()))
                    setImage(context, selfImageMessageViewHolder.ivImageMsg, selfVideoMessage.getFileUrl());

            } else {
                selfImageMessageViewHolder.ivImageMsg.setVisibility(View.GONE);
            }
            selfImageMessageViewHolder.ivPlay.setVisibility(View.GONE);

            final boolean isClickable = setVideoUiStatus(true, selfVideoMessage, selfImageMessageViewHolder.llDownload, selfImageMessageViewHolder.ivPlay,
                    selfImageMessageViewHolder.btnRetry, selfImageMessageViewHolder.btnCancel, selfImageMessageViewHolder.circle_progress, true);

            selfImageMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int pos = selfImageMessageViewHolder.getAdapterPosition();
                    if (mOnRetry != null)
                        mOnRetry.onMessageCancel(selfVideoMessage.getMuid(), pos);
                }
            });

            selfImageMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int pos = selfImageMessageViewHolder.getAdapterPosition();
                    if (mOnRetry != null)
                        mOnRetry.onFileMessageRetry(selfVideoMessage.getMuid(), pos);
                }
            });

            selfImageMessageViewHolder.ivImageMsg.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (isClickable) {
                        String imageurl = selfVideoMessage.getImageUrl();
                        if (!selfVideoMessage.getImageUrl().isEmpty())
                            imageurl = selfVideoMessage.getImageUrl();
                        else if (!selfVideoMessage.getFileUrl().isEmpty())
                            imageurl = selfVideoMessage.getFileUrl();

                        if (adapterCallBack != null)
                            adapterCallBack.showImageDialog(context, imageurl, selfImageMessageViewHolder.ivImageMsg, selfVideoMessage);
                        else
                            showImageDialog(context, imageurl, selfImageMessageViewHolder.ivImageMsg, selfVideoMessage);
                    }
                }
            });

            int typePre = 0;
            if (position > 0)
                typePre = getItemViewType(position - 1);
            int typeNext = -1;
            if (position + 1 != items.size())
                typeNext = getItemViewType(position + 1);
            boolean hasImage = checkRightImage(position, typePre, typeNext, selfVideoMessage);

            if (hasImage) {
                selfImageMessageViewHolder.userName.setText(selfVideoMessage.getfromName());
                selfImageMessageViewHolder.userName.setVisibility(View.VISIBLE);
                selfImageMessageViewHolder.userImage.setVisibility(View.VISIBLE);
                loadUserImage(selfImageMessageViewHolder.userImage, selfVideoMessage.getfromName(), selfVideoMessage.getUserImage());
                setUserName(selfImageMessageViewHolder.userName);
                selfImageMessageViewHolder.llRoot.setPadding(0, pxToDp(20), 0, pxToDp(2));
            } else {
                selfImageMessageViewHolder.userImage.setVisibility(View.INVISIBLE);
                selfImageMessageViewHolder.userName.setVisibility(View.GONE);
                selfImageMessageViewHolder.llRoot.setPadding(0, pxToDp(2), 0, pxToDp(2));
            }


        } else if (itemType == HIPPO_PAYMENT_VIEW) {
            final PaymentView paymentView = (PaymentView) holder;
            Message paymentMsg = items.get(position);
            LinearLayoutManager paymentLayoutManager = new LinearLayoutManager(context);

            paymentLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
            paymentView.recyclerView.setLayoutManager(paymentLayoutManager);
            try {
                PaymentAdapter paymentAdapter = new PaymentAdapter(paymentMsg, paymentMsg.getCustomAction().getHippoPayment(),
                        paymentMsg.getCustomAction().getSelectedId());
                paymentView.recyclerView.setAdapter(paymentAdapter);
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else if (itemType == HIPPO_MULTISELECTION_VIEW) {
            final MultiSelectionView selectionView = (MultiSelectionView) holder;
            Message selectionMsg = items.get(position);

            LinearLayoutManager paymentLayoutManager = new LinearLayoutManager(context);

            paymentLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
            selectionView.recyclerView.setLayoutManager(paymentLayoutManager);
            boolean isMultiSelected = true;
            int max = -1;
            try {
                max = selectionMsg.getCustomAction().getMaxSelection();
                if (selectionMsg.getCustomAction().getMinSelection() < 1)
                    max = -1;
                if (selectionMsg.getCustomAction().getMinSelection() == 1 && selectionMsg.getCustomAction().getMaxSelection() == 1) {
                    isMultiSelected = false;
                }
            } catch (Exception e) {

            }
            MultiSelectionAdapter adapter = new MultiSelectionAdapter(selectionMsg.getCustomAction().getMultiSelectButtons(), isMultiSelected);
            selectionView.recyclerView.setAdapter(adapter);


            selectionView.tvUserName.setText(selectionMsg.getfromName());
            selectionView.tvMsg.setText(selectionMsg.getMessage());
            if (selectionMsg.getSentAtUtc().isEmpty()) {
                selectionView.tvTime.setVisibility(View.GONE);
            } else {
                selectionView.tvTime.setText(dateUtil.getTime(dateUtil.convertToLocal(selectionMsg.getSentAtUtc())));
                selectionView.tvTime.setVisibility(View.VISIBLE);
            }

            loadUserImage(selectionView.userImage, selectionMsg.getfromName(), selectionMsg.getUserImage());

            setBotSelfView(selectionView.tvUserName, selectionView.tvMsg, selectionView.tvTime,
                    selectionView.llRootRight, selectionView.llMessageBgLeft, null, position, selectionMsg);

            try {
                switch (selectionMsg.getMessageStatus()) {
                    case MESSAGE_UNSENT:
                    case MESSAGE_IMAGE_RETRY:
                    case MESSAGE_FILE_RETRY:
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                        selectionView.ivMessageState.setVisibility(View.VISIBLE);
                        break;
                    case MESSAGE_READ:
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
                        selectionView.ivMessageState.setVisibility(View.VISIBLE);
                        break;
                    case MESSAGE_SENT:
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                        selectionView.ivMessageState.setVisibility(View.VISIBLE);
                        break;
                    case MESSAGE_DELIVERED:
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
                        selectionView.ivMessageState.setVisibility(View.VISIBLE);
                        break;
                    default:
                        selectionView.ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                        selectionView.ivMessageState.setVisibility(View.VISIBLE);
                        break;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setImageView(Message selfVideoMessage, SelfMessageViewHolder selfImageMessageViewHolder, int position) {
        setIntegrationSource(selfImageMessageViewHolder.messageSourceType, selfImageMessageViewHolder.messageSourceType1, selfImageMessageViewHolder.messageSourceType2, selfVideoMessage.getIntegrationSource());
        selfImageMessageViewHolder.circle_progress.setBarColor(ContextCompat.getColor(context, R.color.colorPrimary));


        selfImageMessageViewHolder.ivPlay.setVisibility(View.GONE);
        if (!TextUtils.isEmpty(selfVideoMessage.getThumbnailUrl())) {
            setImage(context, selfImageMessageViewHolder.ivImageselfMsg, selfVideoMessage.getThumbnailUrl());
        } else {
            selfImageMessageViewHolder.ivImageselfMsg.setVisibility(View.GONE);
        }
        final boolean isClickable = setVideoUiStatus(true, selfVideoMessage, selfImageMessageViewHolder.llimageDownload, selfImageMessageViewHolder.ivPlay,
                null, null, selfImageMessageViewHolder.circle_progress, true);


        selfImageMessageViewHolder.rlSelfImageMessage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isClickable) {
                    if (adapterCallBack != null)
                        adapterCallBack.showImageDialog(context, selfVideoMessage.getImageUrl(), selfImageMessageViewHolder.ivImageselfMsg, selfVideoMessage);
                    else
                        showImageDialog(context, selfVideoMessage.getImageUrl(), selfImageMessageViewHolder.ivImageselfMsg, selfVideoMessage);
                }
            }
        });
    }

    private void setVideoView(Message selfVideoMessage, SelfMessageViewHolder selfVideoMessageViewHolder, int position) {

        //setSelfMessageBackground(selfVideoMessageViewHolder.llRoot, selfVideoMessageViewHolder.llImageMessage, position);

        setIntegrationSource(selfVideoMessageViewHolder.messageSourceType, selfVideoMessageViewHolder.messageSourceType1, selfVideoMessageViewHolder.messageSourceType2, selfVideoMessage.getIntegrationSource());
        selfVideoMessageViewHolder.circle_progress.setBarColor(ContextCompat.getColor(context, R.color.colorPrimary));

        if (!TextUtils.isEmpty(selfVideoMessage.getThumbnailUrl())) {
            setImage(context, selfVideoMessageViewHolder.ivImageselfMsg, selfVideoMessage.getThumbnailUrl());
        } else {
            selfVideoMessageViewHolder.ivImageselfMsg.setVisibility(View.GONE);
        }

        selfVideoMessageViewHolder.ivPlay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!Utils.preventMultipleClicks()) {
                    return;
                }

                String fname = Utils.getFileName(selfVideoMessage.getFileName(), selfVideoMessage.getMuid());
                String localPath = FileManager.getInstance().getLocalPath(context, fname, FOLDER_TYPE.get(selfVideoMessage.getDocumentType()));
                if (TextUtils.isEmpty(localPath))
                    localPath = selfVideoMessage.getFileUrl();
                Intent intent = new Intent(context, VideoPlayerActivity.class);
                intent.putExtra("url", localPath);
                intent.putExtra("title", selfVideoMessage.getFileName());
                context.startActivity(intent);
            }
        });

        setVideoUiStatus(true, selfVideoMessage, selfVideoMessageViewHolder.llimageDownload, selfVideoMessageViewHolder.ivPlay,
                null, null, selfVideoMessageViewHolder.circle_progress, false);

        selfVideoMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int pos = selfVideoMessageViewHolder.getAdapterPosition();
                if (mOnRetry != null)
                    mOnRetry.onMessageCancel(selfVideoMessage.getMuid(), pos);
            }
        });

        selfVideoMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int pos = selfVideoMessageViewHolder.getAdapterPosition();
                if (mOnRetry != null)
                    mOnRetry.onFileMessageRetry(selfVideoMessage.getMuid(), pos);
            }
        });
        selfVideoMessageViewHolder.llimageDownload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selfVideoMessageViewHolder.circle_progress.setVisibility(View.VISIBLE);
                selfVideoMessageViewHolder.llimageDownload.setVisibility(View.GONE);

                String docType = "video";
                if (selfVideoMessage.getOriginalMessageType() == FILE_MESSAGE) {
                    docType = selfVideoMessage.getDocumentType();
                }

                String fileName = selfVideoMessage.getFileName();


                if (TextUtils.isEmpty(fileName)) {
                    String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                    fileName = "Hippochat_" + timeStamp + ".jpg";
                }

                String fullPath = Utils.getDirectoryPath(context, FOLDER_TYPE.get(docType));
                File file = new File(fullPath);
                if (!file.exists()) {
                    file.mkdir();
                }
                int downloadId = downloadFileFromUrl(fullPath, fileName, selfVideoMessage, position, selfVideoMessage.getFileUrl());

                selfVideoMessage.setDownloadId(downloadId);
            }
        });

    }

    private void setFileTypeView(Message fileSentMessage, SelfMessageViewHolder sentFileViewHolder, int position) {
        //setSelfMessageBackground(sentFileViewHolder.llRoot, sentFileViewHolder.llMessage, position);
        setIntegrationSource(sentFileViewHolder.messageSourceType, sentFileViewHolder.messageSourceType1, sentFileViewHolder.messageSourceType2, fileSentMessage.getIntegrationSource());
        sentFileViewHolder.circleProgress.setBarColor(ContextCompat.getColor(context, R.color.colorPrimary));
        String fileExt = Utils.getExtension(fileSentMessage.getFileName());
        if (TextUtils.isEmpty(fileExt))
            fileExt = Utils.getExtension(fileSentMessage.getFileUrl());

        Integer dimage = IMAGE_MAP.get(fileExt.toLowerCase());
        if (dimage != null) {
            sentFileViewHolder.ivFileImage.setImageResource(dimage);
        } else {
            sentFileViewHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
        }
        sentFileViewHolder.tvFileName.setText(fileSentMessage.getFileName());
        if (fileExt.length() > 4) {
            fileExt = fileExt.substring(0, 4) + "..";
        }
        sentFileViewHolder.tvFileExtension.setText(fileExt);
        if (!TextUtils.isEmpty(fileSentMessage.getFileSize())) {
            try {
                sentFileViewHolder.tvFileSize.setText(fileSentMessage.getFileSize());
            } catch (Exception e) {
                sentFileViewHolder.tvFileSize.setText(fileSentMessage.getFileSize());
            }
        }

        messageStatusTick(sentFileViewHolder.ivMessageState_msg, fileSentMessage);
        setFileUploadStatus(sentFileViewHolder.ivFileImage, sentFileViewHolder.ivFilePlay, sentFileViewHolder.circleProgress, sentFileViewHolder.ivFileDownload, sentFileViewHolder.ivFileUpload, fileSentMessage, position);
        setDownloadClick(sentFileViewHolder.ivFileDownload, sentFileViewHolder.circleProgress, fileSentMessage, position);
        setUploadClick(sentFileViewHolder.ivFileUpload, sentFileViewHolder.circleProgress, fileSentMessage);
        sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
        if (!fileSentMessage.isAudioPlaying()) {
            sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
        } else {
            sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
        }
        setFileCLickListener(sentFileViewHolder.llfileMessage, fileSentMessage, sentFileViewHolder.ivFilePlay, position);
        sentFileViewHolder.ivFileUpload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int pos = sentFileViewHolder.getAdapterPosition();
                if (mOnRetry != null)
                    mOnRetry.onFileMessageRetry(fileSentMessage.getMuid(), pos);
            }
        });
    }

    private RequestOptions options;

    private RequestOptions getRequestOptions(String name) {
        ColorGenerator generator = ColorGenerator.MATERIAL;
        int color = generator.getColor(name.trim());

        if (options == null) {
            options = new RequestOptions()
                    .centerCrop()
                    .fitCenter()
                    .priority(Priority.HIGH)
                    .transform(new CenterCrop(), new RoundedCorners(10))
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL);
        }

        TextDrawable drawable = null;
        try {
            Resources r = context.getResources();
            float px = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 4, r.getDisplayMetrics());

            name = name.trim();
            char text = ' ';

            text = name.charAt(0);

            drawable = TextDrawable.builder()
                    .buildRoundRect((text + "").toUpperCase(), color, Math.round(px));

            options.placeholder(drawable);
            options.error(drawable);
        } catch (Exception e) {
            options.placeholder(R.drawable.placeholder);
            options.error(R.drawable.placeholder);
        }


        options.placeholder(drawable);
        options.error(drawable);
        return options;
    }

    private void setUserName(TextView userName) {
        ColorGenerator colorGenerator = ColorGenerator.MATERIAL_NAME;
        int color = colorGenerator.getColor(userName.getText().toString().trim());
        userName.setTextColor(color);
    }

    private void loadUserImage(ImageView imageView, String name, String url) {
        Glide.with(context).asBitmap()
                .apply(getRequestOptions(name))
                .load(url)
                .into(imageView);
    }

    private boolean checkRightImage(int position, int typePre, int typeNext, Message message) {
        if (position == 0)
            return true;
        else if (typePre == ITEM_TYPE_SELF || typePre == HIPPO_IMAGE_SENT || typePre == HIPPO_FILE_SENT_VIEW) {
            Message lastOrderItem = items.get(position - 1);
            if (message.getUserId().compareTo(lastOrderItem.getUserId()) == 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkUserConsent(int position, int typePre, int typeNext, Message message) {
        if (position == 0)
            return true;
        else if (typePre == ITEM_TYPE_SELF || typePre == HIPPO_IMAGE_SENT || typePre == HIPPO_FILE_SENT_VIEW) {
            Message lastOrderItem = items.get(position - 1);
            if (message.getUserId().compareTo(lastOrderItem.getUserId()) == 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkLeftImage(int position, int typePre, int typeNext, Message currentOrderItem) {
        if (position == 0)
            return true;
        else if (typePre == HIPPO_USER_CONCENT_VIEW && !TextUtils.isEmpty(items.get(position - 1).getSelectedBtnId())) {
            return false;
        } else if (typePre == ITEM_TYPE_OTHER || typePre == FUGU_OTHER_VIDEO_CALL_VIEW ||
                typePre == HIPPO_FILE_RECEIVED_VIEW || typePre == HIPPO_VIDEO_MESSGAE_OTHER || typePre == HIPPO_IMAGE_RECEIVED) {
            if (items.get(position).getUserId().intValue() != items.get(position - 1).getUserId().intValue())
                return true;
            return false;
        }
        return true;
    }

    public static int getColorWrapper(Context context, int id) {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {//if actual version is >= 6.0
                return ContextCompat.getColor(context, id);
            } else {
                //noinspection deprecation
                return context.getResources().getColor(id);
            }
        } catch (Resources.NotFoundException e) {
            return Color.parseColor("@color/colorPrimary");
        }
    }

    private void setBotOtherView(int position, int selectedBtn, UserConcentViewHolder userConcentViewHolder, Message userConcentMessage) {

        userConcentViewHolder.tvMsg.setText(userConcentMessage.getContentValue().get(selectedBtn).getBtnTitle());

        if (userConcentMessage.getSentAtUtc().isEmpty()) {
            userConcentViewHolder.tvTime.setVisibility(View.GONE);
        } else {
            userConcentViewHolder.tvTime.setText(dateUtil.getTime(dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
            userConcentViewHolder.tvTime.setVisibility(View.VISIBLE);
        }

        String userNameText = userConcentMessage.getRepliedBy();
        if (!TextUtils.isEmpty(userNameText)) {
            userConcentViewHolder.tvUserName.setVisibility(View.VISIBLE);
            userConcentViewHolder.tvUserName.setText(userNameText);
        } else {
            userConcentViewHolder.tvUserName.setVisibility(View.GONE);
        }

        int typePre = 0;
        if (position > 0)
            typePre = getItemViewType(position - 1);
        int typeNext = -1;
        if (position + 1 != items.size())
            typeNext = getItemViewType(position + 1);

        boolean hasImage = true;//checkLeftImage(position, typePre, typeNext, userConcentMessage);

        userConcentViewHolder.tvUserName.setVisibility(View.GONE);
        //userConcentViewHolder.userImage.setVisibility(View.INVISIBLE);
        if (hasImage && !TextUtils.isEmpty(userNameText)) {
            userConcentViewHolder.tvUserName.setVisibility(View.VISIBLE);
            userConcentViewHolder.tvUserName.setText(userNameText);

        }

        userConcentViewHolder.userImage.setVisibility(View.VISIBLE);
        loadUserImage(userConcentViewHolder.userImage, userNameText, userConcentMessage.getRepliedUserImage());
        setUserName(userConcentViewHolder.tvUserName);
        userConcentViewHolder.leftrootview.setPadding(0, pxToDp(8), 0, pxToDp(1));
    }


    private void setBotSelfView(TextView tvNameRight, TextView tvMsgRight, TextView tvTimeRight,
                                LinearLayout llRootRight, LinearLayout llChatRight, RelativeLayout rlMessagesRight, int position, Message userConcentMessage) {

        tvNameRight.setText(userConcentMessage.getfromName());
        tvMsgRight.setText(userConcentMessage.getMessage());
        if (userConcentMessage.getSentAtUtc().isEmpty()) {
            tvTimeRight.setVisibility(View.GONE);
        } else {
            tvTimeRight.setText(dateUtil.getTime(dateUtil.convertToLocal(userConcentMessage.getSentAtUtc())));
            tvTimeRight.setVisibility(View.VISIBLE);
        }

        /*if (position != 0
                && (getItemViewType(position - 1) == ITEM_TYPE_SELF)
                && (position + 1 != items.size())
                && (getItemViewType(position + 1) == ITEM_TYPE_SELF)) {
            llRootRight.setPadding(pxToDp(0),
                    pxToDp(1), pxToDp(17), pxToDp(1));

        } else if (position != 0
                && ((getItemViewType(position - 1) == ITEM_TYPE_SELF)
                && (position + 1 != items.size())
                && (getItemViewType(position + 1) != ITEM_TYPE_SELF))
                || (!(position - 1 < 0) && (getItemViewType(position - 1) == ITEM_TYPE_SELF))) {
            if (position == items.size() - 1) {
                llRootRight.setPadding(pxToDp(0),
                        pxToDp(1), pxToDp(17), pxToDp(1));
            } else {
                llRootRight.setPadding(pxToDp(0),
                        pxToDp(1), pxToDp(17), pxToDp(2));
            }
        } else if (position != 0
                && (position + 1 != items.size())
                && (getItemViewType(position + 1) == ITEM_TYPE_SELF)) {
            llRootRight.setPadding(pxToDp(0),
                    pxToDp(4), pxToDp(10), pxToDp(1));
        } else {
            if (position == items.size() - 1) {
                llRootRight.setPadding(pxToDp(0),
                        pxToDp(4), pxToDp(10), pxToDp(1));
            } else {
                llRootRight.setPadding(pxToDp(0),
                        pxToDp(4), pxToDp(10), pxToDp(2));
            }
        }*/

        //add new//
        /*if (position != 0 && isNotSelfViewType(position - 1)) {
            llChatRight.setBackgroundResource(R.drawable.agent_chat_bg_right);
            if(rlMessagesRight != null) {
                rlMessagesRight.setPadding(pxToDp(0),
                        pxToDp(0), pxToDp(12), pxToDp(0));
            }
        } else {
            llChatRight.setBackgroundResource(R.drawable.agent_chat_bg_right_normal);
            if(rlMessagesRight != null) {
                rlMessagesRight.setPadding(pxToDp(0),
                        pxToDp(0), pxToDp(6), pxToDp(0));
            }
        }*/


//        NinePatchDrawable drawable3 = (NinePatchDrawable) llChatRight.getBackground();
//        drawable3.setColorFilter(fuguColorConfig.getFuguBgMessageYou(), PorterDuff.Mode.MULTIPLY);

    }

    private boolean isNotSelfViewType(int position) {
        int itemType = getItemViewType(position);
        if (itemType == ITEM_TYPE_SELF || itemType == HIPPO_FILE_SENT_VIEW ||
                itemType == HIPPO_VIDEO_MESSGAE_SELF || //itemType == HIPPO_USER_CONCENT_VIEW ||
                itemType == FUGU_VIDEO_CALL_VIEW) {
            return false;
        }
        return true;
    }

    private void setIntegrationSource(ImageView source, ImageView messenger, ImageView fugu, int type) {
        source.setVisibility(View.GONE);
        messenger.setVisibility(View.GONE);
        fugu.setVisibility(View.GONE);
        int color = ContextCompat.getColor(context, R.color.colorPrimary);//context.getColor(R.color.colorPrimary);
        switch (type) {
            case 5:
                source.setImageResource(R.drawable.ic_email);
                source.setVisibility(View.VISIBLE);
                source.setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
                break;
            case 6:
                messenger.setVisibility(View.VISIBLE);
                break;
            case 7:
                source.setImageResource(R.drawable.ic_sms);
                source.setVisibility(View.VISIBLE);
                source.setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
                break;
            case 8:
                fugu.setVisibility(View.VISIBLE);
                break;
            default:
//                source.setVisibility(View.GONE);
//                messenger.setVisibility(View.GONE);
                break;
        }
    }

    private void setLeadFormData(LinearLayout leadFormData, Message currentMessage) {
        leadFormData.removeAllViews();
        for (int i = 0; i < currentMessage.getContentValue().get(0).getQuestions().size(); i++) {
            LayoutInflater layoutInflater = (LayoutInflater) context.getBaseContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            final View addView = layoutInflater.inflate(R.layout.lead_form_item, null);

            TextView title = addView.findViewById(R.id.title_view);
            TextView value = addView.findViewById(R.id.value_view);
            TextView countView = addView.findViewById(R.id.count_view);
            ImageView actionView = addView.findViewById(R.id.action_view);
            ImageView arrowBgView = addView.findViewById(R.id.arrow_background_view);

            countView.setVisibility(View.GONE);

            String txtTitle = currentMessage.getContentValue().get(0).getQuestions().get(i);
            title.setText(txtTitle);

            String txtValue = "";
            try {
                if (currentMessage.getValues() != null && currentMessage.getValues().get(i) != null)
                    txtValue = currentMessage.getValues().get(i);
            } catch (Exception e) {
                //e.printStackTrace();
            }

            if (!TextUtils.isEmpty(txtValue)) {
                value.setText(txtValue);
                actionView.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.ic_tick));
                actionView.setVisibility(View.VISIBLE);
            } else {
                value.setText(txtTitle);
                actionView.setVisibility(View.GONE);
            }

            leadFormData.addView(addView);
            if (currentMessage.getValues().size() == i)
                return;
        }

    }

    private void setMargins(View view, int left, int top, int right, int bottom) {
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
            p.setMargins(left, top, right, bottom);
            view.requestLayout();
        }
    }

    private int pxToDp(int dpParam) {
        int dpValue = dpParam; // margin in dips
        float d = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * d); // margin in pixels
    }


    @Override
    public int getItemViewType(int position) {
        return items.get(position).getType();
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    class OtherMessageViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout llRoot, llChatLeft, callLinkView;
        private TextView tvUserName, tvMsg, tvTime, tvTimeNew;
        private RelativeLayout rlImageMessage, rlMessages, rlimagetime;
        private ImageView ivMsgImage, userImage;
        private ImageView messageSourceType, messageSourceType1, messageSourceType2;


        public OtherMessageViewHolder(View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llChatLeft = itemView.findViewById(R.id.llChatLeft);
            tvUserName = itemView.findViewById(R.id.tvUserName);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvTime = itemView.findViewById(R.id.tvTime);
            rlimagetime = itemView.findViewById(R.id.rlimagetime);
            tvTimeNew = itemView.findViewById(R.id.tvImageTime);
            callLinkView = itemView.findViewById(R.id.callLinkView);

            rlImageMessage = itemView.findViewById(R.id.rlImageMessage);
            rlMessages = itemView.findViewById(R.id.rlMessages);
            ivMsgImage = itemView.findViewById(R.id.ivMsgImage);
            userImage = itemView.findViewById(R.id.user_image);
            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
            messageSourceType2 = itemView.findViewById(R.id.message_source_type2);

            tvMsg.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick(llRoot, itemView, getAdapterPosition(), false);
                    return true;
                }
            });

            llRoot.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick(llRoot, itemView, getAdapterPosition(), false);
                    return true;
                }
            });
        }
    }

    class SelfMessageViewHolder extends RecyclerView.ViewHolder {
        private RelativeLayout llRoot;
        private LinearLayout llTime, callLinkView, llimageDownload;
        private TextView tvMsg, tvTime, tvName, tvTryAgain, tvCancel;
        private RelativeLayout rlImageMessage, rlMessages;
        private LinearLayoutCompat rlSelfImageMessage;
        private LinearLayout llChat;
        private ImageView ivMessageState_msg, ivMsgImage, messageSourceType, messageSourceType1, messageSourceType2;
        private ProgressBar pbLoading;
        private Button btnRetry, btnCancel;
        private LinearLayout llRetry;
        private ImageView userImage;

        private LinearLayoutCompat llfileMessage, llImages;
        private TextView tvFileName, tvFileSize, tvFileExtension, tvFileTime;
        private AppCompatImageView ivFileDownload, ivFileUpload, ivFilePlay;
        private ImageView ivFileImage;
        private FuguAgentProgressWheel circleProgress;

        //video
        private LinearLayoutCompat llImageMessage;
        private AppCompatImageView ivImageselfMsg;
        private ImageView ivPlay, ivDownload;
        private TextView tvImgWithText;
        private FuguAgentProgressWheel circle_progress;
        private TextView userName;

        public SelfMessageViewHolder(View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llTime = itemView.findViewById(R.id.llTime);
            callLinkView = itemView.findViewById(R.id.callLinkView);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvName = itemView.findViewById(R.id.tvName);
            tvTime = itemView.findViewById(R.id.tvTime);
            llChat = itemView.findViewById(R.id.llChat);
            rlImageMessage = itemView.findViewById(R.id.rlImageMessage);
            rlMessages = itemView.findViewById(R.id.rlMessages);
            ivMessageState_msg = itemView.findViewById(R.id.ivMessageState_msg);
            ivMsgImage = itemView.findViewById(R.id.ivMsgImage);
            pbLoading = itemView.findViewById(R.id.pbLoading);
            btnRetry = itemView.findViewById(R.id.btnRetry);
            btnCancel = itemView.findViewById(R.id.btnCancel);
            llRetry = itemView.findViewById(R.id.llRetry);
            tvTryAgain = itemView.findViewById(R.id.tvTryAgain);
            tvCancel = itemView.findViewById(R.id.tvCancel);
            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
            messageSourceType2 = itemView.findViewById(R.id.message_source_type2);
            userImage = itemView.findViewById(R.id.user_image);

            //file layout
            llfileMessage = itemView.findViewById(R.id.llfileMessage);
            llImages = itemView.findViewById(R.id.llImages);

            tvFileName = itemView.findViewById(R.id.tvFileName);
            tvFileSize = itemView.findViewById(R.id.tvFileSize);
            tvFileExtension = itemView.findViewById(R.id.tvFileExtension);
            tvFileTime = itemView.findViewById(R.id.tvFileTime);

            ivFileImage = itemView.findViewById(R.id.ivFileImage);

            ivFilePlay = itemView.findViewById(R.id.ivFilePlay);
            ivFileDownload = itemView.findViewById(R.id.ivFileDownload);
            ivFileUpload = itemView.findViewById(R.id.ivFileUpload);

            circleProgress = itemView.findViewById(R.id.circle_progress);

            //videolayout
            llImageMessage = itemView.findViewById(R.id.llImageMessage);
            llimageDownload = itemView.findViewById(R.id.llimageDownload);
            ivImageselfMsg = itemView.findViewById(R.id.ivImageselfMsg);
            rlSelfImageMessage = itemView.findViewById(R.id.rlSelfImageMessage);

            ivPlay = itemView.findViewById(R.id.ivPlay);
            ivDownload = itemView.findViewById(R.id.ivDownload);

            tvImgWithText = itemView.findViewById(R.id.tvImgWithText);
            circle_progress = itemView.findViewById(R.id.circle_progress);


            userImage = itemView.findViewById(R.id.user_image);


            tvMsg.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick(llRoot, itemView, getAdapterPosition(), false);
                    return true;
                }
            });

            llRoot.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick(llRoot, itemView, getAdapterPosition(), false);
                    return true;
                }
            });
        }
    }

    class LeadFormViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout lead_form_data;
        private RelativeLayout mainLayout;
        private ImageView userImage;
        private TextView tvUserName;

        public LeadFormViewHolder(View itemView) {
            super(itemView);
            mainLayout = itemView.findViewById(R.id.main_layout);
            lead_form_data = itemView.findViewById(R.id.lead_form_data);
            userImage = itemView.findViewById(R.id.user_image);
            tvUserName = itemView.findViewById(R.id.tvUserName);
        }
    }

    class EmptyViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout lead_form_data;

        public EmptyViewHolder(View itemView) {
            super(itemView);

        }
    }

    class SelfVideoViewHolder extends RecyclerView.ViewHolder {

        private TextView tvMsg, tvTime, callAgain, tvDuration;
        private ImageView ivCallIcon;
        private LinearLayout llChat;
        private ImageView userImage;
        private TextView tvUserName;
        private View dividerView;

        public SelfVideoViewHolder(View itemView) {
            super(itemView);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvTime = itemView.findViewById(R.id.tvTime);
            callAgain = itemView.findViewById(R.id.callAgain);
            tvDuration = itemView.findViewById(R.id.tvDuration);
            llChat = itemView.findViewById(R.id.llMessage);
            ivCallIcon = itemView.findViewById(R.id.ivCallIcon);
            userImage = itemView.findViewById(R.id.user_image);
            tvUserName = itemView.findViewById(R.id.tvName);
            dividerView = itemView.findViewById(R.id.dividerView);
        }
    }

    class VideoViewHolder extends RecyclerView.ViewHolder {

        private TextView tvMsg, tvTime, callAgain, tvDuration;
        private ImageView ivCallIcon;
        private LinearLayout llChat;
        private ImageView userImage;
        private TextView tvUserName;
        private View callDivider;

        public VideoViewHolder(View itemView) {
            super(itemView);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvTime = itemView.findViewById(R.id.tvTime);
            callAgain = itemView.findViewById(R.id.callAgain);
            tvDuration = itemView.findViewById(R.id.tvDuration);
            llChat = itemView.findViewById(R.id.llMessage);
            ivCallIcon = itemView.findViewById(R.id.ivCallIcon);
            userImage = itemView.findViewById(R.id.user_image);
            tvUserName = itemView.findViewById(R.id.tvUserName);
            callDivider = itemView.findViewById(R.id.call_divider);
        }
    }

    class CustomViewHolder extends RecyclerView.ViewHolder {

        // custom action components
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent, llRoot;
        private RelativeLayout llChatLeft;
        private ImageView userImage;
        private TextView userName;

        public CustomViewHolder(View itemView) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llChatLeft = itemView.findViewById(R.id.llChatLeft);
            rlCustomAction = itemView.findViewById(R.id.layoutCustomAction);
            tvActionTitle = itemView.findViewById(R.id.tvActionTitle);
            rvActionDescription = itemView.findViewById(R.id.rvActionDescription);
            rvActionButtons = itemView.findViewById(R.id.rvActionButtons);
            ivActionImage = itemView.findViewById(R.id.ivActionImage);
            vwActionButtonDivider = itemView.findViewById(R.id.vwActionButtonDivider);
            tvActionTitleDescription = itemView.findViewById(R.id.tvActionDescription);
            llTextualContent = itemView.findViewById(R.id.llTextualContent);

            userImage = itemView.findViewById(R.id.user_image);
            userName = itemView.findViewById(R.id.tvUserName);
        }
    }

    class RatingViewHolder extends RecyclerView.ViewHolder {

        private LinearLayout rootView, ratingView1, ratingView2;
        private TextView title, userName, selectedStar, comment, thanksText;
        private ImageView userImage;
        private RatingBar ratingView;

        public RatingViewHolder(View itemView) {
            super(itemView);
            rootView = itemView.findViewById(R.id.llRoot);
            ratingView1 = itemView.findViewById(R.id.ratingView1);
            ratingView2 = itemView.findViewById(R.id.ratingView2);
            userImage = itemView.findViewById(R.id.user_image);
            userName = itemView.findViewById(R.id.tvUserName);
            title = itemView.findViewById(R.id.title);
            ratingView = itemView.findViewById(R.id.ratingView);
            selectedStar = itemView.findViewById(R.id.selectedStar);
            thanksText = itemView.findViewById(R.id.thanks_text);
            comment = itemView.findViewById(R.id.comment);
        }
    }

    class AssignmentViewHolder extends RecyclerView.ViewHolder {
        private TextView tvAssignment;

        public AssignmentViewHolder(View itemView) {
            super(itemView);
            tvAssignment = itemView.findViewById(R.id.tvAssignment);
        }
    }

    class DateViewHolder extends RecyclerView.ViewHolder {
        private TextView tvDate;

        public DateViewHolder(View itemView) {
            super(itemView);
            tvDate = itemView.findViewById(R.id.tvDate);
        }
    }

    class ReceivedFileViewHolder extends RecyclerView.ViewHolder {

        private LinearLayoutCompat llRoot, llMessage, llFile, llImages;
        private TextView tvUserName, tvFileName, tvFileSize, tvFileExtension, tvFileTime, tvMsg;
        private ImageView ivFileImage, messageSourceType, messageSourceType1, messageSourceType2;
        private AppCompatImageView ivFileDownload, ivFilePlay, ivFileUpload;
        private FuguAgentProgressWheel progressBar;
        private ImageView userImage;


        public ReceivedFileViewHolder(@NonNull View itemView) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llMessage = itemView.findViewById(R.id.llMessage);
            llFile = itemView.findViewById(R.id.llFile);
            llImages = itemView.findViewById(R.id.llImages);

            tvUserName = itemView.findViewById(R.id.tvUserName);
            tvFileName = itemView.findViewById(R.id.tvFileName);
            tvFileSize = itemView.findViewById(R.id.tvFileSize);
            tvFileExtension = itemView.findViewById(R.id.tvFileExtension);
            tvFileTime = itemView.findViewById(R.id.tvFileTime);
            tvMsg = itemView.findViewById(R.id.tvMsg);

            ivFileImage = itemView.findViewById(R.id.ivFileImage);
            ivFilePlay = itemView.findViewById(R.id.ivFilePlay);
            ivFileDownload = itemView.findViewById(R.id.ivFileDownload);
            ivFileUpload = itemView.findViewById(R.id.ivFileUpload);

            progressBar = itemView.findViewById(R.id.circle_progress);
            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
            messageSourceType2 = itemView.findViewById(R.id.message_source_type2);
            userImage = itemView.findViewById(R.id.user_image);
        }
    }

    class SentFileViewHolder extends RecyclerView.ViewHolder {

        private LinearLayoutCompat llRoot, llMessage, fileViewLL, llImages;
        private TextView tvFileName, tvFileSize, tvFileExtension, tvFileTime, tvMsg;
        private AppCompatImageView ivFilePlay, ivFileDownload, ivFileUpload;
        private ImageView ivFileImage, ivMessageState, messageSourceType, messageSourceType1, messageSourceType2;
        private FuguAgentProgressWheel circleProgress;

        private ImageView userImage;
        private TextView tvName;

        public SentFileViewHolder(@NonNull View itemView) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llMessage = itemView.findViewById(R.id.llMessage);
            llImages = itemView.findViewById(R.id.llImages);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            fileViewLL = itemView.findViewById(R.id.fileViewLL);

            tvFileName = itemView.findViewById(R.id.tvFileName);
            tvFileSize = itemView.findViewById(R.id.tvFileSize);
            tvFileExtension = itemView.findViewById(R.id.tvFileExtension);
            tvFileTime = itemView.findViewById(R.id.tvFileTime);

            ivFileImage = itemView.findViewById(R.id.ivFileImage);
            ivFilePlay = itemView.findViewById(R.id.ivFilePlay);
            ivFileDownload = itemView.findViewById(R.id.ivFileDownload);
            ivFileUpload = itemView.findViewById(R.id.ivFileUpload);
            ivMessageState = itemView.findViewById(R.id.ivMessageState);

            circleProgress = itemView.findViewById(R.id.circle_progress);
            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
            messageSourceType2 = itemView.findViewById(R.id.message_source_type2);

            tvName = itemView.findViewById(R.id.tvName);
            userImage = itemView.findViewById(R.id.user_image);

        }
    }

    class SelfVideoMessageViewHolder extends RecyclerView.ViewHolder {

        private LinearLayout llDownload;
        private LinearLayoutCompat llRoot, llImageMessage;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg, ivMessageState;
        private ImageView ivPlay, ivDownload, messageSourceType, messageSourceType1, messageSourceType2;
        private AppCompatTextView tvImageTime;
        private TextView tvFileSize, tvImgWithText;
        private AppCompatButton btnRetry, btnCancel;
        private FuguAgentProgressWheel circle_progress;
        private ImageView userImage;
        private TextView userName;

        public SelfVideoMessageViewHolder(View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llImageMessage = itemView.findViewById(R.id.llImageMessage);
            llDownload = itemView.findViewById(R.id.llDownload);

            rlImageMessage = itemView.findViewById(R.id.rlImageMessage);
            ivImageMsg = itemView.findViewById(R.id.ivImageMsg);
            ivPlay = itemView.findViewById(R.id.ivPlay);
            ivDownload = itemView.findViewById(R.id.ivDownload);
            ivMessageState = itemView.findViewById(R.id.ivMessageState);

            tvFileSize = itemView.findViewById(R.id.tvFileSize);
            tvImageTime = itemView.findViewById(R.id.tvImageTime);
            tvImgWithText = itemView.findViewById(R.id.tvImgWithText);
            circle_progress = itemView.findViewById(R.id.circle_progress);
            btnRetry = itemView.findViewById(R.id.btnRetry);
            btnCancel = itemView.findViewById(R.id.btnCancel);
            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
            messageSourceType2 = itemView.findViewById(R.id.message_source_type2);

            userName = itemView.findViewById(R.id.tvName);
            userImage = itemView.findViewById(R.id.user_image);
        }
    }

    class UserConcentViewHolder extends RecyclerView.ViewHolder {

        private LinearLayout main_root;

        //for right side view
        private LinearLayout llRootRight, llChatRight, llTimeRight;
        private RelativeLayout rlMessagesRight;
        private TextView tvNameRight, tvMsgRight, tvTimeRight;
        private ImageView ivMessageStateRight;

        //for tags
        //private ChatContainerLayout tagLayout;
        private TextView tvTagsTime;
        private RecyclerView recyclerView;

        //for left side view
        //private ConstraintLayout clayout;
        private LinearLayout llChatLeft, llTime;
        private TextView tvUserName, tvMsg, tvTime;
        private RelativeLayout rlMessages, leftrootview;
        private ImageView userImage, userImageRight;

        public UserConcentViewHolder(@NonNull View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            main_root = itemView.findViewById(R.id.main_root);

            llRootRight = itemView.findViewById(R.id.llRootRight);
            llChatRight = itemView.findViewById(R.id.llChatRight);
            llTimeRight = itemView.findViewById(R.id.llTimeRight);
            rlMessagesRight = itemView.findViewById(R.id.rlMessagesRight);
            tvNameRight = itemView.findViewById(R.id.tvNameRight);
            tvMsgRight = itemView.findViewById(R.id.tvMsgRight);
            tvTimeRight = itemView.findViewById(R.id.tvTimeRight);
            ivMessageStateRight = itemView.findViewById(R.id.ivMessageStateRight);
            userImageRight = itemView.findViewById(R.id.user_image_right);


            //tagLayout = itemView.findViewById(R.id.tagLayout);
            tvTagsTime = itemView.findViewById(R.id.tvTagsTime);
            recyclerView = itemView.findViewById(R.id.recyclerView);


            //clayout = itemView.findViewById(R.id.clayout);
            llChatLeft = itemView.findViewById(R.id.llChatLeft);
            llTime = itemView.findViewById(R.id.llTime);
            tvUserName = itemView.findViewById(R.id.tvUserName);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvTime = itemView.findViewById(R.id.tvTime);
            rlMessages = itemView.findViewById(R.id.rlMessages);
            leftrootview = itemView.findViewById(R.id.leftrootview);
            userImage = itemView.findViewById(R.id.user_image);

            tvMsgRight.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick(llChatRight, itemView, getAdapterPosition(), false);
                    return true;
                }
            });
            llRootRight.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick(llChatRight, itemView, getAdapterPosition(), false);
                    return true;
                }
            });

            tvMsg.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick(main_root, itemView, getAdapterPosition(), true);
                    return true;
                }
            });
            leftrootview.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    itemClickListener.onItemLongClick(main_root, itemView, getAdapterPosition(), true);
                    return true;
                }
            });
        }
    }

    class PaymentView extends RecyclerView.ViewHolder {
        private RecyclerView recyclerView;

        public PaymentView(@NonNull final View itemView) {
            super(itemView);
            recyclerView = itemView.findViewById(R.id.tagView);
        }
    }

    class MultiSelectionView extends RecyclerView.ViewHolder {
        private LinearLayout llRootRight, llMessageBgLeft;
        private ImageView ivMessageState;
        private ImageView userImage;

        private TextView tvUserName;
        private TextView tvMsg;
        private TextView tvTime;

        private RecyclerView recyclerView;

        public MultiSelectionView(@NonNull View itemView) {
            super(itemView);

            llRootRight = itemView.findViewById(R.id.root_right);
            llMessageBgLeft = itemView.findViewById(R.id.llMessageBgLeft);
            ivMessageState = itemView.findViewById(R.id.ivMessageState);
            userImage = itemView.findViewById(R.id.user_image);

            tvUserName = itemView.findViewById(R.id.tvUserName);
            tvMsg = itemView.findViewById(R.id.tvMsg);
            tvTime = itemView.findViewById(R.id.tvTime);

            recyclerView = itemView.findViewById(R.id.recyclerView);

        }
    }

    class OtherVideoMessageViewHolder extends RecyclerView.ViewHolder {

        private LinearLayoutCompat llRoot, llImageMessage;
        private RelativeLayout timelayout;
        private LinearLayout llDownload;
        private TextView tvUserName, tvFileSize;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatTextView tvImageTime, tvImgWithText;
        private ImageView ivPlay, ivDownload, messageSourceType, messageSourceType1, messageSourceType2;
        private FuguAgentProgressWheel progressBar;
        private ImageView userImage;

        public OtherVideoMessageViewHolder(final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            llRoot = itemView.findViewById(R.id.llRoot);
            llImageMessage = itemView.findViewById(R.id.llImageMessage);
            llDownload = itemView.findViewById(R.id.llDownload);

            timelayout = itemView.findViewById(R.id.timelayout);

            rlImageMessage = itemView.findViewById(R.id.rlImageMessage);
            tvUserName = itemView.findViewById(R.id.tvUserName);
            tvFileSize = itemView.findViewById(R.id.tvFileSize);

            ivImageMsg = itemView.findViewById(R.id.ivImageMsg);
            tvImageTime = itemView.findViewById(R.id.tvImageTime);
            tvImgWithText = itemView.findViewById(R.id.tvImgWithText);
            ivPlay = itemView.findViewById(R.id.ivPlay);
            ivDownload = itemView.findViewById(R.id.ivDownload);

            progressBar = itemView.findViewById(R.id.circle_progress);
            messageSourceType = itemView.findViewById(R.id.message_source_type);
            messageSourceType1 = itemView.findViewById(R.id.message_source_type1);
            messageSourceType2 = itemView.findViewById(R.id.message_source_type2);

            userImage = itemView.findViewById(R.id.user_image);
            tvUserName = itemView.findViewById(R.id.tvUserName);


            ivPlay.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.onItemClick(llRoot, itemView, getAdapterPosition());
                }
            });
        }
    }

    private void showImageDialog(Activity context, String imgUrl, ImageView imageView, Message message) {
        try {

            if (!Utils.preventMultipleClicks()) {
                return;
            }

            String thumbUrl = message.getThumbnailUrl();
            String fileUrl = message.getImageUrl();

            if (!message.getThumbnailUrl().isEmpty())
                thumbUrl = message.getThumbnailUrl();
            else if (!message.getImageUrl().isEmpty())
                thumbUrl = message.getImageUrl();
            else if (!message.getFileUrl().isEmpty())
                thumbUrl = message.getFileUrl();

            if (!message.getImageUrl().isEmpty())
                fileUrl = message.getImageUrl();
            else if (!message.getFileUrl().isEmpty())
                fileUrl = message.getFileUrl();


            Intent imageIntent = new Intent(context, ImageDisplayActivity.class);
            Image image = new Image(fileUrl, thumbUrl, message.getMuid(), message.getSentAtUtc(), "");
            imageIntent.putExtra("image", image);
            //context.startActivity(imageIntent);
            ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation(context, imageView, message.getMuid());
            context.startActivity(imageIntent, options.toBundle());
//                showImageDialog(mContext, message.image_url, (selfImageMessageViewHolder.ivImageMessage.drawable as BitmapDrawable).bitmap)
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean setVideoUiStatus(boolean isSelf, Message message, LinearLayout download, ImageView playBtn,
                                     AppCompatButton btnRetry, AppCompatButton btnCancel, FuguAgentProgressWheel progress, boolean isImageView) {

        if (isSelf) {

            download.setVisibility(View.GONE);
            playBtn.setVisibility(View.GONE);
            if (btnRetry != null)
                btnRetry.setVisibility(View.GONE);
            if (btnCancel != null)
                btnCancel.setVisibility(View.GONE);
            progress.setVisibility(View.GONE);

            if (message.getMessageStatus() == FuguAppConstant.MESSAGE_READ
                    || message.getMessageStatus() == FuguAppConstant.MESSAGE_DELIVERED
                    || message.getMessageStatus() == FuguAppConstant.MESSAGE_SENT) {
                //sent
                if (!isImageView) {
                    String fname = Utils.getFileName(message.getFileName(), message.getMuid());
                    final String localPath = FileManager.getInstance().getLocalPath(context, fname, FOLDER_TYPE.get(message.getDocumentType()));
                    if (TextUtils.isEmpty(localPath)) {
                        // show download
                        download.setVisibility(View.VISIBLE);
                        playBtn.setVisibility(View.GONE);

                    } else {
                        //show play button
                        playBtn.setVisibility(View.VISIBLE);
                        download.setVisibility(View.GONE);

                    }
                } else {
                    return true;
                }
            } else {
                //unsent
                if (message.getUploadStatus() == FuguAppConstant.UPLOAD_IN_PROGRESS) {
                    // show loader
                    progress.setVisibility(View.VISIBLE);

                    //message.setUploadStatus(FuguAppConstant.UPLOAD_FAILED);

                } else if (message.getIsMessageExpired() == 1) {
                    //retry
                    if (btnRetry != null)
                        btnRetry.setVisibility(View.VISIBLE);
                    if (btnCancel != null)
                        btnCancel.setVisibility(View.VISIBLE);
                }
            }
        } else {

        }
        return false;
    }


    private void setVideoDownloadStatus(final LinearLayout videoDownloadStatus, ImageView playBtn, TextView fileSize, final FuguAgentProgressWheel progressBar, final Message message, final int position) {
        String fname = Utils.getFileName(message.getFileName(), message.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(context, fname, FOLDER_TYPE.get(message.getDocumentType()));
        videoDownloadStatus.setVisibility(View.GONE);
        progressBar.setVisibility(View.GONE);
        playBtn.setVisibility(View.GONE);

        if (!TextUtils.isEmpty(localPath) &&
                (message.getMessageStatus() == FuguAppConstant.MESSAGE_READ
                        || message.getMessageStatus() == FuguAppConstant.MESSAGE_DELIVERED
                        || message.getMessageStatus() == FuguAppConstant.MESSAGE_SENT)) {
            playBtn.setVisibility(View.VISIBLE);
        } else {
            switch (message.getDownloadStatus()) {
                case 1:
                    progressBar.setVisibility(View.VISIBLE);
                    break;
                case 3:
                    playBtn.setVisibility(View.VISIBLE);
                    break;
                default:
                    videoDownloadStatus.setVisibility(View.VISIBLE);
                    fileSize.setText(message.getFileSize());
                    break;
            }
        }
    }

    private void setMessageStatus(ImageView ivMessageState, int messageStatus, Boolean isImage) {
        if (isImage) {
            switch (messageStatus) {
                case MESSAGE_SENT:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                    break;
                case MESSAGE_UNSENT:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting_white));
                    break;
                case MESSAGE_DELIVERED:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
                    break;
                case MESSAGE_READ:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
                    break;
                case MESSAGE_FILE_RETRY:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting_white));
                    break;
                case MESSAGE_IMAGE_RETRY:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting_white));
                    break;
                default:

                    break;
            }
        } else {
            switch (messageStatus) {
                case MESSAGE_SENT:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                    break;
                case MESSAGE_UNSENT:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                    break;
                case MESSAGE_DELIVERED:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
                    break;
                case MESSAGE_READ:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
                    break;
                case MESSAGE_FILE_RETRY:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                    break;
                case MESSAGE_IMAGE_RETRY:
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                    break;

                default:

                    break;
            }
        }
    }

    private void setImageHeightAndWidth(ImageView imageView, RelativeLayout rlImageMessage, LinearLayoutCompat llImageMessage, Message message, Boolean isSpiked) {
        int imageHeight = message.getImageHeight();
        int imageWidth = message.getImageWidth();
        if (imageHeight != 0 && message.getImageWidth() != 0) {
            float ratio = (float) (imageHeight / imageWidth);
            if (ratio < 1) {
                rlImageMessage.getLayoutParams().height = (int) (pxToDp(FuguAppConstant.MAX_HEIGHT) * ratio);
                rlImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH);
                if (isSpiked) {
                    llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER);
                } else {
                    llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER_SPIKED);
                }
            } else {
                rlImageMessage.getLayoutParams().height = pxToDp(FuguAppConstant.MAX_HEIGHT);
                rlImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH);
                if (isSpiked) {
                    llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER);
                } else {
                    llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER_SPIKED);
                }
            }
        } else {
            rlImageMessage.getLayoutParams().height = pxToDp(FuguAppConstant.MAX_HEIGHT);
            rlImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH);
            if (isSpiked) {
                llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER);
            } else {
                llImageMessage.getLayoutParams().width = pxToDp(FuguAppConstant.MAX_WIDTH_OUTER_SPIKED);
            }
        }
    }

    private void setTime(AppCompatTextView tvImageTime, String sentAtUtc) {
        tvImageTime.setText(DateUtils.getTime(DateUtils.getInstance().convertToLocal(sentAtUtc)));
    }

    private RequestOptions myOptions;

    private RequestOptions getRequestOption() {
        if (myOptions == null) {
            myOptions = RequestOptions
                    .bitmapTransform(new RoundedCornersTransformation(context, 7, 2))
                    .placeholder(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder))
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .error(ContextCompat.getDrawable(context, R.drawable.hippo_placeholder));
        }

        return myOptions;
    }

    private void setImage(Activity activity, AppCompatImageView ivImageMessage, String thumbnailUrl) {
        /*String fileExt = Utils.getExtension(thumbnailUrl);
        if(!TextUtils.isEmpty(fileExt) && fileExt.equalsIgnoreCase("gif")) {
            Glide
                    .with(activity)
                    .asGif()
                    .load(thumbnailUrl)
                    .error(R.drawable.hippo_placeholder)
                    .diskCacheStrategy(DiskCacheStrategy.DATA)
                    .into(ivImageMessage);
        } else {
            Glide.with(activity)
                    .asBitmap()
                    .load(thumbnailUrl)
                    .error(Glide.with(activity).asBitmap().load(thumbnailUrl))
                    .apply(getRequestOption())
                    .into(ivImageMessage);
        }*/

        try {
            Log.e(TAG, "thumbnailUrl = " + thumbnailUrl);
            Glide.with(activity).load(thumbnailUrl)
                    .apply(getRequestOption())
                    .into(ivImageMessage);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private boolean setSelfMessageBackground(View viewMessage, View viewBg, int position) {
        int oneDp = pxToDp(1);
        int sixDp = pxToDp(6);
        int sevenDp = pxToDp(7);

        if (items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_right);
            viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
            viewBg.setPadding(sixDp, sixDp, pxToDp(17), sixDp);
            return true;
        } else {
            if (position == 0) {
                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_right);
                viewMessage.setPadding(0, sixDp, pxToDp(7), sevenDp);
                viewBg.setPadding(sixDp, sixDp, pxToDp(17), sixDp);
                return true;
            } else if (getItemViewType(position - 1) == ITEM_TYPE_SELF
                    || getItemViewType(position - 1) == FUGU_VIDEO_CALL_VIEW
                    || getItemViewType(position - 1) == HIPPO_FILE_SENT_VIEW
                    || getItemViewType(position - 1) == HIPPO_VIDEO_MESSGAE_SELF) {
                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_right_normal);
                viewMessage.setPadding(0, oneDp, pxToDp(10), oneDp);
                viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
                return false;
            } else {
                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_right);
                viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
                viewBg.setPadding(sixDp, sixDp, pxToDp(17), sixDp);
                return true;
            }
        }
    }

    private void setFileMessageOtherNew(View viewMessage, View viewBg, int position,
                                        TextView userName, String name, RelativeLayout timelayout) {
        int oneDp = pxToDp(1);
        int sixDp = pxToDp(6);
        int sevenDp = pxToDp(7);
        int eightDp = pxToDp(8);
        if (items.size() == 1) {
//            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left);
//            viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
//            viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);

            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left_normal);
            if (userName != null) {
                userName.setVisibility(View.VISIBLE);
                userName.setText(name);
            } else if (TextUtils.isEmpty(name))
                userName.setVisibility(View.GONE);
        } else {
            if (position == 0) {
//                viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
//                viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);
//                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left);
                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left_normal);
                if (userName != null) {
                    userName.setVisibility(View.VISIBLE);
                    userName.setText(name);
                } else if (TextUtils.isEmpty(name))
                    userName.setVisibility(View.GONE);

            } else if (getItemViewType(position - 1) == ITEM_TYPE_OTHER
                    || getItemViewType(position - 1) == FUGU_OTHER_VIDEO_CALL_VIEW
                    || getItemViewType(position - 1) == HIPPO_VIDEO_MESSGAE_OTHER
                    || getItemViewType(position - 1) == HIPPO_FILE_RECEIVED_VIEW) {
                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left_normal);
//                viewMessage.setPadding(pxToDp(15), oneDp, 0, oneDp);
//                viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
                if (userName != null) {
                    userName.setVisibility(View.GONE);
                }

            } else {
//                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left);
//                viewMessage.setPadding(eightDp, oneDp, eightDp, sevenDp);
                //viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                    viewBg.setPaddingRelative(pxToDp(4), pxToDp(2), 0, oneDp);
                } else {
                    viewBg.setPadding(pxToDp(4), pxToDp(2), 0, oneDp);
                }

                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left_normal);

                if (userName != null) {
                    userName.setVisibility(View.VISIBLE);
                    userName.setText(name);
                } else if (TextUtils.isEmpty(name))
                    userName.setVisibility(View.GONE);


            }
        }
    }

    private boolean setFileMessageOther(View viewMessage, View viewBg, int position, TextView userName, String name) {
        if (userName != null && !TextUtils.isEmpty(name)) {
            userName.setVisibility(View.VISIBLE);
            userName.setText(name);
        } else if (userName != null)
            userName.setVisibility(View.GONE);


        /*int oneDp = pxToDp(1);
        int sixDp = pxToDp(6);
        int sevenDp = pxToDp(7);
        int eightDp = pxToDp(8);
        if (items.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left);
            NinePatchDrawable drawable6 = (NinePatchDrawable) viewBg.getBackground();
            drawable6.setColorFilter(fuguColorConfig.getFuguBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
            viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
            viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);
            if(userName != null && !TextUtils.isEmpty(name)) {
                userName.setVisibility(View.VISIBLE);
                userName.setText(name);
            } else if(userName != null)
                userName.setVisibility(View.GONE);
            return true;
        } else {
            if (position == 0) {
                viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
                viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);
                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left);
                NinePatchDrawable drawable6 = (NinePatchDrawable) viewBg.getBackground();
                drawable6.setColorFilter(fuguColorConfig.getFuguBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
                if(userName != null && !TextUtils.isEmpty(name)) {
                    userName.setVisibility(View.VISIBLE);
                    userName.setText(name);
                } else if(userName != null)
                    userName.setVisibility(View.GONE);
                return true;
            } else if (getItemViewType(position - 1) == ITEM_TYPE_OTHER
                    || getItemViewType(position - 1) == FUGU_OTHER_VIDEO_CALL_VIEW
                    || getItemViewType(position - 1) == HIPPO_VIDEO_MESSGAE_OTHER
                    || getItemViewType(position - 1) == HIPPO_FILE_RECEIVED_VIEW) {
                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left_normal);
                NinePatchDrawable drawable6 = (NinePatchDrawable) viewBg.getBackground();
                drawable6.setColorFilter(fuguColorConfig.getFuguBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
                viewMessage.setPadding(pxToDp(15), oneDp, 0, oneDp);
                viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
                if(userName != null) {
                    userName.setVisibility(View.GONE);
                }
                return true;
            } else {
                viewBg.setBackgroundResource(R.drawable.agent_chat_bg_left);
                NinePatchDrawable drawable6 = (NinePatchDrawable) viewBg.getBackground();
                drawable6.setColorFilter(fuguColorConfig.getFuguBgMessageFrom(), PorterDuff.Mode.MULTIPLY);

                viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
                viewBg.setPadding(pxToDp(13), sixDp, sixDp, sixDp);


                if(userName != null && !TextUtils.isEmpty(name)) {
                    userName.setVisibility(View.VISIBLE);
                    userName.setText(name);
                } else if(userName != null)
                    userName.setVisibility(View.GONE);

                return true;
            }
        }*/
        return true;
    }

    private void messageStatusTick(ImageView fuguIvMessageState, Message currentOrderItem2) {
        switch (currentOrderItem2.getMessageStatus()) {
            case MESSAGE_UNSENT:
            case MESSAGE_IMAGE_RETRY:
            case MESSAGE_FILE_RETRY:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_ic_waiting));
                fuguIvMessageState.setVisibility(View.VISIBLE);
//                fuguIvMessageState.getDrawable()
//                        .setColorFilter(fuguColorConfig.getFuguSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            case MESSAGE_READ:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
//                fuguIvMessageState.getDrawable()
//                        .setColorFilter(fuguColorConfig.getFuguMessageRead(), PorterDuff.Mode.SRC_ATOP);
                fuguIvMessageState.setVisibility(View.VISIBLE);
                break;
            case MESSAGE_SENT:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(View.VISIBLE);
//                fuguIvMessageState.getDrawable()
//                        .setColorFilter(fuguColorConfig.getFuguSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            case MESSAGE_DELIVERED:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.agent_icon_blue_tick));
                if (Build.VERSION.SDK_INT >= 21) {
                    fuguIvMessageState.getDrawable().setTint(ContextCompat.getColor(context, R.color.fugu_drawable_color));
                }
                fuguIvMessageState.setVisibility(View.VISIBLE);
//                fuguIvMessageState.getDrawable()
//                        .setColorFilter(fuguColorConfig.getFuguSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            default:
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable(context, R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(View.VISIBLE);
//                fuguIvMessageState.getDrawable()
//                        .setColorFilter(fuguColorConfig.getFuguSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);

                break;
        }
    }

    private void setUploadClick(AppCompatImageView ivFileUpload, FuguAgentProgressWheel circleProgress, Message message) {
        ivFileUpload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (((FuguChatActivity) context).isNetworkAvailable()) {
                    if (mOnRetry != null) {

                    }
                }
            }
        });
    }

    private void setFileCLickListener(LinearLayoutCompat llFile, final Message message, final AppCompatImageView ivFilePlay,
                                      final int position) {
        ivFilePlay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onPlaySound(message, ivFilePlay, position);
            }
        });

        llFile.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    if (message.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString())) {

                        return;
                    }
                    String fname = Utils.getFileName(message.getFileName(), message.getMuid());
                    String docType = message.getDocumentType();
                    if (!docType.equalsIgnoreCase("audio") &&
                            !docType.equalsIgnoreCase("video") &&
                            !docType.equalsIgnoreCase("file") &&
                            !docType.equalsIgnoreCase("image"))
                        docType = "file";
                    final String localPath = FileManager.getInstance().getLocalPath(context, fname, FOLDER_TYPE.get(docType));
                    if (!TextUtils.isEmpty(localPath)) {
                        FileManager.getInstance().openFileInDevice(context, localPath, new FileManager.FileCopyListener() {
                            @Override
                            public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {

                            }

                            @Override
                            public void largeFileSize() {

                            }

                            @Override
                            public void onError() {
                                Toast.makeText(context, context.getString(R.string.no_handler), Toast.LENGTH_LONG).show();
                            }
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setFileDownLoadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, FuguAgentProgressWheel circleProgress, AppCompatImageView ivFileDownload,
                                       AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {
        ivFileDownload.setVisibility(View.GONE);
        circleProgress.setVisibility(View.GONE);
        ivFileUpload.setVisibility(View.GONE);
        ivFilePlay.setVisibility(View.GONE);

        String fname = Utils.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(context, fname, FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        Log.v("localPath", "localPath ********* = " + localPath);
        if (!TextUtils.isEmpty(localPath)) {
            if (currentOrderItem2.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString()))
                ivFilePlay.setVisibility(View.VISIBLE);
        } else {
            switch (currentOrderItem2.getDownloadStatus()) {
                case 1:
                    circleProgress.setVisibility(View.VISIBLE);
                    break;
                case 3:
                    if (currentOrderItem2.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString()))
                        ivFilePlay.setVisibility(View.VISIBLE);
                    break;
                default:
                    ivFileDownload.setVisibility(View.VISIBLE);
                    break;
            }
        }

        ivFilePlay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    private void setFileUploadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, FuguAgentProgressWheel circleProgress, AppCompatImageView ivFileDownload,
                                     AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {

        ivFileDownload.setVisibility(View.GONE);
        circleProgress.setVisibility(View.GONE);
        ivFileUpload.setVisibility(View.GONE);
        ivFilePlay.setVisibility(View.GONE);
        if (currentOrderItem2.getIsMessageExpired() == 1) {
            ivFileUpload.setVisibility(View.VISIBLE);
        } else {
            if (currentOrderItem2.getMessageStatus() == FuguAppConstant.MESSAGE_UNSENT) {
                switch (currentOrderItem2.getUploadStatus()) {
                    case FuguAppConstant.UPLOAD_FAILED:
                        ivFileUpload.setVisibility(View.VISIBLE);
                        break;
                    case FuguAppConstant.UPLOAD_IN_PROGRESS:
                        circleProgress.setVisibility(View.VISIBLE);
                        break;
                    case FuguAppConstant.UPLOAD_COMPLETED:
                        if (currentOrderItem2.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString()))
                            ivFilePlay.setVisibility(View.VISIBLE);
                        break;
                    default:

                        break;
                }
            } else {
                String fname = Utils.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
                String docType = currentOrderItem2.getDocumentType();
                if (!docType.equalsIgnoreCase("audio") &&
                        !docType.equalsIgnoreCase("video") &&
                        !docType.equalsIgnoreCase("file") &&
                        !docType.equalsIgnoreCase("image"))
                    docType = "file";
                String localPath = FileManager.getInstance().getLocalPath(context, fname, FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
                Log.v("localPath", "localPath ********* = " + currentOrderItem2.getFileName());
                if (!TextUtils.isEmpty(localPath)) {
                    if (currentOrderItem2.getDocumentType().equalsIgnoreCase(DocumentType.AUDIO.toString()))
                        ivFilePlay.setVisibility(View.VISIBLE);
                } else {
                    ivFileDownload.setVisibility(View.VISIBLE);
                }
            }
        }

        ivFilePlay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    public void onPauseActivity() {
        try {
            if (!TextUtils.isEmpty(context.audioMuid)) {
                CommonMediaPlayer.getInstance().stopMedia();
                Message listItem = items.get(context.playingItem);
                listItem.setAudioPlaying(false);
            }
        } catch (Exception e) {

        }
    }

    private void onPlaySound(final Message currentOrderItem2, final AppCompatImageView ivFilePlay, final int position) {
        if (!TextUtils.isEmpty(context.audioMuid)) {
            if (context.audioMuid.equalsIgnoreCase(currentOrderItem2.getMuid())) {
                context.audioMuid = "";
                currentOrderItem2.setAudioPlaying(false);
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                CommonMediaPlayer.getInstance().stopMedia();
                notifyItemChanged(position);
                return;
            } else {
                Message listItem = items.get(context.playingItem);
                listItem.setAudioPlaying(false);
                notifyItemChanged(context.playingItem);

            }
            //return;
        }

        String fname = Utils.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(context, fname, FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        CommonMediaPlayer.getInstance().playMediaPlayer(context, localPath, new CommonMediaPlayer.MediaPlayerStatus() {
            @Override
            public void onPlaying() {
                currentOrderItem2.setAudioPlaying(true);
                context.audioMuid = currentOrderItem2.getMuid();
                context.playingItem = position;
                ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                currentOrderItem2.setAudioPlaying(true);
                notifyItemChanged(position);
            }

            @Override
            public void onCompletion(MediaPlayer mp) {
                context.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                notifyItemChanged(position);
            }

            @Override
            public void onError(MediaPlayer mp, int what, int extra) {
                context.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                notifyItemChanged(position);
            }
        });
    }


    private void setDownloadClick(final AppCompatImageView ivFileDownload, final FuguAgentProgressWheel circleProgress, final Message message, final int position) {
        if (!context.isNetworkAvailable()) {

            return;
        }
        ivFileDownload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (!context.checkPermission()) {
                    context.readExternalStorage();
                    return;
                }
                circleProgress.setVisibility(View.VISIBLE);

                ivFileDownload.setVisibility(View.GONE);

                String docType = "image";
                if (message.getOriginalMessageType() == FILE_MESSAGE) {
                    docType = message.getDocumentType();

                    if (FOLDER_TYPE.get(docType) == null) {
                        docType = "file";
                    }

                }

                String fileName = message.getFileName();

//                if (TextUtils.isEmpty(fileName)) {
//                    String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
//                    fileName = "Hippochat_" + timeStamp + ".jpg";
//                }

                String fullPath = Utils.getOrCreateDirectoryPath(context, FOLDER_TYPE.get(docType));
                int downloadId = downloadFileFromUrl(fullPath, fileName, message, position, message.getFileUrl());

                message.setDownloadId(downloadId);
            }
        });
    }


    int currentProgress = -1;

//    com.tonyodev.fetch2.Request request;
//    Fetch fetch;

//    private Extras getExtrasForRequest(com.tonyodev.fetch2.Request request) {
//        final MutableExtras extras = new MutableExtras();
//        extras.putBoolean("testBoolean", true);
//        extras.putString("testString", "test");
//        extras.putFloat("testFloat", Float.MIN_VALUE);
//        extras.putDouble("testDouble", Double.MIN_VALUE);
//        extras.putInt("testInt", Integer.MAX_VALUE);
//        extras.putLong("testLong", Long.MAX_VALUE);
//        return extras;
//    }


    private int downloadFileFromUrl(String dirPath, String fileName, final Message message, final int position, String fileUrl) {
//        if (!fileName.contains(message.getMuid())) {
//            String muid = message.getMuid();
//            String ext = Utils.getExtension(fileName);
//            String name = Utils.extractFileNameWithoutSuffix(fileName);
//            fileName = name + "_" + muid + "." + ext;
//        }
////        String fileUrl = message.getFileUrl();
//        currentProgress = -1;
//
//
//        request = new com.tonyodev.fetch2.Request(fileUrl, dirPath + File.separator + fileName);
//        request.setExtras(getExtrasForRequest(request));
//        FetchConfiguration config = new FetchConfiguration.Builder(context).preAllocateFileOnCreation(false).build();
//        fetch.Impl.setDefaultInstanceConfiguration(config);
//        fetch = Fetch.Impl.getDefaultInstance();
//
//        fetch.attachFetchObserversForDownload(request.getId(), new FetchObserver<Download>() {
//            @Override
//            public void onChanged(Download download, @NotNull Reason reason) {
//                if (request.getId() == download.getId()) {
//                    if (reason == Reason.DOWNLOAD_COMPLETED) {
//                        message.setDownloadStatus(DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
//                        Intent mIntent = getIntentExtraData(position, 100, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
//                        LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent);
//                        notifyItemChanged(position);
//                        return;
//                    } else if (reason == Reason.DOWNLOAD_ERROR) {
//                        message.setDownloadStatus(DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
//                        Intent mIntent = getIntentExtraData(position, 0, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
//                        LocalBroadcastManager.getInstance(context).sendBroadcast(mIntent);
//                        notifyItemChanged(position);
//                        return;
//                    } else {
//                        message.setCurrentprogress(download.getProgress());
//                        message.setDownloadStatus(DownloadStatus.DOWNLOAD_IN_PROGRESS.downloadStatus);
//                    }
//                }
//            }
//        }).enqueue(request, new Func<Request>() {
//            @Override
//            public void call(@NotNull com.tonyodev.fetch2.Request result) {
//                request = result;
//
//                android.util.Log.e(">>>", ">>>>>>>>>>>>");
//            }
//        }, new Func<com.tonyodev.fetch2.Error>() {
//            @Override
//            public void call(@NotNull com.tonyodev.fetch2.Error result) {
//                android.util.Log.e(">>>", ">>>>>>>>>>>>");
//
//            }
//        });


        return Utils.getUniqueId(message.getFileUrl(), Environment.DIRECTORY_DOWNLOADS, fileName);

    }

    private Intent getIntentExtraData(int position, int progress, String muid, int status) {
        Intent mIntent = new Intent(HIPPO_PROGRESS_INTENT);
        mIntent.putExtra(HIPPO_POSITION, position);
        mIntent.putExtra(HIPPO_PROGRESS, progress);
        mIntent.putExtra(MESSAGE_UNIQUE_ID, muid);
        mIntent.putExtra(HIPPO_STATUS_UPLOAD, status);
        return mIntent;
    }

    private void setTimeView(TextView tvMsg, RelativeLayout rlMessages, View time, int itemType, Message message, int position) {
        View vTime;
        if (itemType == ITEM_TYPE_OTHER) {
            vTime = time;
        } else {
            vTime = time;
        }
        int lineCount = 0;
        int difference = 0;
        lineCount = tvMsg.getLineCount();
        String stringInLastLine;
        if (lineCount != 0) {
            difference = tvMsg.getLayout().getLineStart(lineCount) - tvMsg.getLayout().getLineStart(lineCount - 1);
        }
        String completeString = tvMsg.getText().toString();
        boolean lineCountGreater = lineCount > 1;

        if (lineCountGreater) {
            stringInLastLine = completeString.substring(tvMsg.getText().toString().length() - difference, tvMsg.getText().toString().length());
        } else {
            stringInLastLine = tvMsg.getText().toString();
        }

        float emptySpaceLeft = rlMessages.getMeasuredWidth() - tvMsg.getPaint().measureText(stringInLastLine);
        RelativeLayout.LayoutParams layout = (RelativeLayout.LayoutParams) vTime.getLayoutParams();
        if (emptySpaceLeft > context.getResources().getDimensionPixelSize(R.dimen.height_ll_time)) {
            if (lineCountGreater) {
                layout.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                layout.addRule(RelativeLayout.RIGHT_OF, -1);
                message.setTimeIndex(2);
            } else {
                layout.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, 0);
                layout.addRule(RelativeLayout.RIGHT_OF, tvMsg.getId());
                message.setTimeIndex(3);
            }
            layout.addRule(RelativeLayout.BELOW, -1);
            layout.addRule(RelativeLayout.ALIGN_BOTTOM, tvMsg.getId());
        } else {
            if (!tvMsg.getText().toString().contains("/n")) {
                layout.addRule(RelativeLayout.ALIGN_BOTTOM, -1);
                layout.addRule(RelativeLayout.RIGHT_OF, -1);
                layout.addRule(RelativeLayout.BELOW, tvMsg.getId());
                layout.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                message.setTimeIndex(1);
            }
        }
        vTime.setLayoutParams(layout);
    }

    private void setAlpha() {
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                LoadingBox.hide();
                conversation.setIsTimeSet(1);
                if (((FuguChatActivity) context).getRvMessages().getAlpha() != 1) {
                    ((FuguChatActivity) context).getRvMessages().setAlpha(1);
                }
            }
        }, 150);
    }

    private float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * (metrics.densityDpi / 160f);
        return Math.round(px);
    }

    private String convertSeconds(int seconds) {
        int h = seconds / 3600;
        int m = (seconds % 3600) / 60;
        int s = seconds % 60;
        String sh = (h > 0 ? String.valueOf(h) + " " + "h" : "");
        String sm = (m < 10 && m > 0 && h > 0 ? "0" : "") + (m > 0 ? (h > 0 && s == 0 ? String.valueOf(m) : String.valueOf(m) + " " + "m") : "");
        String ss = (s == 0 && (h > 0 || m > 0) ? "" : (s < 10 && (h > 0 || m > 0) ? "0" : "") + String.valueOf(s) + " " + "s");
        return sh + (h > 0 ? " " : "") + sm + (m > 0 ? " " : "") + ss;
    }

    private String getMessage(Message videoMessage, int userType) {
        String message = "The video call ended";
        String agentType = "you";
        if (userType == FUGU_VIDEO_CALL_VIEW) {
//            if(videoMessage.getUserId().intValue() != HippoApplication.getInstance().getUserData().getUserId().intValue())
//                agentType = videoMessage.getfromName();
            if (videoMessage.getMessageState() != null && videoMessage.getMessageState().intValue() == 2) {
                if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = "Missed Call";//message = customerName + " missed a voice call with "+agentType;
                else
                    message = "Missed Call";//message = customerName + " missed a video call with "+agentType;
            } else {
                if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = "The voice call ended";
                else
                    message = "The video call ended";
            }
        } else {
//            agentType = "You";
//            if(!isChatAssignToMe)
//                agentType = agentName;

            if (videoMessage.getMessageState() != null && videoMessage.getMessageState().intValue() == 2) {
                if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = "Missed Call";//message = agentType+" missed a voice call with "+videoMessage.getfromName();
                else
                    message = "Missed Call";//message = agentType+" missed a video call with "+videoMessage.getfromName();
            } else {
                if (!TextUtils.isEmpty(videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString()))
                    message = "The voice call ended";
                else
                    message = "The video call ended";
            }
        }
        return message;
    }


    /**
     * Attach observers(broadcast) for progress updates
     *
     * @param attach boolean to set if observer has to be attacked or detached
     */
    public void attachObservers(Boolean attach) {
//        if (attach) {
//            attachObserver();
//        } else {
//            detachObserver();
//        }
    }

    boolean receiverRegistered;
    private BroadcastReceiver mProgressReceiver = null;

    /**
     * Detach observer (unregister broadcast)
     */
    private void detachObserver() {
        receiverRegistered = false;
        try {
            LocalBroadcastManager.getInstance(context).unregisterReceiver(mProgressReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * Attach observer (register broadcast)
     */
    private void attachObserver() {
        if (mProgressReceiver == null) {
            if (receiverRegistered)
                return;
            initializeReciever();
        }
        LocalBroadcastManager.getInstance(context).registerReceiver(mProgressReceiver,
                new IntentFilter(HIPPO_PROGRESS_INTENT));
        receiverRegistered = true;
    }

    /**
     * Initialize reciever to recieve broadcasts to update progress bar
     */
    private void initializeReciever() {
        mProgressReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context ctx, final Intent intent) {
                context.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {

                    }

                });
            }
        };

    }

    //check holder type and update progress accordingly
    public void checkHolderAndUpdateProgress(Message currentOrderItem, int position) {
        if (recyclerView.findViewHolderForAdapterPosition(position) instanceof ReceivedFileViewHolder) {
            setOtherHolderFileProgress(currentOrderItem, position);
        } else if (recyclerView.findViewHolderForAdapterPosition(position) instanceof SentFileViewHolder) {
            setSelfHolderFileProgress(currentOrderItem, position);
        } else if (recyclerView.findViewHolderForAdapterPosition(position) instanceof SelfVideoMessageViewHolder) {
            setSelfHolderVideoProgress(currentOrderItem, position);
        } else if (recyclerView.findViewHolderForAdapterPosition(position) instanceof OtherVideoMessageViewHolder) {
            setOtherHolderVideoProgress(currentOrderItem, position);
        } else if (recyclerView.findViewHolderForAdapterPosition(position) instanceof SelfMessageViewHolder) {
            setSelfMessageViewHolderProgress(currentOrderItem, position);
        }
    }

    private void setOtherHolderImageProgress(Message currentOrderItem, int position) {
    }

    private void setSelfHolderImageProgress(Message currentOrderItem, int position) {
    }

    private void setOtherHolderVideoProgress(Message currentOrderItem, int position) {
        OtherVideoMessageViewHolder otherImageMessageViewHolder = (OtherVideoMessageViewHolder) recyclerView.findViewHolderForAdapterPosition(position);
        otherImageMessageViewHolder.llDownload.setVisibility(View.GONE);

        notifyItemChanged(position);
    }

    private void setSelfMessageViewHolderProgress(Message currentOrderItem, int position) {
        SelfMessageViewHolder selfMessageViewHolder = (SelfMessageViewHolder) recyclerView.findViewHolderForAdapterPosition(position);
        selfMessageViewHolder.llimageDownload.setVisibility(View.GONE);
        selfMessageViewHolder.circleProgress.setVisibility(View.GONE);

        notifyItemChanged(position);
    }

    private void setSelfHolderVideoProgress(Message currentOrderItem, int position) {
        SelfVideoMessageViewHolder selfImageMessageViewHolder = (SelfVideoMessageViewHolder) recyclerView.findViewHolderForAdapterPosition(position);
        selfImageMessageViewHolder.circle_progress.setVisibility(View.VISIBLE);
        notifyItemChanged(position);
    }


    private void setMessageText(TextView textView, Message message) {
        textView.setText(message.getMessage());
        String msg = message.getMessage().replace(" ", "&nbsp;");
        if (message.getMessageState() == 5) {
            String editStr = Restring.getString(context, R.string.hippo_edited);
            msg = msg + " <font  color='grey'><small> (" + editStr + ")</small></font>";
        } else if (message.getMessageState() == 4) {
            String deletedStr = Restring.getString(context, R.string.hippo_message_deleted);
            String name = message.getfromName();
            msg = "<font  color='grey'><i>" + name + " " + deletedStr + " </i></font>";
        }
        textView.setText(Html.fromHtml(msg.replace("\n", "<br /> ")));
        textView.setVisibility(View.VISIBLE);
    }

    private void setOtherHolderFileProgress(Message currentOrderItem, int position) {
        ReceivedFileViewHolder otherFileMessageViewHolder = (ReceivedFileViewHolder) recyclerView.findViewHolderForAdapterPosition(position);
        otherFileMessageViewHolder.progressBar.setVisibility(View.VISIBLE);
        otherFileMessageViewHolder.ivFilePlay.setVisibility(View.GONE);
        notifyItemChanged(position);
    }

    private void setSelfHolderFileProgress(Message currentOrderItem, int position) {
        SentFileViewHolder selfFileMessageViewHolder = (SentFileViewHolder) recyclerView.findViewHolderForAdapterPosition(position);
        selfFileMessageViewHolder.circleProgress.setVisibility(View.VISIBLE);
        selfFileMessageViewHolder.ivFilePlay.setVisibility(View.GONE);
        notifyItemChanged(position);
    }

    private void setTextMessage(TextView tvMessage, String message) {
        String[] textArray = message.toString().split(" ");
        String text = "";
        for (String msg : textArray) {
            if (msg.toLowerCase().contains("http") || msg.toLowerCase().contains("www")) {
                text = text + " <a href=\"" + msg + "\">" + msg + "</a> ";
            } else {
                text = text + " " + msg;
            }
        }
        text = text.replace("Http", "http");
        text = text.replace("Https", "https");
        text = text.replace("WWW", "www");

        text = text.trim().replace("\n", "<br>");
        Spanned var14;
        Spannable var15;
        if (Build.VERSION.SDK_INT >= 24) {
            var14 = Html.fromHtml(text.toString(), 256);
            if (var14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.text.Spannable");
            }

            var15 = (Spannable) var14;
        } else {
            var14 = Html.fromHtml(text.toString());
            if (var14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.text.Spannable");
            }

            var15 = (Spannable) var14;
        }

        Spannable s = var15;
        URLSpan[] var9 = s.getSpans(0, s.length(), URLSpan.class);
        int var10 = var9.length;

        //Spannable s = new SpannableString(textView.getText());
        URLSpan[] spans = s.getSpans(0, s.length(), URLSpan.class);
        for (URLSpan span : spans) {
            int start = s.getSpanStart(span);
            int end = s.getSpanEnd(span);
            s.removeSpan(span);
            span = new URLSpanNoUnderline(span.getURL());
            s.setSpan(span, start, end, 0);
        }

        tvMessage.setLinkTextColor(context.getResources().getColor(R.color.color_tag));
        tvMessage.setText((CharSequence) s);
        //tvMessage.setMovementMethod(LinkMovementMethod.getInstance());
        tvMessage.setMovementMethod(BetterLinkMovementMethod.getInstance());
        SpannableString ss1 = new SpannableString((CharSequence) s);
        ss1.setSpan(new RelativeSizeSpan(1.0F), 0, s.length(), 0);
        tvMessage.setText((CharSequence) ss1);
        BetterLinkMovementMethod.linkifyHtmlNone(tvMessage).setOnLinkLongClickListener(this.urlClickListenerLong).setOnLinkClickListener(this.urlClickListener);

    }

    boolean onLinkLongClick = false;
    private BetterLinkMovementMethod.OnLinkLongClickListener urlClickListenerLong = new BetterLinkMovementMethod.OnLinkLongClickListener() {
        @Override
        public boolean onLongClick(TextView textView, String url) {
            if (url.toLowerCase().contains("http") || url.toLowerCase().contains("www")) {
                onLinkLongClick = true;
                ClipboardManager clipboard = (ClipboardManager) context.getSystemService(Context.CLIPBOARD_SERVICE);
                ClipData clip = ClipData.newPlainText("", url);
                clipboard.setPrimaryClip(clip);
                Toast.makeText(context, Restring.getString(context, R.string.hippo_copy_to_clipboard), Toast.LENGTH_SHORT).show();
            }
            return true;
        }
    };
    private BetterLinkMovementMethod.OnLinkClickListener urlClickListener = new BetterLinkMovementMethod.OnLinkClickListener() {
        @Override
        public boolean onClick(TextView textView, String url) {
            if (!onLongClick) {
                if (url.toLowerCase().contains("http") || url.toLowerCase().contains("www")) {
                    String clickableLink = url;
                    clickableLink = clickableLink.replace("<b>", "");
                    clickableLink = clickableLink.replace("<i>", "");
                    clickableLink = clickableLink.replace("</i>", "");
                    clickableLink = clickableLink.replace("</b>", "");
                    clickableLink = clickableLink.replace("</br>", "");
                    clickableLink = clickableLink.replace("<br>", "");
                    try {

                        if (clickableLink.startsWith("www")) {
                            clickableLink = "http://" + clickableLink;
                        }

                        Intent i = new Intent(Intent.ACTION_VIEW);
                        i.setData(Uri.parse(clickableLink));
                        context.startActivity(i);
                    } catch (Exception e) {

                    }
                }
            }
            return true;
        }
    };

    int dp1 = 0;
    int dp2 = 0;
    int dp4 = 0;
    int dp8 = 0;
    int dp30 = 0;
    String botImage = "";

    private String getBotImage() {
//        if(TextUtils.isEmpty(botImage)) {
//            botImage = CommonData.getUserDetails().getData().getBotImageUrl();
//        }
//        if(TextUtils.isEmpty(botImage))
//            botImage = "http://";
//        return botImage;
        return "";
    }

    private int dp1() {
        if (dp1 == 0) {
            dp1 = pxToDp(1);
        }
        return dp1;
    }

    private int dp2() {
        if (dp2 == 0) {
            dp2 = pxToDp(2);
        }
        return dp2;
    }

    private int dp4() {
        if (dp4 == 0) {
            dp4 = pxToDp(4);
        }
        return dp4;
    }

    private int dp8() {
        if (dp8 == 0) {
            dp8 = pxToDp(8);
        }
        return dp8;
    }

    private int dp30() {
        if (dp30 == 0) {
            dp30 = pxToDp(35);
        }
        return dp30;
    }

    public int getImage(String imageName, Context context) {

        int drawableResourceId = context.getResources().getIdentifier(imageName, "drawable", context.getPackageName());

        return drawableResourceId;
    }
}