package com.hippoagent.adapters;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;

import com.google.android.material.textfield.TextInputEditText;
import com.hippoagent.R;
import com.hippoagent.callback.OnItemOpertionListener;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.PaymentModelData;
import com.hippoagent.utils.DecimalDigitsInputFilter;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.Utils;

import java.util.ArrayList;

/**
 * Created by gurmail on 22/02/19.
 *
 * @author gurmail
 */
public class HippoPaymentAdapter extends RecyclerView.Adapter<HippoPaymentAdapter.ViewHolder> {

    private static final String TAG = HippoPaymentAdapter.class.getSimpleName();
    private ArrayList<PaymentModelData> arrayList = new ArrayList();
    private Context context;
    private OnItemOpertionListener onItemOpertionListener;
    private int planType;
    String[] country;

    public HippoPaymentAdapter(ArrayList<PaymentModelData> arrayList, OnItemOpertionListener onItemOpertionListener, int planType,
                               String[] country) {
        this.arrayList = arrayList;
        this.onItemOpertionListener = onItemOpertionListener;
        this.planType = planType;
        this.country = country;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        context = parent.getContext();
        return new ViewHolder(LayoutInflater.from(context).inflate(R.layout.hippo_item_payment, parent, false)
                , new MyFormEditTextListener(), new PriceEditTextListener(), new TitleEditTextListener());
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int position) {
        PaymentModelData paymentModelData = arrayList.get(position);
        viewHolder.titleView.setText(paymentModelData.getTitle());
        viewHolder.itemDescription.setText(paymentModelData.getItemDescription());
        //Utils.getMoneyDecimalFormat().format(paymentModelData.getPrice())
        viewHolder.itemPrice.setText(paymentModelData.getPrice());
        viewHolder.titleView.setHint(Restring.getString(context, R.string.hippo_enter_title));
        viewHolder.itemDescription.setHint(Restring.getString(context, R.string.hippo_item_description));
        viewHolder.itemPrice.setHint(Restring.getString(context, R.string.hippo_item_price));


//        String symbol = country[paymentModelData.getPosition()];
//        viewHolder.selectedCurrency.setText(symbol);

        if(planType == 1) {
            viewHolder.titleView.setEnabled(false);
            viewHolder.itemDescription.setEnabled(false);
            viewHolder.itemPrice.setEnabled(false);
            viewHolder.crossButton.setVisibility(View.GONE);
            viewHolder.spinner.setVisibility(View.GONE);
        } else {
            viewHolder.titleView.setEnabled(true);
            viewHolder.itemDescription.setEnabled(true);
            viewHolder.itemPrice.setEnabled(true);
            //viewHolder.crossButton.setVisibility(View.VISIBLE);
            if(arrayList.size() == 1) {
                viewHolder.crossButton.setVisibility(View.GONE);
            } else {
                viewHolder.crossButton.setVisibility(View.VISIBLE);
            }
        }

        ArrayAdapter aa = new ArrayAdapter(context, R.layout.spinner_row, country);
        aa.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        viewHolder.spinner.setAdapter(aa);

        String symbol = country[paymentModelData.getPosition()];
        viewHolder.spinner.setSelection(paymentModelData.getPosition(),true);  //must
        viewHolder.selectedCurrency.setText(symbol);

        if(!TextUtils.isEmpty(paymentModelData.getErrorTitle()) && TextUtils.isEmpty(paymentModelData.getTitle())) {
            viewHolder.titleView.requestFocus();
            viewHolder.titleView.setError(paymentModelData.getErrorTitle());
        } else {
            viewHolder.titleView.setError(null);
        }

        if(!TextUtils.isEmpty(paymentModelData.getErrorDesc()) && TextUtils.isEmpty(paymentModelData.getItemDescription())) {
            viewHolder.itemDescription.requestFocus();
            viewHolder.itemDescription.setError(paymentModelData.getErrorDesc());
        } else
            viewHolder.itemDescription.setError(null);

        if(!TextUtils.isEmpty(paymentModelData.getErrorPrice())) {
            viewHolder.itemPrice.requestFocus();
            viewHolder.itemPrice.setError(paymentModelData.getErrorPrice());
        } else
            viewHolder.itemPrice.setError(null);


    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public void updateEnabled(int planType) {
        this.planType = planType;
        notifyDataSetChanged();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private MyFormEditTextListener myCustomEditTextListener;
        private PriceEditTextListener priceEditTextListener;
        private TitleEditTextListener titleEditTextListener;
        private EditText itemPrice;
        private TextInputEditText titleView, itemDescription;
        private TextView priceTxt,descTxt, title_txt;
        private RelativeLayout crossButton;
        private ImageView crossView;
        private Spinner spinner;
        private TextView selectedCurrency;
        private boolean isSelected;

        public ViewHolder(@NonNull View itemView, MyFormEditTextListener myCustomEditTextListener,
                          PriceEditTextListener priceEditTextListener, TitleEditTextListener titleEditTextListener) {
            super(itemView);
            titleView = itemView.findViewById(R.id.titie_view);
            itemDescription = itemView.findViewById(R.id.item_description);
            itemPrice = itemView.findViewById(R.id.item_price);
            spinner = itemView.findViewById(R.id.spinner);
            selectedCurrency = itemView.findViewById(R.id.selectedCurrency);
            title_txt = itemView.findViewById(R.id.title_txt);
            descTxt = itemView.findViewById(R.id.descTxt);
            priceTxt = itemView.findViewById(R.id.priceTxt);

            itemPrice.setFilters(new InputFilter[] {new DecimalDigitsInputFilter(6,2)});

            title_txt.setText(Restring.getString(context, R.string.title));
            descTxt.setText(Restring.getString(context, R.string.hippo_title_item_description));
            priceTxt.setText(Restring.getString(context, R.string.hippo_title_item_price));


            this.titleEditTextListener = titleEditTextListener;
            this.myCustomEditTextListener = myCustomEditTextListener;
            this.priceEditTextListener = priceEditTextListener;

            crossButton = itemView.findViewById(R.id.cross_button);
            crossButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(onItemOpertionListener != null)
                        onItemOpertionListener.onItemRemoved(getAdapterPosition());
                }
            });

            selectedCurrency.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(planType != 1) {
                        isSelected = true;
                        spinner.performClick();
                    }
                }
            });

            spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                @Override
                public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                    if(isSelected) {
                        selectedCurrency.setText(country[position]);
                        arrayList.get(getAdapterPosition()).setPosition(position);
                    }
                }

                @Override
                public void onNothingSelected(AdapterView<?> parent) {
                    Log.e("onNothingSelected", "onNothingSelected");
                }
            });

            //crossView = itemView.findViewById(R.id.image_cross);
            //crossView.setColorFilter(new PorterDuffColorFilter(Color.parseColor("#000000"), PorterDuff.Mode.SRC_IN));

            titleView.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    arrayList.get(getAdapterPosition()).setTitle(titleView.getText().toString().trim());
                    if(!TextUtils.isEmpty(titleView.getText().toString()))
                        arrayList.get(getAdapterPosition()).setErrorTitle(null);
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });

            itemDescription.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    arrayList.get(getAdapterPosition()).setItemDescription(itemDescription.getText().toString().trim());
                    if(!TextUtils.isEmpty(itemDescription.getText().toString()))
                        arrayList.get(getAdapterPosition()).setErrorDesc(null);
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });

            itemPrice.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    arrayList.get(getAdapterPosition()).setPrice(itemPrice.getText().toString().trim());
                    if(!TextUtils.isEmpty(itemPrice.getText().toString().trim())) {
                        Double aDouble1 = null;
                        try {
                            aDouble1 = Double.parseDouble(itemPrice.getText().toString().trim());
                            arrayList.get(getAdapterPosition()).setErrorPrice(null);
                        } catch (NumberFormatException e) {

                        }
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {
                    if(onItemOpertionListener != null)
                        onItemOpertionListener.onItemAdded();
                }
            });


            itemDescription.setOnTouchListener(new View.OnTouchListener() {

                public boolean onTouch(View v, MotionEvent event) {
                    if (itemDescription.hasFocus()) {
                        v.getParent().requestDisallowInterceptTouchEvent(true);
                        switch (event.getAction() & MotionEvent.ACTION_MASK){
                            case MotionEvent.ACTION_SCROLL:
                                v.getParent().requestDisallowInterceptTouchEvent(false);
                                return true;
                        }
                    }
                    return false;
                }
            });
        }
    }

    public class MyFormEditTextListener implements TextWatcher {
        private int position;
        private boolean isEdittable;

        public void updatePosition(int position) {
            this.position = position;
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            // no op
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {

        }

        @Override
        public void afterTextChanged(Editable editable) {
            // no op
            if(!TextUtils.isEmpty(editable.toString()) && isEdittable)
                arrayList.get(position).setItemDescription(editable.toString());
            isEdittable = true;
        }
    }

    public class PriceEditTextListener implements TextWatcher {
        private int position;
        private boolean isEdittable;

        public void updatePosition(int position) {
            this.position = position;
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            // no op
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {

        }

        @Override
        public void afterTextChanged(Editable editable) {
            // no op
            if(!TextUtils.isEmpty(editable.toString()) && isEdittable)
                arrayList.get(position).setPrice(editable.toString());
            isEdittable = true;
        }
    }

    public class TitleEditTextListener implements TextWatcher {
        private int position;
        private boolean isEdittable;

        public void updatePosition(int position) {
            this.position = position;
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            // no op
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {

        }

        @Override
        public void afterTextChanged(Editable editable) {
            // no op
            if(!TextUtils.isEmpty(editable.toString()) && isEdittable)
                arrayList.get(position).setPrice(editable.toString());
            isEdittable = true;
        }
    }
}