package com.hippoagent.adapters;

import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import android.text.TextUtils;

import com.hippoagent.fragments.BasicInfoFragment;
import com.hippoagent.fragments.ChatOptionFragment;
import com.hippoagent.fragments.HistoryFragment;
import com.hippoagent.model.Conversation;
import com.hippoagent.model.TagData;
import com.hippoagent.utils.Constants;
import com.google.gson.Gson;

import java.util.ArrayList;

import static com.hippoagent.utils.Constants.TAGS_DATA;

/**
 * Created by harsh on 03/10/17.
 */

public class InfoPagerAdapter extends FragmentStatePagerAdapter {
    private Conversation conversation;
    private int pageCount;
    private ArrayList<TagData> tags;
    private String dealId;
    private Boolean hasBotRunning = false;
    private Boolean directOpen = false;
    private Boolean isMerchantChat = false;


    public InfoPagerAdapter(FragmentManager fm, Conversation conversation, int pageCount, ArrayList<TagData> tags,
                            String dealId, Boolean hasBotRunning, Boolean directOpen, Boolean isMerchantChat) {
        super(fm);
        this.pageCount = pageCount;
        this.conversation = conversation;
        this.tags = tags;
        this.dealId = dealId;
        this.hasBotRunning = hasBotRunning;
        this.directOpen = directOpen;
        this.isMerchantChat = isMerchantChat;
    }

    @Override
    public Fragment getItem(int position) {
        switch (position) {
            case 0:
                ChatOptionFragment basicInfoFragment = new ChatOptionFragment();
                Bundle basicInfo = new Bundle();
                basicInfo.putString(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                basicInfo.putBoolean("btnHistory", false);
                basicInfo.putBoolean("hasBotRunning", hasBotRunning);
                basicInfo.putBoolean("directOpen", directOpen);
                basicInfo.putBoolean("isMerchantChat", isMerchantChat);
                if(!TextUtils.isEmpty(dealId)) {
                    basicInfo.putString("deal_id", dealId);
                }
                if(tags != null)
                    basicInfo.putParcelableArrayList(TAGS_DATA, tags);
                if (conversation.getChatType())
                    basicInfo.putBoolean("iso2o", conversation.getChatType());


                basicInfoFragment.setArguments(basicInfo);
                return basicInfoFragment;
            case 1:
                HistoryFragment customDataFragment = new HistoryFragment();
                Bundle customInfo = new Bundle();
                customInfo.putString(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                customDataFragment.setArguments(customInfo);
                return customDataFragment;
            default:
                BasicInfoFragment basicInfoFragment1 = new BasicInfoFragment();
                Bundle basicInfo1 = new Bundle();
                basicInfo1.putString(Constants.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                if(!TextUtils.isEmpty(dealId))
                basicInfo1.putString("deal_id", dealId);
                if(pageCount == 2)
                    basicInfo1.putBoolean("btnHistory", true);
                if(tags != null)
                    basicInfo1.putParcelableArrayList(TAGS_DATA, tags);

                basicInfoFragment1.setArguments(basicInfo1);
                return basicInfoFragment1;
        }
    }

    @Override
    public int getCount() {
        return pageCount;
    }
}
