package com.hippoagent.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.hippoagent.R;
import com.hippoagent.model.attachmentData.AttachmentDataList;

import java.util.ArrayList;

public class MediaFileItemAdapter extends RecyclerView.Adapter {

    private final ItemListener mListener;
    Context mContext;
    ArrayList<AttachmentDataList> dataList = new ArrayList<>();


    public MediaFileItemAdapter(Context context, ArrayList<AttachmentDataList> values, ItemListener mListener) {

        mContext = context;
        dataList = values;
        this.mListener = mListener;
    }


    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {

        View view = LayoutInflater.from(mContext).inflate(R.layout.media_list_item, parent, false);

        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        MediaFileItemAdapter.ViewHolder viewholder = (MediaFileItemAdapter.ViewHolder) holder;

        RequestOptions options = new RequestOptions()
                .centerCrop()
                .placeholder(R.drawable.placeholder)
                .error(R.drawable.placeholder);

        if (dataList.get(position).getDocument_type() != null
                && !dataList.get(position).getDocument_type().isEmpty()
                && dataList.get(position).getDocument_type().contains("video")) {
            viewholder.videoRL.setVisibility(View.VISIBLE);
            Glide.with(mContext)
                    .load(dataList.get(position).getThumbnailUrl()).apply(options).into(viewholder.imageView);
        } else if (dataList.get(position).getDocument_type() != null
                && !dataList.get(position).getDocument_type().isEmpty()
                && !dataList.get(position).getDocument_type().contains("image")) {
            viewholder.imageView.setImageDrawable(ContextCompat.getDrawable(mContext, R.drawable.doc));
            viewholder.videoRL.setVisibility(View.GONE);

        } else {
            viewholder.videoRL.setVisibility(View.GONE);
            Glide.with(mContext)
                    .load(dataList.get(position).getThumbnailUrl()).apply(options).into(viewholder.imageView);
        }
        viewholder.llParent.setTag(position);
        viewholder.llParent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int pos = (int) v.getTag();
                if (mListener != null)
                    mListener.onItemClick(dataList.get(pos), v);
            }
        });
    }


    @Override
    public int getItemCount() {

        return dataList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {

        public ImageView imageView;
        public RelativeLayout llParent, videoRL;

        public ViewHolder(View v) {
            super(v);
            imageView = v.findViewById(R.id.imageView);
            llParent = v.findViewById(R.id.llParent);
            videoRL = v.findViewById(R.id.videoRL);

        }


    }


    public interface ItemListener {
        void onItemClick(AttachmentDataList item, View imageView);
    }


}