package com.hippoagent.adapters

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.hippoagent.HippoApplication
import com.hippoagent.R
import com.hippoagent.callback.OnPlanListener
import com.hippoagent.langs.Restring
import com.hippoagent.model.payment.PlanData
import com.hippoagent.utils.DateUtils
import kotlinx.android.synthetic.main.hippo_activity_payment.view.*
import kotlinx.android.synthetic.main.item_saved_plan.view.*

/**
 * Created by gurmail on 2019-12-05.
 * @author gurmail
 */
class SavedPlanAdapter constructor(var onPlanListener: OnPlanListener, var hideDelete: Boolean): androidx.recyclerview.widget.RecyclerView.Adapter<SavedPlanAdapter.ViewHolder>() {

    var context: Context? = null
    var arrayList: ArrayList<PlanData> = ArrayList()

    public fun setData(arrayList: ArrayList<PlanData>) {
        this.arrayList = arrayList
        notifyDataSetChanged()
    }

    override fun onCreateViewHolder(p0: ViewGroup, p1: Int): ViewHolder {
        context = p0.context
        return ViewHolder(LayoutInflater.from(p0.context).inflate(R.layout.item_saved_plan, p0, false))
    }

    override fun getItemCount(): Int {
        return arrayList.size
    }

    override fun onBindViewHolder(p0: ViewHolder, p1: Int) {
        p0.bind(arrayList[p1], onPlanListener, hideDelete)
    }

    class ViewHolder(itemView: View): androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(data: PlanData, onPlanListener: OnPlanListener, hideDelete: Boolean) = with(itemView) {
            planid.text =
                    Restring.getString(context, R.string.hippo_plan_id)
            planName.text = Restring.getString(context, R.string.hippo_plan_name)
            planType.text = Restring.getString(context, R.string.hippo_plan_type)
            updated.text = Restring.getString(context, R.string.hippo_updated_at)

            planidValue.text = "${data?.planId}"
            planNameValue.text = "${data?.planName}"

            delete.visibility = View.GONE
            viewOnly.visibility = View.GONE
            editPlan.visibility = View.GONE
            if(data?.type == 2) {
                planTypeValue.text = Restring.getString(context, R.string.hippo_business)
                viewOnly.visibility = View.VISIBLE
            } else {
                if(data?.userId == HippoApplication.getInstance().userData.userId) {
                    planTypeValue.text = Restring.getString(context, R.string.hippo_self)
                    if(!hideDelete) {
                        delete.visibility = View.VISIBLE
                        editPlan.visibility = View.VISIBLE
                    }
                } else {
                    planTypeValue.text = "${data?.fullName}"
                }
            }

            viewOnly.setOnClickListener {
                onPlanListener.onPlanViewOnly(adapterPosition, data)
            }
            editPlan.setOnClickListener {
                onPlanListener.onPlanEditView(adapterPosition, data)
            }


            val localDate = DateUtils.getInstance().convertToLocal(data?.updatedAt, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "MMM dd, yyyy, hh:mm aa")
            updatedValue.text = localDate
            relative.setOnClickListener {
                onPlanListener.onPlanClicked(adapterPosition, data)
            }

            delete.setOnClickListener {
                onPlanListener.onDeleteClicked(adapterPosition, data)
            }
        }
    }


}