package com.hippoagent.adapters

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.bumptech.glide.Glide
import com.bumptech.glide.Priority
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.load.resource.bitmap.CenterCrop
import com.bumptech.glide.load.resource.bitmap.RoundedCorners
import com.bumptech.glide.request.RequestOptions
import com.hippoagent.R
import com.hippoagent.callback.ImageAdpListener
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.model.onBoard.ImageObj
import com.hippoagent.utils.Utils
import kotlinx.android.synthetic.main.horizontal_scroll_image_item.view.*

/**
 * Created by gurmail on 2019-11-20.
 * @author gurmail
 */
class SignupImageAdapter constructor (val position: Int, var data: ArrayList<ImageObj>, var imageListener: ImageAdpListener): androidx.recyclerview.widget.RecyclerView.Adapter<SignupImageAdapter.ViewHolder>() {

    var context: Context? = null
    lateinit var options: RequestOptions

    override fun onCreateViewHolder(p0: ViewGroup, p1: Int): ViewHolder {
        context = p0.context
        return ViewHolder(LayoutInflater.from(context).inflate(R.layout.horizontal_scroll_image_item,
                p0, false), imageListener)
    }

    override fun getItemCount(): Int {
        return data.size
    }

    override fun onBindViewHolder(p0: ViewHolder, p1: Int) {
        p0.bind(position, data[p1])
    }

    override fun getItemId(position: Int): Long {
        return position.toLong()
    }

    class ViewHolder(itemView: View, var listener: ImageAdpListener) : androidx.recyclerview.widget.RecyclerView.ViewHolder(itemView) {
        fun bind(position: Int, imgData: ImageObj) = with(itemView) {
            if(TextUtils.isEmpty(imgData.url)) {
                addImage.visibility = View.VISIBLE
                imgFile.visibility = View.GONE
                llDeleteImage.visibility = View.GONE
            } else {
                addImage.visibility = View.GONE
                imgFile.visibility = View.VISIBLE
                llDeleteImage.visibility = View.VISIBLE

                val fileExt = Utils.getExtension(imgData.url)
                var dimage = FuguAppConstant.IMAGE_MAP[fileExt.toLowerCase()]
                if (dimage == null) {
                    dimage = R.drawable.hippo_placeholder
                }
                val options = RequestOptions()
                        .centerCrop()
                        .dontAnimate()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .placeholder(dimage)
                        .error(dimage)
                        .fitCenter()
                        .priority(Priority.HIGH)
                        .transforms(CenterCrop(), RoundedCorners(3))

                Glide.with(context).asBitmap()
                        .apply(options)
                        .load(imgData.url)
                        .into(imgSnapshot)
            }

            addImage.setOnClickListener {
                if(TextUtils.isEmpty(imgData.url)) {
                    listener.onItemAdded(position)
                }
            }

            llDeleteImage.setOnClickListener {
                if(!TextUtils.isEmpty(imgData.url)) {
                    listener.onItemDeleted(position, adapterPosition)
                }
            }

        }
    }
}