package com.hippoagent.adapters;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.google.gson.Gson;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.R;
import com.hippoagent.callback.OnPromotionalDialogButtonClick;
import com.hippoagent.database.CommonData;
import com.hippoagent.model.promotionalPopupData.Datum;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonResponse;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.RoundedCornersTransformation;
import com.hippoagent.utils.filePicker.Util;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

import java.util.ArrayList;
import java.util.HashMap;

import static com.hippoagent.utils.Constants.ACCESS_TOKEN;

public class ViewPagerAdapter extends PagerAdapter {

    private Activity activity;
    private ArrayList<Datum> mResources;
    private OnPromotionalDialogButtonClick onPromotionalDialogButtonClick;
    private static final Gson gson = new Gson();
    public ViewPagerAdapter(Activity activity, ArrayList<Datum> mResources, OnPromotionalDialogButtonClick onPromotionalDialogButtonClick) {
        this.activity = activity;
        this.mResources = mResources;
        this.onPromotionalDialogButtonClick = onPromotionalDialogButtonClick;
    }

    @Override
    public int getCount() {
        return mResources.size();
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == ((RelativeLayout) object);
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        View itemView = LayoutInflater.from(activity).inflate(R.layout.promotion_banner_view, container, false);
        Datum data = mResources.get(position);
        Button buttonTwoBT = (Button) itemView.findViewById(R.id.buttonTwoBT);
        Button buttonOneBT = (Button) itemView.findViewById(R.id.buttonOneBT);
        TextView descriptionTV = (TextView) itemView.findViewById(R.id.descriptionTV);
        TextView titleTV = (TextView) itemView.findViewById(R.id.titleTV);
        ImageView promoImageIV = (ImageView) itemView.findViewById(R.id.promoImageIV);


        titleTV.setText(data.getTitle());
        descriptionTV.setText(data.getDescription());
        buttonTwoBT.setVisibility(View.GONE);
        buttonOneBT.setVisibility(View.GONE);
        if (data.getCustomAttributes() != null && data.getCustomAttributes().getButtons() != null && data.getCustomAttributes().getButtons().size() > 0) {
            if (data.getCustomAttributes().getButtons().size() == 1) {
                buttonOneBT.setVisibility(View.VISIBLE);
                buttonTwoBT.setVisibility(View.GONE);
                buttonOneBT.setText(data.getCustomAttributes().getButtons().get(0).getLabel());
                buttonOneBT.setTextColor(Color.parseColor(data.getCustomAttributes().getButtons().get(0).getTextColor()));
                buttonOneBT.setBackgroundResource(R.drawable.hippo_rounded_corners);
                GradientDrawable drawable = (GradientDrawable) buttonOneBT.getBackground();
                drawable.setColor(Color.parseColor(data.getCustomAttributes().getButtons().get(0).getBackgroundColor()));
                //  buttonOneBT.setBackgroundColor(Color.parseColor(data.getCustomAttributes().getButtons().get(0).getBackgroundColor()));
                //    buttonOneBT.setBackgroundResource(R.drawable.hippo_rounded_corners);
            } else if (data.getCustomAttributes().getButtons().size() == 2) {

                buttonTwoBT.setText(data.getCustomAttributes().getButtons().get(1).getLabel());
                buttonTwoBT.setTextColor(Color.parseColor(data.getCustomAttributes().getButtons().get(1).getTextColor()));
                buttonTwoBT.setBackgroundColor(Color.parseColor(data.getCustomAttributes().getButtons().get(1).getBackgroundColor()));
                buttonOneBT.setText(data.getCustomAttributes().getButtons().get(0).getLabel());
                buttonOneBT.setTextColor(Color.parseColor(data.getCustomAttributes().getButtons().get(0).getTextColor()));
                buttonTwoBT.setBackgroundResource(R.drawable.hippo_rounded_corners);
                GradientDrawable drawable = (GradientDrawable) buttonTwoBT.getBackground();
                drawable.setColor(Color.parseColor(data.getCustomAttributes().getButtons().get(0).getBackgroundColor()));
                //   buttonOneBT.setBackgroundColor(Color.parseColor(data.getCustomAttributes().getButtons().get(0).getBackgroundColor()));

                buttonOneBT.setVisibility(View.VISIBLE);
                buttonTwoBT.setVisibility(View.VISIBLE);

            }
            buttonOneBT.setTag(position);
            buttonOneBT.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    int pos = (int) view.getTag();


                    sendButtonClicked(mResources.get(pos).getCustomAttributes().getButtons().get(0), mResources.get(pos).getChannelId().toString());

                }
            });
            buttonTwoBT.setTag(position);
            buttonTwoBT.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    int pos = (int) view.getTag();


                    sendButtonClicked(mResources.get(pos).getCustomAttributes().getButtons().get(1), mResources.get(pos).getChannelId().toString());
                }
            });


        } else {
            buttonTwoBT.setVisibility(View.GONE);
            buttonTwoBT.setVisibility(View.GONE);
        }
        if (data.getCustomAttributes().getImage() == null) {

        } else {
            if (data.getCustomAttributes().getImage().getImageUrl() != null && !data.getCustomAttributes().getImage().getImageUrl().isEmpty()) {
                promoImageIV.setVisibility(View.VISIBLE);
                String fileExt = Util.getExtension(data.getCustomAttributes().getImage().getImageUrl());
                Display display = activity.getWindowManager().getDefaultDisplay();

                int width = display.getWidth();
                int height = display.getHeight();
                LinearLayout.LayoutParams parms = new LinearLayout.LayoutParams(width, width);
                promoImageIV.setLayoutParams(parms);
                promoImageIV.setScaleX(0.93f);

                promoImageIV.requestLayout();

                RequestOptions myOptions = RequestOptions
                        .bitmapTransform(new RoundedCornersTransformation(activity, 10, 1))
                        .placeholder(ContextCompat.getDrawable(activity, R.drawable.hippo_placeholder))
                        .dontAnimate()
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .error(ContextCompat.getDrawable(activity, R.drawable.hippo_placeholder));

                boolean isGif = false;
                if (!TextUtils.isEmpty(fileExt) && fileExt.equalsIgnoreCase("gif"))
                    isGif = true;
                else if (!TextUtils.isEmpty(data.getCustomAttributes().getImage().getImageUrl()) && data.getCustomAttributes().getImage().getImageUrl().contains("giphy"))
                    isGif = true;

                if (isGif) {
//                    Glide.with(activity)
//                            .asGif()
//                            .load(data.getCustomAttributes().getImage().getImageUrl())
//                            .into(promoImageIV);
                    Glide.with(activity).load(data.getCustomAttributes().getImage().getImageUrl())
                            .thumbnail(Glide.with(activity).load(data.getCustomAttributes().getImage().getImageUrl()))
                            .fitCenter()
                            .into(promoImageIV);
                } else {
                    Glide.with(activity).load(data.getCustomAttributes().getImage().getImageUrl())
                            .fitCenter()
                            .apply(myOptions)
                            .transform(new CenterCrop(), new RoundedCorners(1))
                            .into(promoImageIV);
                }
            } else {
                promoImageIV.setVisibility(View.GONE);
            }
        }


        container.addView(itemView);

        return itemView;
    }


    private void sendButtonClicked(final com.hippoagent.model.promotionalPopupData.Button butonData, String channelID) {
        try {
            JSONArray open_links = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put("time", System.currentTimeMillis() + "");
            obj.put("link", butonData.getUrl());
            open_links.put(obj);


            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("channel_id", channelID);
            params.put("en_user_id", HippoApplication.getInstance().getUserData().getEnUserId());
            params.put("access_token", HippoApplication.getInstance().getUserData().getAccessToken());

            params.put("is_clicked", 1);

            if(butonData.getActionType() != 2){
                params.put("open_links", open_links);
            }

            RestClient.getApiInterface().advanceSpecApi(params).enqueue(new ResponseResolver<CommonResponse>() {
                @Override
                public void success(CommonResponse commonResponse) {


                }

                @Override
                public void failure(APIError error) {

                }
            });

            if (butonData.getActionType() == 2) {
                try {
                    if(butonData.getCallback_data()!=null){

                        JSONObject jsonObject = objectToJSONObject(butonData.getCallback_data());
                        if(jsonObject!=null)
                            if(isJSONValid(jsonObject.toString()) && jsonObject.length()>0){
                                if(onPromotionalDialogButtonClick != null)
                                    onPromotionalDialogButtonClick.OnButtonClick(jsonObject);
                            }

                    }

                } catch (Exception e) {
                    if (HippoConfig.DEBUG)
                        e.printStackTrace();
                }

            } else {
                if (butonData.getUrl().startsWith("http://") || butonData.getUrl().startsWith("https://")) {
                    try {

                        Intent myIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(butonData.getUrl()));
                        activity.startActivity(myIntent);
                    } catch (ActivityNotFoundException e) {
                        Toast.makeText(activity, "No application can handle this request."
                                + " Please install a webbrowser", Toast.LENGTH_LONG).show();
                        e.printStackTrace();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((RelativeLayout) object);
    }

    public static JSONObject objectToJSONObject(Object object) {
        Object json = null;
        JSONObject jsonObject = null;
        try {
            json = new JSONTokener(object.toString()).nextValue();
        } catch (Exception e) {
            if (HippoConfig.DEBUG)
                e.printStackTrace();
        }
        if (json instanceof JSONObject) {
            jsonObject = (JSONObject) json;
        }
        return jsonObject;
    }

    public static boolean isJSONValid(String jsonInString) {

        try {
            gson.fromJson(jsonInString, Object.class);
            return true;
        } catch(com.google.gson.JsonSyntaxException ex) {
            return false;
        }

}
}
