package com.hippoagent.adapters;

import android.content.Context;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.hippoagent.R;
import com.hippoagent.databinding.CustomAttributeBinding;
import com.hippoagent.langs.Restring;
import com.hippoagent.model.user_details.CustomAttributeList;

import java.util.ArrayList;

/**
 * Created by Gurmail S. Kang on 12/04/18.
 * @author gurmail
 */

public class VisitorInfoAdapter extends RecyclerView.Adapter<VisitorInfoAdapter.ViewHolder> {

    private ArrayList<CustomAttributeList> visitorInfo;
    private Context context;
    private boolean hasShowMore;

    public VisitorInfoAdapter(ArrayList<CustomAttributeList> visitorInfo, boolean hasShowMore) {
        this.visitorInfo = visitorInfo;
        this.hasShowMore = hasShowMore;
    }

    public void setData(ArrayList<CustomAttributeList> visitorInfo) {
        this.visitorInfo = visitorInfo;
        notifyDataSetChanged();
    }

    public void showData(boolean hasShowMore) {
        this.hasShowMore = hasShowMore;
//        notifyDataSetChanged();
        if(!hasShowMore)
            notifyItemRangeInserted(2, visitorInfo.size());
        else
            notifyItemRangeRemoved(2, visitorInfo.size());
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        context = parent.getContext();
        return new ViewHolder(LayoutInflater.from(context)
                .inflate(R.layout.custom_attribute, parent, false));
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        try {
            holder.binding.tvKeyView.setText(visitorInfo.get(position).getKey());
            String txt = Restring.getString(context, R.string.hippo_na);
            holder.binding.tvValueView.setText(TextUtils.isEmpty(visitorInfo.get(position).getValue()) ? txt : visitorInfo.get(position).getValue());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return visitorInfo == null ? 0 : hasShowMore ? 2 : visitorInfo.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private CustomAttributeBinding binding;
        public ViewHolder(View itemView) {
            super(itemView);
            binding = DataBindingUtil.bind(itemView);
        }
    }
}
