package com.hippoagent.apis;

import android.app.Activity;
import android.text.TextUtils;


import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.callback.NotificationListener;
import com.hippoagent.callback.OnClearNotificationListener;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.promotional.PromotionResponse;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.CommonParams;
import com.hippoagent.retrofit.CommonParamsObj;
import com.hippoagent.retrofit.CommonResponse;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;

import java.util.ArrayList;

/**
 * Created by gurmail on 2019-12-23.
 *
 * @author gurmail
 */
public class ApiGetMobileNotification {

    private Activity activity;
    private NotificationListener listener;
    private OnClearNotificationListener onClearNotificationListener;

    public ApiGetMobileNotification(Activity activity, NotificationListener listener) {
        this.activity = activity;
        this.listener = listener;
    }

    public ApiGetMobileNotification(Activity activity, OnClearNotificationListener onClearNotificationListener) {
        this.activity = activity;
        this.onClearNotificationListener = onClearNotificationListener;
    }

    public void getNotificationData(int startOffset, int endOffset) {

        if(TextUtils.isEmpty(HippoApplication.getInstance().getUserData().getAccessToken()) ||
                HippoApplication.getInstance().getUserData().getUserId() == null)
            return;

        CommonParamsObj params = new CommonParamsObj.Builder()
                .add(FuguAppConstant.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken())
                .add("user_id", HippoApplication.getInstance().getUserData().getUserId())
                .add("start_offset", startOffset)
                .add("end_offset", endOffset)
                .build();
        RestClient.getApiInterface().fetchMobilePush(params.getMap()).enqueue(new ResponseResolver<PromotionResponse>() {
            @Override
            public void success(PromotionResponse promotionResponse) {
                if(listener != null)
                    listener.onSucessListener(promotionResponse);
            }

            @Override
            public void failure(APIError error) {
                if(listener != null)
                    listener.onFailureListener();
            }
        });
    }


    public void clearNotification(long channelId, final int position) {
        CommonParamsObj.Builder builder = new CommonParamsObj.Builder();
        builder.add(FuguAppConstant.ACCESS_TOKEN, HippoApplication.getInstance().getUserData().getAccessToken());
        builder.add("user_id", HippoApplication.getInstance().getUserData().getUserId());
        if(channelId > 0) {
            ArrayList<Long> ids = new ArrayList<>();
            ids.add(channelId);
            builder.add("channel_ids", ids);
            builder.add("delete_all_announcements", 0);
        } else {
            builder.add("delete_all_announcements", 1);
        }

        CommonParamsObj params = builder.build();

        RestClient.getApiInterface().clearMobilePush(params.getMap()).enqueue(new ResponseResolver<CommonResponse>(activity, true, true) {
            @Override
            public void success(CommonResponse promotionResponse) {
                if(onClearNotificationListener != null)
                    onClearNotificationListener.onSucessListener(position);
            }

            @Override
            public void failure(APIError error) {
                if(onClearNotificationListener != null)
                    onClearNotificationListener.onFailure();
            }
        });
    }

}

