package com.hippoagent.apis

import android.app.Activity
import android.text.TextUtils
import com.hippoagent.HippoApplication
import com.hippoagent.callback.OnMessageUpdate
import com.hippoagent.database.CommonData
import com.hippoagent.database.UserCommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.retrofit.*
import com.hippoagent.utils.Constants.ACCESS_TOKEN

/**
 * Created by gurmail on 15/10/20.
 * @author gurmail
 */

object MessageUpdate {

    fun updateMessage(activity: Activity, channelId: Int, messageMuid: String, taskStatus: Int, updatedMessage: String, listener: OnMessageUpdate) {
        val params: CommonParams.Builder = CommonParams.Builder()
        params.add("access_token", HippoApplication.getInstance().userData.accessToken)
        params.add("en_user_id", HippoApplication.getInstance().userData.enUserId)
        params.add("channel_id", channelId)
        params.add("message_muid", messageMuid)
        params.add("task_status", taskStatus)
        if(!TextUtils.isEmpty(updatedMessage)) {
            params.add("new_message", updatedMessage)
        }
        params.add("device_details", CommonData.deviceDetails(activity))
        val paramMap = params.build()

        RestClient.getApiInterface().deleteOrEditMessage(paramMap.map).enqueue(object: ResponseResolver<CommonResponse>(activity, true, true) {
            override fun success(t: CommonResponse?) {
                listener.onUpdateListener()
            }

            override fun failure(error: APIError?) {
                listener.onUpdatefailed()
            }
        })
    }

    fun userUpdateMessage(activity: Activity, channelId: Long, messageMuid: String, taskStatus: Int, updatedMessage: String, listener: OnMessageUpdate) {
        val params: CommonParams.Builder = CommonParams.Builder()
        params.add(ACCESS_TOKEN, HippoApplication.getInstance()?.userData?.accessToken)
        params.add("en_user_id", UserCommonData.getUserDetails().data.en_user_id)
        params.add("channel_id", channelId)
        params.add("message_muid", messageMuid)
        params.add("task_status", taskStatus)
        if(!TextUtils.isEmpty(updatedMessage)) {
            params.add("new_message", updatedMessage)
        }
        params.add("device_details", CommonData.deviceDetails(activity))
        val paramMap = params.build()

        RestClient.getApiInterface().deleteOrEditMessage(paramMap.map).enqueue(object: ResponseResolver<CommonResponse>(activity, true, true) {
            override fun success(t: CommonResponse?) {
                listener.onUpdateListener()
            }

            override fun failure(error: APIError?) {
                listener.onUpdatefailed()
            }
        })
    }
}