package com.hippoagent.apis

import android.app.Activity
import android.content.Context
import com.hippoagent.HippoApplication
import com.hippoagent.SessionAttributes
import com.hippoagent.callback.OnStartSessionListener
import com.hippoagent.model.groupCall.GroupCallResponse
import com.hippoagent.retrofit.*
import com.hippoagent.utils.Constants
import java.util.*

/**
 * Created by gurmail on 2020-07-13.
 * @author gurmail
 */
object SessionHandler {

    fun createSession(context: Activity, attributes: SessionAttributes) {
        val params = HashMap<String, Any>()
        params[Constants.ACCESS_TOKEN] = HippoApplication.getInstance().userData.accessToken.toString()
        params["agent_email"] = HippoApplication.getInstance().userData.email
        params["user_id"] = HippoApplication.getInstance().userData.userId
        params["en_user_id"] = HippoApplication.getInstance().userData.enUserId
        params["message"] = attributes.message
        params["user_unique_ids"] = attributes.userUniqueKeys
        params["room_title"] = attributes.sessionTitle
        params["session_end_time"] = attributes.sessionEndTime
        params["session_start_time"] = attributes.sessionStartTime
        params["transaction_id"] = attributes.transactionId

        val paramsObj = CommonParamsObj.Builder()
                .addAll(params)
                .build()

        RestClient.getApiInterface().createSession(paramsObj.map).enqueue(object: ResponseResolver<CommonResponse>(context, true, true) {
            override fun success(t: CommonResponse?) {

            }

            override fun failure(error: APIError?) {

            }

        })
    }

    fun startSession(activity: Activity, transactionId: String, callType: Int, listener: OnStartSessionListener) {
        val params = HashMap<String, Any>()
        params[Constants.ACCESS_TOKEN] = HippoApplication.getInstance().userData.accessToken.toString()
        params["agent_email"] = HippoApplication.getInstance().userData.email
        params["user_id"] = HippoApplication.getInstance().userData.userId
        params["en_user_id"] = HippoApplication.getInstance().userData.enUserId
        params["transaction_id"] = transactionId
//        if(callType == 2) {
//            params["call_type"] = "AUDIO"
//        } else {
//            params["call_type"] = "VIDEO"
//        }

        val paramsObj = CommonParamsObj.Builder()
                .addAll(params)
                .build()

        RestClient.getApiInterface().groupCallChannelDetails(paramsObj.map).enqueue(object: ResponseResolver<GroupCallResponse>() {
            override fun success(t: GroupCallResponse?) {
                listener?.onStartListener(t!!)
            }
            override fun failure(error: APIError?) {
                listener?.onErrorListener(error?.message!!)
            }
        })
    }
}