package com.hippoagent.confcall

import android.app.*
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.graphics.BitmapFactory
import android.media.AudioAttributes
import android.media.MediaPlayer
import android.os.*
import android.widget.RemoteViews
import androidx.annotation.DrawableRes
import androidx.annotation.StringRes
import androidx.core.app.NotificationCompat
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.hippoagent.BuildConfig
import com.hippoagent.HippoApplication
import com.hippoagent.HippoConfig
import com.hippoagent.R
import com.hippoagent.confcall.OngoingCallService.NotificationServiceState.channelId
import com.hippoagent.confcall.OngoingCallService.NotificationServiceState.inviteLink
import com.hippoagent.confcall.OngoingCallService.NotificationServiceState.isConferenceConnected
import com.hippoagent.confcall.OngoingCallService.NotificationServiceState.isConferenceServiceRunning
import com.hippoagent.database.CommonData
import com.hippoagent.datastructure.FuguAppConstant
import com.hippoagent.datastructure.FuguAppConstant.CHANNEL_ID
import com.hippoagent.datastructure.FuguAppConstant.INCOMING_VIDEO_CONFERENCE
import com.hippoagent.hippocall.HippoCallConfig
import com.hippoagent.hippocall.MainCallingActivity
import com.hippoagent.hippocall.VideoCallModel
import com.hippoagent.hippocall.WebRTCCallConstants
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.CALL_TYPE
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.DEVICE_PAYLOAD
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.FULL_NAME
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.INVITE_LINK
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.IS_SILENT
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.MESSAGE_TYPE
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.MESSAGE_UNIQUE_ID
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.USER_ID
import com.hippoagent.hippocall.WebRTCCallConstants.Companion.USER_THUMBNAIL_IMAGE
import com.hippoagent.langs.Restring
import com.hippoagent.utils.Log
import com.hippoagent.utils.UniqueIMEIID
import org.json.JSONObject

class OngoingCallService : Service(), WebRTCCallConstants {
    private var mBinder: IBinder = LocalBinder()
    override fun onBind(intent: Intent?): IBinder? {
        return mBinder
    }

    object NotificationServiceState {
        var isConferenceServiceRunning = false
        var isConferenceConnected = false
        var inviteLink = ""
        var channelId = -1L
        var muid = ""
        var transactionId = ""
        var authObj = ""

    }

    object CallState {
        var muid = ""
        var readyToConnect = 0
    }

    inner class LocalBinder : Binder() {
        val serverInstance: OngoingCallService
            get() = this@OngoingCallService
    }

    override fun onCreate() {
        super.onCreate()

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            var notificationChannel = NotificationChannel("IncomingCall", "IncomingCall", NotificationManager.IMPORTANCE_HIGH)
            notificationChannel.setSound(null, null)
            notificationManager.createNotificationChannel(notificationChannel)
        }

        LocalBroadcastManager.getInstance(this@OngoingCallService).registerReceiver(mCallTerminated, IntentFilter("CALL TERMINATED"))
        LocalBroadcastManager.getInstance(this@OngoingCallService).registerReceiver(mInternetIssue, IntentFilter("INTERNET_ISSUE"))

    }


    private val mInternetIssue = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            var mediaPlayer: MediaPlayer? = null
            var aa = AudioAttributes.Builder()
                    .setUsage(AudioAttributes.USAGE_VOICE_COMMUNICATION)
                    .setContentType(AudioAttributes.CONTENT_TYPE_SPEECH)
                    .build()
            mediaPlayer = MediaPlayer.create(this@OngoingCallService, R.raw.busy_tone)
            mediaPlayer?.setLooping(true)
            mediaPlayer?.start()

            Handler(Looper.getMainLooper()).postDelayed({
                mediaPlayer?.stop()
            }, 3000)

        }
    }

    private val mCallTerminated = object : BroadcastReceiver() {
        override fun onReceive(context: Context?, intent: Intent?) {
            Log.e("CALL_TERMINATED", "CALL_TERMINATED")


            val startCallJson = JSONObject()
            startCallJson.put(IS_SILENT, true)
            startCallJson.put(WebRTCCallConstants.VIDEO_CALL_TYPE, WebRTCCallConstants.Companion.JitsiCallType.HUNGUP_CONFERENCE.toString())
            startCallJson.put(USER_ID, HippoApplication.getInstance().userData.userId)
            startCallJson.put(CHANNEL_ID, channelId)
            startCallJson.put(MESSAGE_TYPE, WebRTCCallConstants.VIDEO_CALL)
            startCallJson.put(CALL_TYPE, "VIDEO")
            startCallJson.put(DEVICE_PAYLOAD, getDeviceDetails())
            startCallJson.put(INVITE_LINK, inviteLink)
            startCallJson.put(MESSAGE_UNIQUE_ID,NotificationServiceState.muid)
            startCallJson.put(WebRTCCallConstants.FULL_NAME, HippoApplication.getInstance().userData.fullName)
            startCallJson.put("message", "")
            startCallJson.put("is_typing", FuguAppConstant.TYPING_SHOW_MESSAGE)
            startCallJson.put("auth0", NotificationServiceState.authObj)

            HippoCallConfig.getInstance().sendMessage(channelId, startCallJson)


            isConferenceServiceRunning = false
            isConferenceConnected = false
            stopSelf()
        }
    }


    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        isConferenceServiceRunning = true
        if (intent?.hasExtra(INCOMING_VIDEO_CONFERENCE)!!) {
            createIncomingCallNotification(intent)
//            createNewIncomingCallNotification(intent)
        } else {
            createOngoingCallNotification(intent)
        }

        return START_STICKY
    }

    val CALLS = "calls_v3"
    private val WEBRTC_NOTIFICATION_RINGING = 313389
    private fun createNewIncomingCallNotification(intent: Intent) {
//        val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
//            var notificationChannel = NotificationChannel("IncomingCall",
//                    "IncomingCall", NotificationManager.IMPORTANCE_HIGH)
//            notificationChannel.setSound(null, null)
//            notificationManager.createNotificationChannel(notificationChannel)
//        }

        try {
//            val contentIntent = Intent(this, MainCallingActivity::class.java)
//            contentIntent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP)

            val notificationIntent = Intent(this, MainCallingActivity::class.java)
            notificationIntent.flags = Intent.FLAG_ACTIVITY_SINGLE_TOP
            notificationIntent.putExtra("room_name", intent?.getStringExtra("room_name"))
            inviteLink = intent?.getStringExtra(INVITE_LINK).toString()
            channelId = intent?.getLongExtra(CHANNEL_ID, -1L)

            try {
                notificationIntent.putExtra("incomming_call", "incomming_call")
                val videoCallModel = intent.extras?.getParcelable<VideoCallModel>("videoCallModel")!! as VideoCallModel

                notificationIntent.putExtra("videoCallModel", videoCallModel)
            } catch (e: Exception) {
            }

            notificationIntent.putExtra(INVITE_LINK, inviteLink)
            notificationIntent.putExtra(CHANNEL_ID, channelId)
            notificationIntent.putExtra(FULL_NAME, intent.getStringExtra(FULL_NAME))
            notificationIntent.putExtra(USER_THUMBNAIL_IMAGE, intent.getStringExtra(USER_THUMBNAIL_IMAGE))
            notificationIntent.putExtra(CALL_TYPE, intent.getStringExtra(CALL_TYPE))
            notificationIntent.putExtra(MESSAGE_UNIQUE_ID, intent.getStringExtra(MESSAGE_UNIQUE_ID))
            notificationIntent.action = Intent.ACTION_MAIN
            notificationIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP)
            notificationIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)


            val pendingIntent = PendingIntent.getActivity(this, 0, notificationIntent, PendingIntent.FLAG_IMMUTABLE)

            val builder = NotificationCompat.Builder(this, "IncomingCall")
                    .setSmallIcon(R.mipmap.hippo_notif)
                    .setContentIntent(pendingIntent)
                    .setOngoing(true)
                    .setContentTitle(getString(R.string.app_name))


            builder.setContentText(Restring.getString(this, R.string.hippo_call_incoming))
            builder.addAction(getServiceNotificationAction(this, intent, R.drawable.ic_close, R.string.hippo_call_hungup))
            builder.addAction(getActivityNotificationAction(this, intent, R.drawable.ic_close, R.string.done))

            if (callActivityRestricted(this)) {
                builder.setFullScreenIntent(pendingIntent, true)
                builder.priority = NotificationCompat.PRIORITY_HIGH
                builder.setCategory(NotificationCompat.CATEGORY_CALL)
            }

            startForeground(WEBRTC_NOTIFICATION_RINGING, builder.build())
        } catch (e: Exception) {
            e.printStackTrace()
        }

//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
//            val calls = NotificationChannel(CALLS, "IncomingCall", NotificationManager.IMPORTANCE_HIGH)
//            calls.setSound(null, null)
//        }


        val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            var notificationChannel = NotificationChannel("IncomingCall",
                    "IncomingCall", NotificationManager.IMPORTANCE_HIGH)
            notificationChannel.setSound(null, null)
            notificationManager.createNotificationChannel(notificationChannel)
        }

        //return builder.build()
    }

    private fun getServiceNotificationAction(context: Context, intent: Intent, iconResId: Int, titleResId: Int): NotificationCompat.Action {
//        val intent = Intent(context, HungUpBroadcast::class.java)
//        intent.action = action

        val hungupIntent = Intent(this, HungUpBroadcast::class.java)
        hungupIntent.putExtra("action", "rejectCall")
        hungupIntent.putExtra(INVITE_LINK, inviteLink)
        hungupIntent.putExtra(CHANNEL_ID, channelId)
        hungupIntent.putExtra(MESSAGE_UNIQUE_ID, intent.getStringExtra(MESSAGE_UNIQUE_ID))
        hungupIntent.putExtra(DEVICE_PAYLOAD, getDeviceDetails().toString())

        val pendingIntent = PendingIntent.getService(context, 0, hungupIntent, PendingIntent.FLAG_IMMUTABLE)

        return NotificationCompat.Action(iconResId, context.getString(titleResId), pendingIntent)
    }

    private fun getActivityNotificationAction(context: Context, intent: Intent,
                                              @DrawableRes iconResId: Int, @StringRes titleResId: Int): NotificationCompat.Action {
        val answerIntent = Intent(this, MainCallingActivity::class.java)
        answerIntent.action = Intent.ACTION_ANSWER
        answerIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP)
        answerIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)
        answerIntent.putExtra("room_name", intent?.getStringExtra("room_name"))
        answerIntent.putExtra("call_type", intent?.getStringExtra("call_type"))
        answerIntent.putExtra(MESSAGE_UNIQUE_ID, intent.getStringExtra(MESSAGE_UNIQUE_ID))
        answerIntent.putExtra("answer_call", "answer_call")
        answerIntent.putExtra(INVITE_LINK, inviteLink)
        answerIntent.putExtra(CHANNEL_ID, channelId)

        try {
            val videoCallModel = intent.extras?.getParcelable<VideoCallModel>("videoCallModel")!! as VideoCallModel
            answerIntent.putExtra("videoCallModel", videoCallModel)
        } catch (e: Exception) {
        }

        val pendingIntent = PendingIntent.getActivity(context, 0, answerIntent, PendingIntent.FLAG_IMMUTABLE)

        return NotificationCompat.Action(iconResId, context.getString(titleResId), pendingIntent)
    }

    private fun callActivityRestricted(context: Context): Boolean {
        return Build.VERSION.SDK_INT >= 29 && !HippoCallConfig.getInstance().isAppVisible()
    }

    private fun createIncomingCallNotification(intent: Intent) {
        val notificationIntent = Intent(this, MainCallingActivity::class.java)
        //notificationIntent.flags = Intent.FLAG_ACTIVITY_SINGLE_TOP
        val customView = RemoteViews(packageName, R.layout.cutom_call_notification)
        customView.setTextViewText(R.id.name, getString(R.string.app_name))
        customView.setTextViewText(R.id.btnDecline, Restring.getString(this, R.string.hippo_reject))
        customView.setTextViewText(R.id.btnAnswer, Restring.getString(this, R.string.hippo_answer))
        notificationIntent.putExtra("room_name", intent?.getStringExtra("room_name"))
        inviteLink = intent?.getStringExtra(INVITE_LINK).toString()
        channelId = intent?.getLongExtra(CHANNEL_ID, -1L)

        try {
            notificationIntent.putExtra("incomming_call", "incomming_call")
            val videoCallModel = intent.extras?.getParcelable<VideoCallModel>("videoCallModel")!! as VideoCallModel
            notificationIntent.putExtra("videoCallModel", videoCallModel)
        } catch (e: Exception) {
        }

        notificationIntent.putExtra(INVITE_LINK, inviteLink)
        notificationIntent.putExtra(CHANNEL_ID, channelId)
        notificationIntent.putExtra(FULL_NAME, intent.getStringExtra(FULL_NAME))
        notificationIntent.putExtra(USER_THUMBNAIL_IMAGE, intent.getStringExtra(USER_THUMBNAIL_IMAGE))
        notificationIntent.putExtra(CALL_TYPE, intent.getStringExtra(CALL_TYPE))
        notificationIntent.putExtra(MESSAGE_UNIQUE_ID, intent.getStringExtra(MESSAGE_UNIQUE_ID))
        notificationIntent.action = Intent.ACTION_MAIN
        notificationIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP)
        notificationIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)

        val hungupIntent = Intent(this, HungUpBroadcast::class.java)
        hungupIntent.putExtra("action", "rejectCall")
        hungupIntent.putExtra(INVITE_LINK, inviteLink)
        hungupIntent.putExtra(CHANNEL_ID, channelId)
        hungupIntent.putExtra(MESSAGE_UNIQUE_ID, intent.getStringExtra(MESSAGE_UNIQUE_ID))
        hungupIntent.putExtra(DEVICE_PAYLOAD, getDeviceDetails().toString())
        hungupIntent.putExtra("auth0", intent.getStringExtra("auth0"))

        val answerIntent = Intent(this, MainCallingActivity::class.java)
        answerIntent.action = Intent.ACTION_ANSWER
        answerIntent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP or Intent.FLAG_ACTIVITY_CLEAR_TOP)
        answerIntent.addFlags(Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS)
        answerIntent.putExtra("room_name", intent?.getStringExtra("room_name"))
        answerIntent.putExtra("call_type", intent?.getStringExtra("call_type"))
        answerIntent.putExtra(MESSAGE_UNIQUE_ID, intent.getStringExtra(MESSAGE_UNIQUE_ID))
        answerIntent.putExtra("answer_call", "answer_call")
        answerIntent.putExtra(INVITE_LINK, inviteLink)
        answerIntent.putExtra(CHANNEL_ID, channelId)

        try {
            val videoCallModel = intent.extras?.getParcelable<VideoCallModel>("videoCallModel")!! as VideoCallModel
            answerIntent.putExtra("videoCallModel", videoCallModel)
        } catch (e: Exception) {
        }

        val pendingIntent = PendingIntent.getActivity(this, 0,
                notificationIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)

        val hungupPendingIntent = PendingIntent.getBroadcast(this, 0,
                hungupIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)

        val answerPendingIntent = PendingIntent.getActivity(this, 0,
                answerIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)

        customView.setTextViewText(R.id.name, intent?.getStringExtra(FULL_NAME))
        if (intent?.getStringExtra(CALL_TYPE).equals("VIDEO")) {
            customView.setTextViewText(R.id.callType, Restring.getString(this, R.string.hippo_call_incoming_video_call))
        } else {
            customView.setTextViewText(R.id.callType, Restring.getString(this, R.string.hippo_call_incoming_audio_call))
        }
        //todo: download image here
        //customView.setImageViewBitmap(R.id.photo, Utils.getCircleBitmap(NotificationImageManager().getImageBitmap(intent?.getStringExtra(USER_THUMBNAIL_IMAGE))))
        customView.setOnClickPendingIntent(R.id.btnAnswer, answerPendingIntent)
        customView.setOnClickPendingIntent(R.id.btnDecline, hungupPendingIntent)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {

            val notification = NotificationCompat.Builder(this, "IncomingCall")
            notification.setContentTitle(getString(R.string.app_name))
            notification.setTicker("Call_STATUS")
            notification.setContentText(Restring.getString(this, R.string.hippo_call_incoming))
            notification.setSmallIcon(R.mipmap.hippo_notif)
            notification.setOngoing(true)
            notification.setStyle(NotificationCompat.DecoratedCustomViewStyle())
            notification.setCustomContentView(customView)
            notification.setCustomBigContentView(customView)

//            notification.setDefaults(Notification.DEFAULT_LIGHTS or Notification.DEFAULT_SOUND)
//            notification.setCategory(NotificationCompat.CATEGORY_CALL)
//            notification.setVibrate(null)
//            notification.setFullScreenIntent(pendingIntent, true)
//            notification.priority = getPriority()

            if (callActivityRestricted(this)) {
                notification.setFullScreenIntent(pendingIntent, true)
                notification.priority = NotificationCompat.PRIORITY_HIGH
                notification.setCategory(NotificationCompat.CATEGORY_CALL)
            }

            startForeground(1122, notification.build())
            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                var notificationChannel = NotificationChannel("IncomingCall",
                        "IncomingCall", NotificationManager.IMPORTANCE_HIGH)
                notificationChannel.setSound(null, null)
                notificationManager.createNotificationChannel(notificationChannel)
            }
        } else {

            val notification = NotificationCompat.Builder(this)
            notification.setContentTitle(getString(R.string.app_name))
            notification.setTicker("Call_STATUS")
            notification.setContentText(Restring.getString(this, R.string.hippo_call_incoming))

            notification.setSmallIcon(R.mipmap.hippo_notif)
            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, R.mipmap.hippo_notif))
            notification.setDefaults(Notification.DEFAULT_LIGHTS or Notification.DEFAULT_SOUND)
            notification.setVibrate(null)
            notification.setContentIntent(pendingIntent)
            notification.setOngoing(true)
            notification.setCategory(NotificationCompat.CATEGORY_CALL)
            notification.priority = getPriority()
            val hangupAction = NotificationCompat.Action.Builder(
                    android.R.drawable.sym_action_chat, Restring.getString(this, R.string.hippo_call_hungup), hungupPendingIntent)
                    .build()
            notification.addAction(hangupAction)
            startForeground(1122, notification.build())
            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        }
    }

    private fun createOngoingCallNotification(intent: Intent?) {

        try {
            inviteLink = intent?.getStringExtra(INVITE_LINK)!!
            channelId = intent?.getLongExtra(CHANNEL_ID, -1L)!!
        } catch (e: Exception) {
            e.printStackTrace()
        }

        val notification: NotificationCompat.Builder
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            notification = NotificationCompat.Builder(this, "NotificationService")
            notification.setContentTitle(getString(R.string.app_name))
            notification.setContentText(Restring.getString(this, R.string.hippo_call_outgoing))
            notification.setSmallIcon(R.mipmap.hippo_notif)
            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, R.mipmap.hippo_notif))
            notification.setDefaults(Notification.DEFAULT_LIGHTS or Notification.DEFAULT_SOUND)
            notification.setVibrate(null)
            notification.setOngoing(true)
            notification.priority = getPriority()

            val hungupIntent = Intent(this, HungUpBroadcast::class.java)
            hungupIntent.putExtra("action", "hungupCall")
            hungupIntent.putExtra(INVITE_LINK, inviteLink)
            hungupIntent.putExtra(CHANNEL_ID, channelId)
            hungupIntent.putExtra(MESSAGE_UNIQUE_ID, intent?.getStringExtra(MESSAGE_UNIQUE_ID))
            hungupIntent.putExtra(DEVICE_PAYLOAD, getDeviceDetails().toString())

            val hungupPendingIntent = PendingIntent.getBroadcast(this, 0,
                    hungupIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)

            val hangupAction = NotificationCompat.Action.Builder(
                    android.R.drawable.sym_action_chat, Restring.getString(this, R.string.hippo_call_hungup), hungupPendingIntent)
                    .build()
            notification.addAction(hangupAction)

            val notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                val notificationChannel = NotificationChannel("NotificationService",
                        "NotificationService", NotificationManager.IMPORTANCE_LOW)
                notificationChannel.setSound(null, null)
                notificationManager.createNotificationChannel(notificationChannel)
            }
            startForeground(1124, notification.build())

        } else {
            notification = NotificationCompat.Builder(this)
            notification.setContentTitle(getString(R.string.app_name))
            notification.setContentText(Restring.getString(this, R.string.hippo_call_outgoing))
            notification.setSmallIcon(R.mipmap.hippo_notif)
            notification.setLargeIcon(BitmapFactory.decodeResource(this.resources, R.mipmap.hippo_notif))
            notification.setDefaults(Notification.DEFAULT_LIGHTS or Notification.DEFAULT_SOUND)
            notification.setVibrate(null)
            notification.setOngoing(true)

            val hungupIntent = Intent(this, HungUpBroadcast::class.java)
            hungupIntent.putExtra("action", "hungupCall")
            hungupIntent.putExtra(INVITE_LINK, inviteLink)
            hungupIntent.putExtra(CHANNEL_ID, channelId)
            hungupIntent.putExtra(MESSAGE_UNIQUE_ID, intent?.getStringExtra(MESSAGE_UNIQUE_ID))
            hungupIntent.putExtra(DEVICE_PAYLOAD, getDeviceDetails().toString())

            val hungupPendingIntent = PendingIntent.getBroadcast(this, 0,
                    hungupIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)

            val hangupAction = NotificationCompat.Action.Builder(
                    android.R.drawable.sym_action_chat, Restring.getString(this, R.string.hippo_call_hungup), hungupPendingIntent)
                    .build()
            notification.addAction(hangupAction)

            notification.priority = getPriority()
            startForeground(1124, notification.build())
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        isConferenceServiceRunning = false
        isConferenceConnected = false
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mCallTerminated)
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mInternetIssue)
    }

    private fun getPriority(): Int {

        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            NotificationManager.IMPORTANCE_HIGH
        } else {
            Notification.PRIORITY_MAX
        }
    }

    private fun getDeviceDetails(): JSONObject {
        val devicePayload = JSONObject()
        devicePayload.put(FuguAppConstant.DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(this))
        devicePayload.put(FuguAppConstant.DEVICE_TYPE, FuguAppConstant.ANDROID_USER)
        devicePayload.put(FuguAppConstant.APP_VERSION, BuildConfig.VERSION_NAME)
        devicePayload.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(this))
        return devicePayload
    }
}