package com.hippoagent.customer;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippoagent.BuildConfig;
import com.hippoagent.HippoApplication;
import com.hippoagent.HippoConfig;
import com.hippoagent.callback.OnAgentCustomerLogin;
import com.hippoagent.database.CommonData;
import com.hippoagent.database.UserCommonData;
import com.hippoagent.datastructure.FuguAppConstant;
import com.hippoagent.model.FuguDeviceDetails;
import com.hippoagent.model.FuguPutUserDetailsResponse;
import com.hippoagent.model.LoginResponse.UserData;
import com.hippoagent.retrofit.APIError;
import com.hippoagent.retrofit.ResponseResolver;
import com.hippoagent.retrofit.RestClient;
import com.hippoagent.utils.Log;
import com.hippoagent.utils.UniqueIMEIID;

import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import static com.hippoagent.utils.Constants.APP_TYPE;
import static com.hippoagent.utils.Constants.APP_VERSION_CODE;
import static com.hippoagent.utils.Constants.DEVICE_TOKEN;
import static com.hippoagent.utils.Constants.EMAIL;
import static com.hippoagent.utils.Constants.PHONE_NUMBER;

/**
 * Created by ankit on 07/09/17.
 */

public class ApiPutUserDetails implements FuguAppConstant {

    public Activity activity;
    private Callback callback;

    public ApiPutUserDetails(Activity activity, Callback callback) {
        this.activity = activity;
        this.callback = callback;
    }

    public void sendUserDetails(String userUniqueKey) {
        Log.e("chk","abcd");
        Log.v("inside sendUserDetails", "inside sendUserDetails");
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJsonTree(new FuguDeviceDetails(getAppVersion()).getDeviceDetails()).getAsJsonObject();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        UserData userData = HippoApplication.getInstance().getUserData();

        HashMap<String, Object> commonParamsMAp = new HashMap<>();
        commonParamsMAp.put(ACCESS_TOKEN, userData.getAccessToken());
        commonParamsMAp.put(DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(activity));
        commonParamsMAp.put(APP_TYPE, HippoConfig.getInstance().getAttributes().getAppType());
        commonParamsMAp.put(DEVICE_TYPE, ANDROID_USER);
        commonParamsMAp.put(APP_VERSION, BuildConfig.VERSION_NAME);
        commonParamsMAp.put(APP_VERSION_CODE, BuildConfig.VERSION_CODE);
        commonParamsMAp.put(DEVICE_DETAILS, deviceDetailsJson);

        commonParamsMAp.put(USER_UNIQUE_KEY, userUniqueKey);
        if (!TextUtils.isEmpty(userData.getFullName()))
            commonParamsMAp.put(FULL_NAME, userData.getFullName());
        if (!TextUtils.isEmpty(userData.getEmail()))
            commonParamsMAp.put(EMAIL, userData.getEmail());
        if(!TextUtils.isEmpty(userData.getPhoneNumber()))
            commonParamsMAp.put(PHONE_NUMBER, userData.getPhoneNumber());
        if(!TextUtils.isEmpty(userData.getUserImage()))
            commonParamsMAp.put("user_image", userData.getUserImage());
        commonParamsMAp.put("neglect_conversations", true);
        commonParamsMAp.put(DEVICE_TOKEN, HippoConfig.getInstance().getAttributes().getDeviceToken());

      //  apiPutUserDetail(commonParamsMAp, true);
    }

    private void apiPutUserDetail(HashMap<String, Object> commonParams, boolean showLoading) {
      //  apiPutUserDetail(commonParams, showLoading, false);
    }
//    private void apiPutUserDetail(HashMap<String, Object> commonParams, boolean showLoading, boolean showError) {
//
//        RestClient.getApiInterface().putUserDetails(commonParams)
//                .enqueue(new ResponseResolver<FuguPutUserDetailsResponse>(activity, showLoading, showError) {
//                    @Override
//                    public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
//                        UserCommonData.setUserDetails(fuguPutUserDetailsResponse);
//                        if(callback != null)
//                            callback.onSuccess(fuguPutUserDetailsResponse);
//                    }
//
//                    @Override
//                    public void failure(APIError error) {
//                        if(callback != null)
//                            callback.onFailure();
//                    }
//                });
//    }



    private int getAppVersion() {
        try {
            return activity.getPackageManager().getPackageInfo(activity.getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public interface Callback {
        void onSuccess(FuguPutUserDetailsResponse fuguPutUserDetailsResponse);
        void onFailure();
    }
}
