package com.hippoagent.customer;

import androidx.recyclerview.widget.DiffUtil;


import java.util.ArrayList;
import java.util.List;

/**
 * Created by gurmail on 2019-11-18.
 *
 * @author gurmail
 */
public class MessageDiffCallback extends DiffUtil.Callback {

    List<CustomerMessage> oldList = new ArrayList<>();
    List<CustomerMessage> newList = new ArrayList<>();

    public MessageDiffCallback(List<CustomerMessage> oldList, List<CustomerMessage> newList) {
        this.oldList = oldList;
        this.newList = newList;
    }

    @Override
    public int getOldListSize() {
        return oldList.size();
    }

    @Override
    public int getNewListSize() {
        return newList.size();
    }

    @Override
    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        if(newList.get(newItemPosition).isDateView())
            return true;
        return oldList.get(oldItemPosition).getMuid().equalsIgnoreCase(newList.get(newItemPosition).getMuid());
    }

    @Override
    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        return oldList.get(oldItemPosition).equals(newList.get(newItemPosition));
    }
}