package com.hippoagent.customer;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.hippoagent.R;

import java.util.ArrayList;

/**
 * Created by gurmail on 07/10/20.
 *
 * @author gurmail
 */

public class TagsAdapterNew extends RecyclerView.Adapter<TagsAdapterNew.ViewHolder> {

    public ArrayList<CustomerContentValue> arrayList = new ArrayList<>();
    private Context mContext;
    private OnTagClicked onTagClicked;

    public TagsAdapterNew(ArrayList<CustomerContentValue> arrayList, OnTagClicked onTagClicked) {
        this.arrayList = arrayList;
        this.onTagClicked = onTagClicked;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        mContext = viewGroup.getContext();
        return new ViewHolder(LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_tag_view, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        viewHolder.tagView.setText(arrayList.get(i).getBtnTitle());

    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tagView;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tagView = itemView.findViewById(R.id.tagView);
            tagView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(onTagClicked != null) {
                        onTagClicked.onClick(getAdapterPosition(), arrayList.get(getAdapterPosition()));
                    }
                }
            });
        }
    }

    public interface OnTagClicked {
        void onClick(int position, CustomerContentValue contentValue);
    }
}