package com.hippoagent.dialogs

import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.hippoagent.R
import com.hippoagent.activities.MerchantActivity
import kotlinx.android.synthetic.main.sheet_list_layout.*

/**
 * Created by gurmail on 29/08/20.
 * @author gurmail
 */
class ListSheetDialogFragment : BottomSheetDialogFragment(), View.OnClickListener,
        SheetAdapter.OnItemSelectedListener {

    private var mContext: Context? = null
    val data = ArrayList<MultiSheetSelect>()
    val dataStatus = ArrayList<MultiSheetSelect>()
    val selected = ArrayList<Boolean>()
    val selectedStatus = ArrayList<Boolean>()
    var title: String? = ""
    var type = 0
    lateinit var adapter: SheetAdapter
    lateinit var adapterStatus: SheetAdapter
    var isSingleSelection = false
    lateinit var activity: MerchantActivity

    companion object {
        const val TAG = "ListSheetDialogFragment"

        fun newInstance(type: Int, title: String, data: ArrayList<MultiSheetSelect>, dataStatus: ArrayList<MultiSheetSelect>): ListSheetDialogFragment? {
            val frag = ListSheetDialogFragment()
            val args = Bundle()
            args.putSerializable("data", data)
            args.putSerializable("dataStatus", dataStatus)
            args.putString("title", title)
            args.putInt("type", type)
            frag.arguments = args
            return frag
        }
    }

    override fun getTheme(): Int {
        return R.style.HippoBottomSheetDialogTheme
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        mContext = context
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if (arguments != null) {
            data.addAll(arguments!!.getSerializable("data") as ArrayList<MultiSheetSelect>)
            dataStatus.addAll(arguments!!.getSerializable("dataStatus") as ArrayList<MultiSheetSelect>)
            title = arguments!!.getString("title")
            type = arguments!!.getInt("type")
            for (a in 0 until data.size) {
                isSingleSelection = data[a].isSingleSelected
                selected.add(data[a].isSelected)
            }
            for (a in 0 until dataStatus.size) {
                isSingleSelection = dataStatus[a].isSingleSelected
                selectedStatus.add(dataStatus[a].isSelected)
            }
        }
    }

    override fun onCreateView(
            inflater: LayoutInflater,
            container: ViewGroup?,
            savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.sheet_list_layout, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        titleView?.text = title
        adapter = SheetAdapter(data, false, this)
        recyclerView?.adapter = adapter


        adapterStatus = SheetAdapter(dataStatus, true, this)
        recyclerViewStatus?.adapter = adapterStatus


        resetBtn?.setOnClickListener(this)
        applyBtn?.setOnClickListener(this)
    }

    override fun onClick(v: View?) {
        when (v?.id!!) {
            R.id.resetBtn -> {
                for (a in 0 until selected.size) {
                    data[a].isSelected = false
                    selected[a] = false
                }
                adapter.notifyDataSetChanged()

                for (a in 0 until selectedStatus.size) {
                    dataStatus[a].isSelected = false
                    selected[a] = false
                }
                adapterStatus.notifyDataSetChanged()
                (context as MerchantActivity).applyFilter(true, 0, null)
                dismiss()
            }
            R.id.applyBtn -> {
                updateValues()
                dismiss()
            }
        }
    }

    private fun updateValues() {
        var pos = 0
        var posStatus = ArrayList<Int>()
        for (a in 0 until selected.size) {
            data[a].isSelected = selected[a]
            if (data[a].isSelected)
                pos = a
        }
        for (a in 0 until selectedStatus.size) {
            dataStatus[a].isSelected = selectedStatus[a]
            if (dataStatus[a].isSelected)
                posStatus.add(dataStatus[a].id)
        }


        //BusProvider.getInstance().post(BusListSheetModel(type, data))
        (context as MerchantActivity).applyFilter(false, pos, posStatus)
    }

    override fun onItemSelected(isSelected: Boolean, position: Int, isFilterStatus: Boolean) {
        if (!isFilterStatus) {
            if (isSingleSelection) {
                for (a in 0 until selected.size) {
                    selected[a] = false
                    data[a].isSelected = false
                }
                data[position].isSelected = isSelected
                selected[position] = isSelected
                adapter.notifyDataSetChanged()
            } else {
                selected[position] = isSelected
            }
        } else {
            if (isSingleSelection) {
//                for (a in 0 until selectedStatus.size) {
//                    selectedStatus[a] = false
//                    dataStatus[a].isSelected = false
//                }
                dataStatus[position].isSelected = isSelected
                selectedStatus[position] = isSelected
                adapterStatus.notifyDataSetChanged()
            } else {
                selectedStatus[position] = isSelected
            }
        }
    }

}