package com.hippoagent.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.appcompat.app.AppCompatActivity;
import androidx.viewpager.widget.ViewPager;

import com.hippoagent.R;
import com.hippoagent.adapters.ViewPagerAdapter;
import com.hippoagent.callback.OnPromotionalDialogButtonClick;
import com.hippoagent.model.promotionalPopupData.PromotionData;
import com.hippoagent.utils.CircleIndicatorPager;

public class PromotionalDialog implements ViewPager.OnPageChangeListener {

    private Dialog dialog;
    private String appSecretKey;
    private Context context;
    private PromotionData promotionData;
    private int dotsCount;
    private ImageView[] dots;
    private ViewPagerAdapter mAdapter;
    private ViewPager intro_images;
    private CircleIndicatorPager pager_indicator;
    private ImageView closeIV;
    private OnPromotionalDialogButtonClick onPromotionalDialogButtonClick;
    private int resource;

    private PromotionalDialog(Activity context, int resourceId, PromotionData commonResponse, OnPromotionalDialogButtonClick onPromotionalDialogButtonClick) {
        if (dialog != null) {
            dialog.dismiss();
        }
        resource = resourceId;
        promotionData = commonResponse;
        this.onPromotionalDialogButtonClick = onPromotionalDialogButtonClick;
        // custom dialog
        dialog = new Dialog(context);
        this.context = context;
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
        dialog.setContentView(R.layout.hippo_promotional_diaog);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.copyFrom(dialog.getWindow().getAttributes());
        layoutParams.width = WindowManager.LayoutParams.MATCH_PARENT;
        layoutParams.height = WindowManager.LayoutParams.MATCH_PARENT;

        dialog.getWindow().setLayout(layoutParams.width,  layoutParams.height);
        intro_images = (ViewPager) dialog.findViewById(R.id.pager_introduction);
        pager_indicator = (CircleIndicatorPager) dialog.findViewById(R.id.viewPagerIndicator);

        closeIV = (ImageView) dialog.findViewById(R.id.closeIV);

        closeIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.dismiss();
            }
        });
        pager_indicator.configureIndicator(15,
                15,
                15,
                resource,
                R.color.fugu_white);
        mAdapter = new ViewPagerAdapter(context, promotionData.getData(), onPromotionalDialogButtonClick);
        intro_images.setAdapter(mAdapter);
        intro_images.setCurrentItem(0);
        intro_images.setOnPageChangeListener(this);
        if(promotionData.getData().size()>1){
            pager_indicator.setViewPager(intro_images);
        }
        //   setUiPageViewController();
    }

    private void setUiPageViewController() {

        dotsCount = promotionData.getData().size();
        dots = new ImageView[dotsCount];

        for (int i = 0; i < dotsCount; i++) {
            dots[i] = new ImageView(context);
            dots[i].setImageDrawable(context.getResources().getDrawable(R.drawable.nonselecteditem_dot));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(
                    LinearLayout.LayoutParams.WRAP_CONTENT,
                    LinearLayout.LayoutParams.WRAP_CONTENT
            );
            params.setMargins(4, 0, 4, 0);
            pager_indicator.addView(dots[i], params);
        }

        dots[0].setImageDrawable(context.getResources().getDrawable(R.drawable.selecteditem_dot));
    }


    public static PromotionalDialog with(Activity context, int res, PromotionData commonResponse, OnPromotionalDialogButtonClick onPromotionalDialogButtonClick) {
        return new PromotionalDialog(context, res, commonResponse, onPromotionalDialogButtonClick);
    }


    public PromotionalDialog setPromotionData(PromotionData data) {
        if (data != null)
            promotionData = data;
        return this;
    }

    public Dialog show() {
        if (dialog != null && !((AppCompatActivity) context).isFinishing()) {
            dialog.show();
            return dialog;
        }
        return null;
    }


    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

    }

    @Override
    public void onPageSelected(int position) {
//        for (int i = 0; i < dotsCount; i++) {
//            dots[i].setImageDrawable(context.getResources().getDrawable(R.drawable.nonselecteditem_dot));
//        }
//        dots[position].setImageDrawable(context.getResources().getDrawable(R.drawable.selecteditem_dot));
    }

    @Override
    public void onPageScrollStateChanged(int state) {

    }


}
