package com.hippoagent.dialogs

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.hippoagent.R
import kotlinx.android.synthetic.main.item_multi_selection.view.*

/**
 * Created by gurmail on 30/08/20.
 * @author gurmail
 */
class SheetAdapter(var multiSheetSelect: ArrayList<MultiSheetSelect>, var isStatusFilter: Boolean, var onItemSelectedListener: OnItemSelectedListener) : RecyclerView.Adapter<SheetAdapter.ViewHolder>() {

    lateinit var context: Context
    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        context = parent.context
        return ViewHolder(LayoutInflater.from(context).inflate(R.layout.item_multi_selection, parent, false))
    }

    override fun getItemCount(): Int {
        return multiSheetSelect.size
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bind(multiSheetSelect[position], onItemSelectedListener, isStatusFilter)
    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(multiSheetSelect: MultiSheetSelect, onItemSelectedListener: OnItemSelectedListener, statusFilter: Boolean) = with(itemView) {
            itemView.itemName.text = multiSheetSelect.name

            itemView.itemCheckBox.isChecked = multiSheetSelect.isSelected
            itemView.itemCheckBox.visibility = View.VISIBLE

            itemView.itemCheckBox.setOnCheckedChangeListener { view, isChecked ->
                if (view.isPressed) {
                    onItemSelectedListener.onItemSelected(isChecked, adapterPosition, statusFilter)
                }
            }

        }
    }

    interface OnItemSelectedListener {
        fun onItemSelected(isSelected: Boolean, position: Int, isStatusFilter: Boolean)
    }
}