package com.hippoagent.encription;

import android.util.Log;

public class Encrypt {
	private final MainActivityInterface mActivity;
	private final JsEncryptorInterface mJsEncryptor;

	public Encrypt(MainActivityInterface activity, JsEncryptorInterface jsEncryptor) {
		mActivity = activity;
		mJsEncryptor = jsEncryptor;
	}

	public void encryptAndUpdate(String message, String password) {
		mJsEncryptor.encrypt(message, password,
				new JsCallback() {
					@Override
					public void onResult(final String encryptedMessage) {
						Log.e("onResult", "onResult = "+encryptedMessage);
						mActivity.setMessage(encryptedMessage);
					}

					@Override
					public void onError(String errorMessage) {
						Log.e("onError", "onError = "+errorMessage);
						// Process JavaScript error here.
						// This method is called in the UI thread.
					}
				});
	}

}
