package com.hippoagent.encription.jsevaluator;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import android.webkit.WebSettings;
import android.webkit.WebView;

import com.hippoagent.encription.jsevaluator.interfaces.CallJavaResultInterface;
import com.hippoagent.encription.jsevaluator.interfaces.WebViewWrapperInterface;


@SuppressLint("SetJavaScriptEnabled")
public class WebViewWrapper implements WebViewWrapperInterface {
    protected WebView mWebView;

    public WebViewWrapper(Context context, CallJavaResultInterface callJavaResult) {
        mWebView = new WebView(context);

        // web view will not draw anything - turn on optimizations
        mWebView.setWillNotDraw(true);

        final WebSettings webSettings = mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDefaultTextEncodingName("utf-8");
        final JavaScriptInterface jsInterface = new JavaScriptInterface(callJavaResult);
        mWebView.addJavascriptInterface(jsInterface, JsEvaluator.JS_NAMESPACE);
    }

    @Override
    public void loadJavaScript(String javascript) {
        byte[] data;
        try {
            javascript = "<script>" + javascript + "</script>";
            data = javascript.getBytes("UTF-8");
            final String base64 = Base64.encodeToString(data, Base64.DEFAULT);

            Handler mainHandler = new Handler(Looper.getMainLooper());
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    mWebView.loadUrl("data:text/html;charset=utf-8;base64," + base64);

                } // This is your code
            };
            mainHandler.post(myRunnable);


        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // Destroys the web view in order to free the memory
    // The web view can not be accessed after is has been destroyed
    // To check open the page in Chrome: chrome://inspect/#devices
    public void destroy() {
        if (mWebView != null) {
            mWebView.removeJavascriptInterface(JsEvaluator.JS_NAMESPACE);
            mWebView.loadUrl("about:blank");
            mWebView.stopLoading();

            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {
                mWebView.freeMemory();
            }

            mWebView.clearHistory();
            mWebView.removeAllViews();
            mWebView.destroyDrawingCache();
            mWebView.destroy();

            mWebView = null;
        }
    }

    // Returns the WebView object
    public WebView getWebView() {
        return mWebView;
    }
}
